/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle;

import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.animation.MultipartRenderStateManager;
import com.paneedah.weaponlib.animation.MultipartTransition;
import com.paneedah.weaponlib.animation.MultipartTransitionProvider;
import com.paneedah.weaponlib.vehicle.HierarchicalPartRenderer;
import com.paneedah.weaponlib.vehicle.PartRenderContext;
import com.paneedah.weaponlib.vehicle.RenderState;
import com.paneedah.weaponlib.vehicle.StatefulRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.ModelBase;
import net.minecraft.util.ResourceLocation;

public class HierarchicalRendererBuilder<Part, State extends RenderState> {
    protected static final int DEFAULT_DURATION = 100;
    protected static final int DEFAULT_ANIMATION_DURATION = 350;
    protected Map<Part, PartConfiguration> partConfigurations = new HashMap<Part, PartConfiguration>();
    protected State initialState;
    protected long animationDuration = 350L;

    public HierarchicalRendererBuilder<Part, State> withPartTexture(Part part, String textureName) {
        PartConfiguration partConfiguration = this.partConfigurations.computeIfAbsent(part, p -> new PartConfiguration());
        partConfiguration.textureName = textureName.toLowerCase();
        return this;
    }

    public HierarchicalRendererBuilder<Part, State> withPartModel(Part part, final ModelBase model) {
        PartConfiguration partConfiguration = this.partConfigurations.computeIfAbsent(part, p -> new PartConfiguration());
        partConfiguration.modelRenderer = new StatefulRenderer<State>(){

            @Override
            public void render(PartRenderContext<State> context) {
                model.func_78088_a(context.getEntity(), context.getLimbSwing(), context.getFlimbSwingAmount(), context.getAgeInTicks(), context.getNetHeadYaw(), context.getHeadPitch(), context.getScale());
            }
        };
        return this;
    }

    public HierarchicalRendererBuilder<Part, State> withPartModelProvider(Part part, Supplier<ModelBase> modelProvider) {
        ModelBase model = modelProvider.get();
        this.withPartModel(part, model);
        return this;
    }

    public HierarchicalRendererBuilder<Part, State> withPartTexturedModel(Part part, Supplier<ModelBase> modelProvider, String textureName) {
        ModelBase model = modelProvider.get();
        this.withPartModel(part, model);
        this.withPartTexture(part, textureName);
        return this;
    }

    public HierarchicalRendererBuilder<Part, State> withPartRenderer(Part part, StatefulRenderer<State> modelRenderer) {
        PartConfiguration partConfiguration = this.partConfigurations.computeIfAbsent(part, p -> new PartConfiguration());
        partConfiguration.modelRenderer = modelRenderer;
        return this;
    }

    public HierarchicalRendererBuilder<Part, State> withInitialState(State initialState) {
        this.initialState = initialState;
        return this;
    }

    public HierarchicalRendererBuilder<Part, State> withPartProgressProvider(Part part, Function<PartRenderContext<State>, Float> currentProgressProvider) {
        PartConfiguration partConfiguration = this.partConfigurations.computeIfAbsent(part, p -> new PartConfiguration());
        partConfiguration.currentProgressProvider = currentProgressProvider;
        return this;
    }

    public HierarchicalRendererBuilder<Part, State> withContinousStateSetter(State initialState) {
        this.initialState = initialState;
        return this;
    }

    public HierarchicalRendererBuilder<Part, State> withPartStateSetter(Part part, BiConsumer<MultipartRenderStateManager<State, HierarchicalPartRenderer.SinglePart, PartRenderContext<State>>, PartRenderContext<State>> stateSetter) {
        PartConfiguration partConfiguration = this.partConfigurations.computeIfAbsent(part, p -> new PartConfiguration());
        partConfiguration.stateSetter = stateSetter;
        return this;
    }

    public HierarchicalRendererBuilder<Part, State> withInitialState(Part part, State initialState) {
        PartConfiguration partConfiguration = this.partConfigurations.computeIfAbsent(part, p -> new PartConfiguration());
        partConfiguration.initialState = initialState;
        return this;
    }

    public HierarchicalRendererBuilder<Part, State> withAnimationDuration(long animationDuration) {
        this.animationDuration = animationDuration;
        return this;
    }

    public HierarchicalRendererBuilder<Part, State> withPartPosition(Part part, State state, Consumer<PartRenderContext<State>> positionFunction) {
        return this.withPartPosition(part, state, positionFunction, 100L);
    }

    public HierarchicalRendererBuilder<Part, State> withPartPosition(Part part, State state, Consumer<PartRenderContext<State>> positionFunction, long duration) {
        PartConfiguration partConfiguration = this.partConfigurations.computeIfAbsent(part, p -> new PartConfiguration());
        List partStateDescriptors = partConfiguration.transitionDescriptors.computeIfAbsent(state, s -> new ArrayList());
        partStateDescriptors.add(new TransitionDescriptor(positionFunction, duration));
        return this;
    }

    public HierarchicalRendererBuilder<Part, State> withPartPosition(Part part, Consumer<PartRenderContext<State>> positionFunction, State ... states) {
        for (State state : states) {
            this.withPartPosition(part, state, positionFunction, 100L);
        }
        return this;
    }

    protected void prebuild() {
    }

    public StatefulRenderer<State> build(ModContext modContext, Part mainPart) {
        this.prebuild();
        HashMap partRenderers = new HashMap();
        this.partConfigurations.forEach((part, partConfiguration) -> {
            final HashMap transitions = new HashMap();
            partConfiguration.transitionDescriptors.forEach((state, partStateDescriptors) -> {
                ArrayList singleStateTransitions = new ArrayList();
                for (TransitionDescriptor descriptor : partStateDescriptors) {
                    MultipartTransition mt = new MultipartTransition(descriptor.duration);
                    mt.withPartPositionFunction(HierarchicalPartRenderer.SinglePart.MAIN, descriptor.positionFunction);
                    singleStateTransitions.add(mt);
                }
                transitions.put(state, singleStateTransitions);
            });
            MultipartTransitionProvider transitionProvider = new MultipartTransitionProvider<State, HierarchicalPartRenderer.SinglePart, PartRenderContext<State>>(){

                @Override
                public List<MultipartTransition<HierarchicalPartRenderer.SinglePart, PartRenderContext<State>>> getTransitions(State state) {
                    return (List)transitions.get(state);
                }
            };
            ResourceLocation textureResource = new ResourceLocation("mwc", "textures/entity/" + partConfiguration.textureName + (partConfiguration.textureName.endsWith(".png") ? "" : ".png"));
            Supplier stateManagerSupplier = () -> new MultipartRenderStateManager(part.toString(), partConfiguration.initialState != null ? partConfiguration.initialState : this.initialState, transitionProvider, partConfiguration.currentTimeProvider, partConfiguration.currentProgressProvider);
            HierarchicalPartRenderer renderer = new HierarchicalPartRenderer(part, partConfiguration.modelRenderer, textureResource, partRenderers, stateManagerSupplier, partConfiguration.stateSetter, partConfiguration.currentProgressProvider);
            partRenderers.put(part, renderer);
        });
        return (StatefulRenderer)partRenderers.get(mainPart);
    }

    protected class PartConfiguration {
        protected StatefulRenderer<State> modelRenderer = c -> {};
        protected State initialState;
        protected Supplier<Long> currentTimeProvider = System::currentTimeMillis;
        protected Function<PartRenderContext<State>, Float> currentProgressProvider;
        protected BiConsumer<MultipartRenderStateManager<State, HierarchicalPartRenderer.SinglePart, PartRenderContext<State>>, PartRenderContext<State>> stateSetter = (stateManager, renderContext) -> {
            RenderState state = (RenderState)renderContext.getState();
            if (state.isContinous()) {
                stateManager.setContinousState(state, true, false, false);
            } else {
                stateManager.setState(state, true, false, true);
            }
        };
        protected Map<State, List<TransitionDescriptor>> transitionDescriptors = new HashMap();
        protected String textureName = "unknown";

        protected PartConfiguration() {
        }
    }

    protected class TransitionDescriptor {
        protected Consumer<PartRenderContext<State>> positionFunction;
        protected long duration;

        protected TransitionDescriptor(Consumer<PartRenderContext<State>> positionFunction, long duration) {
            this.positionFunction = positionFunction;
            this.duration = duration;
        }
    }
}

