/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle;

import com.google.common.collect.Lists;
import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.messages.VehicleControlMessage;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.Configurable;
import com.paneedah.weaponlib.Contextual;
import com.paneedah.weaponlib.CustomGui;
import com.paneedah.weaponlib.EntityClassFactory;
import com.paneedah.weaponlib.KeyBindings;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.animation.Randomizer;
import com.paneedah.weaponlib.compatibility.sound.EngineMovingSound;
import com.paneedah.weaponlib.particle.DriftSmokeFX;
import com.paneedah.weaponlib.particle.vehicle.DriftCloudParticle;
import com.paneedah.weaponlib.particle.vehicle.ExhaustParticle;
import com.paneedah.weaponlib.particle.vehicle.TireTracks;
import com.paneedah.weaponlib.particle.vehicle.VehicleExhaustFlameParticle;
import com.paneedah.weaponlib.state.ExtendedState;
import com.paneedah.weaponlib.vehicle.EntityVehicleConfiguration;
import com.paneedah.weaponlib.vehicle.GearShiftPattern;
import com.paneedah.weaponlib.vehicle.VehicleDrivingAspect;
import com.paneedah.weaponlib.vehicle.VehicleState;
import com.paneedah.weaponlib.vehicle.VehicleSuspensionStrategy;
import com.paneedah.weaponlib.vehicle.collisions.AABBTool;
import com.paneedah.weaponlib.vehicle.collisions.GJKResult;
import com.paneedah.weaponlib.vehicle.collisions.IDynamicCollision;
import com.paneedah.weaponlib.vehicle.collisions.OBBCollider;
import com.paneedah.weaponlib.vehicle.collisions.OreintedBB;
import com.paneedah.weaponlib.vehicle.collisions.RigidBody;
import com.paneedah.weaponlib.vehicle.jimphysics.InterpolationKit;
import com.paneedah.weaponlib.vehicle.jimphysics.Transmission;
import com.paneedah.weaponlib.vehicle.jimphysics.solver.VehiclePhysicsSolver;
import com.paneedah.weaponlib.vehicle.jimphysics.solver.WheelSolver;
import com.paneedah.weaponlib.vehicle.network.VehicleDataContainer;
import com.paneedah.weaponlib.vehicle.network.VehicleDataSerializer;
import com.paneedah.weaponlib.vehicle.network.VehiclePhysSerializer;
import com.paneedah.weaponlib.vehicle.network.VehicleSmoothShell;
import com.paneedah.weaponlib.vehicle.smoothlib.PTIVec;
import io.redstudioragnarok.redcore.vectors.Vector3D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.particle.Particle;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ReportedException;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityVehicle
extends Entity
implements Configurable<EntityVehicleConfiguration>,
ExtendedState<VehicleState>,
IDynamicCollision,
Contextual {
    public boolean vehicleIsRunning = false;
    private EntityVehicleConfiguration configuration;
    private VehicleState vehicleState = VehicleState.IDLE;
    private VehicleDrivingAspect drivingAspect = new VehicleDrivingAspect();
    private DriverInteractionEvent driverInteractionEvent = DriverInteractionEvent.NONE;
    private long stateUpdateTimestamp;
    private Randomizer randomizer;
    public float outOfControlTicks = 0.0f;
    private int lerpSteps;
    public float deltaRotation;
    private double boatPitch;
    private double lerpY;
    private double lerpZ;
    private double boatYaw;
    private double lerpXRot;
    public static final DataParameter<VehicleDataSerializer> VEHICLE_DAT = EntityDataManager.func_187226_a(EntityVehicle.class, VehicleDataSerializer.SERIALIZER);
    public static final DataParameter<VehiclePhysSerializer> SOLVER_DAT = EntityDataManager.func_187226_a(EntityVehicle.class, VehiclePhysSerializer.SERIALIZER);
    public ModContext context;
    public float prevLiftOffset = 0.0f;
    public float liftOffset = 0.0f;
    private Supplier<Vector3D> soundPositionProvider = () -> new Vector3D(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    private Supplier<Boolean> donePlayingSoundProvider = () -> this.field_70128_L;
    private Supplier<Boolean> isDorifto = () -> !this.getSolver().isDrifting;
    private Supplier<Float> doriftoSoundProvider = () -> Float.valueOf(1.0f);
    private boolean leftInputDown;
    private boolean rightInputDown;
    private boolean forwardInputDown;
    private boolean backInputDown;
    public OreintedBB oreintedBoundingBox;
    public float wheelRotationAngle;
    public float prevWheelRotationAngle;
    public VehiclePhysicsSolver solver;
    public double steerangle;
    public double throttle = 0.0;
    public double angularvelocity = 0.0;
    public double forwardLean = 0.0;
    public double sideLean = 0.0;
    public double prevSideLean;
    public double driftTuner = 0.0;
    public boolean isBraking = false;
    public double rideOffset = 0.0;
    public float rotationRoll = 0.0f;
    public float prevRotationRoll = 0.0f;
    public float rotationRollH = 0.0f;
    public float prevRotationRollH = 0.0f;
    public double prevLastYawDelta = 0.0;
    public double lastYawDelta = 0.0;
    public boolean isReversing = false;
    private float nextStepDistance;
    private float nextFlap;
    private int fire;
    public boolean reverseLockout = true;
    public PTIVec smoothShift = new PTIVec();
    public MovingSound drivingSound;
    public MovingSound driftingSound;
    public VehicleSmoothShell smoothShell;
    public int clutchTimer = 0;
    public List<Entity> field_184244_h = Lists.newArrayList();
    double prevDist = 0.0;
    double dist = 0.0;
    public boolean isShifting = false;
    public int tickShiftAnim = 0;
    public RigidBody body;
    public double tV;
    public double prevtV;
    public Material current;
    public Supplier<Integer> currentMaterial = () -> {
        if (this.current == Material.field_151577_b || this.current == Material.field_151578_c || this.current == Material.field_151571_B || this.current == Material.field_151595_p) {
            return 0;
        }
        return 1;
    };

    public EntityVehicle(World worldIn) {
        super(worldIn);
        this.field_70158_ak = true;
        this.smoothShell = new VehicleSmoothShell(this);
        this.func_70105_a(0.2f, 0.5f);
        this.oreintedBoundingBox = new OreintedBB(this.getConfiguration().getAABBforOBB());
    }

    public EntityVehicle(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(VEHICLE_DAT, (Object)new VehicleDataSerializer(this));
        this.func_184212_Q().func_187214_a(SOLVER_DAT, (Object)new VehiclePhysSerializer(this.getSolver()));
    }

    public int getCurrentRiders() {
        return this.func_184188_bt().size();
    }

    public int getCarMaxPersonnel() {
        return this.getConfiguration().getSeats().size();
    }

    public VehiclePhysicsSolver getSolver() {
        this.updateSolver();
        return this.solver;
    }

    @Override
    public EntityVehicleConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = (EntityVehicleConfiguration)EntityClassFactory.getInstance().getConfiguration(this.getClass());
        }
        return this.configuration;
    }

    @Override
    public OreintedBB getOreintedBoundingBox() {
        if (this.oreintedBoundingBox == null) {
            this.oreintedBoundingBox = new OreintedBB(this.getConfiguration().getAABBforOBB());
        }
        return this.oreintedBoundingBox;
    }

    public float getInterpolatedWheelRotation() {
        return (float)InterpolationKit.interpolateValue(this.prevWheelRotationAngle, this.wheelRotationAngle, ClientProxy.MC.func_184121_ak());
    }

    public float getWheelRotationAngle() {
        return this.wheelRotationAngle;
    }

    public float getInterpolatedYawDelta() {
        return (float)InterpolationKit.interpolateValue(this.prevLastYawDelta, this.lastYawDelta, ClientProxy.MC.func_184121_ak());
    }

    public double getLastYawDelta() {
        return this.lastYawDelta;
    }

    public double getSpeed() {
        this.updateSolver();
        return this.solver.synthAccelFor;
    }

    @Override
    public VehicleState getState() {
        return this.vehicleState;
    }

    @Override
    public long getStateUpdateTimestamp() {
        return this.stateUpdateTimestamp;
    }

    public Randomizer getRandomizer() {
        if (this.randomizer == null) {
            this.randomizer = new Randomizer();
        }
        return this.randomizer;
    }

    public VehicleSuspensionStrategy getSuspensionStrategy() {
        return this.getConfiguration().getSuspensionStrategy();
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            if (passenger.field_70181_x == 0.0) {
                passenger.field_70181_x = 1.0E-5;
            }
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            int i = this.func_184188_bt().indexOf(passenger);
            Vec3d seatOffset = this.getConfiguration().getSeatAtIndex(i).getSeatPosition();
            if (i == 1) {
                seatOffset = new Vec3d(-1.0, -0.3, -1.0);
            }
            if (this.func_184188_bt().size() > 1) {
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof EntityAnimal) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            float mu = (float)((1.0 - Math.cos(1.5707963267948966)) / 2.0);
            float iRoll = this.prevRotationRollH + this.prevRotationRoll + (this.rotationRoll + this.rotationRollH - (this.prevRotationRoll + this.prevRotationRollH)) * mu;
            float iPitch = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * mu;
            Vec3d apr = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            float nin = (float)Math.toRadians(90.0);
            Vec3d tBro = new Vec3d(seatOffset.field_72450_a, seatOffset.field_72448_b, seatOffset.field_72449_c).func_178789_a((float)Math.toRadians(iPitch)).func_178785_b((float)Math.toRadians(-this.field_70177_z));
            passenger.func_70107_b(apr.field_72450_a + tBro.field_72450_a, apr.field_72448_b + tBro.field_72448_b, apr.field_72449_c + tBro.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
            this.applyYawToEntity(passenger);
            if (passenger instanceof EntityAnimal && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((EntityAnimal)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    protected void func_184225_p(Entity passenger) {
        Vec3d p = new Vec3d(2.0, 0.0, 1.0).func_178789_a((float)Math.toRadians(this.field_70125_A)).func_178785_b((float)Math.toRadians(-this.field_70177_z));
        passenger.func_70091_d(MoverType.SELF, p.field_72450_a, p.field_72448_b, p.field_72449_c);
        Vec3d speed = this.getSolver().getVelocityVector().func_186678_a(0.5);
        double bruh = 0.0;
        if (speed.func_72433_c() != 0.0) {
            bruh = 0.3;
        }
        passenger.func_70024_g(speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
        super.func_184225_p(passenger);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.outOfControlTicks < 60.0f && this.func_184219_q((Entity)player)) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public boolean func_184219_q(Entity passenger) {
        return this.getCurrentRiders() + 1 <= this.getCarMaxPersonnel();
    }

    public boolean isSteeredForward() {
        return !this.isReversing;
    }

    public boolean isSteeredBackward() {
        return this.isReversing;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateInputs(boolean left, boolean right, boolean forward, boolean back) {
        this.leftInputDown = left;
        this.rightInputDown = right;
        this.forwardInputDown = forward;
        this.backInputDown = back;
    }

    @Override
    public boolean setState(VehicleState vehicleState) {
        this.vehicleState = vehicleState;
        this.stateUpdateTimestamp = System.currentTimeMillis();
        return false;
    }

    @Override
    public void updateOBB() {
        Vec3d d = this.getSolver().getPhysConf().dimensions;
        Vec3d corDim = new Vec3d(d.field_72448_b, d.field_72449_c, d.field_72450_a);
        AxisAlignedBB bb = AABBTool.createAABB(corDim.func_186678_a(-0.5), corDim.func_186678_a(0.5));
        bb = bb.func_72317_d(0.5, 1.0, 0.0).func_72314_b(0.0, -0.2, 0.0);
        this.oreintedBoundingBox = OreintedBB.fromAABB(bb, this.func_174791_d());
        this.oreintedBoundingBox.setPosition(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.oreintedBoundingBox.setRotation(Math.toRadians(180.0f - this.field_70177_z), Math.toRadians(this.field_70125_A), Math.toRadians(this.rotationRoll + this.rotationRollH));
    }

    public void updateSolver() {
        if (this.solver == null) {
            this.solver = this.getConfiguration().getPhysicsConfig().getPhysicsSolver().clone();
            if (this.solver.vehicle == null) {
                this.solver.activate(this);
            }
        }
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.boatPitch - this.field_70165_t) / (double)this.lerpSteps;
            double d1 = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double d2 = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.boatPitch = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.boatYaw = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.field_70165_t = this.boatPitch;
            this.field_70163_u = this.lerpY;
            this.field_70161_v = this.lerpZ;
            this.field_70177_z = (float)this.boatYaw;
            this.field_70125_A = (float)this.lerpXRot;
        }
    }

    public void keyBasedSteering() {
        double angle = Math.toDegrees(this.steerangle);
        double sensitivity = 5.0;
        if (KeyBindings.vehicleTurnLeft.func_151470_d()) {
            angle -= sensitivity;
        }
        if (KeyBindings.vehicleTurnRight.func_151470_d()) {
            angle += sensitivity;
        }
        if (angle < -45.0) {
            angle = -45.0;
        }
        if (angle > 45.0) {
            angle = 45.0;
        }
        this.steerangle = Math.toRadians(angle);
    }

    public void updateSteering(EntityPlayer driver) {
        float yaw = driver.field_70177_z;
        float pitch = driver.field_70125_A;
        float f = 1.0f;
        double motionX = -MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)) * f;
        double motionZ = MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)) * f;
        double motionY = -MathHelper.func_76126_a((float)(pitch / 180.0f * (float)Math.PI)) * f;
        Vec3d dirVec = new Vec3d(motionX, 0.0, motionZ);
        Vec3d oreintVec = Vec3d.func_189986_a((float)this.field_70125_A, (float)this.field_70177_z);
        double det = dirVec.func_72431_c((Vec3d)oreintVec).field_72448_b;
        det = det > 0.0 ? 1.0 : -1.0;
        Vector3d dir = new Vector3d(dirVec.field_72450_a, dirVec.field_72448_b, dirVec.field_72449_c);
        Vector3d ore = new Vector3d(oreintVec.field_72450_a, oreintVec.field_72448_b, oreintVec.field_72449_c);
        double aT = Math.toDegrees(dir.angle(ore)) / 2.0;
        double steeringAngle = aT * det * -1.0;
        if (aT < -45.0) {
            aT = -45.0;
        }
        if (aT > 45.0) {
            aT = 45.0;
        }
        this.steerangle = Math.toRadians(-steeringAngle);
    }

    public boolean isVehicleRunning() {
        return this.vehicleIsRunning;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateControls() {
        Transmission trans = this.getSolver().transmission;
        if (KeyBindings.vehicleTurnOff.func_151468_f()) {
            if (this.isVehicleRunning()) {
                this.vehicleIsRunning = false;
                this.drivingSound = null;
                CustomGui.vehicleGUIOverlay.keyAnimator.removeKey();
            } else {
                this.vehicleIsRunning = true;
                this.drivingSound = null;
                CustomGui.vehicleGUIOverlay.keyAnimator.turnKey();
            }
        }
        if (!trans.isReverseGear) {
            if (this.isVehicleRunning()) {
                if (KeyBindings.vehicleThrottle.func_151470_d()) {
                    this.reverseLockout = true;
                    if (this.throttle < 1.0) {
                        this.throttle += 0.1;
                    }
                } else if (this.throttle > 0.0) {
                    this.throttle -= 0.1;
                }
                if (this.getSolver().getVelocityVector().func_72433_c() < 0.5 && !KeyBindings.vehicleBrake.func_151470_d()) {
                    this.reverseLockout = false;
                }
            }
            if (KeyBindings.vehicleBrake.func_151470_d()) {
                if (this.isVehicleRunning() && this.getSolver().getVelocityVector().func_72433_c() < 0.5 && !this.reverseLockout) {
                    trans.enterReverse();
                }
                this.isBraking = true;
            } else {
                this.isBraking = false;
            }
        } else if (this.isVehicleRunning()) {
            if (KeyBindings.vehicleThrottle.func_151470_d()) {
                if (this.getSolver().getVelocityVector().func_72433_c() < 2.5) {
                    trans.exitReverse();
                }
                this.isBraking = true;
            } else {
                this.isBraking = false;
            }
            if (KeyBindings.vehicleBrake.func_151470_d()) {
                if (this.throttle < 1.0) {
                    this.throttle += 0.1;
                }
            } else if (this.throttle > 0.0) {
                this.throttle -= 0.1;
            }
        }
        if (this.throttle < 0.0) {
            this.throttle = 0.0;
        }
        if (this.throttle > 1.0) {
            this.throttle = 1.0;
        }
        if (!this.isVehicleRunning()) {
            // empty if block
        }
        if (this.isVehicleRunning()) {
            if (KeyBindings.vehicleHandbrake.func_151470_d()) {
                this.solver.applyHandbrake();
            } else {
                this.solver.releaseHandbrake();
            }
        }
        if (KeyBindings.vehicleClutch.func_151470_d()) {
            this.getSolver().transmission.declutch();
        } else {
            this.getSolver().transmission.clutch();
        }
        this.steerangle = !KeyBindings.vehicleTurnLeft.func_151470_d() && !KeyBindings.vehicleTurnRight.func_151470_d() ? (this.steerangle *= 0.6) : (this.steerangle *= 0.8);
        int mA = 45;
        double maxSteerAngle = 35.0;
        double dSA = Math.toDegrees(this.steerangle);
        if (dSA > maxSteerAngle) {
            this.steerangle = Math.toRadians(maxSteerAngle);
        }
        if (dSA < -maxSteerAngle) {
            this.steerangle = Math.toRadians(-maxSteerAngle);
        }
        this.prevLastYawDelta = this.lastYawDelta;
        this.lastYawDelta = this.steerangle;
        this.prevWheelRotationAngle = this.wheelRotationAngle;
        double angVel = this.getRealSpeed();
        this.wheelRotationAngle = (float)((double)this.wheelRotationAngle + angVel % 360.0);
    }

    @Override
    public void doOBBCollision() {
        OreintedBB obb = this.getOreintedBoundingBox();
        if ((double)Math.abs(this.field_70125_A) < 1.0E-7) {
            List list3 = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_186662_g(3.0).func_72321_a(1.0, 1.0, 1.0));
            OreintedBB bb = this.getOreintedBoundingBox();
            GJKResult bestResult = new GJKResult();
            for (AxisAlignedBB aabb : list3) {
                Vec3d pos = new Vec3d(aabb.field_72336_d - 0.5, aabb.field_72337_e - 0.5, aabb.field_72334_f - 0.5);
                AxisAlignedBB fixedBB = aabb.func_191194_a(pos.func_186678_a(-1.0));
                GJKResult result = OBBCollider.areColliding(bb, OreintedBB.fromAABB(fixedBB, pos));
                if (result.status != GJKResult.Status.COLLIDING || !(result.penetrationDepth > bestResult.penetrationDepth)) continue;
                bestResult = result;
            }
            if (bestResult == null || bestResult.status != GJKResult.Status.COLLIDING) {
                return;
            }
            Vec3d normal = bestResult.separationVector;
            double yawInertia = 1.0f / this.getSolver().getPhysConf().getVehicleMassObject().inertia.m11;
            double a = 1.0;
            Vec3d aSep = normal.func_186678_a(-bestResult.penetrationDepth * a);
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            if (aSep.func_72433_c() > 0.1) {
                aSep = aSep.func_186678_a(1.0 / (aSep.func_72433_c() / 0.1));
            }
            this.func_70107_b(this.field_70165_t + aSep.field_72450_a, this.field_70163_u, this.field_70161_v + aSep.field_72449_c);
            double totalMass = 1.0 / this.getSolver().getPhysConf().getVehicleMassObject().mass;
            Vec3d relativeA = bestResult.contactPointA.func_178788_d(this.func_174791_d()).func_178785_b((float)Math.toRadians(this.field_70177_z));
            Vec3d angularVelocityA = new Vec3d(0.0, this.getSolver().angularVelocity, 0.0).func_72431_c(relativeA);
            Vec3d fullVelocityA = this.getSolver().velocity.func_178787_e(angularVelocityA);
            Vec3d contactVelocity = fullVelocityA.func_186678_a(-1.0);
            double impulseForce = contactVelocity.func_72430_b(normal);
            Vec3d inertiaA = relativeA.func_72431_c(normal).func_186678_a(yawInertia).func_72431_c(relativeA);
            double angularEffect = inertiaA.func_72430_b(normal);
            double restitution = 0.3;
            double j = -(1.0 + restitution) * impulseForce / (totalMass + angularEffect);
            Vec3d fullImpulse = normal.func_186678_a(j);
            this.getSolver().velocity = this.getSolver().velocity.func_178787_e(fullImpulse.func_186678_a(-1.0).func_186678_a(totalMass));
            Vec3d angularImpulse = relativeA.func_72431_c(fullImpulse).func_186678_a(-1.0);
            this.getSolver().angularVelocity += angularImpulse.func_186678_a((double)yawInertia).field_72448_b * 0.02;
        }
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public void oldCollisions() {
        OreintedBB carBound = this.getOreintedBoundingBox();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g(10.0), EntitySelectors.field_94557_a);
        list.removeIf(e -> this.func_184196_w((Entity)e));
        for (Entity ent : list) {
            AxisAlignedBB cEnt = ent.func_174813_aQ();
            AxisAlignedBB aabbEnt = new AxisAlignedBB(cEnt.field_72340_a - ent.field_70165_t, cEnt.field_72338_b - ent.field_70163_u, cEnt.field_72339_c - ent.field_70161_v, cEnt.field_72336_d - ent.field_70165_t, cEnt.field_72337_e - ent.field_70163_u, cEnt.field_72334_f - ent.field_70161_v);
            GJKResult result = OBBCollider.areColliding(this.getOreintedBoundingBox(), OreintedBB.fromAABB(aabbEnt, ent.func_174791_d()));
            if (result.status != GJKResult.Status.COLLIDING) continue;
            Vec3d shoot = result.separationVector.func_186678_a(result.penetrationDepth);
            Vec3d p = ent.func_174791_d();
            if (ent instanceof EntityPlayer) {
                if (!this.field_70170_p.field_72995_K) continue;
                ent.func_70107_b(p.field_72450_a + shoot.field_72450_a, p.field_72448_b + shoot.field_72448_b, p.field_72449_c + shoot.field_72449_c);
                EntityPlayer player = (EntityPlayer)ent;
                if (player.field_70122_E) continue;
                player.field_70181_x += 0.08;
                player.field_70159_w *= 0.9;
                player.field_70179_y *= 0.9;
                continue;
            }
            this.func_70108_f(ent);
            ent.func_70107_b(p.field_72450_a + shoot.field_72450_a, p.field_72448_b + shoot.field_72448_b, p.field_72449_c + shoot.field_72449_c);
        }
    }

    protected void func_145775_I() {
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.field_70145_X) {
            this.func_174826_a(this.func_174813_aQ().func_72317_d(x, 0.0, z));
            this.func_174829_m();
        } else {
            BlockPos blockpos1;
            IBlockState iblockstate1;
            Block block1;
            boolean flag;
            this.field_70170_p.field_72984_F.func_76320_a("move");
            double d10 = this.field_70165_t;
            double d11 = this.field_70163_u;
            double d1 = this.field_70161_v;
            if (this.field_70134_J) {
                this.field_70134_J = false;
                x *= 0.25;
                y *= (double)0.05f;
                z *= 0.25;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            double d2 = x;
            double d3 = y;
            double d4 = z;
            if ((type == MoverType.SELF || type == MoverType.PLAYER) && this.field_70122_E && this.func_70093_af()) {
                double d5 = 0.05;
                while (x != 0.0 && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72317_d(x, (double)(-this.field_70138_W), 0.0)).isEmpty()) {
                    x = x < 0.05 && x >= -0.05 ? 0.0 : (x > 0.0 ? (x -= 0.05) : (x += 0.05));
                    d2 = x;
                }
                while (z != 0.0 && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72317_d(0.0, (double)(-this.field_70138_W), z)).isEmpty()) {
                    z = z < 0.05 && z >= -0.05 ? 0.0 : (z > 0.0 ? (z -= 0.05) : (z += 0.05));
                    d4 = z;
                }
                while (x != 0.0 && z != 0.0 && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72317_d(x, (double)(-this.field_70138_W), z)).isEmpty()) {
                    x = x < 0.05 && x >= -0.05 ? 0.0 : (x > 0.0 ? (x -= 0.05) : (x += 0.05));
                    d2 = x;
                    z = z < 0.05 && z >= -0.05 ? 0.0 : (z > 0.0 ? (z -= 0.05) : (z += 0.05));
                    d4 = z;
                }
            }
            List list1 = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(x, y, z));
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            ArrayList<AxisAlignedBB> rList = new ArrayList<AxisAlignedBB>();
            for (int q = 0; q < list1.size(); ++q) {
                AxisAlignedBB item = (AxisAlignedBB)list1.get(q);
                Vec3d centerOfPos = new Vec3d(item.field_72340_a + (item.field_72336_d - item.field_72340_a) * 0.5, item.field_72338_b + (item.field_72337_e - item.field_72338_b) * 0.5, item.field_72339_c + (item.field_72334_f - item.field_72339_c) * 0.5);
                BlockPos pos = new BlockPos(centerOfPos);
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                if (!(state.func_177230_c() instanceof BlockCarpet)) continue;
                IBlockState below = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b());
                AxisAlignedBB bb = below.func_185890_d((IBlockAccess)this.field_70170_p, this.func_180425_c().func_177977_b());
                rList.add(item);
                bb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                list1.add(bb.func_186670_a(this.func_180425_c().func_177977_b()));
            }
            for (AxisAlignedBB bruh : rList) {
                list1.remove(bruh);
            }
            IBlockState below = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b());
            AxisAlignedBB bb = below.func_185890_d((IBlockAccess)this.field_70170_p, this.func_180425_c().func_177977_b());
            if (bb != null && bb.field_72337_e >= 0.75 && bb.field_72337_e < 1.0) {
                bb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                list1.add(bb.func_186670_a(this.func_180425_c().func_177977_b()));
            }
            if (y != 0.0) {
                int l = list1.size();
                for (int k = 0; k < l; ++k) {
                    y = ((AxisAlignedBB)list1.get(k)).func_72323_b(this.func_174813_aQ(), y);
                }
                this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, y, 0.0));
            }
            if (x != 0.0) {
                int l5 = list1.size();
                for (int j5 = 0; j5 < l5; ++j5) {
                    x = ((AxisAlignedBB)list1.get(j5)).func_72316_a(this.func_174813_aQ(), x);
                }
                if (x != 0.0) {
                    this.func_174826_a(this.func_174813_aQ().func_72317_d(x, 0.0, 0.0));
                }
            }
            if (z != 0.0) {
                int i6 = list1.size();
                for (int k5 = 0; k5 < i6; ++k5) {
                    z = ((AxisAlignedBB)list1.get(k5)).func_72322_c(this.func_174813_aQ(), z);
                }
                if (z != 0.0) {
                    this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, z));
                }
            }
            boolean bl = flag = this.field_70122_E || d3 != y && d3 < 0.0;
            if (this.field_70138_W > 0.0f && flag && (d2 != x || d4 != z)) {
                double d14 = x;
                double d6 = y;
                double d7 = z;
                AxisAlignedBB axisalignedbb1 = this.func_174813_aQ();
                this.func_174826_a(axisalignedbb);
                y = this.field_70138_W;
                List list = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(d2, y, d4));
                AxisAlignedBB axisalignedbb2 = this.func_174813_aQ();
                AxisAlignedBB axisalignedbb3 = axisalignedbb2.func_72321_a(d2, 0.0, d4);
                double d8 = y;
                int k1 = list.size();
                for (int j1 = 0; j1 < k1; ++j1) {
                    d8 = ((AxisAlignedBB)list.get(j1)).func_72323_b(axisalignedbb3, d8);
                }
                axisalignedbb2 = axisalignedbb2.func_72317_d(0.0, d8, 0.0);
                double d18 = d2;
                int i2 = list.size();
                for (int l1 = 0; l1 < i2; ++l1) {
                    d18 = ((AxisAlignedBB)list.get(l1)).func_72316_a(axisalignedbb2, d18);
                }
                axisalignedbb2 = axisalignedbb2.func_72317_d(d18, 0.0, 0.0);
                double d19 = d4;
                int k2 = list.size();
                for (int j2 = 0; j2 < k2; ++j2) {
                    d19 = ((AxisAlignedBB)list.get(j2)).func_72322_c(axisalignedbb2, d19);
                }
                axisalignedbb2 = axisalignedbb2.func_72317_d(0.0, 0.0, d19);
                AxisAlignedBB axisalignedbb4 = this.func_174813_aQ();
                double d20 = y;
                int i3 = list.size();
                for (int l2 = 0; l2 < i3; ++l2) {
                    d20 = ((AxisAlignedBB)list.get(l2)).func_72323_b(axisalignedbb4, d20);
                }
                axisalignedbb4 = axisalignedbb4.func_72317_d(0.0, d20, 0.0);
                double d21 = d2;
                int k3 = list.size();
                for (int j3 = 0; j3 < k3; ++j3) {
                    d21 = ((AxisAlignedBB)list.get(j3)).func_72316_a(axisalignedbb4, d21);
                }
                axisalignedbb4 = axisalignedbb4.func_72317_d(d21, 0.0, 0.0);
                double d22 = d4;
                int i4 = list.size();
                for (int l3 = 0; l3 < i4; ++l3) {
                    d22 = ((AxisAlignedBB)list.get(l3)).func_72322_c(axisalignedbb4, d22);
                }
                axisalignedbb4 = axisalignedbb4.func_72317_d(0.0, 0.0, d22);
                double d23 = d18 * d18 + d19 * d19;
                double d9 = d21 * d21 + d22 * d22;
                if (d23 > d9) {
                    x = d18;
                    z = d19;
                    y = -d8;
                    this.func_174826_a(axisalignedbb2);
                } else {
                    x = d21;
                    z = d22;
                    y = -d20;
                    this.func_174826_a(axisalignedbb4);
                }
                int k4 = list.size();
                for (int j4 = 0; j4 < k4; ++j4) {
                    y = ((AxisAlignedBB)list.get(j4)).func_72323_b(this.func_174813_aQ(), y);
                }
                this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, y, 0.0));
                if (d14 * d14 + d7 * d7 >= x * x + z * z) {
                    x = d14;
                    y = d6;
                    z = d7;
                    this.func_174826_a(axisalignedbb1);
                }
            }
            this.field_70170_p.field_72984_F.func_76319_b();
            this.field_70170_p.field_72984_F.func_76320_a("rest");
            this.func_174829_m();
            this.field_70123_F = d2 != x || d4 != z;
            this.field_70124_G = d3 != y;
            this.field_70122_E = this.field_70124_G && d3 < 0.0;
            this.field_70132_H = this.field_70123_F || this.field_70124_G;
            int j6 = MathHelper.func_76128_c((double)this.field_70165_t);
            int i1 = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
            int k6 = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos blockpos = new BlockPos(j6, i1, k6);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_185904_a() == Material.field_151579_a && ((block1 = (iblockstate1 = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_177230_c()) instanceof BlockFence || block1 instanceof BlockWall || block1 instanceof BlockFenceGate)) {
                iblockstate = iblockstate1;
                blockpos = blockpos1;
            }
            this.func_184231_a(y, this.field_70122_E, iblockstate, blockpos);
            if (d2 != x) {
                this.field_70159_w = 0.0;
            }
            if (d4 != z) {
                this.field_70179_y = 0.0;
            }
            Block block = iblockstate.func_177230_c();
            if (d3 != y) {
                block.func_176216_a(this.field_70170_p, (Entity)this);
            }
            if (!(!this.func_70041_e_() || this.field_70122_E && this.func_70093_af() && this.func_184218_aH())) {
                double d15 = this.field_70165_t - d10;
                double d16 = this.field_70163_u - d11;
                double d17 = this.field_70161_v - d1;
                if (block != Blocks.field_150468_ap) {
                    d16 = 0.0;
                }
                if (block != null && this.field_70122_E) {
                    block.func_176199_a(this.field_70170_p, blockpos, (Entity)this);
                }
                this.field_70140_Q = (float)((double)this.field_70140_Q + (double)MathHelper.func_76133_a((double)(d15 * d15 + d17 * d17)) * 0.6);
                this.field_82151_R = (float)((double)this.field_82151_R + (double)MathHelper.func_76133_a((double)(d15 * d15 + d16 * d16 + d17 * d17)) * 0.6);
                if (this.field_82151_R > this.nextStepDistance && iblockstate.func_185904_a() != Material.field_151579_a) {
                    this.nextStepDistance = (int)this.field_82151_R + 1;
                    if (this.func_70090_H()) {
                        EntityVehicle entity = this.func_184207_aI() && this.func_184179_bs() != null ? this.func_184179_bs() : this;
                        float f = entity == this ? 0.35f : 0.4f;
                        float f1 = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w * (double)0.2f + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y * (double)0.2f)) * f;
                        if (f1 > 1.0f) {
                            f1 = 1.0f;
                        }
                        this.func_184185_a(this.func_184184_Z(), f1, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                    } else {
                        this.func_180429_a(blockpos, block);
                    }
                } else if (this.field_82151_R > this.nextFlap && this.func_191957_ae() && iblockstate.func_185904_a() == Material.field_151579_a) {
                    this.nextFlap = this.func_191954_d(this.field_82151_R);
                }
            }
            try {
                this.func_145775_I();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
                this.func_85029_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
            boolean flag1 = this.func_70026_G();
            if (this.field_70170_p.func_147470_e(this.func_174813_aQ().func_186664_h(0.001))) {
                this.func_70081_e(1);
                if (!flag1) {
                    ++this.fire;
                    if (this.fire == 0) {
                        this.func_70015_d(8);
                    }
                }
            } else if (this.fire <= 0) {
                this.fire = -this.func_190531_bD();
            }
            if (flag1 && this.func_70027_ad()) {
                this.func_184185_a(SoundEvents.field_187541_bC, 0.7f, 1.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                this.fire = -this.func_190531_bD();
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    public float getInterpolatedLiftOffset() {
        return (float)InterpolationKit.interpolateValue(this.prevLiftOffset, this.liftOffset, ClientProxy.MC.func_184121_ak());
    }

    public void oldHC() {
        Vec3d end;
        Vec3d start;
        RayTraceResult ray;
        Vec3d eDown;
        float targetDown = 0.0f;
        float targetUp = 0.0f;
        double dist = 0.0;
        double forwardNess = 2.0;
        Vec3d sDown = new Vec3d(-0.5, 0.0, forwardNess).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d());
        RayTraceResult rayDown = this.field_70170_p.func_72933_a(sDown, eDown = new Vec3d(-0.5, -10.0, forwardNess).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d()));
        if (rayDown != null) {
            float newPitch;
            dist = rayDown.field_72307_f.func_178788_d(sDown).func_72433_c();
            targetDown = newPitch = (float)(-Math.toDegrees(Math.atan(dist / 2.5)));
        }
        if ((ray = this.field_70170_p.func_72933_a(start = new Vec3d(-0.5, 0.0, 0.0).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d()), end = new Vec3d(-0.5, 0.0, 5.75).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178785_b((float)(-this.solver.getSideSlipAngle())).func_178787_e(this.func_174791_d()))) != null) {
            float newPitch;
            IBlockState b = this.field_70170_p.func_180495_p(ray.func_178782_a().func_177984_a());
            if (b.func_191058_s()) {
                return;
            }
            Vec3d hitVec = ray.field_72307_f;
            Vec3d ab = hitVec.func_178788_d(this.func_174791_d());
            double distance = ab.func_189985_c();
            double upMag = 0.0;
            upMag = distance > 15.5 ? 0.25 : (distance > 1.0 ? 0.5 : 1.5);
            double liftPush = 0.0;
            IBlockState bL = this.field_70170_p.func_180495_p(ray.func_178782_a());
            if (!bL.func_185913_b()) {
                upMag /= 2.0;
                liftPush = 0.1;
            }
            BlockPos bTC = ray.func_178782_a();
            Vec3d sB = new Vec3d((double)bTC.func_177958_n(), (double)bTC.func_177956_o() - 1.0, (double)bTC.func_177952_p());
            Vec3d eB = new Vec3d((double)bTC.func_177958_n(), (double)bTC.func_177956_o(), (double)bTC.func_177952_p());
            RayTraceResult heightRay = this.field_70170_p.func_72933_a(sB, eB);
            double opp = 0.0;
            double adj = 0.0;
            if (heightRay != null) {
                opp = heightRay.field_72307_f.field_72448_b - this.func_174791_d().field_72448_b;
                adj = heightRay.field_72307_f.func_178788_d(ray.field_72307_f).func_72433_c();
            }
            float t = 1.0f;
            float mu2 = (float)((1.0 - Math.cos((double)t * Math.PI)) / 2.0);
            Vec3d lift = new Vec3d(0.0, upMag + 0.2, 0.7 + liftPush).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_186678_a((double)mu2);
            this.func_70091_d(MoverType.SELF, lift.field_72450_a, lift.field_72448_b, lift.field_72449_c);
            targetUp = newPitch = (float)Math.toDegrees(Math.atan(upMag / 2.5));
        }
        float adjT = 0.0f;
        adjT = (double)targetDown == 0.0 ? targetUp : ((double)targetUp == 0.0 ? targetDown : (targetDown + targetUp) / 2.0f);
        if (dist > 0.5) {
            this.field_70125_A = adjT < this.field_70125_A ? (float)((double)this.field_70125_A - (double)Math.abs(adjT) * 0.05) : (float)((double)this.field_70125_A + (double)Math.abs(adjT) * 0.3);
        } else {
            if ((double)adjT == 0.0) {
                adjT = -this.field_70125_A;
            }
            this.field_70125_A = adjT < this.field_70125_A ? (float)((double)this.field_70125_A - (double)Math.abs(adjT) * 0.5) : (float)((double)this.field_70125_A + (double)Math.abs(adjT) * 0.3);
        }
    }

    public void func_70108_f(Entity entityIn) {
        Vec3d speed = this.getSolver().velocity.func_186678_a(0.5);
        entityIn.func_70024_g(speed.field_72450_a, speed.field_72448_b + 1.0, speed.field_72449_c);
        entityIn.func_70097_a(DamageSource.field_82728_o, (float)speed.func_189985_c());
        super.func_70108_f(entityIn);
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public void handleHillClimbing() {
        Vec3d end;
        Vec3d start;
        RayTraceResult ray;
        double hillAngle;
        double rollDist;
        double sideWidth;
        if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177984_a()).func_185904_a().func_76224_d()) {
            this.vehicleIsRunning = false;
            CustomGui.vehicleGUIOverlay.keyAnimator.removeKey();
        }
        double wheelbase = 2.85;
        double sideScan = 1.0;
        Vec3d rollSA = new Vec3d(sideScan, 2.0, 0.0).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d());
        Vec3d rollEA = new Vec3d(sideScan, -10.0, 0.0).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d());
        RayTraceResult rollRA = this.field_70170_p.func_147447_a(rollSA, rollEA, false, true, false);
        Vec3d rollSB = new Vec3d(-sideScan, 2.0, 0.0).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d());
        Vec3d rollEB = new Vec3d(-sideScan, -10.0, 0.0).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d());
        RayTraceResult rollRB = this.field_70170_p.func_147447_a(rollSB, rollEB, false, true, false);
        double rollHA = 0.0;
        double rollHB = 0.0;
        rollHB = rollRB == null ? 5.0 : rollRB.field_72307_f.func_178788_d(rollSB).func_72433_c();
        double ang = Math.asin((rollHB - (rollHA = rollRA == null ? 5.0 : rollRA.field_72307_f.func_178788_d(rollSA).func_72433_c())) / (sideWidth = 1.847));
        double rollTarget = (float)Math.toDegrees(-ang);
        if (Double.isNaN(rollTarget)) {
            rollTarget = 0.0;
        }
        if ((rollDist = (double)Math.abs(this.rotationRollH) - Math.abs(rollTarget)) > 0.5) {
            if (rollTarget == 0.0 || rollTarget < 0.0) {
                // empty if block
            }
            if (rollTarget < (double)this.rotationRollH) {
                this.rotationRollH = (float)((double)this.rotationRollH - Math.abs(rollDist) * 0.68);
            } else {
                double bruh = (double)this.rotationRollH + rollTarget;
                this.rotationRollH = (float)((double)this.rotationRollH + Math.abs(rollTarget + (double)this.rotationRollH) * 0.9);
            }
        } else {
            if (rollTarget == 0.0) {
                rollTarget = -this.rotationRollH;
            }
            this.rotationRollH = rollTarget < (double)this.rotationRollH ? (float)((double)this.rotationRollH - Math.abs(rollTarget) * 0.03) : (float)((double)this.rotationRollH + Math.abs(rollTarget) * 0.08);
        }
        float targetDown = 0.0f;
        float targetUp = 0.0f;
        double dist = 0.0;
        double forwardNess = 2.0;
        Vec3d sDown = new Vec3d(-0.5, 0.0, forwardNess).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d());
        Vec3d eDown = new Vec3d(-0.5, -10.0, forwardNess).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d());
        RayTraceResult rayDown = this.field_70170_p.func_147447_a(sDown, eDown, false, true, false);
        Vec3d sDown2 = new Vec3d(-0.5, 0.0, -forwardNess + 0.5).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d());
        Vec3d eDown2 = new Vec3d(-0.5, -10.0, -forwardNess + 0.5).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d());
        RayTraceResult rayDown2 = this.field_70170_p.func_147447_a(sDown2, eDown2, false, true, false);
        double hF = 0.0;
        double hB = 0.0;
        if (rayDown2 == null) {
            this.field_70125_A = (float)((double)this.field_70125_A * 1.2);
            this.rotationRoll = (float)((double)this.rotationRoll * 1.2);
        } else {
            hB = rayDown2.field_72307_f.func_178788_d(sDown2).func_72433_c();
        }
        if (rayDown != null) {
            hF = rayDown.field_72307_f.func_178788_d(sDown).func_72433_c();
        }
        if ((hillAngle = Math.toDegrees(Math.asin((hF - hB) / wheelbase))) != 0.0 && rayDown != null && hF - hB >= 0.0) {
            float newPitch;
            dist = rayDown.field_72307_f.func_178788_d(sDown).func_72433_c();
            this.getSolver().velocity = this.getSolver().getVelocityVector().func_186678_a(1.005);
            targetDown = newPitch = (float)(-Math.toDegrees(Math.atan(dist / wheelbase)));
        }
        double SSAng = Math.abs(Math.toDegrees(this.getSolver().getSideSlipAngle()));
        double mult = 1.0 - 0.3 * Math.min(SSAng / 30.0, 1.0);
        if (this.field_70125_A < 3.0f) {
            mult *= 0.5;
        }
        double baseReach = 14.75 * Math.min(this.getRealSpeed() / 25.0, 1.0) * mult;
        if (!this.field_70122_E || this.field_70125_A > 5.0f) {
            baseReach += 3.0;
        }
        boolean flagOne = false;
        if (this.isBraking || this.getSolver().getVelocityVector().func_72433_c() < 0.3 || this.throttle == 0.0 && this.getSolver().getVelocityVector().func_72433_c() < 25.0) {
            flagOne = true;
        }
        if ((ray = this.field_70170_p.func_147447_a(start = new Vec3d(-0.5, 0.1, 0.0).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d()), end = new Vec3d(-0.5, 0.1, baseReach).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178785_b((float)(-this.solver.getSideSlipAngle())).func_178787_e(this.func_174791_d()), false, true, false)) != null && !flagOne) {
            double heightDifference;
            IBlockState below = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b());
            IBlockState bOfCar = this.field_70170_p.func_180495_p(this.func_180425_c());
            IBlockState b = this.field_70170_p.func_180495_p(ray.func_178782_a().func_177984_a());
            double upMag = 0.0;
            if (b.func_177230_c() instanceof BlockPane || b.func_177230_c() instanceof BlockSlab || b.func_177230_c() instanceof BlockGlass) {
                return;
            }
            Vec3d hitVec = ray.field_72307_f;
            Vec3d ab = hitVec.func_178788_d(this.func_174791_d());
            double distance = ab.func_189985_c();
            upMag = distance > 15.5 ? 0.25 : (distance > 1.0 ? 0.5 : 1.5);
            double liftPush = 0.0;
            IBlockState bL = this.field_70170_p.func_180495_p(ray.func_178782_a());
            if (bL.func_177230_c() instanceof BlockFence || bL.func_177230_c() instanceof BlockWall) {
                return;
            }
            boolean snowFlag = false;
            int layers = 0;
            if (bL.func_177230_c() instanceof BlockSnow) {
                snowFlag = true;
                layers = (Integer)bL.func_177229_b((IProperty)BlockSnow.field_176315_a);
            }
            AxisAlignedBB ablf = bL.func_185890_d((IBlockAccess)this.field_70170_p, ray.func_178782_a());
            double blockHeight = ablf.field_72337_e - ablf.field_72338_b;
            BlockPos bTC = ray.func_178782_a();
            Vec3d sB = new Vec3d((double)bTC.func_177958_n(), (double)bTC.func_177956_o() - 1.0, (double)bTC.func_177952_p());
            Vec3d eB = new Vec3d((double)bTC.func_177958_n(), (double)bTC.func_177956_o(), (double)bTC.func_177952_p());
            RayTraceResult heightRay = this.field_70170_p.func_147447_a(sB, eB, false, true, false);
            double opp = 0.0;
            double adj = 0.0;
            if (heightRay != null) {
                opp = heightRay.field_72307_f.field_72448_b - this.func_174791_d().field_72448_b;
                adj = heightRay.field_72307_f.func_178788_d(ray.field_72307_f).func_72433_c();
            }
            float t = 1.0f;
            float mu2 = (float)((1.0 - Math.cos((double)t * Math.PI)) / 2.0);
            Vec3d lift = new Vec3d(0.0, upMag + 0.55, 0.05 + liftPush).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_186678_a((double)mu2);
            this.getSolver().velocity = this.getSolver().getVelocityVector().func_186678_a(0.95);
            double targetTopHeight = (double)ray.func_178782_a().func_177956_o() + 1.0;
            if (snowFlag) {
                targetTopHeight = layers == 0 ? (double)ray.func_178782_a().func_177956_o() + 0.3 : (double)ray.func_178782_a().func_177956_o() + 0.7;
            }
            if ((heightDifference = lift.field_72448_b + this.func_174791_d().field_72448_b - targetTopHeight) > 0.0) {
                double correction = lift.field_72448_b - heightDifference;
                lift = new Vec3d(lift.field_72450_a, correction, lift.field_72449_c);
            }
            float newPitch = (float)Math.toDegrees(Math.atan(upMag / wheelbase));
            if (this.field_70125_A < 55.0f) {
                this.func_70091_d(MoverType.SELF, lift.field_72450_a, lift.field_72448_b, lift.field_72449_c);
                newPitch = (float)((double)newPitch + -hillAngle);
                if (snowFlag) {
                    newPitch = (float)((double)newPitch * 0.2);
                }
                targetUp = newPitch;
            }
        }
        float adjT = 0.0f;
        adjT = (double)targetDown == 0.0 ? targetUp : ((double)targetUp == 0.0 ? targetDown : (targetDown + targetUp) / 2.0f);
        if (dist > 0.5) {
            if (!((double)Math.abs(adjT - this.field_70125_A) < 0.55)) {
                this.field_70125_A = adjT < this.field_70125_A ? (float)((double)this.field_70125_A - (double)Math.abs(adjT) * 0.05) : (float)((double)this.field_70125_A + (double)Math.abs(adjT) * 0.5);
            }
        } else {
            if ((double)adjT == 0.0) {
                adjT = -this.field_70125_A;
            }
            this.field_70125_A = adjT < this.field_70125_A ? (float)((double)this.field_70125_A - (double)Math.abs(adjT) * 0.3) : (float)((double)this.field_70125_A + (double)Math.abs(adjT) * 0.1);
        }
        this.func_145775_I();
    }

    public RayTraceResult castFromEntity(Vec3d direction) {
        Vec3d start = this.func_174791_d();
        Vec3d end = direction.func_72432_b().func_178787_e(start);
        return this.field_70170_p.func_147447_a(start, end, false, true, false);
    }

    public void stabilizeRotation() {
        double mag = 2.5;
        double boost = 0.25;
        if (this.getRealSpeed() * 3.6 > 30.0) {
            boost = 0.35;
        }
        RayTraceResult r1 = this.castFromEntity(new Vec3d(1.0 * mag, 0.0, 1.0 * mag));
        RayTraceResult r2 = this.castFromEntity(new Vec3d(-1.0 * mag, 0.0, -1.0 * mag));
        RayTraceResult r3 = this.castFromEntity(new Vec3d(-1.0 * mag, 0.0, 1.0 * mag));
        RayTraceResult r4 = this.castFromEntity(new Vec3d(1.0 * mag, 0.0, -1.0 * mag));
        Object r5 = null;
        if (this.field_70125_A > 5.0f) {
            // empty if block
        }
        if (r1 != null || r2 != null || r3 != null || r4 != null || r5 != null) {
            this.getSolver().frontAxel.applyBrakingForce(1.0);
            this.getSolver().rearAxel.applyBrakingForce(1.0);
            if (r1 != null) {
                if (this.getBlockAt(r1.func_178782_a()) instanceof BlockCarpet) {
                    return;
                }
                this.func_70091_d(MoverType.SELF, -1.0 * boost, 0.0, -1.0 * boost);
            }
            if (r2 != null) {
                if (this.getBlockAt(r2.func_178782_a()) instanceof BlockCarpet) {
                    return;
                }
                this.func_70091_d(MoverType.SELF, 1.0 * boost, 0.0, 1.0 * boost);
            }
            if (r3 != null) {
                if (this.getBlockAt(r3.func_178782_a()) instanceof BlockCarpet) {
                    return;
                }
                this.func_70091_d(MoverType.SELF, 1.0 * boost, 0.0, -1.0 * boost);
            }
            if (r4 != null) {
                if (this.getBlockAt(r4.func_178782_a()) instanceof BlockCarpet) {
                    return;
                }
                this.func_70091_d(MoverType.SELF, -1.0 * boost, 0.0, 1.0 * boost);
            }
            if (r5 != null) {
                if (this.getBlockAt(r5.func_178782_a()) instanceof BlockCarpet) {
                    return;
                }
                this.func_70091_d(MoverType.SELF, 0.0, 1.0 * boost, 0.0);
            }
        }
    }

    public Block getBlockAt(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_177230_c();
    }

    public Vec3d[] calculateTerrainPlane() {
        Vec3d one = this.getWheelPlanePoint(new Vec3d(-1.7, 0.0, 1.75));
        Vec3d two = this.getWheelPlanePoint(new Vec3d(0.5, 0.0, 1.75));
        Vec3d three = this.getWheelPlanePoint(new Vec3d(-1.7, 0.0, -1.75));
        Vec3d four = this.getWheelPlanePoint(new Vec3d(0.5, 0.0, -1.75));
        return new Vec3d[]{one, two, three, four};
    }

    public Vec3d getWheelPlanePoint(Vec3d wheelPos) {
        Vec3d endVec;
        Vec3d realPos = wheelPos.func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d());
        RayTraceResult result = this.field_70170_p.func_147447_a(realPos, endVec = realPos.func_178786_a(0.0, 2.5, 0.0), false, true, false);
        if (result != null) {
            return result.field_72307_f.func_178788_d(this.func_174791_d());
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleDriveParticles() {
        boolean b = this.field_70170_p.func_180495_p(this.func_180425_c()).func_185904_a().func_76224_d();
        if (!this.field_70170_p.func_180495_p(this.func_180425_c().func_177984_a()).func_185904_a().func_76224_d() && b) {
            for (int x = 0; x < 60; ++x) {
                Vec3d pos = this.func_174791_d();
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, pos.field_72450_a + this.field_70146_Z.nextGaussian(), pos.field_72448_b + 1.0 + this.field_70146_Z.nextGaussian() / 2.0, pos.field_72449_c + this.field_70146_Z.nextGaussian(), 0.0, 0.3, 0.0, new int[]{Block.func_176210_f((IBlockState)this.field_70170_p.func_180495_p(this.func_180425_c()))});
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, pos.field_72450_a + this.field_70146_Z.nextGaussian(), pos.field_72448_b + 1.0 + this.field_70146_Z.nextGaussian() / 2.0, pos.field_72449_c + this.field_70146_Z.nextGaussian(), 0.0, 0.3, 0.0, new int[]{Block.func_176210_f((IBlockState)this.field_70170_p.func_180495_p(this.func_180425_c()))});
            }
        }
        if (this.isVehicleRunning()) {
            this.doExhaustParticles(true, new Vec3d(0.25, 0.5, -3.25), 0.5);
            this.doExhaustParticles(true, new Vec3d(-1.45, 0.5, -3.25), 0.5);
        }
        for (WheelSolver w : this.getSolver().wheels) {
            this.doWheelParticles(w);
        }
    }

    public double getRealSpeed() {
        return this.dist * 20.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void doExhaustParticles(boolean spitFire, Vec3d exhaustPosition, double exhaustWidth) {
        Vec3d posExhaust = exhaustPosition.func_178789_a((float)Math.toRadians(this.field_70125_A)).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d());
        Vec3d partDirExhaust = new Vec3d(0.0, 0.3, -1.0).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178789_a((float)Math.toRadians(this.field_70125_A)).func_186678_a(0.1);
        int x = 0;
        while ((double)x < 2.0 + this.solver.synthAccelFor / 2.0) {
            ClientProxy.MC.field_71452_i.func_78873_a((Particle)new ExhaustParticle(this.field_70170_p, posExhaust.field_72450_a, posExhaust.field_72448_b, posExhaust.field_72449_c, partDirExhaust.field_72450_a, partDirExhaust.field_72448_b, partDirExhaust.field_72449_c, 2));
            ++x;
        }
        int max = 1000;
        int min = 0;
        int mult = 20;
        Vec3d partDirExhaust2 = new Vec3d(0.0, 0.3, -1.0).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178789_a((float)Math.toRadians(this.field_70125_A)).func_186678_a(2.0);
        int ran = (int)Math.floor(Math.random() * (double)(max - min + 1) + (double)min);
        if (ran < 1) {
            PositionedSoundRecord ps = new PositionedSoundRecord(this.getConfiguration().getBackfireSound(), SoundCategory.MASTER, 1.5f, 1.0f, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v);
            ClientProxy.MC.func_147118_V().func_147682_a((ISound)ps);
            int x2 = 0;
            while ((double)x2 < 20.0 + this.solver.synthAccelFor) {
                Vec3d pE = posExhaust;
                ClientProxy.MC.field_71452_i.func_78873_a((Particle)new VehicleExhaustFlameParticle(this.field_70170_p, pE.field_72450_a, pE.field_72448_b, pE.field_72449_c, partDirExhaust2.field_72450_a * (double)mult, 0.0, partDirExhaust2.field_72449_c * (double)mult));
                ++x2;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doWheelParticles(WheelSolver wSolve) {
        Vec3d wheelPosition = wSolve.relativePosition;
        boolean isDriveWheel = wSolve.isDriveWheel();
        float wheelAngle = (float)wSolve.wheelAngle;
        Vec3d realPos = wheelPosition.func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d());
        Vec3d direction = new Vec3d(0.0, 0.3, -1.0).func_178785_b(-wheelAngle).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_186678_a(0.1);
        double variation = 5.0;
        double reducer = 1.0;
        if (!isDriveWheel) {
            reducer = 2.0;
        }
        int amount = (int)Math.min(wSolve.wheelAngularVelocity * wSolve.getRadius() / 8.0, 8.0);
        for (int x = 0; x < amount; ++x) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, realPos.field_72450_a + this.field_70146_Z.nextGaussian() / (variation * 12.0), realPos.field_72448_b + this.field_70146_Z.nextGaussian() / variation, realPos.field_72449_c + this.field_70146_Z.nextGaussian() / variation, direction.field_72450_a, direction.field_72448_b + 0.1, direction.field_72449_c, new int[]{Block.func_176210_f((IBlockState)this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()))});
        }
        if (wSolve.isDriveWheel() && Math.abs(Math.toDegrees(this.getSolver().getSideSlipAngle())) > 3.0) {
            ClientProxy.MC.field_71452_i.func_78873_a((Particle)new TireTracks(ClientProxy.MC.func_110434_K(), this.field_70170_p, realPos.field_72450_a, realPos.field_72448_b + 0.001, realPos.field_72449_c, (double)(-this.field_70177_z) + Math.toDegrees(this.getSolver().getSideSlipAngle())));
        }
        if (!isDriveWheel) {
            return;
        }
        if (Math.abs(this.solver.getSideSlipAngle()) > 0.1) {
            Random rand = new Random();
            for (int x = 0; x < 4 + (int)Math.floor(Math.abs(this.solver.getSideSlipAngle()) * 4.0); ++x) {
                double gaus = rand.nextGaussian() / 2.0;
                int id = 2;
                if (this.getSolver().materialBelow != Material.field_151576_e) {
                    id = 1;
                }
                if (this.getSolver().materialBelow == Material.field_151595_p) {
                    id = 4;
                }
                ClientProxy.MC.field_71452_i.func_78873_a((Particle)new DriftCloudParticle(this.field_70170_p, realPos.field_72450_a + gaus, realPos.field_72448_b + gaus + 0.2, realPos.field_72449_c + gaus, direction.field_72450_a, direction.field_72448_b, direction.field_72449_c, id));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doGeneralParticles() {
        Vec3d partDir = new Vec3d(-this.steerangle * 20.0, 0.3, -1.0).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_186678_a(0.1);
        Vec3d posDir = new Vec3d(0.0, 0.0, -1.0).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d());
        if (this.solver.rearAxel.isHandbraking) {
            Random rand = new Random();
            for (int x = 0; x < 4; ++x) {
                double gaus = rand.nextGaussian() / 2.0;
                ClientProxy.MC.field_71452_i.func_78873_a((Particle)new DriftSmokeFX(this.field_70170_p, posDir.field_72450_a + gaus, posDir.field_72448_b + gaus, posDir.field_72449_c + gaus, partDir.field_72450_a, partDir.field_72448_b, partDir.field_72449_c));
            }
        }
        for (int x = 0; x < (int)this.solver.synthAccelFor; ++x) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, posDir.field_72450_a + this.field_70146_Z.nextGaussian() / 2.0, posDir.field_72448_b + this.field_70146_Z.nextGaussian() / 15.0, posDir.field_72449_c + this.field_70146_Z.nextGaussian() / 2.0, partDir.field_72450_a, partDir.field_72448_b + 0.1, partDir.field_72449_c, new int[]{Block.func_176210_f((IBlockState)this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()))});
        }
    }

    public void notifyOfShift(int toGear) {
        this.field_70159_w = 0.0;
        this.isShifting = true;
        this.tickShiftAnim = 0;
    }

    public boolean isInShift() {
        return this.isShifting;
    }

    public void tickShiftAnim() {
        ++this.tickShiftAnim;
    }

    public void updateSuspension(WheelSolver solver) {
        Vec3d realPos = solver.relativePosition.func_178789_a((float)Math.toRadians(this.field_70125_A)).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(this.func_174791_d()).func_72441_c(0.0, this.rideOffset, 0.0);
        RayTraceResult result = this.field_70170_p.func_72933_a(realPos.func_72441_c(0.0, 3.0, 0.0), realPos.func_178786_a(0.0, 8.0, 0.0));
        if (result != null) {
            double h = Math.min(Math.abs(realPos.field_72448_b - result.field_72307_f.field_72448_b) - solver.getRadius() + 0.4, 1.0);
            if (solver.actualRideHeight == 0.0) {
                solver.actualRideHeight = h;
            } else {
                solver.rideHeight = h;
            }
        }
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    protected boolean func_145771_j(double x, double y, double z) {
        System.out.println("FUICK?");
        return super.func_145771_j(x, y, z);
    }

    public void func_70071_h_() {
        this.field_70138_W = 0.3f;
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
        try {
            this.prevRotationRoll = this.rotationRoll;
            this.prevRotationRollH = this.rotationRollH;
            this.updateOBB();
            this.oldCollisions();
            if (this.field_70170_p.field_72995_K) {
                for (WheelSolver ws : this.getSolver().wheels) {
                    ws.prevWheelRot = ws.wheelRot;
                }
                if (!this.func_184207_aI()) {
                    return;
                }
                if (!(this.func_184179_bs() instanceof EntityPlayer)) {
                    return;
                }
                EntityPlayer player = (EntityPlayer)this.func_184179_bs();
                if (player == null) {
                    return;
                }
                this.handleGeneralSound();
                this.handleDriveParticles();
                if (ClientProxy.MC.field_71439_g == player) {
                    GearShiftPattern pattern = this.getSolver().getPhysConf().getShiftPattern();
                    if (this.getState() != VehicleState.STARTING_TO_SHIFT && this.getState() != VehicleState.SHIFTING && this.getState() != VehicleState.FINISHING_SHIFT) {
                        if (this.smoothShift.get().func_72433_c() != 0.0) {
                            this.smoothShift.set(pattern.quickDoAnimation(this.getSolver().transmission).func_186678_a(0.3));
                        }
                        this.smoothShift.updatePrev();
                    }
                    this.doOBBCollision();
                    this.keyBasedSteering();
                    this.updateControls();
                    this.tickLerp();
                    super.func_70071_h_();
                    this.drivingAspect.onUpdate(this);
                    this.getSuspensionStrategy().update(this.getSpeed(), this.lastYawDelta);
                    if (this.func_70094_T()) {
                        System.out.println("REPORT!");
                    }
                    this.getSolver().activate(this);
                    Vec3d oldPos = this.func_174791_d();
                    this.solver.engineSolver.previousRPM = this.solver.getCurrentRPM();
                    try {
                        for (int x = 0; x < 50; ++x) {
                            this.getSolver().updatePhysics();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.getSolver().resetStep();
                    Vec3d newPos = this.func_174791_d();
                    this.prevDist = this.dist;
                    this.dist = newPos.func_178788_d(oldPos).func_72433_c();
                    this.prevtV = this.tV;
                    this.tV = (this.dist * 20.0 - this.prevtV * 20.0) / 20.0;
                    this.handleHillClimbing();
                    MWC.CHANNEL.sendToServer((IMessage)new VehicleControlMessage(new VehicleDataContainer(this)));
                    this.stabilizeRotation();
                } else {
                    this.smoothShell.update();
                }
            }
            if (this.field_70170_p.field_72995_K) {
                this.field_70159_w = this.field_70159_w <= 2.0 ? (this.field_70159_w += 1.0) : 0.0;
                this.drivingAspect = new VehicleDrivingAspect();
                if (this.field_70159_w == 3.0 && this.isShifting) {
                    this.isShifting = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleGeneralSound() {
        Material mat = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_185904_a();
        if (this.isInShift()) {
            PositionedSoundRecord ps = new PositionedSoundRecord(this.getConfiguration().getShiftSound(), SoundCategory.MASTER, 1.5f, 1.0f, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v);
            ClientProxy.MC.func_147118_V().func_147682_a((ISound)ps);
        }
        if (this.drivingSound != null && (this.drivingSound.func_147667_k() || !this.isVehicleRunning())) {
            this.drivingSound = null;
        }
        if (this.driftingSound != null && this.driftingSound.func_147667_k()) {
            this.driftingSound = null;
        }
        if (this.current != mat) {
            this.driftingSound = null;
        }
        if (this.drivingSound == null && this.isVehicleRunning()) {
            this.drivingSound = new EngineMovingSound(this.getConfiguration().getRunSound(), this.soundPositionProvider, this.donePlayingSoundProvider, this, false);
            ClientProxy.MC.func_147118_V().func_147682_a((ISound)this.drivingSound);
        }
        if (this.driftingSound == null) {
            // empty if block
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    @Override
    public <E extends ExtendedState<VehicleState>> void prepareTransaction(E finallyUpdateToState) {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public void doNetworking(boolean slave) {
        try {
            if (!slave) {
                VehiclePhysicsSolver s = this.getSolver();
                ((VehicleDataSerializer)this.func_184212_Q().func_187225_a(VEHICLE_DAT)).setData(this.func_174791_d(), this.throttle, this.driftTuner, this.isBraking, this.forwardLean, this.sideLean, this.wheelRotationAngle, this.steerangle);
                ((VehiclePhysSerializer)this.func_184212_Q().func_187225_a(SOLVER_DAT)).setData(s.synthAccelFor, s.synthAccelSide, s.velocity);
                this.func_184212_Q().func_187217_b(VEHICLE_DAT);
                this.func_184212_Q().func_187217_b(SOLVER_DAT);
            } else {
                ((VehicleDataSerializer)this.func_184212_Q().func_187225_a(VEHICLE_DAT)).updateVehicle(this);
                ((VehiclePhysSerializer)this.func_184212_Q().func_187225_a(SOLVER_DAT)).updateSolver(this.solver);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setContext(ModContext modContext) {
        this.context = modContext;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_180136_u()) {
            this.solver = null;
            this.func_70106_y();
        }
        return super.func_70097_a(source, amount);
    }

    private static enum DriverInteractionEvent {
        NONE,
        ENTER,
        EXIT,
        DRIVING,
        OUT;

    }
}

