/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.shader.jim;

import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.shader.jim.ShaderLoader;
import com.paneedah.weaponlib.shader.jim.Uniform;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL20;

public class Shader {
    private int shader;
    private List<Uniform> uniforms = new ArrayList<Uniform>(2);

    public Shader(int shader) {
        this.shader = shader;
    }

    public Shader withUniforms(Uniform ... uniforms) {
        for (Uniform u : uniforms) {
            this.uniforms.add(u);
        }
        return this;
    }

    public void use() {
        if (!ShaderLoader.enableShaders) {
            return;
        }
        if (!ModernConfigManager.enableAllShaders) {
            return;
        }
        GL20.glUseProgram((int)this.shader);
        for (Uniform uniform : this.uniforms) {
            uniform.apply(this.shader);
        }
    }

    public void release() {
        GL20.glUseProgram((int)0);
    }

    public int getShaderId() {
        return this.shader;
    }

    public void sendMatrix4AsUniform(String name, boolean transpose, FloatBuffer mat) {
        OpenGlHelper.func_153160_c((int)this.getLoc(name), (boolean)transpose, (FloatBuffer)mat);
    }

    public void boolean1b(String name, boolean b) {
        this.uniform1i(name, b ? 1 : 0);
    }

    public void uniform1i(String name, int i) {
        OpenGlHelper.func_153163_f((int)this.getLoc(name), (int)i);
    }

    public void uniform1f(String name, float i) {
        GL20.glUniform1f((int)this.getLoc(name), (float)i);
    }

    public void uniform2f(String name, float f0, float f1) {
        GL20.glUniform2f((int)this.getLoc(name), (float)f0, (float)f1);
    }

    public void uniform3f(String name, float f, float g, float h) {
        GL20.glUniform3f((int)this.getLoc(name), (float)f, (float)g, (float)h);
    }

    private int getLoc(String name) {
        return OpenGlHelper.func_153194_a((int)this.getShaderId(), (CharSequence)name);
    }
}

