/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render.scopes;

import java.awt.Color;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class Reticle {
    private static final int DEFAULT_TINT = 5727604;
    private ResourceLocation reticleTexture;
    private Type reticleType = Type.HOLOGRAPHIC;
    private float textureScale;
    private Vec3d backgroundColor;

    public Reticle(String textureName) {
        this(textureName, 1.0f, 5727604);
        this.reticleType = Type.SNIPER;
    }

    public Reticle(String textureName, float textureScale, int background) {
        this.reticleTexture = new ResourceLocation("mwc:textures/crosshairs/" + textureName + ".png");
        this.textureScale = textureScale;
        this.backgroundColor = Reticle.extractColorFromHex(background);
    }

    public Reticle(String textureName, float textureScale) {
        this(textureName, textureScale, 5727604);
        this.reticleType = Type.HOLOGRAPHIC;
    }

    private static Vec3d extractColorFromHex(int color) {
        Color col = new Color(color);
        return new Vec3d((double)((float)col.getRed() / 255.0f), (double)((float)col.getBlue() / 255.0f), (double)((float)col.getGreen() / 255.0f));
    }

    public ResourceLocation getReticleTexture() {
        return this.reticleTexture;
    }

    public void setReticleTexture(ResourceLocation reticleTexture) {
        this.reticleTexture = reticleTexture;
    }

    public float getTextureScale() {
        return this.textureScale;
    }

    public void setTextureScale(float textureScale) {
        this.textureScale = textureScale;
    }

    public Vec3d getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Vec3d backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public static int getDefaultTint() {
        return 5727604;
    }

    public static enum Type {
        HOLOGRAPHIC,
        SNIPER;

    }
}

