/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render.gui;

import com.paneedah.mwc.proxies.ClientProxy;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class GUIRenderHelper {
    private static final double FONT_SIZE_HALVED = (double)ClientProxy.MC.field_71466_p.field_78288_b / 2.0;

    public static String formatTimeString(long time, TimeUnit unit) {
        FiniteDuration duration = Duration.create((long)time, (TimeUnit)unit);
        if (duration.toDays() != 0L) {
            return duration.toDays() + "d " + (duration.toHours() - duration.toDays() * 24L) + "h ";
        }
        if (duration.toHours() != 0L) {
            return duration.toHours() + "h " + (duration.toMinutes() - duration.toHours() * 60L) + "m " + (duration.toSeconds() - duration.toMinutes() * 60L) + "s";
        }
        if (duration.toMinutes() != 0L) {
            return duration.toMinutes() + "m " + (duration.toSeconds() - duration.toMinutes() * 60L) + "s";
        }
        if (duration.toSeconds() != 0L) {
            return duration.toSeconds() + "s";
        }
        return "";
    }

    public static void drawAlignedString(String text, StringAlignment alignment, boolean verticallyCentered, double x, double y, double scale, int color) {
        switch (alignment) {
            case CENTERED: {
                x -= (double)ClientProxy.MC.field_71466_p.func_78256_a(text) * scale / 2.0;
            }
            case RIGHT: {
                x -= (double)ClientProxy.MC.field_71466_p.func_78256_a(text) * scale;
            }
        }
        if (verticallyCentered) {
            y += FONT_SIZE_HALVED;
        }
        GUIRenderHelper.drawScaledString(text, x, y, scale, color);
    }

    public static boolean checkInBox(double tX, double tY, double x, double y, double width, double height) {
        return tX >= x && tX <= x + width && tY >= y && tY <= y + height;
    }

    public static void drawScaledString(String text, double x, double y, double scale, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)0.0);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        ClientProxy.MC.field_71466_p.func_175063_a(text, 0.0f, 0.0f, color);
        GlStateManager.func_179121_F();
    }

    public static void quickItemRender(Item item, double x, double y, double scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)0.0);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
        RenderHelper.func_74520_c();
        ClientProxy.MC.func_175599_af().func_175042_a(new ItemStack(item), 0, 0);
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    public static void drawTexturedRect(double x, double y, float u, float v, double width, double height, double textureWidth, double textureHeight) {
        float f = (float)(1.0 / textureWidth);
        float f1 = (float)(1.0 / textureHeight);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_187315_a((double)(u * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_187315_a((double)((u + (float)width) * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_187315_a((double)((u + (float)width) * f), (double)(v * f1)).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawColoredRectangle(double x, double y, double width, double height, double alpha, int color) {
        float r = (float)((double)((color & 0xFF0000) >> 16) / 255.0);
        float g = (float)((double)((color & 0xFF00) >> 8) / 255.0);
        float b = (float)((double)(color & 0xFF) / 255.0);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_181666_a(r, g, b, (float)alpha).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_181666_a(r, g, b, (float)alpha).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_181666_a(r, g, b, (float)alpha).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_181666_a(r, g, b, (float)alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedScaledRect(double x, double y, float u, float v, double width, double height, double textureWidth, double textureHeight, double scale) {
        float f = (float)(1.0 / textureWidth);
        float f1 = (float)(1.0 / textureHeight);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height * scale, 0.0).func_187315_a((double)(u * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b(x + width * scale, y + height * scale, 0.0).func_187315_a((double)((u + (float)width) * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b(x + width * scale, y, 0.0).func_187315_a((double)((u + (float)width) * f), (double)(v * f1)).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static enum StringAlignment {
        CENTERED,
        LEFT,
        RIGHT;

    }
}

