/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render.bgl.instancing;

import com.paneedah.weaponlib.render.VAOData;
import com.paneedah.weaponlib.render.VAOLoader;
import com.paneedah.weaponlib.render.bgl.GLCompatible;
import com.paneedah.weaponlib.render.bgl.ModernUtil;
import com.paneedah.weaponlib.render.bgl.instancing.InstancedAttribute;
import com.paneedah.weaponlib.shader.jim.Shader;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;

public abstract class BasicInstancedObject<K> {
    private K genericType;
    private int maxObjects;
    private int instanceVBO;
    private VAOData vao;
    private FloatBuffer instancedBuffer;
    protected int arrayPointer;
    private Shader renderShader;
    protected String shaderName;
    private int instanceDataLength;
    private int largestAttribute = 0;
    private int renderMode;
    private InstancedAttribute[] attribs;

    public BasicInstancedObject(String shader, int renderMode, int maxCopies, InstancedAttribute ... attribs) {
        this.shaderName = shader;
        this.renderMode = renderMode;
        this.maxObjects = maxCopies;
        this.attribs = attribs;
    }

    protected abstract void setupShader();

    protected void initialize(VAOData vao) {
        this.vao = vao;
        if (this.attribs != null) {
            for (InstancedAttribute attr : this.attribs) {
                this.instanceDataLength += attr.getAttributeType().getSize();
            }
        }
        this.instancedBuffer = BufferUtils.createFloatBuffer((int)(this.getInstanceDataLength() * this.getMaxObjects()));
        this.instanceVBO = ModernUtil.createEmptyVBO(this.maxObjects * this.instanceDataLength);
        GLCompatible.glBindVertexArray(vao.getVaoID());
        int offset = 0;
        if (this.attribs != null) {
            for (InstancedAttribute attr : this.attribs) {
                ModernUtil.addInstancedAttribute(vao.getVaoID(), this.instanceVBO, attr.getAttributeID(), attr.getAttributeType().getSize(), this.instanceDataLength, offset);
                offset += attr.getAttributeType().getSize();
                if (attr.getAttributeID() <= this.largestAttribute) continue;
                this.largestAttribute = attr.getAttributeID();
            }
        }
        GLCompatible.glBindVertexArray(0);
    }

    protected void preRender() {
        this.renderShader.use();
        GLCompatible.glBindVertexArray(this.vao.getVaoID());
        ModernUtil.enableVertexAttribRange(0, this.largestAttribute);
    }

    protected void postRender() {
        ModernUtil.disableVertexAttribRange(0, this.largestAttribute);
        GLCompatible.glBindVertexArray(0);
        this.renderShader.release();
    }

    public abstract void updateData(K var1);

    public void render(int primCount) {
        this.preRender();
        GLCompatible.glDrawArraysInstanced(this.renderMode, 0, this.vao.getVertexCount(), primCount);
        this.postRender();
    }

    public void uploadToBuffer(float[] data) {
        VAOLoader.updateVBO(this.getInstanceVBO(), data, this.getInstancedBuffer());
    }

    public K getGenericType() {
        return this.genericType;
    }

    public void setGenericType(K genericType) {
        this.genericType = genericType;
    }

    public int getMaxObjects() {
        return this.maxObjects;
    }

    public void setMaxObjects(int maxObjects) {
        this.maxObjects = maxObjects;
    }

    public int getInstanceVBO() {
        return this.instanceVBO;
    }

    public void setInstanceVBO(int instanceVBO) {
        this.instanceVBO = instanceVBO;
    }

    public VAOData getVao() {
        return this.vao;
    }

    public void setVao(VAOData vao) {
        this.vao = vao;
    }

    public FloatBuffer getInstancedBuffer() {
        return this.instancedBuffer;
    }

    public void setInstancedBuffer(FloatBuffer instancedBuffer) {
        this.instancedBuffer = instancedBuffer;
    }

    public int getArrayPointer() {
        return this.arrayPointer;
    }

    public void setArrayPointer(int arrayPointer) {
        this.arrayPointer = arrayPointer;
    }

    public Shader getRenderShader() {
        return this.renderShader;
    }

    public void setRenderShader(Shader renderShader) {
        this.renderShader = renderShader;
    }

    public int getInstanceDataLength() {
        return this.instanceDataLength;
    }

    public void setInstanceDataLength(int instanceDataLength) {
        this.instanceDataLength = instanceDataLength;
    }

    public int getLargestAttribute() {
        return this.largestAttribute;
    }

    public void setLargestAttribute(int largestAttribute) {
        this.largestAttribute = largestAttribute;
    }

    public int getRenderMode() {
        return this.renderMode;
    }

    public void setRenderMode(int renderMode) {
        this.renderMode = renderMode;
    }

    public InstancedAttribute[] getAttribs() {
        return this.attribs;
    }

    public void setAttribs(InstancedAttribute[] attribs) {
        this.attribs = attribs;
    }
}

