/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render.bgl;

import com.paneedah.weaponlib.config.ModernConfigManager;
import org.apache.commons.lang3.SystemUtils;
import org.lwjgl.opengl.APPLEVertexArrayObject;
import org.lwjgl.opengl.ARBDrawInstanced;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.ARBTextureMultisample;
import org.lwjgl.opengl.ARBVertexArrayObject;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTDrawInstanced;
import org.lwjgl.opengl.EXTFramebufferBlit;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GLContext;

public class GLCompatible {
    public static final int NORMAL = 0;
    public static final int ARB = 1;
    public static final int EXT = 2;
    public static final int APPLE = 3;
    public static final int ATI = 4;
    public static boolean supportsInstancing = true;
    public static int fboType = -1;
    public static int msaaType = -1;
    public static int vaoType = -1;
    public static int instancingType = -1;
    public static int attribDivisorType = -1;
    public static int multisampleType = -1;
    public static int GL_READ_FRAMEBUFFER;
    public static int GL_DRAW_FRAMEBUFFER;
    public static int GL_FRAMEBUFFER;
    public static int GL_COLOR_ATTACHMENT0;
    public static int GL_DEPTH_ATTACHMENT;
    public static int GL_RENDERBUFFER;
    public static int GL_RGBA16F;
    public static int GL_DEPTH_COMPONENT24;
    public static int GL_TEXTURE_2D_MULTISAMPLE;
    public static int GL_VERTEX_ARRAY_BINDING;
    public static boolean isLoaded;

    public static boolean doesSupportInstancing() {
        return supportsInstancing && ModernConfigManager.enableAllShaders;
    }

    public static int glGenVertexArrays() {
        switch (vaoType) {
            case 3: {
                return APPLEVertexArrayObject.glGenVertexArraysAPPLE();
            }
            case 1: {
                return ARBVertexArrayObject.glGenVertexArrays();
            }
            case 0: {
                return GL30.glGenVertexArrays();
            }
        }
        return 0;
    }

    public static void glBindVertexArray(int arg0) {
        switch (vaoType) {
            case 3: {
                APPLEVertexArrayObject.glBindVertexArrayAPPLE((int)arg0);
                break;
            }
            case 1: {
                ARBVertexArrayObject.glBindVertexArray((int)arg0);
                break;
            }
            case 0: {
                GL30.glBindVertexArray((int)arg0);
            }
        }
    }

    public static boolean glIsVertexArray(int arg0) {
        switch (vaoType) {
            case 3: {
                return APPLEVertexArrayObject.glIsVertexArrayAPPLE((int)arg0);
            }
            case 1: {
                return ARBVertexArrayObject.glIsVertexArray((int)arg0);
            }
            case 0: {
                return GL30.glIsVertexArray((int)arg0);
            }
        }
        return false;
    }

    public static void glDeleteVertexArrays(int arg0) {
        switch (vaoType) {
            case 3: {
                APPLEVertexArrayObject.glDeleteVertexArraysAPPLE((int)arg0);
                break;
            }
            case 1: {
                ARBVertexArrayObject.glDeleteVertexArrays((int)arg0);
                break;
            }
            case 0: {
                GL30.glDeleteVertexArrays((int)arg0);
            }
        }
    }

    public static void glVertexAttribDivisor(int arg0, int arg1) {
        switch (attribDivisorType) {
            case 1: {
                ARBInstancedArrays.glVertexAttribDivisorARB((int)arg0, (int)arg1);
                break;
            }
            case 0: {
                GL33.glVertexAttribDivisor((int)arg0, (int)arg1);
            }
        }
    }

    public static void glDrawElementsInstanced(int arg0, int arg1, int arg2, long arg3, int arg4) {
        switch (instancingType) {
            case 1: {
                ARBDrawInstanced.glDrawElementsInstancedARB((int)arg0, (int)arg1, (int)arg2, (long)arg3, (int)arg4);
                break;
            }
            case 2: {
                EXTDrawInstanced.glDrawElementsInstancedEXT((int)arg0, (int)arg1, (int)arg2, (long)arg3, (int)arg4);
                break;
            }
            case 0: {
                GL31.glDrawElementsInstanced((int)arg0, (int)arg1, (int)arg2, (long)arg3, (int)arg4);
            }
        }
    }

    public static void glDrawArraysInstanced(int mode, int first, int count, int priMCount) {
        switch (instancingType) {
            case 0: {
                GL31.glDrawArraysInstanced((int)mode, (int)first, (int)count, (int)priMCount);
                break;
            }
            case 1: {
                ARBDrawInstanced.glDrawArraysInstancedARB((int)mode, (int)first, (int)count, (int)priMCount);
                break;
            }
            case 2: {
                EXTDrawInstanced.glDrawArraysInstancedEXT((int)mode, (int)first, (int)count, (int)priMCount);
            }
        }
    }

    public static void init() {
        if (isLoaded) {
            return;
        }
        isLoaded = true;
        ContextCapabilities cap = GLContext.getCapabilities();
        if (cap.OpenGL33) {
            attribDivisorType = 0;
        } else if (cap.GL_ARB_instanced_arrays) {
            attribDivisorType = 1;
        } else {
            supportsInstancing = false;
        }
        if (cap.OpenGL31) {
            instancingType = 0;
        } else if (cap.GL_ARB_draw_instanced) {
            instancingType = 1;
        } else if (cap.GL_EXT_draw_instanced) {
            instancingType = 2;
        } else {
            supportsInstancing = false;
        }
        if (SystemUtils.IS_OS_MAC) {
            supportsInstancing = false;
        }
        if (cap.OpenGL30) {
            vaoType = 0;
            GL_VERTEX_ARRAY_BINDING = 34229;
        } else if (cap.GL_ARB_vertex_array_object) {
            vaoType = 1;
            GL_VERTEX_ARRAY_BINDING = 34229;
        } else if (cap.GL_APPLE_vertex_array_object) {
            GL_VERTEX_ARRAY_BINDING = 34229;
            vaoType = 3;
        }
        if (cap.OpenGL30) {
            fboType = 0;
            GL_READ_FRAMEBUFFER = 36008;
            GL_DRAW_FRAMEBUFFER = 36009;
            GL_FRAMEBUFFER = 36160;
            GL_RENDERBUFFER = 36161;
            GL_DEPTH_ATTACHMENT = 36096;
            GL_COLOR_ATTACHMENT0 = 36064;
        } else if (cap.GL_ARB_framebuffer_object) {
            fboType = 1;
            GL_READ_FRAMEBUFFER = 36008;
            GL_DRAW_FRAMEBUFFER = 36009;
            GL_FRAMEBUFFER = 36160;
            GL_RENDERBUFFER = 36161;
            GL_COLOR_ATTACHMENT0 = 36064;
            GL_DEPTH_ATTACHMENT = 36096;
        } else if (cap.GL_EXT_framebuffer_object && cap.GL_EXT_framebuffer_blit) {
            GL_READ_FRAMEBUFFER = 36008;
            GL_DRAW_FRAMEBUFFER = 36009;
            GL_FRAMEBUFFER = 36160;
            GL_COLOR_ATTACHMENT0 = 36064;
            GL_DEPTH_ATTACHMENT = 36096;
            GL_RENDERBUFFER = 36161;
            fboType = 2;
        } else {
            System.out.println("Framebuffer objects not supported");
        }
        if (cap.OpenGL30) {
            GL_RGBA16F = 34842;
        } else if (cap.GL_APPLE_float_pixels) {
            GL_RGBA16F = 34842;
        } else if (cap.GL_ARB_texture_float) {
            GL_RGBA16F = 34843;
        } else if (cap.GL_ATI_texture_float) {
            GL_RGBA16F = 34842;
        } else {
            System.out.println("Floating point texture component not supported");
        }
        if (cap.OpenGL14) {
            GL_DEPTH_COMPONENT24 = 33190;
        } else if (cap.GL_ARB_depth_texture) {
            GL_DEPTH_COMPONENT24 = 33190;
        }
        if (cap.OpenGL32) {
            multisampleType = 0;
            GL_TEXTURE_2D_MULTISAMPLE = 37120;
        } else if (cap.GL_ARB_texture_multisample) {
            multisampleType = 1;
            GL_TEXTURE_2D_MULTISAMPLE = 37120;
        }
    }

    public static void glTexImage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations) {
        GLCompatible.init();
        switch (multisampleType) {
            case 0: {
                GL32.glTexImage2DMultisample((int)target, (int)samples, (int)internalformat, (int)width, (int)height, (boolean)fixedsamplelocations);
                break;
            }
            case 1: {
                ARBTextureMultisample.glTexImage2DMultisample((int)target, (int)samples, (int)internalformat, (int)width, (int)height, (boolean)fixedsamplelocations);
            }
        }
    }

    public static int glGenFramebuffers() {
        GLCompatible.init();
        switch (fboType) {
            case 0: {
                return GL30.glGenFramebuffers();
            }
            case 1: {
                return ARBFramebufferObject.glGenFramebuffers();
            }
            case 2: {
                return EXTFramebufferObject.glGenFramebuffersEXT();
            }
        }
        return -1;
    }

    public static void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        GLCompatible.init();
        switch (fboType) {
            case 0: {
                GL30.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
                break;
            }
            case 1: {
                ARBFramebufferObject.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
                break;
            }
            case 2: {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
            }
        }
    }

    public static void glBindFramebuffer(int target, int framebuffer) {
        GLCompatible.init();
        switch (fboType) {
            case 0: {
                GL30.glBindFramebuffer((int)target, (int)framebuffer);
                break;
            }
            case 1: {
                ARBFramebufferObject.glBindFramebuffer((int)target, (int)framebuffer);
                break;
            }
            case 2: {
                EXTFramebufferObject.glBindFramebufferEXT((int)target, (int)framebuffer);
            }
        }
    }

    public static void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        GLCompatible.init();
        switch (fboType) {
            case 0: {
                GL30.glBlitFramebuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
                break;
            }
            case 1: {
                ARBFramebufferObject.glBlitFramebuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
                break;
            }
            case 2: {
                EXTFramebufferBlit.glBlitFramebufferEXT((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
            }
        }
    }

    public static void glBindAttribLocation(int shaderID, int attribID, String variableName) {
        GL20.glBindAttribLocation((int)shaderID, (int)attribID, (CharSequence)variableName);
    }

    static {
        isLoaded = false;
        GLCompatible.init();
    }
}

