/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import com.paneedah.weaponlib.render.GLModelBuilder;
import com.paneedah.weaponlib.render.bgl.GLCompatible;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public class WavefrontModel {
    public ArrayList<float[]> vertex = new ArrayList();
    public ArrayList<float[]> texcoord = new ArrayList();
    public ArrayList<float[]> normals = new ArrayList();
    public ArrayList<Integer> indexBuffer = new ArrayList();
    public ArrayList<Vertex> vertices = new ArrayList();
    public HashMap<String, Integer> indexVertexMap = new HashMap();
    protected int ebo = -1;
    protected int vao = -1;
    protected int vbo = -1;
    private boolean hasVAO;

    public void buildIndexBuffer(String[] line) {
        for (int i = 1; i < line.length; ++i) {
            String[] subArray = line[i].split("/");
            String vertexID = subArray[0] + "t" + subArray[1] + "n" + subArray[2];
            if (this.indexVertexMap.containsKey(vertexID)) {
                this.indexBuffer.add(this.indexVertexMap.get(vertexID));
                continue;
            }
            int newIndex = this.indexVertexMap.size();
            this.indexVertexMap.put(vertexID, newIndex);
            this.vertices.add(this.buildVertexFromString(subArray));
            this.indexBuffer.add(newIndex);
        }
    }

    public boolean usesVAO() {
        return this.hasVAO;
    }

    public int getVAOID() {
        return this.vao;
    }

    public Vertex buildVertexFromString(String[] array) {
        int vertID = Integer.parseInt(array[0]);
        int texID = Integer.parseInt(array[1]);
        int normalID = Integer.parseInt(array[2]);
        Vertex vert = new Vertex(this.texcoord.get(texID - 1), this.vertex.get(vertID - 1), this.normals.get(normalID - 1));
        return vert;
    }

    public void build() {
        IntBuffer intBuf = BufferUtils.createIntBuffer((int)this.indexBuffer.size());
        for (int i : this.indexBuffer) {
            intBuf.put(i);
        }
        intBuf.rewind();
        this.ebo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)this.ebo);
        GL15.glBufferData((int)34963, (IntBuffer)intBuf, (int)35044);
        GL15.glBindBuffer((int)34963, (int)0);
        this.vbo = GLModelBuilder.buildVBO(this.vertices);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public int buildVAO() {
        this.hasVAO = true;
        int vS = 32;
        IntBuffer intBuf = BufferUtils.createIntBuffer((int)this.indexBuffer.size());
        for (int i : this.indexBuffer) {
            intBuf.put(i);
        }
        intBuf.rewind();
        GL11.glEnable((int)34962);
        this.vao = GLModelBuilder.createVAO();
        this.ebo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)this.ebo);
        GL15.glBufferData((int)34963, (IntBuffer)intBuf, (int)35044);
        this.vbo = GLModelBuilder.buildVBO(this.vertices);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)vS, (long)0L);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glVertexAttribPointer((int)1, (int)3, (int)5126, (boolean)false, (int)vS, (long)20L);
        GL20.glEnableVertexAttribArray((int)2);
        GL20.glVertexAttribPointer((int)2, (int)2, (int)5126, (boolean)false, (int)vS, (long)12L);
        GLCompatible.glBindVertexArray(0);
        GL15.glBindBuffer((int)34963, (int)0);
        return this.vao;
    }

    public void render() {
        GlStateManager.func_187410_q((int)32884);
        GlStateManager.func_187410_q((int)32888);
        GlStateManager.func_187410_q((int)32885);
        GL15.glBindBuffer((int)34963, (int)this.ebo);
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        int vS = 32;
        GL11.glVertexPointer((int)3, (int)5126, (int)vS, (long)0L);
        GL11.glNormalPointer((int)5126, (int)vS, (long)20L);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)vS, (long)12L);
        GL11.glDrawElements((int)4, (int)this.indexBuffer.size(), (int)5125, (long)0L);
        GL15.glBindBuffer((int)34963, (int)0);
        GL15.glBindBuffer((int)34962, (int)0);
        GlStateManager.func_187429_p((int)32884);
        GlStateManager.func_187429_p((int)32888);
        GlStateManager.func_187429_p((int)32885);
    }

    public static class Vertex {
        public float[] texCoord;
        public float[] pos;
        public float[] normal;

        public Vertex(float[] tex, float[] pos, float[] normal) {
            this.texCoord = tex;
            this.pos = pos;
            this.normal = normal;
        }
    }
}

