/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import com.paneedah.weaponlib.render.VAOData;
import com.paneedah.weaponlib.render.bgl.GLCompatible;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class VAOLoader {
    public static VAOData loadToVAO(float[] positions) {
        int vaoID = VAOLoader.createVAO();
        VAOLoader.storeDataInAttributeList(0, positions);
        VAOLoader.unbindVAO();
        return new VAOData(vaoID, positions.length / 3);
    }

    public static int createVAO() {
        int vaoID = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)vaoID);
        return vaoID;
    }

    public static void storeDataInAttributeList(int attribNumber, float[] data) {
        int vboID = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vboID);
        FloatBuffer buffer = VAOLoader.makeFloatBufferFromArray(data);
        GL15.glBufferData((int)34962, (FloatBuffer)buffer, (int)35044);
        GL20.glVertexAttribPointer((int)attribNumber, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public static void updateVBO(int vbo, float[] data, FloatBuffer buffer) {
        buffer.clear();
        buffer.put(data);
        buffer.flip();
        GL15.glBindBuffer((int)34962, (int)vbo);
        GL15.glBufferData((int)34962, (long)(buffer.capacity() * 4), (int)35040);
        GL15.glBufferSubData((int)34962, (long)0L, (FloatBuffer)buffer);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public static void unbindVAO() {
        GL30.glBindVertexArray((int)0);
    }

    public static FloatBuffer makeFloatBufferFromArray(float[] data) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)data.length);
        buffer.put(data);
        buffer.flip();
        return buffer;
    }

    public int createEmptyVBO(int floatCount) {
        int vbo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vbo);
        GL15.glBufferData((int)34962, (long)(floatCount * 4), (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
        return vbo;
    }

    public void addInstancedAttribute(int vao, int vbo, int attribute, int dataSize, int instancedDataLength, int offset) {
        GL15.glBindBuffer((int)34962, (int)vbo);
        GLCompatible.glBindVertexArray(vao);
        GL20.glVertexAttribPointer((int)attribute, (int)dataSize, (int)5126, (boolean)false, (int)(instancedDataLength * 4), (long)(offset * 4));
        GLCompatible.glVertexAttribDivisor(attribute, 1);
        GL15.glBindBuffer((int)34962, (int)0);
        GLCompatible.glBindVertexArray(0);
    }
}

