/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.ClientModContext;
import com.paneedah.weaponlib.Pair;
import com.paneedah.weaponlib.animation.MatrixHelper;
import com.paneedah.weaponlib.numerical.RandomVector;
import com.paneedah.weaponlib.numerical.SpringVector;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec3d;

public class NewScreenshakingManager {
    public RandomVector randomVec = new RandomVector();
    public double prevIntensity;
    public double intensity;
    public SpringVector springVector = new SpringVector(1.0, 2.0, 2.0);
    private double prevX;
    private double prevY;
    private double prevZ;
    private double prevRotX;
    private double prevRotY;
    private double prevRotZ;
    private double x;
    private double y;
    private double z;
    private double rotX;
    private double rotY;
    private double rotZ;
    public double dt = 0.0;
    public long currentTime = System.currentTimeMillis();
    public double accumulator;
    public Vec3d interpolated = Vec3d.field_186680_a;

    private double getRandom(double min, double max) {
        return Math.random() * (max - min + 1.0) + min;
    }

    private double getRandomWithNegative(double min, double max) {
        double random = Math.random() * (max - min + 1.0) + min;
        if (Math.random() < 0.5) {
            random *= -1.0;
        }
        return random;
    }

    public void impulse(double mag) {
        this.intensity += mag;
        this.x = -10.0 * mag;
        this.z = 2.0 * mag;
        this.springVector.addVelocity(this.x, this.y, this.z);
    }

    public void applyWorld() {
        float pt = ClientProxy.MC.func_184121_ak();
        if (ClientModContext.getContext() != null && ClientModContext.getContext().getMainHeldWeapon() != null) {
            Pair<Double, Double> param = ClientModContext.getContext().getMainHeldWeapon().getScreenShakeParameters();
            this.springVector.setXSpringParam(2.0, 3000.0 * param.getSecond(), 200.0 * param.getSecond());
            this.springVector.setZSpringParam(4.0, 9000.0 * param.getSecond(), 75.0 * param.getSecond());
        } else {
            this.springVector.setXSpringParam(2.0, 3000.0, 200.0);
            this.springVector.setZSpringParam(4.0, 9000.0, 75.0);
        }
        Vec3d rotVec = this.interpolated;
        GlStateManager.func_179114_b((float)((float)rotVec.field_72449_c), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)rotVec.field_72450_a), (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public void applyHead() {
        float pt = ClientProxy.MC.func_184121_ak();
        double i = MatrixHelper.solveLerp(this.prevIntensity, this.intensity, (double)pt);
    }

    public void update() {
        this.dt = 0.008333333333333333;
        long newTime = System.currentTimeMillis();
        double frameTime = (double)(newTime - this.currentTime) / 1000.0;
        this.currentTime = newTime;
        if (frameTime > 0.25) {
            frameTime = 0.25;
        }
        this.accumulator += frameTime;
        Vec3d prev = this.springVector.getPosition();
        while (this.accumulator >= this.dt) {
            this.springVector.update(this.dt);
            this.accumulator -= this.dt;
        }
        this.interpolated = MatrixHelper.lerpVectors(prev, this.springVector.getPosition(), (float)(this.accumulator / this.dt));
    }
}

