/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.shader.jim.Attribute;
import com.paneedah.weaponlib.shader.jim.Shader;
import com.paneedah.weaponlib.shader.jim.ShaderLoader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class ModernSkyRenderer
extends IRenderHandler {
    public static int cubeMapTexture = -1;
    public static float[] cubeMap = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f};
    private static final String str = "mwc:textures/sky/hd/";
    public Shader skyShader = ShaderLoader.loadShader("sky", new Attribute[0]);

    public static ByteBuffer readByteBuffer3(BufferedImage image) {
        int[] pixels = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        ByteBuffer buffer = ByteBuffer.allocateDirect(image.getWidth() * image.getHeight() * 3);
        for (int h = 0; h < image.getHeight(); ++h) {
            for (int w = 0; w < image.getWidth(); ++w) {
                int pixel = pixels[h * image.getWidth() + w];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
            }
        }
        buffer.flip();
        buffer.rewind();
        return buffer;
    }

    public ByteBuffer readImageFromFile(ResourceLocation location) {
        IResource resource = null;
        try {
            resource = ClientProxy.MC.func_110442_L().func_110536_a(location);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ByteBuffer buf = null;
        try {
            BufferedImage image = ImageIO.read(resource.func_110527_b());
            buf = ByteBuffer.allocateDirect(image.getWidth() * image.getHeight() * 3);
            buf.put(ModernSkyRenderer.readByteBuffer3(image));
            buf.rewind();
            return buf;
        }
        catch (IOException e) {
            System.err.println("Failed to read out cubemap texture!");
            e.printStackTrace();
            return null;
        }
    }

    public void setupCubemap() {
        if (cubeMapTexture != -1) {
            GlStateManager.func_179150_h((int)cubeMapTexture);
        }
        cubeMapTexture = GlStateManager.func_179146_y();
        GL11.glBindTexture((int)34067, (int)cubeMapTexture);
        String[] faces = new String[]{"right.jpg", "left.jpg", "top.jpg", "bottom.jpg", "front.jpg", "back.jpg"};
        for (int i = 0; i < faces.length; ++i) {
            ByteBuffer buffer = this.readImageFromFile(new ResourceLocation(str + faces[i]));
            GL11.glTexImage2D((int)(34069 + i), (int)0, (int)6407, (int)2048, (int)2048, (int)0, (int)6407, (int)5121, (ByteBuffer)buffer);
        }
        System.out.println("Cubemap succesfully created!");
        GL11.glTexParameteri((int)34067, (int)10241, (int)9729);
        GL11.glTexParameteri((int)34067, (int)10240, (int)9729);
        GL11.glTexParameteri((int)34067, (int)10242, (int)33071);
        GL11.glTexParameteri((int)34067, (int)10243, (int)33071);
        GL11.glTexParameteri((int)34067, (int)32882, (int)33071);
    }

    public void render(float partialTicks, WorldClient world, Minecraft MC) {
    }
}

