/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import com.paneedah.weaponlib.render.Triangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.util.vector.Matrix4f;

public class ModelRenderTool {
    public static Field quadListField = null;

    public static VertexData compress(Triangle[] tris) {
        ArrayList<Vec3d> vertices = new ArrayList<Vec3d>(tris.length * 3);
        int[] indices = new int[tris.length * 3];
        float[] texCoords = new float[tris.length * 6];
        for (int i = 0; i < tris.length; ++i) {
            Triangle tri = tris[i];
            double eps = 1.0E-5;
            int idx = ModelRenderTool.epsIndexOf(vertices, tri.p1.pos, eps);
            if (idx != -1) {
                indices[i * 3] = idx;
            } else {
                indices[i * 3] = vertices.size();
                vertices.add(tri.p1.pos);
            }
            idx = ModelRenderTool.epsIndexOf(vertices, tri.p2.pos, eps);
            if (idx != -1) {
                indices[i * 3 + 1] = idx;
            } else {
                indices[i * 3 + 1] = vertices.size();
                vertices.add(tri.p2.pos);
            }
            idx = ModelRenderTool.epsIndexOf(vertices, tri.p3.pos, eps);
            if (idx != -1) {
                indices[i * 3 + 2] = idx;
            } else {
                indices[i * 3 + 2] = vertices.size();
                vertices.add(tri.p3.pos);
            }
            texCoords[i * 6 + 0] = tri.p1.texX;
            texCoords[i * 6 + 1] = tri.p1.texY;
            texCoords[i * 6 + 2] = tri.p2.texX;
            texCoords[i * 6 + 3] = tri.p2.texY;
            texCoords[i * 6 + 4] = tri.p3.texX;
            texCoords[i * 6 + 5] = tri.p3.texY;
        }
        VertexData data = new VertexData();
        data.positions = vertices.toArray(new Vec3d[0]);
        data.texCoords = texCoords;
        return data;
    }

    public static boolean epsilonEquals(Vec3d a, Vec3d b, double eps) {
        double dx = Math.abs(a.field_72450_a - b.field_72450_a);
        double dy = Math.abs(a.field_72448_b - b.field_72448_b);
        double dz = Math.abs(a.field_72449_c - b.field_72449_c);
        return dx < eps && dy < eps && dz < eps;
    }

    private static int epsIndexOf(List<Vec3d> l, Vec3d vec, double eps) {
        for (int i = 0; i < l.size(); ++i) {
            if (!ModelRenderTool.epsilonEquals(vec, l.get(i), eps)) continue;
            return i;
        }
        return -1;
    }

    public static Triangle[] triangulate(ModelBox b, Matrix4f transform) {
        if (quadListField == null) {
            quadListField = ReflectionHelper.findField(ModelBox.class, (String)"quadList", (String)"field_78254_i");
        }
        Triangle[] tris = new Triangle[12];
        try {
            TexturedQuad[] quadList = (TexturedQuad[])quadListField.get(b);
            int i = 0;
            for (TexturedQuad t : quadList) {
                Vec3d v0 = ModelRenderTool.transformViaMatrix(t.field_78239_a[0].field_78243_a, transform);
                Vec3d v1 = ModelRenderTool.transformViaMatrix(t.field_78239_a[1].field_78243_a, transform);
                Vec3d v2 = ModelRenderTool.transformViaMatrix(t.field_78239_a[2].field_78243_a, transform);
                Vec3d v3 = ModelRenderTool.transformViaMatrix(t.field_78239_a[3].field_78243_a, transform);
                float[] tex = new float[]{t.field_78239_a[0].field_78241_b, t.field_78239_a[0].field_78242_c, t.field_78239_a[1].field_78241_b, t.field_78239_a[1].field_78242_c, t.field_78239_a[2].field_78241_b, t.field_78239_a[2].field_78242_c};
                tris[i++] = new Triangle(v0, v1, v2, tex);
                tex = new float[]{t.field_78239_a[2].field_78241_b, t.field_78239_a[2].field_78242_c, t.field_78239_a[3].field_78241_b, t.field_78239_a[3].field_78242_c, t.field_78239_a[0].field_78241_b, t.field_78239_a[0].field_78242_c};
                tris[i++] = new Triangle(v2, v3, v0, tex);
            }
            return tris;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new RuntimeException("Failed to get quads!");
        }
    }

    public static Vec3d transformViaMatrix(Vec3d vec, Matrix4f mat) {
        if (mat != null) {
            double x = (double)mat.m00 * vec.field_72450_a + (double)mat.m10 * vec.field_72448_b + (double)mat.m20 * vec.field_72449_c + (double)mat.m30;
            double y = (double)mat.m01 * vec.field_72450_a + (double)mat.m11 * vec.field_72448_b + (double)mat.m21 * vec.field_72449_c + (double)mat.m31;
            double z = (double)mat.m02 * vec.field_72450_a + (double)mat.m12 * vec.field_72448_b + (double)mat.m22 * vec.field_72449_c + (double)mat.m32;
            return new Vec3d(x, y, z);
        }
        return vec;
    }

    public static float[] transformViaMatrix(float x1, float y1, float z1, Matrix4f mat) {
        if (mat != null) {
            float x = mat.m00 * x1 + mat.m10 * y1 + mat.m20 * z1 + mat.m30;
            float y = mat.m01 * x1 + mat.m11 * y1 + mat.m21 * z1 + mat.m31;
            float z = mat.m02 * x1 + mat.m12 * y1 + mat.m22 * z1 + mat.m32;
            return new float[]{x, y, z};
        }
        return new float[]{x1, y1, z1};
    }

    public static float[] transformViaMatrix(float[] vec, Matrix4f mat) {
        if (mat != null) {
            float x = mat.m00 * vec[0] + mat.m10 * vec[1] + mat.m20 * vec[2] + mat.m30;
            float y = mat.m01 * vec[0] + mat.m11 * vec[1] + mat.m21 * vec[2] + mat.m31;
            float z = mat.m02 * vec[0] + mat.m12 * vec[1] + mat.m22 * vec[2] + mat.m32;
            return new float[]{x, y, z};
        }
        return vec;
    }

    public static class VertexData {
        public Vec3d[] positions;
        public int[] positionsIndices;
        public float[] texCoords;

        public float[] vertexArray() {
            float[] verts = new float[this.positions.length * 3];
            for (int i = 0; i < this.positions.length; ++i) {
                Vec3d pos = this.positions[i];
                verts[i * 3] = (float)pos.field_72450_a;
                verts[i * 3 + 1] = (float)pos.field_72448_b;
                verts[i * 3 + 2] = (float)pos.field_72449_c;
            }
            return verts;
        }
    }
}

