/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import com.paneedah.weaponlib.render.VAOData;
import com.paneedah.weaponlib.render.VAOLoader;
import com.paneedah.weaponlib.shader.jim.Attribute;
import com.paneedah.weaponlib.shader.jim.Shader;
import com.paneedah.weaponlib.shader.jim.ShaderLoader;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.util.vector.Matrix4f;

public class InstancedRender {
    private static final int MAX_INSTANCES = 50000;
    private static final int INSTANCE_DATA_LENGTH = 21;
    private static final float[] VERTICES = new float[]{-0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f, -0.5f};
    private static final FloatBuffer buffer = BufferUtils.createFloatBuffer((int)1050000);
    private static Shader shad = ShaderLoader.loadShader("instanced", new Attribute[0]);
    private int vbo;
    private VAOData vao;
    private VAOLoader loader = new VAOLoader();
    private int pointer = 0;

    public InstancedRender() {
        this.vbo = this.loader.createEmptyVBO(1050000);
        this.vao = VAOLoader.loadToVAO(VERTICES);
        this.loader.addInstancedAttribute(this.vao.getVaoID(), this.vbo, 1, 4, 21, 0);
        this.loader.addInstancedAttribute(this.vao.getVaoID(), this.vbo, 2, 4, 21, 4);
        this.loader.addInstancedAttribute(this.vao.getVaoID(), this.vbo, 3, 4, 21, 8);
        this.loader.addInstancedAttribute(this.vao.getVaoID(), this.vbo, 4, 4, 21, 12);
        this.loader.addInstancedAttribute(this.vao.getVaoID(), this.vbo, 5, 4, 21, 16);
        this.loader.addInstancedAttribute(this.vao.getVaoID(), this.vbo, 6, 1, 21, 20);
    }

    public void prepare() {
        shad.use();
        GL30.glBindVertexArray((int)this.vao.getVaoID());
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL20.glEnableVertexAttribArray((int)3);
        GL20.glEnableVertexAttribArray((int)4);
        GL20.glEnableVertexAttribArray((int)5);
        GL20.glEnableVertexAttribArray((int)6);
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)false);
    }

    public void render() {
        this.prepare();
        this.updateData();
        GL31.glDrawArraysInstanced((int)4, (int)0, (int)this.vao.getVertexCount(), (int)1000);
        this.finishRender();
    }

    public void finishRender() {
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GL20.glDisableVertexAttribArray((int)0);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)3);
        GL20.glDisableVertexAttribArray((int)4);
        GL20.glDisableVertexAttribArray((int)5);
        GL20.glDisableVertexAttribArray((int)6);
    }

    public void updateData() {
        this.pointer = 0;
        int testNum = 1000;
        float[] vboData = new float[testNum * 21];
        for (int i = 0; i < testNum; ++i) {
            this.storeMatrixData(new Matrix4f(), vboData);
            vboData[this.pointer++] = 0.0f;
            vboData[this.pointer++] = 0.0f;
            vboData[this.pointer++] = 0.0f;
            vboData[this.pointer++] = 0.0f;
            vboData[this.pointer++] = 0.0f;
        }
        VAOLoader.updateVBO(this.vbo, vboData, buffer);
    }

    public void storeMatrixData(Matrix4f matrix, float[] vboData) {
        vboData[this.pointer++] = matrix.m00;
        vboData[this.pointer++] = matrix.m01;
        vboData[this.pointer++] = matrix.m02;
        vboData[this.pointer++] = matrix.m03;
        vboData[this.pointer++] = matrix.m10;
        vboData[this.pointer++] = matrix.m11;
        vboData[this.pointer++] = matrix.m12;
        vboData[this.pointer++] = matrix.m13;
        vboData[this.pointer++] = matrix.m20;
        vboData[this.pointer++] = matrix.m21;
        vboData[this.pointer++] = matrix.m22;
        vboData[this.pointer++] = matrix.m23;
        vboData[this.pointer++] = matrix.m30;
        vboData[this.pointer++] = matrix.m31;
        vboData[this.pointer++] = matrix.m32;
        vboData[this.pointer++] = matrix.m33;
    }
}

