/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.perspective;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.ClientModContext;
import com.paneedah.weaponlib.CustomRenderer;
import com.paneedah.weaponlib.RenderContext;
import com.paneedah.weaponlib.RenderableState;
import com.paneedah.weaponlib.ViewfinderModel;
import com.paneedah.weaponlib.perspective.Perspective;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class PerspectiveRenderer
implements CustomRenderer<RenderableState> {
    protected static Perspective<RenderableState> STATIC_TEXTURE_PERSPECTIVE = new StaticTexturePerspective();
    protected ViewfinderModel model = new ViewfinderModel();
    protected Runnable positioning;

    public PerspectiveRenderer(Runnable positioning) {
        this.positioning = positioning;
    }

    @Override
    public void render(RenderContext<RenderableState> renderContext) {
        if (renderContext.getTransformType() != ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND && renderContext.getTransformType() != ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
            return;
        }
        ClientModContext clientModContext = (ClientModContext)MWC.modContext;
        Perspective<Object> perspective = clientModContext.getViewManager().getPerspective(renderContext.getPlayerItemInstance(), false);
        if (perspective == null) {
            perspective = STATIC_TEXTURE_PERSPECTIVE;
        }
        float brightness = perspective.getBrightness(renderContext);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8193);
        this.positioning.run();
        GL11.glBindTexture((int)3553, (int)perspective.getTexture(renderContext));
        ClientProxy.MC.field_71460_t.func_175072_h();
        GL11.glEnable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        this.model.func_78088_a((Entity)renderContext.getPlayer(), renderContext.getLimbSwing(), renderContext.getFlimbSwingAmount(), renderContext.getAgeInTicks(), renderContext.getNetHeadYaw(), renderContext.getHeadPitch(), renderContext.getScale());
        ClientProxy.MC.field_71460_t.func_180436_i();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private static class StaticTexturePerspective
    extends Perspective<RenderableState> {
        private Integer textureId;

        private StaticTexturePerspective() {
        }

        @Override
        public void update(TickEvent.RenderTickEvent event) {
        }

        @Override
        public int getTexture(RenderContext<RenderableState> context) {
            if (this.textureId == null) {
                ResourceLocation textureResource = new ResourceLocation("weaponlib:/com/paneedah/weaponlib/resources/dark-screen.png");
                ClientProxy.MC.func_110434_K().func_110577_a(textureResource);
                ITextureObject textureObject = ClientProxy.MC.func_110434_K().func_110581_b(textureResource);
                if (textureObject != null) {
                    this.textureId = textureObject.func_110552_b();
                }
            }
            return this.textureId;
        }

        @Override
        public float getBrightness(RenderContext<RenderableState> context) {
            return 0.0f;
        }
    }
}

