/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.perspective;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.ClientModContext;
import com.paneedah.weaponlib.PlayerItemInstance;
import com.paneedah.weaponlib.compatibility.CompatibleWorldRenderer;
import com.paneedah.weaponlib.compatibility.MWCParticleManager;
import com.paneedah.weaponlib.perspective.Perspective;
import net.minecraft.client.multiplayer.WorldClient;

public class PerspectiveManager {
    private Perspective<?> currentPerspective;
    private ClientModContext clientModContext;
    private CompatibleWorldRenderer entityRenderer;
    private MWCParticleManager effectRenderer;

    public PerspectiveManager(ClientModContext clientModContext) {
        this.clientModContext = clientModContext;
    }

    public Perspective<?> getPerspective(PlayerItemInstance<?> currentInstance, boolean init) {
        if (currentInstance == null || this.currentPerspective == null && !init) {
            return null;
        }
        Class<Perspective<?>> perspectiveClass = currentInstance.getRequiredPerspectiveType();
        if (perspectiveClass != null) {
            if (this.currentPerspective == null) {
                this.currentPerspective = this.createActivePerspective(perspectiveClass);
            } else if (!perspectiveClass.isInstance(this.currentPerspective)) {
                this.currentPerspective.deactivate(this.clientModContext);
                this.currentPerspective = this.createActivePerspective(perspectiveClass);
            }
        } else if (this.currentPerspective != null && init) {
            this.currentPerspective.deactivate(this.clientModContext);
            this.currentPerspective = null;
        }
        return this.currentPerspective;
    }

    private Perspective<?> createActivePerspective(Class<? extends Perspective<?>> perspectiveClass) {
        Perspective<?> result = null;
        try {
            result = perspectiveClass.newInstance();
            result.activate(this.clientModContext, this);
        }
        catch (IllegalAccessException | InstantiationException e) {
            ModReference.LOG.error("Failed to create view of {} - {}", perspectiveClass, (Object)e, (Object)e);
        }
        return result;
    }

    CompatibleWorldRenderer getEntityRenderer() {
        if (this.entityRenderer == null) {
            this.entityRenderer = new CompatibleWorldRenderer(ClientProxy.MC, ClientProxy.MC.func_110442_L());
        }
        return this.entityRenderer;
    }

    MWCParticleManager getEffectRenderer() {
        if (this.effectRenderer == null) {
            WorldClient world = (WorldClient)ClientProxy.MC.field_71439_g.field_70170_p;
            this.effectRenderer = MWCParticleManager.getParticleManager();
        }
        return this.effectRenderer;
    }
}

