/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.numerical;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.animation.MatrixHelper;
import net.minecraft.util.math.Vec3d;

public class RandomVector {
    private double dirX;
    private double dirY;
    private double dirZ;
    private double x;
    private double y;
    private double z;
    private double prevX;
    private double prevY;
    private double prevZ;
    private double agressiveness = 0.2;

    public void update(double speed, double dampening) {
        this.prevX = this.x;
        this.prevY = this.y;
        this.prevZ = this.z;
        this.x += this.dirX * speed;
        this.y += this.dirY * speed;
        this.z += this.dirZ * speed;
        this.dirX *= dampening;
        this.dirY *= dampening;
        this.dirZ *= dampening;
        this.x *= dampening;
        this.y *= dampening;
        this.z *= dampening;
    }

    public double getX() {
        return this.x;
    }

    public void setAgressiveness(double agr) {
        this.agressiveness = agr;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public void callRandom(double mag) {
        double halfMag = mag / 2.0;
        if (Math.random() < this.agressiveness) {
            this.dirX = Math.random() * mag - halfMag;
            this.dirY = Math.random() * mag - halfMag;
            this.dirZ = Math.random() * mag - halfMag;
        }
    }

    public Vec3d getVector(double amplitude) {
        return new Vec3d(this.x * amplitude, this.y * amplitude, this.z * amplitude);
    }

    public Vec3d getInterpolatedVector(double amplitude) {
        float ticks = ClientProxy.MC.func_184121_ak();
        return new Vec3d(MatrixHelper.solveLerp(this.prevX, this.x, (double)ticks), MatrixHelper.solveLerp(this.prevY, this.y, (double)ticks), MatrixHelper.solveLerp(this.prevZ, this.z, (double)ticks)).func_186678_a(amplitude);
    }
}

