/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.crafting.workbench;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.messages.WorkbenchServerMessage;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.animation.gui.GuiRenderUtil;
import com.paneedah.weaponlib.crafting.CraftingGroup;
import com.paneedah.weaponlib.crafting.CraftingRegistry;
import com.paneedah.weaponlib.crafting.base.GUIContainerStation;
import com.paneedah.weaponlib.crafting.workbench.ContainerWorkbench;
import com.paneedah.weaponlib.crafting.workbench.GUIButtonCustom;
import com.paneedah.weaponlib.crafting.workbench.TileEntityWorkbench;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GUIContainerWorkbench
extends GUIContainerStation<TileEntityWorkbench> {
    private GUIButtonCustom assaultSelector;
    private GUIButtonCustom attachSelector;
    private GUIButtonCustom modSelector;
    private GUIButtonCustom gearSelector;

    public GUIContainerWorkbench(EntityPlayer player, InventoryPlayer inventory, TileEntityWorkbench tileEntityWorkbench) {
        super(tileEntityWorkbench, new ContainerWorkbench(player, inventory, tileEntityWorkbench));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.assaultSelector = new GUIButtonCustom(GUI_TEX, 3, this.field_147003_i + 92, this.field_147009_r + 29, 19, 20, 480, 370, "").withStandardState(0xFFFFFF, 0, 291).withHoveredState(0xFFFFFF, 19, 291).withToggledState(0xFFFFFF, 38, 291).withPageRestriction(2).makeToggleButton();
        this.attachSelector = new GUIButtonCustom(GUI_TEX, 4, this.field_147003_i + 115, this.field_147009_r + 29, 19, 20, 480, 370, "").withStandardState(0xFFFFFF, 0, 311).withHoveredState(0xFFFFFF, 19, 311).withToggledState(0xFFFFFF, 38, 311).withPageRestriction(2).makeToggleButton();
        this.modSelector = new GUIButtonCustom(GUI_TEX, 5, this.field_147003_i + 138, this.field_147009_r + 29, 19, 20, 480, 370, "").withStandardState(0xFFFFFF, 0, 331).withHoveredState(0xFFFFFF, 19, 331).withToggledState(0xFFFFFF, 38, 331).withPageRestriction(2).makeToggleButton();
        this.gearSelector = new GUIButtonCustom(GUI_TEX, 6, this.field_147003_i + 161, this.field_147009_r + 29, 19, 20, 480, 370, "").withStandardState(0xFFFFFF, 57, 331).withHoveredState(0xFFFFFF, 76, 331).withToggledState(0xFFFFFF, 95, 331).withPageRestriction(2).makeToggleButton();
        this.assaultSelector.toggleOn();
        this.func_189646_b(this.assaultSelector);
        this.func_189646_b(this.attachSelector);
        this.func_189646_b(this.modSelector);
        this.func_189646_b(this.gearSelector);
        this.setPage(1);
    }

    @Override
    public void fillFilteredList() {
        this.filteredCraftingList.clear();
        if (this.getCraftingMode() == CraftingGroup.GUN.getID()) {
            this.filteredCraftingList.addAll(CraftingRegistry.getCraftingListForGroup(CraftingGroup.GUN));
        } else if (this.getCraftingMode() == CraftingGroup.ATTACHMENT_NORMAL.getID()) {
            this.filteredCraftingList.addAll(CraftingRegistry.getCraftingListForGroup(CraftingGroup.ATTACHMENT_NORMAL));
        } else if (this.getCraftingMode() == CraftingGroup.ATTACHMENT_MODIFICATION.getID()) {
            this.filteredCraftingList.addAll(CraftingRegistry.getCraftingListForGroup(CraftingGroup.ATTACHMENT_MODIFICATION));
        } else if (this.getCraftingMode() == CraftingGroup.GEAR.getID()) {
            this.filteredCraftingList.addAll(CraftingRegistry.getCraftingListForGroup(CraftingGroup.GEAR));
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawTooltips(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.craftButton) {
            if (this.hasSelectedCraftingPiece() && ((TileEntityWorkbench)this.tileEntity).craftingTimer == -1 && !this.craftButton.isDisabled()) {
                int craftingTime = this.getCraftingMode() == 1 ? 1200 : 400;
                MWC.CHANNEL.sendToServer((IMessage)new WorkbenchServerMessage(1, ((TileEntityWorkbench)this.tileEntity).func_174877_v(), 0, craftingTime, CraftingGroup.getValue(this.getCraftingMode()), this.getSelectedCraftingPiece().getItemStack().func_77977_a()));
            }
        } else if (button == this.assaultSelector) {
            ((GUIButtonCustom)button).toggleOn();
            this.modSelector.toggleOff();
            this.attachSelector.toggleOff();
            this.gearSelector.toggleOff();
            this.setCraftingMode(1);
            this.setSelectedCraftingPiece(null);
            this.fillFilteredList();
        } else if (button == this.attachSelector) {
            ((GUIButtonCustom)button).toggleOn();
            this.modSelector.toggleOff();
            this.assaultSelector.toggleOff();
            this.gearSelector.toggleOff();
            this.setCraftingMode(2);
            this.setSelectedCraftingPiece(null);
            this.fillFilteredList();
        } else if (button == this.modSelector) {
            ((GUIButtonCustom)button).toggleOn();
            this.attachSelector.toggleOff();
            this.assaultSelector.toggleOff();
            this.gearSelector.toggleOff();
            this.setCraftingMode(3);
            this.setSelectedCraftingPiece(null);
            this.fillFilteredList();
        } else if (button == this.gearSelector) {
            ((GUIButtonCustom)button).toggleOn();
            this.attachSelector.toggleOff();
            this.assaultSelector.toggleOff();
            this.modSelector.toggleOff();
            this.setCraftingMode(CraftingGroup.GEAR.getID());
            this.setSelectedCraftingPiece(null);
            this.fillFilteredList();
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (!this.craftButton.isDisabled() && ((TileEntityWorkbench)this.tileEntity).getProgress() != 0.0) {
            this.craftButton.setErrored(true);
        }
        if (this.hasSelectedCraftingPiece() && this.hasRequiredItems() && ((TileEntityWorkbench)this.tileEntity).getProgress() == 0.0) {
            this.craftButton.setErrored(false);
        }
    }

    @Override
    public boolean requiresMaterialsToSubmitCraftRequest() {
        return true;
    }

    @Override
    public void addCraftingInformationToTooltip(ArrayList<String> tooltip) {
        int remainingTicks = ((TileEntityWorkbench)this.tileEntity).craftingDuration - ((TileEntityWorkbench)this.tileEntity).craftingTimer;
        tooltip.add(TextFormatting.GOLD + "Crafting: " + TextFormatting.WHITE + I18n.func_135052_a((String)(((TileEntityWorkbench)this.tileEntity).craftingTargetName + ".name"), (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + "Time remaining: " + TextFormatting.WHITE + String.format("%.2f", Float.valueOf((float)remainingTicks / 20.0f)) + "s");
    }

    @Override
    public boolean shouldOverrideCraftingModeOneRender() {
        return true;
    }

    @Override
    public void doCraftingModeOneRender(float partialTicks, int mouseX, int mouseY) {
        if (!(this.getSelectedCraftingPiece().getItemStack().func_77973_b() instanceof Weapon)) {
            return;
        }
        Weapon weapon = (Weapon)this.getSelectedCraftingPiece().getItemStack().func_77973_b();
        GuiRenderUtil.drawScaledString(this.field_146289_q, this.format(weapon.func_77658_a()), this.field_147003_i + 214, this.field_147009_r + 31, 1.2, 16642428);
        GuiRenderUtil.drawScaledString(this.field_146289_q, weapon.builder.getWeaponType(), this.field_147003_i + 214, this.field_147009_r + 43, 0.75, 13157532);
        this.render3DItemInGUI(weapon, this.field_147003_i + 300, this.field_147009_r + 55, mouseX, mouseY);
    }
}

