/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.crafting;

import com.paneedah.weaponlib.crafting.CraftingEntry;
import com.paneedah.weaponlib.crafting.CraftingGroup;
import com.paneedah.weaponlib.crafting.IModernCraftingRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.Item;

public class CraftingRegistry {
    public static final HashMap<CraftingGroup, ArrayList<IModernCraftingRecipe>> craftingMap = new HashMap(200, 0.7f);
    private static final HashMap<CraftingGroup, HashMap<String, IModernCraftingRecipe>> categoricalLookup = new HashMap(50, 0.7f);
    protected static HashMap<String, CraftingEntry[]> recipeMap = new HashMap();
    private static final HashMap<Item, IModernCraftingRecipe> hookMap = new HashMap();

    public static IModernCraftingRecipe getModernCrafting(CraftingGroup group, String name) {
        return categoricalLookup.get((Object)group).get(name);
    }

    public static boolean hasModernCrafting(CraftingGroup group, String name) {
        return categoricalLookup.get((Object)group).containsKey(name);
    }

    public static ArrayList<IModernCraftingRecipe> getCraftingListForGroup(CraftingGroup group) {
        return craftingMap.get((Object)group);
    }

    public static void registerHook(IModernCraftingRecipe crafting) {
        hookMap.put(crafting.getItemStack().func_77973_b(), crafting);
    }

    public static boolean hasHook(String registryName) {
        return CraftingRegistry.hasHook(Item.func_111206_d((String)registryName));
    }

    public static boolean hasHook(Item item) {
        return hookMap.containsKey(item);
    }

    public static IModernCraftingRecipe getHook(String registryName) {
        return CraftingRegistry.getHook(Item.func_111206_d((String)registryName));
    }

    public static IModernCraftingRecipe getHook(Item item) {
        return hookMap.get(item);
    }

    protected static boolean isRecipeRegistered(String registryName) {
        return CraftingRegistry.isRecipeRegistered(Item.func_111206_d((String)registryName));
    }

    protected static boolean isRecipeRegistered(Item item) {
        return CraftingRegistry.isRecipeRegistered(CraftingRegistry.getHook(item));
    }

    protected static boolean isRecipeRegistered(IModernCraftingRecipe crafting) {
        if (crafting.getCraftingGroup() == null) {
            return false;
        }
        return craftingMap.get((Object)crafting.getCraftingGroup()).contains(crafting);
    }

    protected static void deleteRecipeRegistry(Item item) {
        CraftingRegistry.deleteRecipeRegistry(CraftingRegistry.getHook(item));
    }

    public static void deleteRecipeRegistry(IModernCraftingRecipe crafting) {
        hookMap.remove(crafting.getItemStack().func_77973_b(), crafting);
        craftingMap.get((Object)crafting.getCraftingGroup()).remove(crafting);
        categoricalLookup.get((Object)crafting.getCraftingGroup()).remove(crafting.getItemStack().func_77977_a());
    }

    public static void registerRecipe(Item item, CraftingGroup group, CraftingEntry[] entry) {
        IModernCraftingRecipe crafting = CraftingRegistry.getHook(item);
        try {
            crafting.setCraftingRecipe(entry);
            crafting.setCraftingGroup(group);
        }
        catch (Exception ignored) {
            return;
        }
        if (CraftingRegistry.isRecipeRegistered(crafting)) {
            CraftingRegistry.deleteRecipeRegistry(crafting);
        }
        craftingMap.get((Object)crafting.getCraftingGroup()).add(crafting);
        categoricalLookup.get((Object)crafting.getCraftingGroup()).put(crafting.getItemStack().func_77977_a(), crafting);
    }

    public static void registerRecipe(IModernCraftingRecipe crafting) {
        CraftingRegistry.registerHook(crafting);
        craftingMap.get((Object)crafting.getCraftingGroup()).add(crafting);
        categoricalLookup.get((Object)crafting.getCraftingGroup()).put(crafting.getItemStack().func_77977_a(), crafting);
    }

    public static void clearRegistry() {
        for (CraftingGroup g : CraftingGroup.values()) {
            CraftingRegistry.clearGroup(g);
        }
    }

    public static void clearGroup(CraftingGroup group) {
        craftingMap.get((Object)group).clear();
        categoricalLookup.get((Object)group).clear();
    }

    static {
        for (CraftingGroup group : CraftingGroup.values()) {
            craftingMap.put(group, new ArrayList());
            categoricalLookup.put(group, new HashMap());
        }
    }
}

