/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.config;

import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.config.ConfigSync;
import com.paneedah.weaponlib.config.VMWModConfigGUI;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;

public class ModernConfigManager {
    private static final HashMap<Field, Property> elementMappings = new HashMap();
    public static final String CATEGORY_RENDERING = "rendering";
    public static final String CATEGORY_RENDERING_SCREENSHADERS = "rendering.screenshaders";
    public static final String CATEGORY_GAMEPLAY = "gameplay";
    public static final String CATEGORY_ENTITIES = "entities";
    public static final String CATEGORY_ORES = "ores";
    @ConfigSync(category="ores", comment="Spawns per chunk for sulfur ore.")
    public static int sulfurSpawnsPerChunk = 13;
    @ConfigSync(category="ores", comment="Spawns per chunk for copper ore.")
    public static int copperSpawnsPerChunk = 12;
    @ConfigSync(category="ores", comment="Spawns per chunk for tin ore.")
    public static int tinSpawnsPerChunk = 10;
    @ConfigSync(category="ores", comment="Spawns per chunk for lead ore.")
    public static int leadSpawnsPerChunk = 11;
    @ConfigSync(category="ores", comment="Spawns per chunk for graphite ore.")
    public static int graphiteSpawnsPerChunk = 9;
    @ConfigSync(category="rendering", comment="Setting this to false disables all shaders, enabling allows to select which shaders are used.")
    public static boolean enableAllShaders = true;
    @ConfigSync(category="rendering", comment="Setting this to false disables all world shaders, enabling allows to select which world shaders are used.")
    public static boolean enableWorldShaders = true;
    @ConfigSync(category="rendering", comment="Setting this to false disables all screen shaders, enabling allows to select which screen shaders are used.")
    public static boolean enableScreenShaders = true;
    @ConfigSync(category="rendering", comment="Enables gun shaders, so skinning & lighting")
    public static boolean enableGunShaders = true;
    @ConfigSync(category="rendering", comment="Enables scope effects")
    public static boolean enableScopeEffects = true;
    @ConfigSync(category="rendering", comment="Enables flash shaders")
    public static boolean enableFlashShaders = true;
    @ConfigSync(category="rendering", comment="Enables reticle shaders")
    public static boolean enableReticleShaders = true;
    @ConfigSync(category="rendering.screenshaders", comment="Enables film grain effect")
    public static boolean filmGrain = true;
    @Config.RangeDouble(min=0.0, max=1.0)
    @ConfigSync(category="rendering.screenshaders", comment="Configures the intensity of the film grain effect")
    public static double filmGrainIntensity = 0.03;
    @ConfigSync(category="rendering.screenshaders", comment="Enables glow around bright objects (bloom)")
    public static boolean bloomEffect = true;
    @Config.RequiresMcRestart
    @Config.RangeInt(min=2, max=8)
    @ConfigSync(category="rendering.screenshaders", comment="Lower numbers = better performance")
    public static int bloomLayers = 3;
    @ConfigSync(category="rendering.screenshaders", comment="Enable on-screen rain/snow VFX")
    public static boolean onScreenRainAndSnow = true;
    @Config.RequiresMcRestart
    @ConfigSync(category="rendering", comment="Enables the HDR framebuffer, requires restart. The HDR is the cause of a lot of shader incompat")
    public static boolean enableHDRFramebuffer = true;
    @ConfigSync(category="rendering", comment="Enables the fancy MWC snow/rain")
    public static boolean enableFancyRainAndSnow = true;
    @ConfigSync(category="gameplay", comment="Enables the ammo counter")
    public static boolean enableAmmoCounter = true;
    @ConfigSync(category="gameplay", comment="")
    public static int ammoCounterX = 0;
    @ConfigSync(category="gameplay", comment="")
    public static int ammoCounterY = 0;
    @Config.RangeDouble(min=0.1, max=3.0)
    @ConfigSync(category="gameplay", comment="")
    public static double ammoCounterSize = 0.5;
    @ConfigSync(category="gameplay", comment="Enables the black background on the ammo counter.")
    public static boolean enableAmmoCounterBackground = true;
    @ConfigSync(category="gameplay", comment="")
    public static boolean ammoCounterBackgroundReverse = false;
    @ConfigSync(category="gameplay", comment="Enable open door key display when hovering doors")
    public static boolean enableOpenDoorDisplay = true;
    @ConfigSync(category="gameplay", comment="If true, hold to aim. If false, toggle to aim.")
    public static boolean holdToAim = true;
    @Config.RangeDouble(min=0.0, max=1.0)
    @ConfigSync(category="gameplay", comment="Should players bleed when hit?")
    public static double enableBleedingOnHit = 1.0;
    @ConfigSync(category="gameplay", comment="Should glass blocks be breakable by bullets?")
    public static boolean bulletBreakGlass = true;
    @ConfigSync(category="gameplay", comment="A list of blocks that will be penetrable by bullets.")
    public static String penetrableBlocks = "minecraft:glass, minecraft:glass_pane, minecraft:stained_glass, minecraft:stained_glass_pane";
    @ConfigSync(category="gameplay", comment="Enables muzzle effects.")
    public static boolean enableMuzzleEffects = true;
    @ConfigSync(category="gameplay", comment="Should blur be applied when aiming?")
    public static boolean enableBlurOnAim = true;
    @ConfigSync(category="gameplay", comment="Should the explosion break blocks?")
    public static boolean explosionBreak = true;
    @Config.RangeDouble(min=0.0, max=20.0)
    @ConfigSync(category="gameplay", comment="How much damage explosions should deal.")
    public static double explosionDamage = 5.0;
    @Config.RangeDouble(min=0.0, max=1.0)
    @ConfigSync(category="gameplay", comment="What should the block drop chance be?")
    public static double explodedBlockDropChance = 1.0;
    @ConfigSync(category="gameplay", comment="Where should the status bar be located?")
    public static String statusBarPosition = "TOP_RIGHT";
    @Config.RequiresMcRestart
    @Config.RangeDouble(min=0.1, max=5.0)
    @ConfigSync(category="entities", comment="How much health should terrorists have?")
    public static double terroristHealth = 1.0;
    @Config.RequiresMcRestart
    @Config.RangeDouble(min=0.0, max=2.0)
    @ConfigSync(category="entities", comment="How much should terrorists spawn?")
    public static double terroristSpawn = 0.1;
    @Config.RequiresMcRestart
    @Config.RangeDouble(min=0.1, max=5.0)
    @ConfigSync(category="entities", comment="How much health should soldiers have?")
    public static double soldierHealth = 2.0;
    @Config.RequiresMcRestart
    @Config.RangeDouble(min=0.0, max=2.0)
    @ConfigSync(category="entities", comment="How much should soldiers spawn?")
    public static double soldierSpawn = 0.0;
    @ConfigSync(category="entities", comment="What equipment should the terrorists have?")
    public static String terroristEquipmentConfiguration = "m4a1:1.0:M4A1Mag_2, m16a1:1.0:M4A1Mag_2, Remington870:1.0";
    private static Configuration config = null;
    private static boolean isLoaded = false;

    public static void updateField(Field f, Object value) {
        try {
            f.set(null, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ModReference.LOG.error("Could not set field for field name: {}, please report this to developers.", (Object)f.getName());
            e.printStackTrace();
        }
        if (f.getType() == Integer.TYPE) {
            elementMappings.get(f).set(((Integer)value).intValue());
        } else if (f.getType() == int[].class) {
            elementMappings.get(f).set((int[])value);
        } else if (f.getType() == Boolean.TYPE) {
            elementMappings.get(f).set(((Boolean)value).booleanValue());
        } else if (f.getType() == boolean[].class) {
            elementMappings.get(f).set((boolean[])value);
        } else if (f.getType() == String.class) {
            elementMappings.get(f).set((String)value);
        } else if (f.getType() == String[].class) {
            elementMappings.get(f).set((String[])value);
        } else if (f.getType() == Double.TYPE) {
            elementMappings.get(f).set(((Double)value).doubleValue());
        } else if (f.getType() == double[].class) {
            elementMappings.get(f).set((double[])value);
        } else if (f.getType() == Long.TYPE) {
            elementMappings.get(f).set(((Long)value).longValue());
        }
    }

    private static void registerProperty(Field f, ConfigSync annotation) {
        Property property = null;
        try {
            if (f.getType() == Integer.TYPE) {
                boolean isRanged = f.isAnnotationPresent(Config.RangeInt.class);
                if (!isRanged) {
                    property = config.get(annotation.category(), f.getName(), f.getInt(null), annotation.comment());
                    f.set(null, property.getInt());
                } else {
                    Config.RangeInt rangedAnnotation = f.getAnnotation(Config.RangeInt.class);
                    property = config.get(annotation.category(), f.getName(), f.getInt(null), annotation.comment(), rangedAnnotation.min(), rangedAnnotation.max());
                    f.set(null, property.getInt());
                }
            } else if (f.getType() == Boolean.TYPE) {
                property = config.get(annotation.category(), f.getName(), f.getBoolean(null), annotation.comment());
                f.set(null, property.getBoolean());
            } else if (f.getType() == String.class) {
                property = config.get(annotation.category(), f.getName(), (String)f.get(null), annotation.comment());
                f.set(null, property.getString());
            } else if (f.getType() == Double.TYPE) {
                boolean isRanged = f.isAnnotationPresent(Config.RangeDouble.class);
                if (!isRanged) {
                    property = config.get(annotation.category(), f.getName(), f.getDouble(null), annotation.comment());
                    f.set(null, property.getDouble());
                } else {
                    Config.RangeDouble range = f.getAnnotation(Config.RangeDouble.class);
                    property = config.get(annotation.category(), f.getName(), f.getDouble(null), annotation.comment(), range.min(), range.max());
                    f.set(null, property.getDouble());
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        if (f.isAnnotationPresent(Config.RequiresMcRestart.class) && property != null) {
            property.setRequiresMcRestart(true);
        }
        elementMappings.put(f, property);
    }

    public static void saveConfig() {
        config.save();
    }

    public static void init() {
        if (isLoaded) {
            return;
        }
        isLoaded = true;
        config = new Configuration(new File(Loader.instance().getConfigDir(), "mwc.cfg"));
        for (Field f : ModernConfigManager.class.getFields()) {
            ConfigSync annotation = f.getAnnotation(ConfigSync.class);
            if (annotation == null) continue;
            ModernConfigManager.registerProperty(f, annotation);
            if (FMLCommonHandler.instance().getSide().isServer()) continue;
            VMWModConfigGUI.submitField(annotation, f);
        }
        ModernConfigManager.saveConfig();
    }
}

