/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.config;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HierarchialTree<K> {
    private final HashMap<String, Branch<K>> roots = new HashMap(1, 0.7f);
    private final List<Branch<K>> rootsList = new ArrayList<Branch<K>>();

    private Branch<K> putBranch(String key, Branch<K> newBranch) {
        this.rootsList.add(newBranch);
        this.roots.put(key, newBranch);
        return newBranch;
    }

    public Branch<K> addBranch(String pathway) {
        if (!pathway.contains(".") && !this.roots.containsKey(pathway)) {
            return this.putBranch(pathway, new Branch(pathway, null));
        }
        if (pathway.contains(".")) {
            String head = pathway.substring(0, pathway.indexOf("."));
            if (!this.roots.containsKey(head)) {
                this.putBranch(head, new Branch(head, null));
            }
            return this.roots.get(head).addBranch(pathway.substring(pathway.indexOf(".") + 1));
        }
        return this.roots.get(pathway);
    }

    public void print() {
        this.print(System.out);
    }

    public void print(OutputStream output) {
        for (Map.Entry<String, Branch<K>> branch : this.roots.entrySet()) {
            try {
                output.write((branch.getKey() + (branch.getValue().size() != 0 ? " (" + branch.getValue().size() + ")" : "") + "\n").getBytes());
            }
            catch (IOException e) {
                System.err.println("Error writing to output stream");
                e.printStackTrace();
            }
            branch.getValue().print(1);
        }
    }

    public Branch<K> pruneBranch(String pathway) {
        if (pathway.contains(".")) {
            String[] split = pathway.split("\\.");
            return ((Branch)this.addBranch(pathway)).parent.pruneBranch(split[split.length - 1]);
        }
        Branch<K> rootBranch = this.roots.get(pathway);
        this.roots.remove(pathway);
        this.rootsList.remove(rootBranch);
        return rootBranch;
    }

    public void addNode(String pathway, K node) {
        ((Branch)this.addBranch(pathway)).nodes.add(node);
    }

    public List<K> fetchNodes(String pathway) {
        return ((Branch)this.addBranch(pathway)).nodes;
    }

    public int getTotalBranches() {
        int total = 0;
        for (Map.Entry<String, Branch<K>> entry : this.roots.entrySet()) {
            total += entry.getValue().totalBranchesBeneath() + 1;
        }
        return total;
    }

    public Iterator<Branch<K>> getRootIterator() {
        return this.rootsList.iterator();
    }

    public static void main(String[] args) {
        HierarchialTree<String> tree = new HierarchialTree<String>();
        tree.addNode("root.branchA.branchAA.branchAAa", "Lemme know");
        tree.addNode("root.branchA.branchAA.branchAAb", "Lemme know");
        tree.pruneBranch("root.branchA.branchAA");
        tree.print(System.out);
    }

    public static class Branch<K> {
        private Branch<K> parent;
        private String key;
        private HashMap<String, Branch<K>> subBranches = new HashMap();
        private final List<Branch<K>> subBranchList = new ArrayList<Branch<K>>();
        private final List<K> nodes = new ArrayList<K>();

        public Branch(String key, Branch<K> parent) {
            this.key = key;
            this.parent = parent;
        }

        public List<K> getNodes() {
            return this.nodes;
        }

        public HashMap<String, Branch<K>> getSubBranches() {
            return this.subBranches;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public Branch<K> getParent() {
            return this.parent;
        }

        public int size() {
            return this.subBranches.size();
        }

        public int nodeCount() {
            return this.nodes.size();
        }

        private Branch<K> putBranch(String key, Branch<K> newBranch) {
            this.subBranchList.add(newBranch);
            this.subBranches.put(key, newBranch);
            return newBranch;
        }

        public Iterator<K> getNodeIterator() {
            return this.nodes.iterator();
        }

        public void print(int i) {
            for (Map.Entry<String, Branch<K>> branch : this.subBranches.entrySet()) {
                for (int n = 0; n < i; ++n) {
                    System.out.print("-");
                }
                String print = " " + branch.getKey();
                if (branch.getValue().size() != 0) {
                    print = print + " (" + branch.getValue().size() + ")";
                }
                System.out.println(print);
                branch.getValue().print(i + 1);
            }
        }

        public int totalBranchesBeneath() {
            int total = 0;
            for (Map.Entry<String, Branch<K>> branch : this.subBranches.entrySet()) {
                total += branch.getValue().totalBranchesBeneath() + 1;
            }
            return total;
        }

        public String getPathway() {
            if (this.parent != null) {
                return this.appendPath(this.key);
            }
            return this.key;
        }

        private String appendPath(String builder) {
            if (this.parent == null) {
                return this.key + "." + builder;
            }
            return super.appendPath(this.key + "." + builder);
        }

        public Branch<K> pruneBranch(String name) {
            Branch<K> branch = this.subBranches.get(name);
            this.subBranches.remove(name);
            this.subBranchList.remove(branch);
            return branch;
        }

        public Branch<K> addBranch(String pathway) {
            if (!pathway.contains(".") && !this.subBranches.containsKey(pathway)) {
                return this.putBranch(pathway, new Branch<K>(pathway, this));
            }
            if (pathway.contains(".")) {
                String head = pathway.substring(0, pathway.indexOf("."));
                if (!this.subBranches.containsKey(head)) {
                    this.putBranch(head, new Branch<K>(head, this));
                }
                return this.subBranches.get(head).addBranch(pathway.substring(pathway.indexOf(".") + 1));
            }
            return this.subBranches.get(pathway);
        }
    }
}

