/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.compatibility;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.animation.MatrixHelper;
import com.paneedah.weaponlib.compatibility.shells.ShellRegistry;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.render.InstancedShellObject;
import com.paneedah.weaponlib.render.WavefrontLoader;
import com.paneedah.weaponlib.render.WavefrontModel;
import com.paneedah.weaponlib.render.bgl.GLCompatible;
import com.paneedah.weaponlib.render.bgl.instancing.InstancedAttribute;
import com.paneedah.weaponlib.render.shells.ShellParticleSimulator;
import com.paneedah.weaponlib.shader.jim.Attribute;
import com.paneedah.weaponlib.shader.jim.Shader;
import com.paneedah.weaponlib.shader.jim.ShaderLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Vector3d;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class ShellRenderer {
    private static HashMap<ShellParticleSimulator.Shell.Type, InstancedShellObject> shellObjMap = new HashMap();
    private static Shader legacyShader = ShaderLoader.loadShader("shells", new Attribute[0]);
    private static int shadowDisplayList = -1;
    public static final float[] g_vertex_buffer_data = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f};
    private static int degenDisplayOne;

    public static void addInstancedOperator(ShellParticleSimulator.Shell.Type type, String name) {
        WavefrontModel model = WavefrontLoader.loadSubModel(name, "casing", true);
        InstancedShellObject iso = new InstancedShellObject(type, "instanced", model, 4, 10000, new InstancedAttribute("inPosition", 3, InstancedAttribute.Type.VEC3), new InstancedAttribute("inQuat", 4, InstancedAttribute.Type.VEC4), new InstancedAttribute("inLightmapCoords", 5, InstancedAttribute.Type.VEC2));
        shellObjMap.put(type, iso);
    }

    public static void setupLightmapCoords(Vector3d pos) {
        ShellRenderer.setupLightmapCoords(new Vec3d(pos.x, pos.y, pos.z));
    }

    public static void setupLightmapCoords(Vec3d pos) {
        int i = ClientProxy.MC.field_71441_e.func_175626_b(new BlockPos(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c), 0);
        float f = i & 0xFFFF;
        float f1 = i >> 16;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)f, (float)f1);
    }

    public static double getDistanceFromPlayer(Vector3d vec) {
        Vec3d player = ClientProxy.MC.field_71439_g.func_174791_d();
        double d0 = vec.x - player.field_72450_a;
        double d1 = vec.y - player.field_72448_b;
        double d2 = vec.z - player.field_72449_c;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public static void renderDegenerateModel() {
        if (degenDisplayOne == -1) {
            degenDisplayOne = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)degenDisplayOne, (int)4864);
            Tessellator t = Tessellator.func_178181_a();
            BufferBuilder bb2 = t.func_178180_c();
            bb2.func_181668_a(4, DefaultVertexFormats.field_181705_e);
            GlStateManager.func_179131_c((float)0.78f, (float)0.65f, (float)0.33f, (float)1.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            double shScaleX = 0.02;
            double shScaleY = 0.12;
            double shScaleZ = 0.02;
            for (int i = 0; i < g_vertex_buffer_data.length - 3; i += 3) {
                bb2.func_181662_b((double)g_vertex_buffer_data[i] * shScaleX, (double)g_vertex_buffer_data[i + 1] * shScaleY, (double)g_vertex_buffer_data[i + 2] * shScaleZ).func_181675_d();
            }
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            t.func_78381_a();
            GlStateManager.func_187415_K();
        } else {
            GlStateManager.func_179148_o((int)degenDisplayOne);
        }
    }

    public static void render(ArrayList<ShellParticleSimulator.Shell> shells) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179098_w();
        EntityPlayerSP pla = ClientProxy.MC.field_71439_g;
        float interpX = (float)MatrixHelper.solveLerp(pla.field_70169_q, pla.field_70165_t, (double)ClientProxy.MC.func_184121_ak());
        float interpY = (float)MatrixHelper.solveLerp(pla.field_70167_r, pla.field_70163_u, (double)ClientProxy.MC.func_184121_ak());
        float interpZ = (float)MatrixHelper.solveLerp(pla.field_70166_s, pla.field_70161_v, (double)ClientProxy.MC.func_184121_ak());
        GlStateManager.func_179109_b((float)(-interpX), (float)(-interpY), (float)(-interpZ));
        if (GLCompatible.doesSupportInstancing()) {
            ShellRenderer.renderInstanced(shells);
        } else {
            ShellRenderer.renderNonInstanced(shells);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void renderInstanced(ArrayList<ShellParticleSimulator.Shell> shells) {
        for (Map.Entry<ShellParticleSimulator.Shell.Type, InstancedShellObject> i : shellObjMap.entrySet()) {
            ClientProxy.MC.func_110434_K().func_110577_a(ShellRegistry.getShellTexture(i.getKey()));
            i.getValue().updateData(shells);
            i.getValue().render(shells.size());
        }
    }

    public static void renderNonInstanced(ArrayList<ShellParticleSimulator.Shell> shells) {
        GlStateManager.func_179089_o();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientProxy.MC.field_71460_t.func_180436_i();
        for (ShellParticleSimulator.Shell sh : shells) {
            GlStateManager.func_179094_E();
            ShellRenderer.setupLightmapCoords(sh.pos);
            Vec3d iP = MatrixHelper.lerpVectors(sh.prevPos, sh.pos, ClientProxy.MC.func_184121_ak());
            Vec3d iR = MatrixHelper.lerpVectors(sh.prevRot, sh.rot, ClientProxy.MC.func_184121_ak());
            GlStateManager.func_179137_b((double)iP.field_72450_a, (double)iP.field_72448_b, (double)iP.field_72449_c);
            GlStateManager.func_179114_b((float)((float)iR.field_72450_a), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)((float)iR.field_72448_b), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)iR.field_72449_c), (float)1.0f, (float)0.0f, (float)0.0f);
            double shellScale = 0.8;
            GlStateManager.func_179139_a((double)shellScale, (double)shellScale, (double)shellScale);
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            if (ShellRenderer.getDistanceFromPlayer(sh.pos) < 120.0) {
                if (ModernConfigManager.enableAllShaders) {
                    legacyShader.use();
                    legacyShader.uniform1i("lightmap", 1);
                    ClientProxy.MC.func_110434_K().func_110577_a(ShellRegistry.getShellTexture(sh.getType()));
                    ShellRegistry.getShellModel(sh.getType()).render();
                    legacyShader.release();
                } else {
                    ClientProxy.MC.func_110434_K().func_110577_a(ShellRegistry.getShellTexture(sh.getType()));
                    ShellRegistry.getShellModel(sh.getType()).render();
                }
            } else {
                ShellRenderer.renderDegenerateModel();
            }
            GlStateManager.func_179140_f();
            GlStateManager.func_179090_x();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179098_w();
        ClientProxy.MC.field_71460_t.func_175072_h();
    }

    static {
        if (GLCompatible.doesSupportInstancing()) {
            ShellRenderer.addInstancedOperator(ShellParticleSimulator.Shell.Type.ASSAULT, "assaultshell");
            ShellRenderer.addInstancedOperator(ShellParticleSimulator.Shell.Type.SHOTGUN, "12gaugeshell");
            ShellRenderer.addInstancedOperator(ShellParticleSimulator.Shell.Type.PISTOL, "9mmshell");
        }
        degenDisplayOne = -1;
    }
}

