/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.command;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.AttachmentContainer;
import com.paneedah.weaponlib.ClientEventHandler;
import com.paneedah.weaponlib.CompatibleAttachment;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.crafting.CraftingEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class MainCommand
extends CommandBase {
    private static final String SHOW_OPTION_RECIPE = "recipe";
    private static final String SHOW_OPTION_ATTACHMENTS = "attachments";
    private static final String ARG_SHOW = "show";
    private String mainCommandName;
    private ModContext modContext;

    public MainCommand(ModContext modContext) {
        this.modContext = modContext;
        this.mainCommandName = "mwc";
    }

    public String func_71517_b() {
        return "mwc";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.mainCommandName + "<options>";
    }

    private String getSubCommandShowUsage() {
        return String.format("/%s %s recipe|attachments", this.mainCommandName, ARG_SHOW);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args[0].equals("nosway")) {
            boolean bl = ClientEventHandler.cancelSway = !ClientEventHandler.cancelSway;
        }
        if (args.length > 0) {
            if (ARG_SHOW.indexOf(args[0].toLowerCase()) == 0) {
                this.processShowSubCommand(args);
            } else {
                ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
            }
        } else {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
        }
    }

    private void processShowSubCommand(String[] args) {
        if (args.length < 2) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandShowUsage()));
            return;
        }
        if (SHOW_OPTION_RECIPE.indexOf(args[1].toLowerCase()) == 0) {
            this.showRecipe();
        } else if (SHOW_OPTION_ATTACHMENTS.indexOf(args[1].toLowerCase()) == 0) {
            int page = 1;
            if (args.length == 3) {
                page = Integer.parseInt(args[2]);
            }
            this.showAttachments(page);
        } else {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandShowUsage()));
        }
    }

    private void showAttachments(int page) {
        Item item;
        ItemStack itemStack = ClientProxy.MC.field_71439_g.func_184614_ca();
        if (itemStack != null && (item = itemStack.func_77973_b()) instanceof AttachmentContainer) {
            AttachmentContainer container = (AttachmentContainer)item;
            Collection<CompatibleAttachment<? extends AttachmentContainer>> compatibleAttachments = container.getCompatibleAttachments(AttachmentCategory.BULLET, AttachmentCategory.GRIP, AttachmentCategory.MAGAZINE, AttachmentCategory.SCOPE, AttachmentCategory.SILENCER, AttachmentCategory.SKIN);
            ArrayList<CompatibleAttachment<? extends AttachmentContainer>> sorted = new ArrayList<CompatibleAttachment<? extends AttachmentContainer>>(compatibleAttachments);
            sorted.sort((c1, c2) -> c1.getAttachment().func_77658_a().compareTo(c2.getAttachment().func_77658_a()));
            int pageSize = 8;
            int offset = pageSize * (page - 1);
            if (page < 1) {
                ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Invalid page"));
            } else if (sorted.size() == 0) {
                ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("No attachments found for " + item.func_77653_i(itemStack)));
            } else if (offset < sorted.size()) {
                ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Attachments for " + item.func_77653_i(itemStack) + ", page " + page + " of " + (int)Math.ceil((double)sorted.size() / (double)pageSize)));
                for (int i = offset; i < offset + pageSize && i >= 0 && i < sorted.size(); ++i) {
                    ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(" - " + ((CompatibleAttachment)sorted.get(i)).getAttachment().func_77653_i(null)));
                }
            } else {
                ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Invalid page"));
            }
        }
    }

    public int func_82362_a() {
        return 0;
    }

    private void showRecipe() {
        ItemStack itemStack = ClientProxy.MC.field_71439_g.func_184614_ca();
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            this.showRecipe(item);
        }
    }

    private void showRecipe(Item item) {
        if (item != null && item instanceof Weapon) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "-- Recipe for " + TextFormatting.GRAY + item.func_77653_i(null) + TextFormatting.GOLD + "--"));
            CraftingEntry[] modernRecipe = ((Weapon)item).getModernRecipe();
            if (modernRecipe == null) {
                return;
            }
            for (CraftingEntry stack : modernRecipe) {
                String toPrint = "> " + stack.getCount() + "x " + TextFormatting.WHITE + I18n.func_135052_a((String)(stack.getItem().func_77658_a() + ".name"), (Object[])new Object[0]);
                toPrint = toPrint + " -> " + (double)stack.getCount() * stack.getYield() + "x " + I18n.func_135052_a((String)(stack.getItem().getRegistryName() + ".name"), (Object[])new Object[0]);
                ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + toPrint));
            }
        }
    }

    private String formatRecipe(List<Object> recipe) {
        Object element;
        int i;
        StringBuilder output = new StringBuilder();
        HashMap<Character, Object> decoder = new HashMap<Character, Object>();
        boolean inRow = true;
        for (i = 0; i < recipe.size(); ++i) {
            element = recipe.get(i);
            if (inRow && !(element instanceof String)) {
                inRow = false;
            }
            if (inRow || !(element instanceof Character) || recipe.size() <= i + 1) continue;
            Object value = recipe.get(i + 1);
            if (value instanceof Item) {
                value = ((Item)value).func_77653_i(null);
            } else if (value instanceof Block) {
                value = ((Block)value).func_149732_F();
            }
            decoder.put((Character)element, value);
            ++i;
        }
        ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(""));
        for (i = 0; i < recipe.size() && (element = recipe.get(i)) instanceof String; ++i) {
            StringBuilder builder = new StringBuilder();
            char[] cArray = ((String)element).toCharArray();
            int n = cArray.length;
            for (int j = 0; j < n; ++j) {
                Character c = Character.valueOf(cArray[j]);
                Object decoded = decoder.get(c);
                builder.append(String.format("[%.20s] ", decoded != null ? decoded : "*"));
            }
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("" + builder.toString()));
        }
        return output.toString();
    }
}

