/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.command;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.ClientEventHandler;
import com.paneedah.weaponlib.ClientModContext;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.Pair;
import com.paneedah.weaponlib.Part;
import com.paneedah.weaponlib.animation.AnimationModeProcessor;
import com.paneedah.weaponlib.animation.DebugPositioner;
import com.paneedah.weaponlib.animation.Transform;
import com.paneedah.weaponlib.animation.jim.BBLoader;
import com.paneedah.weaponlib.render.ModificationGUI;
import com.paneedah.weaponlib.render.WeaponSpritesheetBuilder;
import com.paneedah.weaponlib.vehicle.VehiclePart;
import java.util.ArrayList;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class DebugCommand
extends CommandBase {
    public static boolean debugF3;
    private static final String SHOW_OPTION_CODE = "code";
    private static final String COMMAND_DEBUG = "wdb";
    private static final String DEBUG_ARG_ON = "on";
    private static final String DEBUG_ARG_OFF = "off";
    private static final String DEBUG_ARG_PAUSE = "pause";
    private static final String DEBUG_ARG_PART = "part";
    private static final String DEBUG_ARG_VPART = "vpart";
    private static final String DEBUG_ARG_SCALE = "scale";
    private static final String DEBUG_ARG_SHOW = "show";
    private static final String DEBUG_ARG_WATCH = "watch";
    private static final String DEBUG_ARG_STEP = "step";
    private static final String DEBUG_ARG_AUTOROTATE = "ar";
    private static final String DEBUG_ANIM_MODE = "anim";
    private static final String DEBUG_WEAPON = "weapon";
    private static final String DEBUG_F3 = "f3";
    private static final String DEBUG_FREECAM = "freecam";
    private static final String DEBUG_MUZZLE_POS = "muzzle";
    public static int debugFlag;
    public ArrayList<String> compatList = new ArrayList();
    private static boolean isInfiniteAmmo;
    private static boolean isDebuggingActionPosition;
    private static boolean isWorkingOnScreenShake;
    private static boolean isForceLiveRenderGUI;
    private static boolean isEditingGUI;
    public static Transform debugSlideTransform;
    public static Pair<Double, Double> screenShakeParam;

    public String func_71517_b() {
        return COMMAND_DEBUG;
    }

    public String getDebugPrefix() {
        return TextFormatting.GOLD + "[" + TextFormatting.DARK_GRAY + "VMW DEBUG" + TextFormatting.GOLD + "] ";
    }

    public String getDefaultPrefix() {
        return TextFormatting.BOLD + "" + TextFormatting.GOLD + "(" + TextFormatting.DARK_GRAY + "MWC" + TextFormatting.GOLD + ") ";
    }

    public String func_71518_a(ICommandSender sender) {
        return this.getDebugPrefix() + "/" + COMMAND_DEBUG + " (options) or type /wdb help";
    }

    public void sendDebugMessage(String message) {
        ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getDebugPrefix() + message));
    }

    private String getSubCommandDebugUsage() {
        return "/wdb <on|off>";
    }

    private String getSubCommandPauseUsage() {
        return String.format("/%s %s <transition-number> <pause-duration>", COMMAND_DEBUG, DEBUG_ARG_PAUSE);
    }

    private String getSubCommandPartUsage() {
        return String.format("/%s %s main|lhand|rhand", COMMAND_DEBUG, DEBUG_ARG_PART);
    }

    private String getSubCommandVPartUsage() {
        return String.format("/%s %s main|lhand|rhand|swheel", COMMAND_DEBUG, DEBUG_ARG_VPART);
    }

    private String getSubCommandShowUsage() {
        return String.format("/%s %s code", COMMAND_DEBUG, DEBUG_ARG_SHOW);
    }

    private String getSubCommandScaleUsage() {
        return String.format("/%s %s <scale>", COMMAND_DEBUG, DEBUG_ARG_SCALE);
    }

    private String getSubCommandStepUsage() {
        return String.format("/%s %s <step>", COMMAND_DEBUG, DEBUG_ARG_STEP);
    }

    private String getSubCommandWatchUsage() {
        return String.format("/%s %s [entity-id]", COMMAND_DEBUG, DEBUG_ARG_WATCH);
    }

    private String getSubCommandAutorotateUsage() {
        return String.format("/%s %s <rpm> [x|y|z]", COMMAND_DEBUG, DEBUG_ARG_AUTOROTATE);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length > 0) {
            switch (args[0].toLowerCase()) {
                case "on": {
                    this.processDebugModeSubCommand(args);
                    break;
                }
                case "off": {
                    this.processDebugModeSubCommand(args);
                    break;
                }
                case "pause": {
                    this.processPauseSubCommand(args);
                    break;
                }
                case "part": {
                    this.processWeaponPartSubCommand(args);
                    break;
                }
                case "vpart": {
                    this.processVehiclePartSubCommand(args);
                    break;
                }
                case "show": {
                    this.processShowSubCommand(args);
                    break;
                }
                case "scale": {
                    this.processScaleSubCommand(args);
                    break;
                }
                case "step": {
                    this.processStepSubCommand(args);
                    break;
                }
                case "watch": {
                    this.processWatchSubCommand(args);
                    break;
                }
                case "ar": {
                    this.processAutorotateSubCommand(args);
                    break;
                }
                case "freecam": {
                    this.processFreecamAndMuzzleSubCommands(args);
                    break;
                }
                case "muzzle": {
                    this.processFreecamAndMuzzleSubCommands(args);
                    break;
                }
                case "anim": {
                    this.processAnimMode(args);
                    break;
                }
                case "weapon": {
                    this.processWeapon(args);
                    break;
                }
                case "f3": {
                    this.processF3();
                    break;
                }
                default: {
                    ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
                    break;
                }
            }
        } else {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
        }
    }

    public static boolean isDebuggingActionPosition() {
        return isDebuggingActionPosition;
    }

    public static boolean isWorkingOnScreenShake() {
        return isWorkingOnScreenShake;
    }

    public static boolean isInfiniteAmmo() {
        return isInfiniteAmmo;
    }

    public static boolean isEditingGUI() {
        return isEditingGUI;
    }

    public static boolean isForceLiveRenderGUI() {
        return isForceLiveRenderGUI;
    }

    private void processF3() {
        debugF3 = !debugF3;
        MWC.updateDebugHandler();
        this.sendDebugMessage("F3 debugging is now " + (debugF3 ? DEBUG_ARG_ON : DEBUG_ARG_OFF));
    }

    private void processWeapon(String[] args) {
        switch (args[1]) {
            case "infinite": {
                isInfiniteAmmo = !isInfiniteAmmo;
                ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getDebugPrefix() + " Infinite ammo mode is " + (isInfiniteAmmo ? DEBUG_ARG_ON : DEBUG_ARG_OFF)));
                break;
            }
            case "slide": {
                if (args[2].equals("edit")) {
                    isDebuggingActionPosition = !isDebuggingActionPosition;
                    ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getDebugPrefix() + " Slide editor mode is " + (isDebuggingActionPosition ? DEBUG_ARG_ON : DEBUG_ARG_OFF)));
                    break;
                }
                if (!args[2].equals("setpos")) break;
                double x = Double.parseDouble(args[3]);
                double y = Double.parseDouble(args[4]);
                double z = Double.parseDouble(args[5]);
                debugSlideTransform.withPosition(x, y, z);
                break;
            }
            case "shake": {
                if (args[2].equals("edit")) {
                    isWorkingOnScreenShake = !isWorkingOnScreenShake;
                    ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getDebugPrefix() + " Shake editor mode is " + (isWorkingOnScreenShake ? DEBUG_ARG_ON : DEBUG_ARG_OFF)));
                    break;
                }
                if (!args[2].equals("set")) break;
                double intensity = Double.parseDouble(args[3]);
                double lengthModifier = Double.parseDouble(args[4]);
                screenShakeParam = new Pair<Double, Double>(intensity, lengthModifier);
                break;
            }
            case "buildsheet": {
                this.sendDebugMessage("Checking to see if a sprite sheet can be built...");
                WeaponSpritesheetBuilder.build();
                this.sendDebugMessage("Generating icon sheet as... " + TextFormatting.GREEN + " guniconsheet.png");
                break;
            }
            case "liverender": {
                if (args[2].equals("toggle")) {
                    isForceLiveRenderGUI = !isForceLiveRenderGUI;
                    this.sendDebugMessage("Live renderer is now " + TextFormatting.DARK_GRAY + (isForceLiveRenderGUI ? DEBUG_ARG_ON : DEBUG_ARG_OFF));
                    break;
                }
                if (!args[2].equals("?")) break;
                this.sendDebugMessage("Live renderer causes weapons to switch off of the icon sheet and directly renderer into the inventory. This should only ever be used for debugging.");
                break;
            }
            case "gui": {
                if (args[2].equals("print")) {
                    this.sendDebugMessage("Printing locations to console (or log)");
                    ModificationGUI.getInstance().printTabLocations();
                    break;
                }
                isEditingGUI = !isEditingGUI;
                this.sendDebugMessage("GUI editing mode: " + TextFormatting.DARK_GRAY + (isEditingGUI ? DEBUG_ARG_ON : DEBUG_ARG_OFF));
                break;
            }
            case "debugFlag": {
                debugFlag = Integer.parseInt(args[2]);
            }
        }
    }

    private void processAnimMode(String[] args) {
        switch (args[1]) {
            case "on": {
                if (!AnimationModeProcessor.getInstance().isLegacyMode()) {
                    AnimationModeProcessor.getInstance().setFPSMode(true);
                    break;
                }
                ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getDebugPrefix() + " You cannot enter animation mode with a legacy gun!"));
                break;
            }
            case "off": {
                AnimationModeProcessor.getInstance().setFPSMode(false);
                break;
            }
            case "dh": {
                BBLoader.HANDDIVISOR = Double.parseDouble(args[2]);
                ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Hand divisor set to " + BBLoader.HANDDIVISOR));
                break;
            }
            case "dg": {
                BBLoader.GENDIVISOR = Double.parseDouble(args[2]);
                ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("General divisor set to " + BBLoader.GENDIVISOR));
                break;
            }
            case "as": {
                double x = Double.parseDouble(args[2]);
                double y = Double.parseDouble(args[3]);
                double z = Double.parseDouble(args[4]);
                ClientModContext.getContext().getMainHeldWeapon().getWeapon().getRenderer().getWeaponRendererBuilder().firstPersonLeftHandTransform.withScale(x, y, z);
            }
        }
    }

    private void processFreecamAndMuzzleSubCommands(String[] args) {
        switch (args[0].toLowerCase()) {
            case "freecam": {
                if (args.length > 1 && args[1].equals("lock")) {
                    ClientEventHandler.freecamLock = !ClientEventHandler.freecamLock;
                    this.sendDebugMessage("Freecam lock " + TextFormatting.DARK_GRAY + (ClientEventHandler.freecamLock ? "enabled" : "disabled"));
                    break;
                }
                ClientEventHandler.freecamEnabled = !ClientEventHandler.freecamEnabled;
                this.sendDebugMessage("Freecam " + TextFormatting.DARK_GRAY + (ClientEventHandler.freecamEnabled ? "enabled" : "disabled"));
                break;
            }
            case "muzzle": {
                if (ClientEventHandler.muzzlePositioner) {
                    ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getDebugPrefix() + "Exiting muzzle debug..."));
                    ClientEventHandler.muzzlePositioner = false;
                    break;
                }
                ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getDebugPrefix() + "Entering muzzle debug... a point will display."));
                ClientEventHandler.muzzlePositioner = true;
            }
        }
    }

    private void processDebugModeSubCommand(String[] args) {
        Boolean debugMode = null;
        switch (args[0].toLowerCase()) {
            case "on": {
                debugMode = true;
                break;
            }
            case "off": {
                debugMode = false;
            }
        }
        if (debugMode != null) {
            DebugPositioner.setDebugMode(debugMode);
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getDebugPrefix() + "Debug mode " + args[0].toLowerCase()));
        } else {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandDebugUsage()));
        }
    }

    private void processPauseSubCommand(String[] args) {
        if (args.length != 3) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandPauseUsage()));
            return;
        }
        try {
            int transitionNumber = Integer.parseInt(args[1]);
            long pauseDuration = Long.parseLong(args[2]);
            DebugPositioner.configureTransitionPause(transitionNumber, pauseDuration);
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Set transition " + transitionNumber + " pause to " + pauseDuration + "ms"));
        }
        catch (NumberFormatException e) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandPauseUsage()));
        }
    }

    private void processWatchSubCommand(String[] args) {
        if (args.length < 1) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandWatchUsage()));
            return;
        }
        DebugPositioner.watch();
    }

    private void processScaleSubCommand(String[] args) {
        if (args.length != 2) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandScaleUsage()));
            return;
        }
        if (DebugPositioner.getDebugPart() == null) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debug part not selected"));
            return;
        }
        try {
            float scale = Float.parseFloat(args[1]);
            DebugPositioner.setScale(scale);
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Set scale to " + scale));
        }
        catch (NumberFormatException e) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandScaleUsage()));
        }
    }

    private void processAutorotateSubCommand(String[] args) {
        if (args.length < 2) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandAutorotateUsage()));
            return;
        }
        if (DebugPositioner.getDebugPart() == null) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debug part not selected"));
            return;
        }
        try {
            float rpm = Float.parseFloat(args[1]);
            if (rpm < 0.0f) {
                ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("RPM must be greater than 0"));
                return;
            }
            float xrpm = 0.0f;
            float yrpm = 0.0f;
            float zrpm = 0.0f;
            if (args.length >= 3) {
                switch (args[2].trim().toLowerCase()) {
                    case "y": {
                        yrpm = rpm;
                        break;
                    }
                    case "z": {
                        zrpm = rpm;
                        break;
                    }
                    default: {
                        xrpm = rpm;
                        break;
                    }
                }
            } else {
                xrpm = rpm;
            }
            DebugPositioner.setAutorotate(xrpm, yrpm, zrpm);
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Set autorotate to " + xrpm + ", " + yrpm + ", " + zrpm));
        }
        catch (NumberFormatException e) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandAutorotateUsage()));
        }
    }

    private void processStepSubCommand(String[] args) {
        if (args.length != 2) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandStepUsage()));
            return;
        }
        if (DebugPositioner.getDebugPart() == null) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debug part not selected"));
            return;
        }
        try {
            float step = Float.parseFloat(args[1]);
            DebugPositioner.setStep(step);
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Set step to " + step));
        }
        catch (NumberFormatException e) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandStepUsage()));
        }
    }

    private void processShowSubCommand(String[] args) {
        if (args.length != 2) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandShowUsage()));
            return;
        }
        if (ClientEventHandler.muzzlePositioner) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getDebugPrefix() + "Muzzle Position: " + ClientEventHandler.debugmuzzlePosition));
            return;
        }
        if (DebugPositioner.getDebugPart() == null) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debug part not selected"));
            return;
        }
        if (args[1].equalsIgnoreCase(SHOW_OPTION_CODE)) {
            DebugPositioner.showCode();
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Code is copied to the console"));
        } else {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandShowUsage()));
        }
    }

    private void processWeaponPartSubCommand(String[] args) {
        if (args.length != 2) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandPartUsage()));
            return;
        }
        try {
            switch (args[1].toLowerCase()) {
                case "main": {
                    DebugPositioner.setDebugPart(Part.MAIN_ITEM);
                    break;
                }
                case "lhand": {
                    DebugPositioner.setDebugPart(Part.LEFT_HAND);
                    break;
                }
                case "rhand": {
                    DebugPositioner.setDebugPart(Part.RIGHT_HAND);
                    break;
                }
                case "inventory": {
                    DebugPositioner.setDebugPart(Part.INVENTORY);
                    break;
                }
                default: {
                    String partName = args[1];
                    Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("mwc", partName));
                    Part part = null;
                    if (item instanceof Part) {
                        part = (Part)item;
                    } else if (item instanceof ItemAttachment) {
                        part = ((ItemAttachment)item).getRenderablePart();
                    }
                    if (part == null) break;
                    DebugPositioner.setDebugPart(part);
                }
            }
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debugging part " + args[1]));
        }
        catch (NumberFormatException e) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandPartUsage()));
        }
    }

    private void processVehiclePartSubCommand(String[] args) {
        if (args.length != 2) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandVPartUsage()));
            return;
        }
        try {
            switch (args[1].toLowerCase()) {
                case "main": {
                    DebugPositioner.setDebugPart(VehiclePart.MAIN);
                    break;
                }
                case "lhand": {
                    DebugPositioner.setDebugPart(VehiclePart.LEFT_HAND);
                    break;
                }
                case "rhand": {
                    DebugPositioner.setDebugPart(VehiclePart.RIGHT_HAND);
                    break;
                }
                case "swheel": {
                    DebugPositioner.setDebugPart(VehiclePart.STEERING_WHEEL);
                    break;
                }
                case "flarm": {
                    DebugPositioner.setDebugPart(VehiclePart.FRONT_LEFT_CONTROL_ARM);
                    break;
                }
                case "frarm": {
                    DebugPositioner.setDebugPart(VehiclePart.FRONT_RIGHT_CONTROL_ARM);
                    break;
                }
                case "flwheel": {
                    DebugPositioner.setDebugPart(VehiclePart.FRONT_LEFT_WHEEL);
                    break;
                }
                case "frwheel": {
                    DebugPositioner.setDebugPart(VehiclePart.FRONT_RIGHT_WHEEL);
                    break;
                }
                case "rlwheel": {
                    DebugPositioner.setDebugPart(VehiclePart.REAR_LEFT_WHEEL);
                    break;
                }
                case "rrwheel": {
                    DebugPositioner.setDebugPart(VehiclePart.REAR_RIGHT_WHEEL);
                    break;
                }
                default: {
                    ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Don't know anything about part " + args[1]));
                    return;
                }
            }
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debugging part " + args[1]));
        }
        catch (NumberFormatException e) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSubCommandVPartUsage()));
        }
    }

    public int func_82362_a() {
        return 2;
    }

    static {
        debugFlag = 0;
        isForceLiveRenderGUI = true;
        debugSlideTransform = new Transform();
        screenShakeParam = new Pair<Double, Double>(0.0, 0.0);
    }
}

