/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.command;

import com.paneedah.weaponlib.command.TidyCompatibleCommand;
import com.paneedah.weaponlib.crafting.CraftingFileManager;
import com.paneedah.weaponlib.crafting.CraftingRegistry;
import net.minecraft.command.ICommandSender;

public class CraftingFileCommand
extends TidyCompatibleCommand {
    private static final String RELOAD_KEY = "reload";
    private static final String STATUS_KEY = "status";

    public CraftingFileCommand() {
        super("mwccraftingmanager", "MWC Crafting Manager");
        this.addMainOption(RELOAD_KEY, "Reloads the current crafting setup", new String[0]);
        this.addMainOption(STATUS_KEY, "Provides current crafting file manager status", new String[0]);
        this.initCommand();
    }

    @Override
    protected void executeTidyCommand(ICommandSender sender, String mainArgument, String secondArgument, String[] args) {
        switch (mainArgument) {
            case "reload": {
                this.sendFormattedMessage(sender, "Reloading crafting file...");
                CraftingRegistry.clearRegistry();
                CraftingFileManager.getInstance().loadDirectory();
                this.sendFormattedMessage(sender, "Succesfully reloaded crafting file!");
                return;
            }
            case "status": {
                int load = CraftingFileManager.getInstance().getLoadingStatus();
                this.sendFormattedMessage(sender, "Crafting file manager status:");
                this.sendNormalMessage(sender, this.getSecondaryColor() + "File loaded: " + this.getDisplayColor() + (load != -1));
                if (load != -1) {
                    this.sendNormalMessage(sender, this.getSecondaryColor() + "File hash: " + this.getDisplayColor() + CraftingFileManager.getInstance().getCurrentFileHash());
                }
                this.sendNormalMessage(sender, this.getSecondaryColor() + "Using custom recipes: " + this.getDisplayColor() + (load != -1 ? (load == 2 ? "CUSTOM" : "DEFAULT") : ""));
                return;
            }
        }
    }
}

