/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation.gui;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.ClientEventHandler;
import com.paneedah.weaponlib.ClientModContext;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.WeaponAttachmentAspect;
import com.paneedah.weaponlib.WeaponRenderer;
import com.paneedah.weaponlib.animation.AnimationModeProcessor;
import com.paneedah.weaponlib.animation.DebugPositioner;
import com.paneedah.weaponlib.animation.OpenGLSelectionHelper;
import com.paneedah.weaponlib.animation.gui.Button;
import com.paneedah.weaponlib.animation.gui.Panel;
import com.paneedah.weaponlib.animation.gui.Slider;
import com.paneedah.weaponlib.animation.gui.Textbar;
import com.paneedah.weaponlib.compatibility.RecoilParam;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.input.Mouse;

public class AnimationGUI {
    private static AnimationGUI instance = new AnimationGUI();
    public static final ResourceLocation TEXTURES = new ResourceLocation("mwc:textures/hud/animguio.png");
    public ArrayList<Panel> panels = new ArrayList();
    public boolean mouseStatus = false;
    public boolean grabStatus = false;
    public boolean guiHoverStatus = false;
    public Button resetCamera = new Button("Reset Camera", 0, 10, 10, 20);
    public Button resetTransforms = new Button("Reset Transforms", 3, 35, 10, 20);
    public Button forceSteveArms = new Button("Force steve arms", 1, 60, 10, 20);
    public Button forceAlexArms = new Button("Force alex arms", 2, 85, 10, 20);
    public Button printConsole = new Button("Print to console", 6, 10, 35, 20);
    public Button switchScopes = new Button("Switch scopes", 8, 85, 35, 20);
    public Button axisToggle = new Button("Toggle axis indicator", true, 4, 110, 10, 20);
    public Button forceFlash = new Button("Position muzzle flash", true, 5, 135, 10, 20);
    public Button titleSafe = new Button("Center indicator", true, 9, 110, 35, 20);
    public Button editRotButton = new Button("Edit rotation point", true, 10, 35, 35, 20);
    public Button moveForward = new Button("Move axis backwards", true, 7, 60, 35, 20);
    public Button leftDrag = new Button("Position drag alignment", true, 11, 135, 35, 20);
    public Button magEdit = new Button("Edit magazine rotation point", true, 12, 10, 80, 20);
    public Button forceADS = new Button("Force ADS", true, 13, 10, 80, 20);
    public Slider weaponPower = new Slider("Weapon Power", false, 0.0, 200.0);
    public Slider muzzleClimbDivisor = new Slider("Muzzle Climb Divisor", false, 0.0, 30.0);
    public Slider stockLength = new Slider("Stock Length", false, 0.0, 100.0);
    public Slider powerRecoveryNormalRate = new Slider("Power Recovery", false, 0.0, 1.0);
    public Slider powerRecoveryStockRate = new Slider("Power Recovery @ Stock", false, 0.0, 1.0);
    public Slider weaponRotationX = new Slider("Recoil Rotation (Y)", false, 0.0, 1.0);
    public Slider weaponRotationY = new Slider("Recoil Rotation (Z)", false, 0.0, 1.0);
    public Slider adsSimilarity = new Slider("ADS Similarity", false, 1.0, 10.0);
    public Slider debugFireRate = new Slider("Debug Fire Rate", false, 1.0, 25.0);
    public Button but;
    public Textbar position = new Textbar("Position", 40, 40, 90, 15);
    public Textbar rotation = new Textbar("Rotation", 10, 75, 90, 15);

    public static AnimationGUI getInstance() {
        return instance;
    }

    public boolean isPanelClosed(String name) {
        for (Panel panel : this.panels) {
            if (!panel.getTitle().equals(name)) continue;
            return panel.isClosed();
        }
        return false;
    }

    public void setRecoilDefaults(RecoilParam param) {
        this.weaponPower.setValue(param.getWeaponPower());
        this.muzzleClimbDivisor.setValue(param.getMuzzleClimbDivisor());
        this.stockLength.setValue(param.getStockLength());
        this.powerRecoveryNormalRate.setValue(param.getPowerRecoveryNormalRate());
        this.powerRecoveryStockRate.setValue(param.getPowerRecoveryStockRate());
        this.weaponRotationX.setValue(param.getWeaponRotationX());
        this.weaponRotationY.setValue(param.getWeaponRotationY());
    }

    public RecoilParam getRecoilParams() {
        return new RecoilParam(this.weaponPower.getValue(), this.muzzleClimbDivisor.getValue(), this.stockLength.getValue(), this.powerRecoveryNormalRate.getValue(), this.powerRecoveryStockRate.getValue(), this.weaponRotationX.getValue(), this.weaponRotationY.getValue(), this.adsSimilarity.getValue());
    }

    public AnimationGUI() {
        Panel cameraPanel = new Panel(this, "Functionality", 10.0, 10.0, 20.0);
        cameraPanel.addButtons(this.resetCamera, this.resetTransforms, this.forceSteveArms, this.forceAlexArms, this.switchScopes, this.magEdit, this.leftDrag, this.printConsole, this.forceADS);
        Panel renderPanel = new Panel(this, "Rendering", 10.0, 45.0, 20.0);
        renderPanel.addButtons(this.axisToggle, this.forceFlash, this.editRotButton, this.moveForward, this.titleSafe);
        Panel recoilPanel = new Panel(this, "Recoil", 10.0, 100.0, 20.0);
        recoilPanel.setWidth(100.0);
        recoilPanel.setHeight(200.0);
        recoilPanel.setClosed(true);
        this.setRecoilDefaults(new RecoilParam());
        this.debugFireRate.setValue(10.0);
        this.debugFireRate.push(25.0);
        recoilPanel.addElement(this.weaponPower);
        recoilPanel.addElement(this.muzzleClimbDivisor);
        recoilPanel.addElement(this.stockLength);
        recoilPanel.addElement(this.powerRecoveryNormalRate);
        recoilPanel.addElement(this.powerRecoveryStockRate);
        recoilPanel.addElement(this.weaponRotationX);
        recoilPanel.addElement(this.weaponRotationY);
        recoilPanel.addElement(this.adsSimilarity);
        recoilPanel.addElement(this.debugFireRate);
        this.axisToggle.setState(true);
        this.panels.add(recoilPanel);
        this.panels.add(cameraPanel);
        this.panels.add(renderPanel);
    }

    public void render() {
        ScaledResolution scaledresolution = new ScaledResolution(ClientProxy.MC);
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        int mouseX = Mouse.getX() * scaledWidth / ClientProxy.MC.field_71443_c;
        int mouseY = scaledHeight - Mouse.getY() * scaledHeight / ClientProxy.MC.field_71440_d - 1;
        this.but = null;
        this.update(mouseX, mouseY);
        this.extraRender();
        for (Panel p : this.panels) {
            p.render(mouseX, mouseY);
        }
        if (this.but != null) {
            AnimationGUI.renderRect(new Color(2240318).darker().darker().darker(), mouseX, mouseY, (float)ClientProxy.MC.field_71466_p.func_78256_a(this.but.tooltip) * 0.8f, 10.0);
            GlStateManager.func_179098_w();
            AnimationGUI.renderScaledString(this.but.tooltip, (double)mouseX + 2.5, mouseY + 2, 0.9f);
            GlStateManager.func_179090_x();
        }
        GlStateManager.func_179098_w();
    }

    public void extraRender() {
        ScaledResolution sr = new ScaledResolution(ClientProxy.MC);
        this.position.x = (int)(sr.func_78327_c() - 100.0);
        this.rotation.x = (int)(sr.func_78327_c() - 100.0);
        DebugPositioner.Position p = DebugPositioner.getCurrentPartPosition();
        if (p == null) {
            this.position.setStrings(0.0, 0.0, 0.0);
            this.rotation.setStrings(0.0, 0.0, 0.0);
        } else {
            this.position.setStrings(p.x, p.y, p.z);
            this.rotation.setStrings(p.xRotation, p.yRotation, p.zRotation);
        }
        this.position.renderButton(0, 0);
        this.rotation.renderButton(0, 0);
        GlStateManager.func_179098_w();
        String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("h:mm a"));
        AnimationGUI.renderScaledString(time, sr.func_78327_c() - 40.0, 5.0, 1.0);
        String fps = "FPS: " + ClientProxy.MC.func_175610_ah();
        AnimationGUI.renderScaledString(fps, sr.func_78327_c() - 45.0, 15.0, 1.0);
        String itemPos = "";
        if (this.magEdit.isState()) {
            itemPos = "Mag Rotation Point";
        } else if (this.forceFlash.isState()) {
            itemPos = "Muzzle Flash";
        } else if (this.editRotButton.isState()) {
            itemPos = "Weapon Rotation Point";
        } else if (OpenGLSelectionHelper.selectID == 3) {
            itemPos = "Weapon";
        } else if (OpenGLSelectionHelper.selectID == 1) {
            itemPos = "Left Hand";
        } else if (OpenGLSelectionHelper.selectID == 2) {
            itemPos = "Right Hand";
        }
        String currentlyPositioning = TextFormatting.WHITE + "Positioning " + TextFormatting.GOLD + itemPos;
        AnimationGUI.renderScaledString(currentlyPositioning, 5.0, 5.0, 0.5);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179090_x();
    }

    public void update(int mouseX, int mouseY) {
        this.grabStatus = false;
        for (Panel p : this.panels) {
            if (!this.checkIn2DBox(mouseX, mouseY, p.getPositionX(), p.getPositionY(), p.getWidth(), p.getHeight())) continue;
            this.grabStatus = true;
        }
        if (Mouse.isButtonDown((int)0) && !this.mouseStatus) {
            this.mouseStatus = true;
            this.onMouseClick(mouseX, mouseY);
        } else if (!Mouse.isButtonDown((int)0) && this.mouseStatus) {
            this.onMouseReleased(mouseX, mouseY);
            this.mouseStatus = false;
        }
    }

    public boolean checkIn2DBox(double a, double b, double x, double y, double width, double height) {
        return a >= x && a <= x + width && b >= y && b <= y + height;
    }

    public void onMouseClick(int mouseX, int mouseY) {
        for (Panel panel : this.panels) {
            panel.handleButtonClicks(mouseX, mouseY);
        }
    }

    public void onMouseReleased(int mouseX, int mouseY) {
        for (Panel panel : this.panels) {
            panel.onMouseReleased(mouseX, mouseY);
        }
    }

    public void onAction(Button id) {
        if (id == this.resetCamera) {
            AnimationModeProcessor.getInstance().rot = Vec3d.field_186680_a;
            AnimationModeProcessor.getInstance().pan = Vec3d.field_186680_a;
        } else if (id == this.resetTransforms) {
            AnimationModeProcessor amp = AnimationModeProcessor.getInstance();
            WeaponRenderer.Builder b = amp.getCurrentWeaponRenderBuilder();
            b.firstPersonTransform.set(amp.backupFP);
            b.firstPersonLeftHandTransform.set(amp.backupFPL);
            b.firstPersonRightHandTransform.set(amp.backupFPR);
            AnimationModeProcessor.getInstance().slideTransform.withPosition(0.0, 0.0, 0.0).withRotation(0.0, 0.0, 0.0).withRotationPoint(0.0, 0.0, 0.0);
            DebugPositioner.reset();
        } else if (id == this.forceSteveArms) {
            AnimationGUI.forceSkin("default");
        } else if (id == this.forceAlexArms) {
            AnimationGUI.forceSkin("slim");
        } else if (id == this.printConsole) {
            if (ClientEventHandler.muzzlePositioner) {
                System.out.println("(" + ClientEventHandler.debugmuzzlePosition.field_72450_a + ", " + ClientEventHandler.debugmuzzlePosition.field_72448_b + ", " + ClientEventHandler.debugmuzzlePosition.field_72449_c + ")");
                return;
            }
            if (this.magEdit.isState()) {
                System.out.println("(" + ClientEventHandler.magRotPositioner.field_72450_a + ", " + ClientEventHandler.magRotPositioner.field_72448_b + ", " + ClientEventHandler.magRotPositioner.field_72449_c + ")");
                return;
            }
            int selectID = OpenGLSelectionHelper.selectID;
            if (ClientModContext.getContext() == null || ClientModContext.getContext().getMainHeldWeapon() == null) {
                return;
            }
            WeaponRenderer.Builder i = ClientModContext.getContext().getMainHeldWeapon().getWeapon().getRenderer().getWeaponRendererBuilder();
            switch (selectID) {
                case 1: {
                    i.firstPersonLeftHandTransform.printTransform();
                    break;
                }
                case 2: {
                    i.firstPersonRightHandTransform.printTransform();
                    break;
                }
                case 3: {
                    i.firstPersonTransform.printTransform();
                    break;
                }
                case 4: {
                    AnimationModeProcessor.getInstance().slideTransform.printTransform();
                }
            }
            PlayerWeaponInstance instance = ClientModContext.getContext().getMainHeldWeapon();
            instance.getWeapon().setRecoilParameters(this.getRecoilParams());
            if (!this.isPanelClosed("Recoil")) {
                StringBuilder builder = new StringBuilder();
                builder.append("\n.withRecoilParam(new RecoilParam(\n");
                builder.append("\t\t// The weapon power\n");
                builder.append("\t\t" + this.weaponPower.getValue() + ",\n");
                builder.append("\t\t// Muzzle climb divisor\n");
                builder.append("\t\t" + this.muzzleClimbDivisor.getValue() + ",\n");
                builder.append("\t\t// \"Stock Length\"\n");
                builder.append("\t\t" + this.stockLength.getValue() + ",\n");
                builder.append("\t\t// Recovery rate from initial shot\n");
                builder.append("\t\t" + this.powerRecoveryNormalRate.getValue() + ",\n");
                builder.append("\t\t// Recovery rate @ \"stock\"\n");
                builder.append("\t\t" + this.powerRecoveryStockRate.getValue() + ",\n");
                builder.append("\t\t// Recoil rotation (Y)\n");
                builder.append("\t\t" + this.weaponRotationX.getValue() + ",\n");
                builder.append("\t\t// Recoil rotation (Z)\n");
                builder.append("\t\t" + this.weaponRotationY.getValue() + ",\n");
                builder.append("\t\t// Ads similarity divisor\n");
                builder.append("\t\t" + this.adsSimilarity.getValue() + "\n");
                builder.append("))");
                System.out.println(builder.toString());
            }
        } else if (id == this.switchScopes) {
            PlayerWeaponInstance instance = ClientModContext.getContext().getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)ClientProxy.MC.field_71439_g, PlayerWeaponInstance.class);
            ClientModContext.getContext().getAttachmentAspect().tryChange(new WeaponAttachmentAspect.ChangeAttachmentPermit(AttachmentCategory.SCOPE), instance);
        } else if (id == this.editRotButton) {
            if (this.editRotButton.isState()) {
                this.moveForward.setState(false);
            }
        } else if (id == this.forceFlash) {
            ClientEventHandler.muzzlePositioner = this.forceFlash.isState();
        } else if (id == this.magEdit) {
            DebugPositioner.setDebugMode(true);
        } else if (id == this.forceADS) {
            PlayerWeaponInstance instance = ClientModContext.getContext().getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)ClientProxy.MC.field_71439_g, PlayerWeaponInstance.class);
            if (id.isState()) {
                instance.setAimed(true);
            } else {
                instance.setAimed(false);
            }
        }
    }

    public static void forceSkin(String type) {
        Method f = ReflectionHelper.findMethod(AbstractClientPlayer.class, (String)"getPlayerInfo", (String)"getPlayerInfo", (Class[])new Class[]{null});
        NetworkPlayerInfo npi = null;
        try {
            npi = (NetworkPlayerInfo)f.invoke((Object)ClientProxy.MC.field_71439_g, new Object[]{null});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (npi != null) {
            try {
                Field f2 = ReflectionHelper.findField(NetworkPlayerInfo.class, (String[])new String[]{"skinType"});
                f2.setAccessible(true);
                f2.set(npi, type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        WeaponRenderer.acp = null;
    }

    public static void renderScaledString(String str, double x, double y, double scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)0.0);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        ClientProxy.MC.field_71466_p.func_175063_a(str, 0.0f, 0.0f, 0xFFFFFF);
        GlStateManager.func_179121_F();
    }

    public static void renderRect(Color c, double x, double y, double w, double h) {
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float grad = 0.8f;
        GlStateManager.func_179103_j((int)7425);
        bb.func_181662_b(x, y, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        bb.func_181662_b(x, y + h, 0.0).func_181666_a(r * grad, g * grad, b * grad, 1.0f).func_181675_d();
        bb.func_181662_b(x + w, y + h, 0.0).func_181666_a(r * grad, g * grad, b * grad, 1.0f).func_181675_d();
        bb.func_181662_b(x + w, y, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        t.func_78381_a();
    }

    public static void renderTexturedRect(int id, double x, double y, double w, double h) {
        ClientProxy.MC.func_110434_K().func_110577_a(new ResourceLocation("mwc:textures/hud/animguio.png"));
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float width = 64.0f;
        float icoSize = 16.0f;
        float height = 64.0f;
        float u = (float)id * icoSize % width / width;
        float v = (float)Math.floor((float)id * icoSize / width) * icoSize / height;
        float m = icoSize / width;
        float n = icoSize / height;
        bb.func_181662_b(x, y, 0.0).func_187315_a((double)u, (double)v).func_181675_d();
        bb.func_181662_b(x, y + h, 0.0).func_187315_a((double)u, (double)(v + n)).func_181675_d();
        bb.func_181662_b(x + w, y + h, 0.0).func_187315_a((double)(u + m), (double)(v + n)).func_181675_d();
        bb.func_181662_b(x + w, y, 0.0).func_187315_a((double)(u + m), (double)v).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179090_x();
    }
}

