/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation;

import com.paneedah.weaponlib.RenderContext;
import com.paneedah.weaponlib.RenderableState;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.lwjgl.opengl.GL11;

public class Transform {
    public static final Transform NULL = new Transform().withPosition(0.0, 0.0, 0.0).withRotation(0.0, 0.0, 0.0).withRotationPoint(0.0, 0.0, 0.0).withScale(1.0, 1.0, 1.0);
    private double[] scale = new double[3];
    private double[] rotation = new double[3];
    private double[] position = new double[3];
    private double[] rotationPoint = new double[3];

    public Transform withScale(double x, double y, double z) {
        this.scale[0] = x;
        this.scale[1] = y;
        this.scale[2] = z;
        return this;
    }

    public Transform withPosition(double x, double y, double z) {
        this.position[0] = x;
        this.position[1] = y;
        this.position[2] = z;
        return this;
    }

    public Transform withBBRotation(double x, double y, double z) {
        this.rotation[0] = -x;
        this.rotation[1] = -y;
        this.rotation[2] = z;
        return this;
    }

    public Transform withRotation(double x, double y, double z) {
        this.rotation[0] = x;
        this.rotation[1] = y;
        this.rotation[2] = z;
        return this;
    }

    public Transform addTransformConditional(Supplier<Boolean> condition, double x, double y, double z) {
        if (!condition.get().booleanValue()) {
            return this;
        }
        return this.addTransform(x, y, z);
    }

    public Transform addTransform(double x, double y, double z) {
        this.position[0] = this.position[0] + x;
        this.position[1] = this.position[1] + y;
        this.position[2] = this.position[2] + z;
        return this;
    }

    public Transform withRotationPoint(double x, double y, double z) {
        this.rotationPoint[0] = x;
        this.rotationPoint[1] = y;
        this.rotationPoint[2] = z;
        return this;
    }

    public double getPositionX() {
        return this.position[0];
    }

    public double getPositionY() {
        return this.position[1];
    }

    public double getPositionZ() {
        return this.position[2];
    }

    public double getRotationX() {
        return this.rotation[0];
    }

    public double getRotationY() {
        return this.rotation[1];
    }

    public double getRotationZ() {
        return this.rotation[2];
    }

    public double getScaleX() {
        return this.scale[0];
    }

    public double getScaleY() {
        return this.scale[1];
    }

    public double getScaleZ() {
        return this.scale[2];
    }

    public double getRotationPointX() {
        return this.rotationPoint[0];
    }

    public double getRotationPointY() {
        return this.rotationPoint[1];
    }

    public double getRotationPointZ() {
        return this.rotationPoint[2];
    }

    private double[] copyArray(double[] array) {
        double[] newArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public void set(Transform t) {
        this.position = this.copyArray(t.position);
        this.rotation = this.copyArray(t.rotation);
        this.rotationPoint = this.copyArray(t.rotationPoint);
        this.scale = this.copyArray(t.scale);
    }

    public Transform copy() {
        Transform nT = new Transform();
        nT.position = this.copyArray(this.position);
        nT.rotation = this.copyArray(this.rotation);
        nT.rotationPoint = this.copyArray(this.rotationPoint);
        nT.scale = this.copyArray(this.scale);
        return nT;
    }

    public Consumer<RenderContext<RenderableState>> getAsPosition() {
        return renderContext -> this.doGLDirect();
    }

    public void doGLDirect() {
        GL11.glTranslated((double)this.getPositionX(), (double)this.getPositionY(), (double)this.getPositionZ());
        GL11.glTranslated((double)this.getRotationPointX(), (double)this.getRotationPointY(), (double)this.getRotationPointZ());
        GL11.glRotated((double)this.getRotationZ(), (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)this.getRotationY(), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)this.getRotationX(), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)(-this.getRotationPointX()), (double)(-this.getRotationPointY()), (double)(-this.getRotationPointZ()));
        GL11.glScaled((double)this.getScaleX(), (double)this.getScaleY(), (double)this.getScaleZ());
    }

    public void printTransform() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("new Transform()", new Object[0]));
        result.append(String.format("\n.withPosition(%ff, %ff, %ff)", this.getPositionX(), this.getPositionY(), this.getPositionZ()));
        result.append(String.format("\n.withRotation(%ff, %ff, %ff)", this.getRotationX(), this.getRotationY(), this.getRotationZ()));
        result.append(String.format("\n.withRotationPoint(%ff, %ff, %ff)", this.getRotationPointX(), this.getRotationPointY(), this.getRotationPointZ()));
        result.append(String.format("\n.withScale(%ff, %ff, %ff)", this.getScaleX(), this.getScaleY(), this.getScaleZ()));
        System.out.println("\n" + result);
    }
}

