/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.ClientEventHandler;
import com.paneedah.weaponlib.ClientModContext;
import com.paneedah.weaponlib.Part;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.WeaponRenderer;
import com.paneedah.weaponlib.animation.Arcball;
import com.paneedah.weaponlib.animation.DebugPositioner;
import com.paneedah.weaponlib.animation.MatrixHelper;
import com.paneedah.weaponlib.animation.OpenGLSelectionHelper;
import com.paneedah.weaponlib.animation.Transform;
import com.paneedah.weaponlib.animation.gui.AnimationGUI;
import com.paneedah.weaponlib.debug.DebugRenderer;
import com.paneedah.weaponlib.render.Shaders;
import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;

public class AnimationModeProcessor {
    private static HashMap<Integer, AttachmentCategory> extraIDRegistry = new HashMap();
    private HashMap<AttachmentCategory, Boolean> shouldRender = new HashMap();
    private AttachmentCategory activeCategory;
    private AttachmentCategory exclusionCategory;
    private static AnimationModeProcessor instance;
    public boolean legacyMode = false;
    public Vec3d pan = Vec3d.field_186680_a;
    public Vec3d rot = Vec3d.field_186680_a;
    private boolean fpsMode = false;
    public FloatBuffer deferredMatrix = BufferUtils.createFloatBuffer((int)16);
    public boolean mouseStatus = false;
    public boolean permissionToDrag = false;
    public boolean leftLock = false;
    public long leftClickLast = System.currentTimeMillis();
    public int transformMode = -1;
    public Transform atGrab;
    public boolean editRotationPointMode = false;
    public Matrix4f currentPartMatrix = new Matrix4f();
    public Transform slideTransform = Transform.NULL.copy();
    public int colorSelected = -1;
    public int colorHover = -1;
    public PlayerWeaponInstance pwi;
    public Transform backupFP;
    public Transform backupFPL;
    public Transform backupFPR;
    public FloatBuffer VIEW_BUFFER = BufferUtils.createFloatBuffer((int)16);

    public AnimationModeProcessor() {
        for (Map.Entry<Integer, AttachmentCategory> i : extraIDRegistry.entrySet()) {
            this.shouldRender.put(i.getValue(), true);
        }
    }

    public void setExcludedCategory(AttachmentCategory category) {
        this.exclusionCategory = category;
    }

    public AttachmentCategory getExcludedCategory() {
        return this.exclusionCategory;
    }

    public void setActiveCategory(AttachmentCategory category) {
        this.activeCategory = category;
    }

    public boolean shouldIsolateCategory() {
        return this.activeCategory != null;
    }

    public AttachmentCategory getIsolatedCategory() {
        return this.activeCategory;
    }

    public void flagRender(AttachmentCategory category, boolean status) {
        if (!this.shouldRender.containsKey((Object)category)) {
            return;
        }
        this.shouldRender.put(category, status);
    }

    public boolean queryRender(AttachmentCategory category) {
        if (!this.shouldRender.containsKey((Object)category)) {
            return true;
        }
        return this.shouldRender.get((Object)category);
    }

    public boolean getFPSMode() {
        return this.fpsMode;
    }

    public void setFPSMode(boolean state) {
        this.fpsMode = state;
    }

    public static AnimationModeProcessor getInstance() {
        return instance;
    }

    public boolean isLegacyMode() {
        return this.legacyMode;
    }

    public void captureDeferral() {
        this.deferredMatrix.rewind();
        GL11.glGetFloat((int)2982, (FloatBuffer)this.deferredMatrix);
        this.deferredMatrix.rewind();
    }

    public void onMouseClick() {
        if (AnimationGUI.getInstance().grabStatus) {
            return;
        }
        if (OpenGLSelectionHelper.selectID > 0 && OpenGLSelectionHelper.selectID < 5) {
            ScaledResolution scaledresolution = new ScaledResolution(ClientProxy.MC);
            int scaledWidth = scaledresolution.func_78326_a();
            int scaledHeight = scaledresolution.func_78328_b();
            int mouseX = Mouse.getX() * scaledWidth / ClientProxy.MC.field_71443_c;
            int mouseY = scaledHeight - Mouse.getY() * scaledHeight / ClientProxy.MC.field_71440_d - 1;
            this.atGrab = this.getTransformFromSelected().copy();
            Arcball.grab(mouseX, mouseY);
        }
        if (this.transformMode == -1) {
            this.transformMode = 1;
        }
        if (Mouse.isButtonDown((int)0) && !AnimationModeProcessor.instance.leftLock) {
            instance.tryToUpdateSelectedColor(AnimationModeProcessor.instance.colorHover);
        }
        if ((this.colorHover != -1 || this.colorSelected != -1) && AnimationGUI.getInstance().axisToggle.isState()) {
            this.leftLock = false;
        } else if (OpenGLSelectionHelper.currentlyHovering > 0 && OpenGLSelectionHelper.currentlyHovering < 5 || AnimationGUI.getInstance().grabStatus) {
            OpenGLSelectionHelper.selectID = OpenGLSelectionHelper.currentlyHovering;
            DebugPositioner.setDebugMode(true);
            switch (OpenGLSelectionHelper.selectID) {
                case 1: {
                    DebugPositioner.setDebugPart(Part.LEFT_HAND);
                    break;
                }
                case 2: {
                    DebugPositioner.setDebugPart(Part.RIGHT_HAND);
                    break;
                }
                case 3: {
                    DebugPositioner.setDebugPart(Part.MAIN_ITEM);
                }
            }
        } else {
            this.leftLock = true;
            this.permissionToDrag = true;
        }
    }

    public void tryToUpdateSelectedColor(int i) {
        this.colorSelected = i;
    }

    public WeaponRenderer.Builder getCurrentWeaponRenderBuilder() {
        return ClientModContext.getContext().getMainHeldWeapon().getWeapon().getRenderer().getWeaponRendererBuilder();
    }

    public Transform getTransformFromSelected() {
        int i = OpenGLSelectionHelper.selectID;
        WeaponRenderer.Builder b = this.getCurrentWeaponRenderBuilder();
        switch (i) {
            case 1: {
                return b.firstPersonLeftHandTransform;
            }
            case 2: {
                return b.firstPersonRightHandTransform;
            }
            case 3: {
                return b.firstPersonTransform;
            }
            case 4: {
                return this.slideTransform;
            }
        }
        return null;
    }

    public void onTick() {
        double y;
        double x;
        if (ClientModContext.getContext() != null && ClientModContext.getContext().getMainHeldWeapon() != null && (this.pwi == null || this.pwi != ClientModContext.getContext().getMainHeldWeapon())) {
            WeaponRenderer.Builder builder = this.getCurrentWeaponRenderBuilder();
            this.pwi = ClientModContext.getContext().getMainHeldWeapon();
            this.backupFP = builder.firstPersonTransform.copy();
            this.backupFPL = builder.firstPersonLeftHandTransform.copy();
            this.backupFPR = builder.firstPersonRightHandTransform.copy();
        }
        if (ClientEventHandler.muzzlePositioner) {
            DebugPositioner.setDebugPart(Part.NONE);
            OpenGLSelectionHelper.selectID = 4;
            this.transformMode = 1;
        }
        if (AnimationGUI.getInstance().editRotButton.isState()) {
            this.transformMode = 1;
            this.editRotationPointMode = true;
        } else {
            this.editRotationPointMode = false;
        }
        if (Mouse.isButtonDown((int)0) && !this.mouseStatus) {
            this.mouseStatus = true;
            this.onMouseClick();
            this.leftClickLast = System.currentTimeMillis();
        } else if (this.mouseStatus && !Mouse.isButtonDown((int)0)) {
            this.mouseStatus = false;
            this.permissionToDrag = false;
            this.leftLock = false;
        }
        if (!Mouse.isButtonDown((int)0)) {
            AnimationModeProcessor.getInstance().atGrab = null;
        }
        double dx = Mouse.getDX();
        double dy = Mouse.getDY();
        if (this.permissionToDrag && this.colorSelected == -1 && Mouse.isButtonDown((int)0)) {
            x = dx / 2.0;
            y = dy / 2.0;
            this.rot = this.rot.func_72441_c(-y, x, 0.0);
        }
        if (this.colorSelected != -1 && Mouse.isButtonDown((int)0)) {
            if (this.transformMode == 1) {
                float m = 0.2f;
                if (Keyboard.isKeyDown((int)42)) {
                    m /= 10.0f;
                }
                Vec3d vec = Vec3d.field_186680_a;
                switch (this.colorSelected) {
                    case 1: {
                        vec = new Vec3d(-dx * (double)m, 0.0, 0.0);
                        break;
                    }
                    case 2: {
                        vec = new Vec3d(0.0, -dy * (double)m, 0.0);
                        break;
                    }
                    case 3: {
                        vec = new Vec3d(0.0, 0.0, dx * (double)m);
                    }
                }
                boolean modernMode = true;
                if (ClientEventHandler.muzzlePositioner) {
                    ClientEventHandler.debugmuzzlePosition = ClientEventHandler.debugmuzzlePosition.func_72441_c(-vec.field_72450_a * (double)m * 0.1, vec.field_72448_b * (double)m * 0.1, vec.field_72449_c * (double)m * 0.1);
                } else if (!modernMode) {
                    DebugPositioner.incrementXPosition((float)vec.field_72450_a * m, false);
                    DebugPositioner.incrementYPosition((float)vec.field_72448_b * m, false);
                    DebugPositioner.incrementZPosition((float)vec.field_72449_c * m, false);
                } else if (AnimationGUI.getInstance().magEdit.isState()) {
                    ClientEventHandler.magRotPositioner = ClientEventHandler.magRotPositioner.func_72441_c(vec.field_72450_a * (double)m, vec.field_72448_b * (double)m, vec.field_72449_c * (double)m);
                } else if (!this.editRotationPointMode) {
                    Transform t = this.getTransformFromSelected();
                    t.withPosition(t.getPositionX() + vec.field_72450_a * (double)m, t.getPositionY() + vec.field_72448_b * (double)m, t.getPositionZ() + vec.field_72449_c * (double)m);
                    if (AnimationGUI.getInstance().leftDrag.isState()) {
                        t.withRotation(t.getRotationX(), t.getRotationY() - vec.field_72450_a * 0.4, t.getRotationZ());
                    }
                } else {
                    Transform t = this.getTransformFromSelected();
                    t.withRotationPoint(t.getRotationPointX() + vec.field_72450_a * (double)m, t.getRotationPointY() + vec.field_72448_b * (double)m, t.getRotationPointZ() + vec.field_72449_c * (double)m);
                }
            } else {
                Vec3d vec = Vec3d.field_186680_a;
                switch (this.colorSelected) {
                    case 1: {
                        vec = new Vec3d(0.0, 1.0, 0.0);
                        break;
                    }
                    case 2: {
                        vec = new Vec3d(1.0, 0.0, 0.0);
                        break;
                    }
                    case 3: {
                        vec = new Vec3d(0.0, 0.0, 1.0);
                    }
                }
                float m = (float)(-dy) * 0.35f;
                boolean modernMode = true;
                ScaledResolution scaledresolution = new ScaledResolution(ClientProxy.MC);
                int scaledWidth = scaledresolution.func_78326_a();
                int scaledHeight = scaledresolution.func_78328_b();
                int mouseX = Mouse.getX() * scaledWidth / ClientProxy.MC.field_71443_c;
                int mouseY = scaledHeight - Mouse.getY() * scaledHeight / ClientProxy.MC.field_71440_d - 1;
                Quaternion quat = Arcball.runArcBall(mouseX, mouseY);
                double[] quangles = MatrixHelper.toEulerAngles(quat);
                if (!modernMode) {
                    DebugPositioner.incrementXRotation((float)(vec.field_72450_a * (double)m));
                    DebugPositioner.incrementYRotation((float)(vec.field_72448_b * (double)m));
                    DebugPositioner.incrementZRotation((float)(vec.field_72449_c * (double)m));
                } else {
                    WeaponRenderer.Builder i = ClientModContext.getContext().getMainHeldWeapon().getWeapon().getRenderer().getWeaponRendererBuilder();
                    Transform t = this.getTransformFromSelected();
                    if (this.atGrab != null) {
                        t.withRotation(this.atGrab.getRotationX() + Math.toDegrees(quangles[0]) * vec.field_72450_a, this.atGrab.getRotationY() + Math.toDegrees(quangles[1]) * vec.field_72448_b, this.atGrab.getRotationZ() + -Math.toDegrees(quangles[2]) * vec.field_72449_c);
                    }
                    t.printTransform();
                }
            }
        }
        if (Mouse.isButtonDown((int)1)) {
            x = dx / 10.0;
            y = dy / 10.0;
            this.pan = this.pan.func_72441_c(-x, -y, 0.0);
        }
    }

    public void renderTransformIndicator(float scalar) {
        GlStateManager.func_179097_i();
        if (!AnimationGUI.getInstance().axisToggle.isState()) {
            return;
        }
        GlStateManager.func_179094_E();
        if (AnimationGUI.getInstance().moveForward.isState()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-4.0f);
        }
        if (this.transformMode == 1) {
            if (this.editRotationPointMode) {
                Transform t = this.getTransformFromSelected();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(t.getRotationPointX() + t.getPositionX()), (double)(t.getRotationPointY() + t.getPositionY()), (double)(t.getRotationPointZ() + t.getPositionZ()));
                GlStateManager.func_179152_a((float)3.0f, (float)3.0f, (float)3.0f);
                this.renderAtlas(scalar * 5.0f);
                GlStateManager.func_179097_i();
                this.renderLightAxisRing(new Vec3d(0.0, 1.0, 0.0), Color.red, 0.2f, 0.1f, true, false);
                DebugRenderer.setupBasicRender();
                DebugRenderer.renderPoint(Vec3d.field_186680_a, new Vec3d(1.0, 0.0, 0.0));
                DebugRenderer.destructBasicRender();
                GlStateManager.func_179121_F();
            } else {
                this.renderAtlas(scalar);
            }
        } else if (this.transformMode == 2) {
            this.renderRotAxis(scalar);
        } else {
            this.renderCross();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
    }

    public void renderCross() {
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bb.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        bb.func_181662_b(0.0, -1.0, 0.0).func_181675_d();
        bb.func_181662_b(0.0, 1.0, 0.0).func_181675_d();
        bb.func_181662_b(-1.0, 0.0, 0.0).func_181675_d();
        bb.func_181662_b(1.0, 0.0, 0.0).func_181675_d();
        bb.func_181662_b(0.0, 0.0, -1.0).func_181675_d();
        bb.func_181662_b(0.0, 0.0, 1.0).func_181675_d();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        t.func_78381_a();
    }

    public void renderRotAxis(float scalar) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glLineWidth((float)5.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        float size = (float)((double)0.08f * this.pan.field_72449_c);
        float innerSize = (float)((double)size - AnimationModeProcessor.instance.pan.field_72449_c * 0.01);
        GlStateManager.func_179094_E();
        this.VIEW_BUFFER.rewind();
        GL11.glGetFloat((int)2982, (FloatBuffer)this.VIEW_BUFFER);
        FloatBuffer modifiedView = BufferUtils.createFloatBuffer((int)16);
        Matrix4f mat = new Matrix4f();
        this.VIEW_BUFFER.rewind();
        mat.load(this.VIEW_BUFFER);
        mat.m30 = 0.0f;
        mat.m31 = 0.0f;
        mat.m32 = 0.0f;
        mat.invert();
        mat.store(modifiedView);
        modifiedView.rewind();
        GL11.glLineWidth((float)2.0f);
        GlStateManager.func_179110_a((FloatBuffer)modifiedView);
        GlStateManager.func_179097_i();
        this.renderLightAxisRing(Vec3d.field_186680_a, Color.GRAY.brighter(), 0.0f, size * 5.5f, false, false);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        OpenGLSelectionHelper.ballBuf.func_147614_f();
        OpenGLSelectionHelper.ballBuf.func_147610_a(false);
        this.renderAxisRing(new Vec3d(1.0, 0.0, 0.0), Color.RED, size, innerSize, this.colorSelected == -1 || this.colorSelected == 1, false);
        this.renderAxisRing(Vec3d.field_186680_a, Color.BLUE, size, innerSize, this.colorSelected == -1 || this.colorSelected == 3, false);
        this.renderAxisRing(new Vec3d(0.0, 1.0, 0.0), Color.GREEN, size, innerSize, this.colorSelected == -1 || this.colorSelected == 2, false);
        ClientProxy.MC.func_147110_a().func_147610_a(false);
        GL11.glLineWidth((float)1.5f);
        Shaders.axis.use();
        float panValue = (float)this.pan.func_72433_c() * 1.7f;
        panValue = Math.max(45.0f, panValue);
        Shaders.axis.uniform1f("zoom", panValue);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179126_j();
        GlStateManager.func_179097_i();
        this.renderLightAxisRing(new Vec3d(1.0, 0.0, 0.0), new Color(0xFF3838), size, innerSize, this.colorSelected == -1 || this.colorSelected == 1, this.colorSelected == 1 || this.colorHover == 1);
        this.renderLightAxisRing(Vec3d.field_186680_a, new Color(3342206), size, innerSize, this.colorSelected == -1 || this.colorSelected == 3, this.colorSelected == 3 || this.colorHover == 3);
        this.renderLightAxisRing(new Vec3d(0.0, 1.0, 0.0), new Color(1629439), size, innerSize, this.colorSelected == -1 || this.colorSelected == 2, this.colorSelected == 2 || this.colorHover == 2);
        Shaders.axis.release();
    }

    public void renderLightAxisRing(Vec3d axis, Color c, float outer, float inner, boolean held, boolean hovered) {
        if (hovered) {
            c = new Color(4774907);
        }
        float size = (outer + inner) / 2.0f;
        float r = (float)c.getRed() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float al = 1.0f;
        if (!held) {
            al = 0.5f;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        if (axis.func_189985_c() != 0.0) {
            GlStateManager.func_179114_b((float)90.0f, (float)((float)axis.field_72450_a), (float)((float)axis.field_72448_b), (float)((float)axis.field_72449_c));
        }
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        bb.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (double a = 0.0; a <= Math.PI * 2; a += 0.2243994752564138) {
            bb.func_181662_b(Math.cos(a) * (double)size, Math.sin(a) * (double)size, 0.0).func_181666_a(r, g, b, al).func_181675_d();
        }
        t.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public void renderAxisRing(Vec3d axis, Color c, float outer, float inner, boolean held, boolean hovered) {
        if (hovered) {
            c = new Color(4774907);
        }
        float r = (float)c.getRed() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float al = 1.0f;
        if (!held) {
            al = 0.5f;
        }
        GlStateManager.func_179094_E();
        if (axis.func_189985_c() != 0.0) {
            GlStateManager.func_179114_b((float)90.0f, (float)((float)axis.field_72450_a), (float)((float)axis.field_72448_b), (float)((float)axis.field_72449_c));
        }
        AnimationModeProcessor.renderCircleOutline(c, al, 0.0, 0.0, outer, inner);
        GlStateManager.func_179121_F();
    }

    public void renderHollowCircle() {
    }

    public void renderAtlas(float scalar) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        GL11.glLineWidth((float)((float)Math.abs(1.0 / this.pan.field_72449_c) * 50.0f));
        OpenGLSelectionHelper.ballBuf.func_147614_f();
        OpenGLSelectionHelper.ballBuf.func_147610_a(false);
        this.drawArrow(new Vec3d(1.0, 0.0, 0.0), Color.RED, 1.0f, 1.0f, this.colorSelected == -1 || this.colorSelected == 1, false);
        this.drawArrow(new Vec3d(0.0, 1.0, 0.0), Color.GREEN, -1.0f, 1.0f, this.colorSelected == -1 || this.colorSelected == 2, false);
        this.drawArrow(new Vec3d(0.0, 0.0, 1.0), Color.BLUE, 1.0f, 1.0f, this.colorSelected == -1 || this.colorSelected == 3, false);
        GL11.glLineWidth((float)((float)Math.abs(1.0 / this.pan.field_72449_c) * 15.0f));
        ClientProxy.MC.func_147110_a().func_147610_a(false);
        GlStateManager.func_179097_i();
        this.drawArrow(new Vec3d(1.0, 0.0, 0.0), new Color(0xFF3838), 1.0f, 1.0f, this.colorSelected == -1 || this.colorSelected == 1, this.colorHover == 1 || this.colorSelected == 1);
        this.drawArrow(new Vec3d(0.0, 1.0, 0.0), new Color(3342206), -1.0f, 1.0f, this.colorSelected == -1 || this.colorSelected == 2, this.colorHover == 2 || this.colorSelected == 2);
        this.drawArrow(new Vec3d(0.0, 0.0, 1.0), new Color(1629439), 1.0f, 1.0f, this.colorSelected == -1 || this.colorSelected == 3, this.colorHover == 3 || this.colorSelected == 3);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
    }

    public void drawAlignmentWidget(float size) {
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        bb.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        bb.func_181662_b(0.0, 0.0, 0.0).func_181669_b(1, 0, 0, 1).func_181675_d();
        bb.func_181662_b(1.0, 0.0, 0.0).func_181669_b(1, 0, 0, 1).func_181675_d();
        bb.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 1, 0, 1).func_181675_d();
        bb.func_181662_b(0.0, 1.0, 0.0).func_181669_b(0, 1, 0, 1).func_181675_d();
        bb.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 0, 1, 1).func_181675_d();
        bb.func_181662_b(0.0, 0.0, 1.0).func_181669_b(0, 0, 1, 1).func_181675_d();
        t.func_78381_a();
    }

    public void drawArrow(Vec3d dir, Color c, float size, float ct, boolean held, boolean hovered) {
        if (hovered) {
            c = new Color(4774907);
        }
        float r = (float)c.getRed() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float al = 1.0f;
        if (!held) {
            al = 0.5f;
        }
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        bb.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        bb.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, al).func_181675_d();
        bb.func_181662_b(dir.field_72450_a * (double)size, dir.field_72448_b * (double)size, dir.field_72449_c * (double)size).func_181666_a(r, g, b, al).func_181675_d();
        t.func_78381_a();
        bb.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        double x = dir.field_72450_a * (double)size;
        double y = 0.0;
        for (double a = 0.0; a <= Math.PI * 2; a += 0.4487989505128276) {
            double cos = -Math.cos(a) * (double)size / 10.0;
            double sin = -Math.sin(a) * (double)size / 10.0;
            if (Math.abs(dir.field_72450_a) == 1.0) {
                bb.func_181662_b(dir.field_72450_a * (double)size, cos, y + sin).func_181666_a(r, g, b, al).func_181675_d();
                bb.func_181662_b(dir.field_72450_a * (double)size + (double)(size / 5.0f), 0.0, 0.0).func_181666_a(r, g, b, al).func_181675_d();
                continue;
            }
            if (Math.abs(dir.field_72448_b) == 1.0) {
                bb.func_181662_b(x + cos, dir.field_72448_b * (double)size, y + sin).func_181666_a(r, g, b, al).func_181675_d();
                bb.func_181662_b(x, dir.field_72448_b * (double)size + (double)(size / 5.0f), 0.0).func_181666_a(r, g, b, al).func_181675_d();
                continue;
            }
            bb.func_181662_b(x + cos, y + sin, dir.field_72449_c * (double)size).func_181666_a(r, g, b, al).func_181675_d();
            bb.func_181662_b(x, 0.0, dir.field_72449_c * (double)size + (double)(size / 5.0f)).func_181666_a(r, g, b, al).func_181675_d();
        }
        t.func_78381_a();
    }

    public void applyCameraTransforms() {
        GL11.glTranslated((double)this.pan.field_72450_a, (double)this.pan.field_72448_b, (double)this.pan.field_72449_c);
        GL11.glRotatef((float)((float)this.rot.field_72450_a), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)((float)this.rot.field_72448_b), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)this.rot.field_72449_c), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public static void renderCircleOutline(Color c, double alpha, double x, double y, double outerRadius, double innerRadius) {
        AnimationModeProcessor.renderHalfCircle(c, alpha, x, y, outerRadius, innerRadius, 0.0, 360.0);
    }

    public static void renderHalfCircle(Color c, double alpha, double x, double y, double outerRadius, double innerRadius, double beginAngle, double finishAngle) {
        float red = (float)c.getRed() / 255.0f;
        float blue = (float)c.getBlue() / 255.0f;
        float green = (float)c.getGreen() / 255.0f;
        GL11.glPushMatrix();
        GlStateManager.func_179090_x();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        double endAng = 0.0;
        bb.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (double a = beginAngle; a <= finishAngle; a += 12.0) {
            double cos = -Math.cos(Math.toRadians(a)) * outerRadius;
            double sin = -Math.sin(Math.toRadians(a)) * outerRadius;
            double cosI = -Math.cos(Math.toRadians(a)) * innerRadius;
            double sinI = -Math.sin(Math.toRadians(a)) * innerRadius;
            bb.func_181662_b(x + cos, y + sin, -0.05).func_181666_a(red, green, blue, (float)alpha).func_181675_d();
            bb.func_181662_b(x + cosI, y + sinI, 0.025).func_181666_a(red, green, blue, (float)alpha).func_181675_d();
            endAng = a;
        }
        t.func_78381_a();
        GlStateManager.func_179118_c();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GL11.glPopMatrix();
    }

    static {
        extraIDRegistry.put(4, AttachmentCategory.ACTION);
        instance = new AnimationModeProcessor();
    }
}

