/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.ai;

import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.CustomArmor;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.SecondaryEntityRegistry;
import com.paneedah.weaponlib.WeightedOptions;
import com.paneedah.weaponlib.ai.CustomMobAttack;
import com.paneedah.weaponlib.ai.EntityClassFactory;
import com.paneedah.weaponlib.ai.RenderCustomMob;
import com.paneedah.weaponlib.config.ModernConfigManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class EntityConfiguration {
    private static final int DEFAULT_TRACKING_RANGE = 64;
    private static final int DEFAULT_UPDATE_FREQUENCY = 3;
    private static final int DEFAULT_MAX_HEALTH = 20;
    private static final double DEFAULT_MAX_SPEED = 0.25;
    private static final double DEFAULT_FOLLOW_RANGE = 35.0;
    private static final double DEFAULT_COLLISION_ATTACK_DAMAGE = 3.0;
    private static final float DEFAULT_MAX_TOLERABLE_LIGHT_BRIGHTNESS = 1.0f;
    private static final float DEFAULT_PRIMARY_EQUIPMENT_DROP_CHANCE = 0.5f;
    private static final float DEFAULT_SECONDARY_EQUIPMENT_DROP_CHANCE = 0.25f;
    private static final float DEFAULT_ARMOR_DROP_CHANCE = 0.25f;
    private static final int DEFAULT_MAX_AMMO = 36000;
    private WeightedOptions<EnumDifficulty, Equipment> equipmentOptions;
    private WeightedOptions<EnumDifficulty, Equipment> secondaryEquipmentOptions;
    private List<AiTask> aiTasks;
    private List<AiTask> aiTargetTasks;
    private SoundEvent ambientSound;
    private SoundEvent hurtSound;
    private SoundEvent deathSound;
    private SoundEvent stepSound;
    private ResourceLocation lootTable;
    private double maxHealth;
    private Predicate<Entity> canSpawnHere;
    private Predicate<Entity> isValidLightLevel;
    private EnumCreatureAttribute creatureAttribute;
    private float maxTolerableLightBrightness;
    private double maxSpeed;
    private List<TexturedModel> texturedModelVariants;
    private double followRange;
    private double collisionAttackDamage;
    private boolean isPushable;
    private boolean isInvulnerable;
    private boolean isCollidable;
    private boolean isDespawnable;
    public float lookHeightMultiplier;
    public float sizeWidth;
    public float sizeHeight;
    private Map<EntityEquipmentSlot, CustomArmor> armor;
    private float primaryEquipmentDropChance;
    private float secondaryEquipmentDropChance;
    private float armorDropChance;
    private int maxAmmo;
    private CustomMobAttack collisionAttack;
    private CustomMobAttack delayedAttack;
    private String mobName;
    private int pickupItemID = -1;

    protected EntityConfiguration() {
    }

    public String getMobName() {
        return this.mobName;
    }

    public WeightedOptions<EnumDifficulty, Equipment> getEquipmentOptions() {
        return this.equipmentOptions;
    }

    public WeightedOptions<EnumDifficulty, Equipment> getSecondaryEquipmentOptions() {
        return this.secondaryEquipmentOptions;
    }

    public float getSizeWidth() {
        return this.sizeWidth;
    }

    public float getSizeHeight() {
        return this.sizeHeight;
    }

    public int getPickupItemID() {
        return this.pickupItemID;
    }

    public void addAiTasks(EntityLiving e, EntityAITasks tasks) {
        this.aiTasks.stream().forEach(t -> tasks.func_75776_a(t.priority, t.taskSupplier.apply(e)));
    }

    public void addAiTargetTasks(EntityLiving e, EntityAITasks tasks) {
        this.aiTargetTasks.stream().forEach(t -> tasks.func_75776_a(t.priority, t.taskSupplier.apply(e)));
    }

    public float getLookHeightMultiplier() {
        return this.lookHeightMultiplier;
    }

    public SoundEvent getAmbientSound() {
        return this.ambientSound;
    }

    public SoundEvent getHurtSound() {
        return this.hurtSound;
    }

    public SoundEvent getDeathSound() {
        return this.deathSound;
    }

    public SoundEvent getStepSound() {
        return this.stepSound;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public Predicate<Entity> getCanSpawnHere() {
        return this.canSpawnHere;
    }

    public Predicate<Entity> isValidLightLevel() {
        return this.isValidLightLevel;
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return this.creatureAttribute;
    }

    public float getMaxTolerableLightBrightness() {
        return this.maxTolerableLightBrightness;
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    public double getFollowRange() {
        return this.followRange;
    }

    public List<TexturedModel> getTexturedModelVariants() {
        return this.texturedModelVariants;
    }

    public Collection<CustomArmor> getArmorSet() {
        return this.armor.values();
    }

    public float getPrimaryEquipmentDropChance() {
        return this.primaryEquipmentDropChance;
    }

    public float getSecondaryEquipmentDropChance() {
        return this.secondaryEquipmentDropChance;
    }

    public float getArmorDropChance() {
        return this.armorDropChance;
    }

    public int getMaxAmmo() {
        return this.maxAmmo;
    }

    public CustomMobAttack getCollisionAttack() {
        return this.collisionAttack;
    }

    public CustomMobAttack getDelayedAttack() {
        return this.delayedAttack;
    }

    public double getCollisionAttackDamage() {
        return this.collisionAttackDamage;
    }

    public boolean isPushable() {
        return this.isPushable;
    }

    public boolean isInvulnerable() {
        return this.isInvulnerable;
    }

    public boolean isCollidable() {
        return this.isCollidable;
    }

    public boolean isDespawnable() {
        return this.isDespawnable;
    }

    public static class Builder {
        private int trackingRange = 64;
        private int updateFrequency = 3;
        private boolean sendVelocityUpdates = true;
        private Supplier<Integer> entityIdSupplier;
        private Map<EquipmentKey, EquipmentValue> equipmentOptions = new HashMap<EquipmentKey, EquipmentValue>();
        private Map<EquipmentKey, EquipmentValue> secondaryEquipmentOptions = new HashMap<EquipmentKey, EquipmentValue>();
        private Class<? extends Entity> baseClass;
        private List<Spawn> spawns = new ArrayList<Spawn>();
        private List<AiTask> aiTasks = new ArrayList<AiTask>();
        private List<AiTask> aiTargetTasks = new ArrayList<AiTask>();
        private List<TexturedModel> texturedModelVariants = new ArrayList<TexturedModel>();
        private String name;
        private String ambientSound;
        private String hurtSound;
        private String deathSound;
        private String stepSound;
        private ResourceLocation lootTable;
        private Predicate<Entity> canSpawnHere;
        private Predicate<Entity> isValidLightLevel = e -> e.field_70170_p.field_73012_v.nextFloat() > 0.5f;
        private float maxTolerableLightBrightness = 1.0f;
        private EnumCreatureAttribute creatureAttribute = EnumCreatureAttribute.UNDEFINED;
        private float sizeWidth = 0.6f;
        private float sizeHeight = 1.99f;
        private double maxHealth = 20.0;
        private double maxSpeed = 0.25;
        private double followRange = 35.0;
        private double collisionAttackDamage = 3.0;
        private boolean spawnEgg;
        private int primaryEggColor;
        private int secondaryEggColor;
        private Map<EntityEquipmentSlot, CustomArmor> armor = new HashMap<EntityEquipmentSlot, CustomArmor>();
        private float primaryEquipmentDropChance = 0.5f;
        private float secondaryEquipmentDropChance = 0.25f;
        private float armorDropChance = 0.25f;
        private int maxAmmo = 36000;
        private CustomMobAttack collisionAttack;
        private CustomMobAttack delayedAttack;
        private boolean isPushable = true;
        private boolean isInvulnerable = false;
        private boolean isCollidable = true;
        private boolean isDespawnable = true;
        private float lookHeightMultiplier;
        private int pickupItemID = -1;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withBaseClass(Class<? extends Entity> baseClass) {
            this.baseClass = baseClass;
            return this;
        }

        public Builder withPickupItemID(int item) {
            this.pickupItemID = item;
            return this;
        }

        public Builder withCreatureAttribute(EnumCreatureAttribute creatureAttribute) {
            this.creatureAttribute = creatureAttribute;
            return this;
        }

        public Builder withMaxTolerableLightBrightness(float maxTolerableLightBrightness) {
            this.maxTolerableLightBrightness = maxTolerableLightBrightness;
            return this;
        }

        public Builder withEntityIdSupplier(Supplier<Integer> entityIdSupplier) {
            this.entityIdSupplier = entityIdSupplier;
            return this;
        }

        public Builder withEquipmentOption(Item item, EnumDifficulty difficultyLevel, float weight, ItemAttachment<?> ... attachments) {
            this.withEquipmentOption(this.equipmentOptions, item, difficultyLevel, weight, attachments);
            return this;
        }

        public Builder withSecondaryEquipmentOption(Item item, EnumDifficulty difficultyLevel, float weight, ItemAttachment<?> ... attachments) {
            this.withEquipmentOption(this.secondaryEquipmentOptions, item, difficultyLevel, weight, attachments);
            return this;
        }

        public Builder withSize(float width, float height) {
            this.sizeWidth = width;
            this.sizeHeight = height;
            return this;
        }

        public Builder withLookHeightMulitplier(float multiplier) {
            this.lookHeightMultiplier = multiplier;
            return this;
        }

        private Builder withEquipmentOption(Map<EquipmentKey, EquipmentValue> equipmentOptions, Item item, EnumDifficulty difficultyLevel, float weight, ItemAttachment<?> ... attachments) {
            if (item == null) {
                ModReference.LOG.warn("Attempted to configure entity equipment with null item");
                return this;
            }
            Equipment equipment = new Equipment();
            equipment.item = item;
            equipment.attachments = Arrays.asList(attachments);
            EnumDifficulty[] difficultyValues = EnumDifficulty.values();
            for (int i = difficultyLevel.ordinal(); i < difficultyValues.length; ++i) {
                equipmentOptions.put(new EquipmentKey(difficultyValues[i], equipment.item, attachments), new EquipmentValue(equipment, weight));
            }
            return this;
        }

        public Builder withPrimaryEquipmentDropChance(float chance) {
            this.primaryEquipmentDropChance = chance;
            return this;
        }

        public Builder withSecondaryEquipmentDropChance(float chance) {
            this.secondaryEquipmentDropChance = chance;
            return this;
        }

        public Builder withArmor(CustomArmor armor) {
            this.armor.put(armor.getCompatibleEquipmentSlot(), armor);
            return this;
        }

        public Builder withArmorDropChance(float chance) {
            this.armorDropChance = chance;
            return this;
        }

        public Builder withSpawn(int weightedProb, int min, int max, BiomeDictionary.Type ... biomeTypes) {
            this.spawns.add(new Spawn(weightedProb, min, max, biomeTypes));
            return this;
        }

        public Builder withTexturedModelVariant(String modelClassName, String texture) {
            TexturedModel tm = new TexturedModel();
            tm.modelClassName = modelClassName;
            tm.textureName = texture;
            this.texturedModelVariants.add(tm);
            return this;
        }

        public Builder withAiTask(int priority, Function<EntityLiving, EntityAIBase> taskSupplier) {
            AiTask task = new AiTask();
            task.priority = priority;
            task.taskSupplier = taskSupplier;
            this.aiTasks.add(task);
            return this;
        }

        public Builder withAiTargetTask(int priority, Function<EntityLiving, EntityAIBase> taskSupplier) {
            AiTask task = new AiTask();
            task.priority = priority;
            task.taskSupplier = taskSupplier;
            this.aiTargetTasks.add(task);
            return this;
        }

        public Builder withAmbientSound(String sound) {
            this.ambientSound = sound.toLowerCase();
            return this;
        }

        public Builder withHurtSound(String sound) {
            this.hurtSound = sound.toLowerCase();
            return this;
        }

        public Builder withDeathSound(String sound) {
            this.deathSound = sound.toLowerCase();
            return this;
        }

        public Builder withStepSound(String sound) {
            this.stepSound = sound.toLowerCase();
            return this;
        }

        public Builder withLootTable(ResourceLocation lootTable) {
            this.lootTable = lootTable;
            return this;
        }

        public Builder withMaxHealth(double maxHealth) {
            this.maxHealth = maxHealth;
            return this;
        }

        public Builder withMaxSpeed(double maxSpeed) {
            this.maxSpeed = maxSpeed;
            return this;
        }

        public Builder withFollowRange(double followRange) {
            this.followRange = followRange;
            return this;
        }

        public Builder withCollisionAttackDamage(double collisionAttackDamage) {
            this.collisionAttackDamage = collisionAttackDamage;
            return this;
        }

        public Builder withSpawnLocationPredicate(Predicate<Entity> canSpawnHere) {
            this.canSpawnHere = canSpawnHere;
            return this;
        }

        public Builder withSpawnLightLevelPredicate(Predicate<Entity> isValidLightLevel) {
            this.isValidLightLevel = isValidLightLevel;
            return this;
        }

        public Builder withSpawnEgg(int primaryEggColor, int secondaryEggColor) {
            this.spawnEgg = true;
            this.primaryEggColor = primaryEggColor;
            this.secondaryEggColor = secondaryEggColor;
            return this;
        }

        public Builder withMaxAmmo(int maxAmmo) {
            this.maxAmmo = maxAmmo;
            return this;
        }

        public Builder withCollisionAttack(CustomMobAttack collisionAttack) {
            this.collisionAttack = collisionAttack;
            return this;
        }

        public Builder withDelayedAttack(CustomMobAttack delayedAttack) {
            this.delayedAttack = delayedAttack;
            return this;
        }

        public Builder withPushability(boolean isPushable) {
            this.isPushable = isPushable;
            return this;
        }

        public Builder withCollidability(boolean isCollidable) {
            this.isCollidable = isCollidable;
            return this;
        }

        public Builder withDespawnability(boolean isDespawnable) {
            this.isDespawnable = isDespawnable;
            return this;
        }

        public Builder withInvulnerability() {
            this.isInvulnerable = true;
            return this;
        }

        public void register(ModContext context) {
            EntityConfiguration configuration = new EntityConfiguration();
            configuration.creatureAttribute = this.creatureAttribute;
            configuration.aiTasks = this.aiTasks;
            configuration.aiTargetTasks = this.aiTargetTasks;
            configuration.collisionAttack = this.collisionAttack;
            configuration.delayedAttack = this.delayedAttack;
            configuration.mobName = this.name;
            int modEntityId = this.entityIdSupplier.get();
            String entityName = this.name != null ? this.name : this.baseClass.getSimpleName() + "Ext" + modEntityId;
            WeightedOptions.Builder equipmentOptionsBuilder = new WeightedOptions.Builder();
            if (ModernConfigManager.terroristEquipmentConfiguration == null || ModernConfigManager.terroristEquipmentConfiguration.isEmpty()) {
                this.equipmentOptions.forEach((key, value) -> equipmentOptionsBuilder.withOption(value.equipment, key.difficulty, value.weight));
            } else {
                String[] attachments;
                HashMap<EquipmentKey, EquipmentValue> equipmentOptions = new HashMap<EquipmentKey, EquipmentValue>();
                EnumDifficulty difficultyLevel = EnumDifficulty.EASY;
                EnumDifficulty[] difficultyValues = EnumDifficulty.values();
                for (String attachment : attachments = ModernConfigManager.terroristEquipmentConfiguration.split(", ")) {
                    double weight;
                    String[] parts = attachment.split(":");
                    if (parts.length < 2) {
                        ModReference.LOG.warn("Invalid attachment configuration for entity " + this.name + ": " + attachment + ". Expected format: <gunId>:<weight>[:<attachment>...]");
                        continue;
                    }
                    String gunId = parts[0];
                    try {
                        weight = Double.parseDouble(parts[1]);
                    }
                    catch (NumberFormatException e) {
                        ModReference.LOG.warn("Invalid weight for gun " + this.name + ": " + parts[1] + ". Expected a valid double.");
                        continue;
                    }
                    Item gun = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("mwc", gunId));
                    if (gun == null) {
                        ModReference.LOG.warn("Invalid equipment for entity " + this.name + ": " + gunId + ". Expected a valid item.");
                        continue;
                    }
                    Equipment equipment = new Equipment();
                    switch (this.name) {
                        case "turret": {
                            equipment.item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("mwc", "turretgun"));
                            break;
                        }
                        case "turretupgraded": {
                            equipment.item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("mwc", "turretgunupgraded"));
                            break;
                        }
                        case "turretsilenced": {
                            equipment.item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("mwc", "turretgunsilenced"));
                            break;
                        }
                        default: {
                            equipment.item = gun;
                        }
                    }
                    equipment.attachments = new ArrayList();
                    if (parts.length >= 3) {
                        for (String attachmentId : Arrays.asList(parts).subList(2, parts.length)) {
                            Item att = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("mwc", attachmentId));
                            if (!(att instanceof ItemAttachment)) {
                                ModReference.LOG.warn("Invalid attachment for entity " + this.name + ": " + attachmentId + ". Expected a valid item.");
                                continue;
                            }
                            equipment.attachments.add((ItemAttachment)att);
                        }
                    }
                    for (int i = difficultyLevel.ordinal(); i < difficultyValues.length; ++i) {
                        equipmentOptions.put(new EquipmentKey(difficultyValues[i], equipment.item, equipment.attachments.toArray(new ItemAttachment[0])), new EquipmentValue(equipment, (float)weight));
                    }
                }
                equipmentOptions.forEach((key, value) -> equipmentOptionsBuilder.withOption(value.equipment, key.difficulty, value.weight));
            }
            configuration.equipmentOptions = equipmentOptionsBuilder.build();
            WeightedOptions.Builder secondaryEquipmentOptionsBuilder = new WeightedOptions.Builder();
            this.secondaryEquipmentOptions.forEach((key, value) -> secondaryEquipmentOptionsBuilder.withOption(value.equipment, key.difficulty, value.weight));
            configuration.secondaryEquipmentOptions = secondaryEquipmentOptionsBuilder.build();
            configuration.ambientSound = context.registerSound(this.ambientSound);
            configuration.hurtSound = context.registerSound(this.hurtSound);
            configuration.deathSound = context.registerSound(this.deathSound);
            configuration.stepSound = context.registerSound(this.stepSound);
            configuration.lootTable = this.lootTable;
            configuration.maxHealth = this.maxHealth;
            configuration.maxSpeed = this.maxSpeed;
            configuration.followRange = this.followRange;
            configuration.canSpawnHere = this.canSpawnHere;
            configuration.isValidLightLevel = this.isValidLightLevel;
            configuration.maxTolerableLightBrightness = this.maxTolerableLightBrightness;
            configuration.texturedModelVariants = this.texturedModelVariants;
            configuration.armor = this.armor;
            configuration.primaryEquipmentDropChance = this.primaryEquipmentDropChance;
            configuration.secondaryEquipmentDropChance = this.secondaryEquipmentDropChance;
            configuration.armorDropChance = this.armorDropChance;
            configuration.maxAmmo = this.maxAmmo;
            configuration.collisionAttackDamage = this.collisionAttackDamage;
            configuration.isPushable = this.isPushable;
            configuration.isInvulnerable = this.isInvulnerable;
            configuration.isCollidable = this.isCollidable;
            configuration.isDespawnable = this.isDespawnable;
            configuration.lookHeightMultiplier = this.lookHeightMultiplier;
            configuration.pickupItemID = this.pickupItemID;
            configuration.sizeHeight = this.sizeHeight;
            configuration.sizeWidth = this.sizeWidth;
            Class<? extends Entity> entityClass = EntityClassFactory.getInstance().generateEntitySubclass(this.baseClass, modEntityId, configuration);
            SecondaryEntityRegistry.map.put(this.name, entityClass);
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mwc", entityName), entityClass, (String)("mwc_" + entityName), (int)modEntityId, (Object)context.getMod(), (int)this.trackingRange, (int)this.updateFrequency, (boolean)this.sendVelocityUpdates);
            if (this.spawnEgg) {
                EntityRegistry.registerEgg((ResourceLocation)EntityList.func_191306_a(entityClass), (int)this.primaryEggColor, (int)this.secondaryEggColor);
            }
            for (Spawn spawn : this.spawns) {
                int weightedProb = spawn.weightedProb;
                if (entityName.equals("terrorist")) {
                    weightedProb = (int)((double)spawn.weightedProb * ModernConfigManager.terroristSpawn);
                    configuration.maxHealth = ModernConfigManager.terroristHealth * this.maxHealth;
                } else if (entityName.equals("soldier")) {
                    weightedProb = (int)((double)spawn.weightedProb * ModernConfigManager.soldierSpawn);
                    configuration.maxHealth = ModernConfigManager.soldierHealth * this.maxHealth;
                }
                if (weightedProb <= 0) continue;
                HashSet biomes = new HashSet();
                for (BiomeDictionary.Type biomeType : spawn.biomeTypes) {
                    Set biomesForType = BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeType);
                    biomes.addAll(biomesForType);
                }
                EntityRegistry.addSpawn(this.safeCast(entityClass), (int)weightedProb, (int)spawn.min, (int)spawn.max, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes.toArray(new Biome[0]));
            }
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                for (TexturedModel tmv : this.texturedModelVariants) {
                    tmv.textureResource = new ResourceLocation("mwc", "textures/entity/" + tmv.textureName);
                    try {
                        tmv.model = (ModelBiped)Class.forName(tmv.modelClassName).newInstance();
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                    }
                }
                RendererRegistration.registerRenderableEntity(context, entityClass, this.texturedModelVariants);
            }
        }

        private Class<? extends EntityLiving> safeCast(Class<? extends Entity> entityClass) {
            return entityClass;
        }

        private static class RendererRegistration {
            private RendererRegistration() {
            }

            private static void registerRenderableEntity(ModContext context, Class<? extends Entity> entityClass, List<TexturedModel> texturedModelVariants) {
                try {
                    ModelBiped model = (ModelBiped)Class.forName(texturedModelVariants.get((int)0).modelClassName).newInstance();
                    context.registerRenderableEntity(entityClass, (Object)new RenderCustomMob(model));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }

        private static class EquipmentKey {
            EnumDifficulty difficulty;
            Item item;
            ItemAttachment<?>[] attachments;

            public EquipmentKey(EnumDifficulty difficulty, Item item, ItemAttachment<?>[] attachments) {
                this.difficulty = difficulty;
                this.item = item;
                this.attachments = attachments;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + Arrays.hashCode(this.attachments);
                result = 31 * result + (this.difficulty == null ? 0 : this.difficulty.hashCode());
                result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                EquipmentKey other = (EquipmentKey)obj;
                if (!Arrays.equals(this.attachments, other.attachments)) {
                    return false;
                }
                if (this.difficulty != other.difficulty) {
                    return false;
                }
                return !(this.item == null ? other.item != null : !this.item.equals(other.item));
            }
        }

        private static class EquipmentValue {
            Equipment equipment;
            float weight;

            public EquipmentValue(Equipment equipment, float weight) {
                this.equipment = equipment;
                this.weight = weight;
            }
        }

        private static class Spawn {
            int weightedProb;
            int min;
            int max;
            BiomeDictionary.Type[] biomeTypes;

            public Spawn(int weightedProb, int min, int max, BiomeDictionary.Type[] biomeTypes) {
                this.weightedProb = weightedProb;
                this.min = min;
                this.max = max;
                this.biomeTypes = biomeTypes;
            }
        }
    }

    static class TexturedModel {
        String modelClassName;
        ModelBiped model;
        private String textureName;
        ResourceLocation textureResource;

        TexturedModel() {
        }
    }

    public static class Equipment {
        Item item;
        List<ItemAttachment<?>> attachments;
    }

    private static class AiTask {
        int priority;
        Function<EntityLiving, EntityAIBase> taskSupplier;

        private AiTask() {
        }
    }
}

