/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.messages.BloodClientMessage;
import com.paneedah.mwc.utils.MWCUtil;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.EntityProjectile;
import com.paneedah.weaponlib.Explosion;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.jim.util.HitUtil;
import io.netty.buffer.ByteBuf;
import io.redstudioragnarok.redcore.vectors.Vector3F;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WeaponSpawnEntity
extends EntityProjectile {
    private static final String TAG_ENTITY_ITEM = "entityItem";
    private static final String TAG_DAMAGE = "damage";
    private static final String TAG_EXPLOSION_RADIUS = "explosionRadius";
    private static final String TAG_EXPLOSION_IS_DESTROYING_BLOCKS = "destroyBlocks";
    private static final String TAG_IS_SPAWN_ROCKET_PARTICLES = "rocketParticles";
    private static final String TAG_EXPLOSION_PARTICLE_AGE_COEFFICIENT = "epac";
    private static final String TAG_SMOKE_PARTICLE_AGE_COEFFICIENT = "spac";
    private static final String TAG_EXPLOSION_PARTICLE_SCALE_COEFFICIENT = "epsc";
    private static final String TAG_SMOKE_PARTICLE_SCALE_COEFFICIENT = "spsc";
    private static final String TAG_EXPLOSION_PARTICLE_TEXTURE_ID = "epti";
    private static final String TAG_SMOKE_PARTICLE_TEXTURE_ID = "spti";
    private boolean isDestroyingBlocks;
    public boolean spawnRocketParticles;
    private int explosionParticleTextureId;
    private int smokeParticleTextureId;
    private float explosionRadius;
    private float damage = 6.0f;
    private float explosionParticleAgeCoefficient;
    private float smokeParticleAgeCoefficient;
    private float explosionParticleScaleCoefficient;
    private float smokeParticleScaleCoefficient;
    private Weapon weapon;

    public WeaponSpawnEntity(World world) {
        super(world);
    }

    public WeaponSpawnEntity(Weapon weapon, World world, EntityLivingBase player, float speed, float gravityVelocity, float inaccuracy, float damage, float explosionRadius, boolean isDestroyingBlocks, boolean spawnRocketParticles, float explosionParticleAgeCoefficient, float smokeParticleAgeCoefficient, float explosionParticleScaleCoefficient, float smokeParticleScaleCoefficient, int explosionParticleTextureId, int smokeParticleTextureId) {
        super(world, player, speed, gravityVelocity, inaccuracy);
        this.weapon = weapon;
        this.damage = damage;
        this.explosionRadius = explosionRadius;
        this.isDestroyingBlocks = isDestroyingBlocks;
        this.explosionParticleAgeCoefficient = explosionParticleAgeCoefficient;
        this.smokeParticleAgeCoefficient = smokeParticleAgeCoefficient;
        this.explosionParticleScaleCoefficient = explosionParticleScaleCoefficient;
        this.smokeParticleScaleCoefficient = smokeParticleScaleCoefficient;
        this.explosionParticleTextureId = explosionParticleTextureId;
        this.smokeParticleTextureId = smokeParticleTextureId;
        this.spawnRocketParticles = spawnRocketParticles;
        this.func_70105_a(0.3f, 0.3f);
    }

    @Override
    protected void onImpact(RayTraceResult position) {
        if (position.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.weapon.onSpawnEntityBlockImpact(this.field_70170_p, null, this, position);
        }
        if (this.field_70170_p.field_72995_K || this.weapon == null) {
            return;
        }
        if (this.explosionRadius > 0.0f) {
            Explosion.createServerSideExplosion(this.field_70170_p, this.getThrower(), this, position.field_72307_f.field_72450_a, position.field_72307_f.field_72448_b, position.field_72307_f.field_72449_c, this.explosionRadius, false, true, this.isDestroyingBlocks, this.explosionParticleAgeCoefficient, this.smokeParticleAgeCoefficient, this.explosionParticleScaleCoefficient, this.smokeParticleScaleCoefficient, this.weapon.getModContext().getRegisteredTexture(this.explosionParticleTextureId), this.weapon.getModContext().getRegisteredTexture(this.smokeParticleTextureId), this.weapon.getModContext().getExplosionSound());
        } else if (position.field_72308_g != null) {
            RayTraceResult rayTraceResult;
            position.field_72308_g.func_70097_a((DamageSource)new ProjectileDamageSource("gun", this.weapon.getName(), this, (Entity)this.getThrower()), this.damage);
            position.field_72308_g.field_70172_ad = 0;
            position.field_72308_g.field_70126_B = (float)((double)position.field_72308_g.field_70126_B - 0.3);
            ModReference.LOG.debug("Hit entity {}", (Object)position.field_72308_g);
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(position.field_72308_g.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0);
            double bleedingCoefficient = (double)this.weapon.getBleedingCoefficient() * ModernConfigManager.enableBleedingOnHit;
            if (bleedingCoefficient > 0.0 && (rayTraceResult = HitUtil.traceProjectilehit(this, position.field_72308_g)) != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                MWC.CHANNEL.sendToAllAround((IMessage)new BloodClientMessage(new Vector3F(rayTraceResult.field_72307_f), new Vector3F((float)this.field_70159_w, (float)this.field_70181_x, (float)this.field_70179_y)), point);
            }
        }
        this.func_70106_y();
    }

    @Override
    public void readSpawnData(ByteBuf buffer) {
        super.readSpawnData(buffer);
        this.weapon = (Weapon)Item.func_150899_d((int)buffer.readInt());
        this.damage = buffer.readFloat();
        this.explosionRadius = buffer.readFloat();
        this.isDestroyingBlocks = buffer.readBoolean();
        this.spawnRocketParticles = buffer.readBoolean();
        this.explosionParticleAgeCoefficient = buffer.readFloat();
        this.smokeParticleAgeCoefficient = buffer.readFloat();
        this.explosionParticleScaleCoefficient = buffer.readFloat();
        this.smokeParticleScaleCoefficient = buffer.readFloat();
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.weapon = (Weapon)Item.func_150899_d((int)tagCompound.func_74762_e(TAG_ENTITY_ITEM));
        this.damage = tagCompound.func_74760_g(TAG_DAMAGE);
        this.explosionRadius = tagCompound.func_74760_g(TAG_EXPLOSION_RADIUS);
        this.isDestroyingBlocks = tagCompound.func_74767_n(TAG_EXPLOSION_IS_DESTROYING_BLOCKS);
        this.spawnRocketParticles = tagCompound.func_74767_n(TAG_IS_SPAWN_ROCKET_PARTICLES);
        this.explosionParticleAgeCoefficient = tagCompound.func_74760_g(TAG_EXPLOSION_PARTICLE_AGE_COEFFICIENT);
        this.smokeParticleAgeCoefficient = tagCompound.func_74760_g(TAG_SMOKE_PARTICLE_AGE_COEFFICIENT);
        this.explosionParticleScaleCoefficient = tagCompound.func_74760_g(TAG_EXPLOSION_PARTICLE_SCALE_COEFFICIENT);
        this.smokeParticleScaleCoefficient = tagCompound.func_74760_g(TAG_SMOKE_PARTICLE_SCALE_COEFFICIENT);
        this.explosionParticleTextureId = tagCompound.func_74762_e(TAG_EXPLOSION_PARTICLE_TEXTURE_ID);
        this.smokeParticleTextureId = tagCompound.func_74762_e(TAG_SMOKE_PARTICLE_TEXTURE_ID);
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(Item.func_150891_b((Item)this.weapon));
        buffer.writeFloat(this.damage);
        buffer.writeFloat(this.explosionRadius);
        buffer.writeBoolean(this.isDestroyingBlocks);
        buffer.writeBoolean(this.spawnRocketParticles);
        buffer.writeFloat(this.explosionParticleAgeCoefficient);
        buffer.writeFloat(this.smokeParticleAgeCoefficient);
        buffer.writeFloat(this.explosionParticleScaleCoefficient);
        buffer.writeFloat(this.smokeParticleScaleCoefficient);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a(TAG_ENTITY_ITEM, Item.func_150891_b((Item)this.weapon));
        tagCompound.func_74776_a(TAG_DAMAGE, this.damage);
        tagCompound.func_74776_a(TAG_EXPLOSION_RADIUS, this.explosionRadius);
        tagCompound.func_74757_a(TAG_EXPLOSION_IS_DESTROYING_BLOCKS, this.isDestroyingBlocks);
        tagCompound.func_74757_a(TAG_IS_SPAWN_ROCKET_PARTICLES, this.spawnRocketParticles);
        tagCompound.func_74776_a(TAG_EXPLOSION_PARTICLE_AGE_COEFFICIENT, this.explosionParticleAgeCoefficient);
        tagCompound.func_74776_a(TAG_SMOKE_PARTICLE_AGE_COEFFICIENT, this.smokeParticleAgeCoefficient);
        tagCompound.func_74776_a(TAG_EXPLOSION_PARTICLE_SCALE_COEFFICIENT, this.explosionParticleScaleCoefficient);
        tagCompound.func_74776_a(TAG_SMOKE_PARTICLE_SCALE_COEFFICIENT, this.smokeParticleScaleCoefficient);
        tagCompound.func_74768_a(TAG_EXPLOSION_PARTICLE_TEXTURE_ID, this.explosionParticleTextureId);
        tagCompound.func_74768_a(TAG_SMOKE_PARTICLE_TEXTURE_ID, this.smokeParticleTextureId);
    }

    @Override
    public boolean canCollideWithBlock(List<BlockPos> violators, Block block, BlockPos pos, IBlockState iBlockState) {
        return !MWCUtil.isPenetrableByBullets(iBlockState) && super.canCollideWithBlock(violators, block, pos, iBlockState);
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
    }

    public Weapon getWeapon() {
        return this.weapon;
    }

    public static class ProjectileDamageSource
    extends DamageSource {
        private final String gunName;
        private final Entity projectile;
        private final Entity shooter;

        public ProjectileDamageSource(String damageTypeIn, String gunName, Entity projectile, Entity shooter) {
            super(damageTypeIn);
            this.gunName = gunName;
            this.projectile = projectile;
            this.shooter = shooter;
        }

        public Entity func_76346_g() {
            return this.shooter;
        }

        public Entity func_76364_f() {
            return this.projectile;
        }

        public ITextComponent func_151519_b(EntityLivingBase entityLivingBaseIn) {
            if (this.shooter == null) {
                return new TextComponentTranslation("death.attack.gun.noshooter", new Object[]{entityLivingBaseIn.func_145748_c_(), this.gunName});
            }
            return new TextComponentTranslation("death.attack.gun", new Object[]{entityLivingBaseIn.func_145748_c_(), this.shooter.func_145748_c_(), this.gunName});
        }
    }
}

