/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.google.common.collect.Maps;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.renderer.ModelSource;
import com.paneedah.mwc.skins.CustomSkin;
import com.paneedah.mwc.utils.MWCUtil;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.AsyncWeaponState;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.AttachmentContainer;
import com.paneedah.weaponlib.ClientEventHandler;
import com.paneedah.weaponlib.ClientModContext;
import com.paneedah.weaponlib.CompatibleAttachment;
import com.paneedah.weaponlib.CustomRenderer;
import com.paneedah.weaponlib.DefaultPart;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.ItemMagazine;
import com.paneedah.weaponlib.ItemScope;
import com.paneedah.weaponlib.ItemSkin;
import com.paneedah.weaponlib.ModelWithAttachments;
import com.paneedah.weaponlib.Pair;
import com.paneedah.weaponlib.Part;
import com.paneedah.weaponlib.PlayerItemInstance;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.RenderContext;
import com.paneedah.weaponlib.RenderableState;
import com.paneedah.weaponlib.TransitionContainer;
import com.paneedah.weaponlib.Tuple;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.WeaponState;
import com.paneedah.weaponlib.animation.AnimationModeProcessor;
import com.paneedah.weaponlib.animation.ClientValueRepo;
import com.paneedah.weaponlib.animation.DebugPositioner;
import com.paneedah.weaponlib.animation.Interpolation;
import com.paneedah.weaponlib.animation.MatrixHelper;
import com.paneedah.weaponlib.animation.MultipartPositioning;
import com.paneedah.weaponlib.animation.MultipartRenderStateDescriptor;
import com.paneedah.weaponlib.animation.MultipartRenderStateManager;
import com.paneedah.weaponlib.animation.MultipartTransition;
import com.paneedah.weaponlib.animation.MultipartTransitionProvider;
import com.paneedah.weaponlib.animation.OpenGLSelectionHelper;
import com.paneedah.weaponlib.animation.SpecialAttachments;
import com.paneedah.weaponlib.animation.Transform;
import com.paneedah.weaponlib.animation.Transition;
import com.paneedah.weaponlib.animation.gui.AnimationGUI;
import com.paneedah.weaponlib.animation.jim.AnimationData;
import com.paneedah.weaponlib.animation.jim.AnimationSet;
import com.paneedah.weaponlib.animation.jim.BBLoader;
import com.paneedah.weaponlib.animation.jim.SingleAnimation;
import com.paneedah.weaponlib.animation.movement.WeaponRotationHandler;
import com.paneedah.weaponlib.command.DebugCommand;
import com.paneedah.weaponlib.config.BalancePackManager;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.render.MuzzleFlashRenderer;
import com.paneedah.weaponlib.render.ResourceManager;
import com.paneedah.weaponlib.render.Shaders;
import com.paneedah.weaponlib.render.SpriteSheetTools;
import com.paneedah.weaponlib.render.WavefrontModel;
import com.paneedah.weaponlib.render.WeaponSpritesheetBuilder;
import com.paneedah.weaponlib.shader.jim.Shader;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Matrix4f;

public class WeaponRenderer
extends ModelSource
implements IBakedModel {
    private static final float DEFAULT_RANDOMIZING_RATE = 0.33f;
    private static final float DEFAULT_RANDOMIZING_FIRING_RATE = 20.0f;
    private static final float DEFAULT_RANDOMIZING_ZOOM_RATE = 0.25f;
    private static final float DEFAULT_NORMAL_RANDOMIZING_AMPLITUDE = 0.06f;
    private static final float DEFAULT_ZOOM_RANDOMIZING_AMPLITUDE = 0.005f;
    private static final float DEFAULT_FIRING_RANDOMIZING_AMPLITUDE = 0.03f;
    public static final int DEFAULT_ANIMATION_DURATION = 250;
    private static final int DEFAULT_RECOIL_ANIMATION_DURATION = 100;
    private static final int DEFAULT_SHOOTING_ANIMATION_DURATION = 100;
    private static final int DEFAULT_ITERATION_COMPLETED_ANIMATION_DURATION = 100;
    private static final int DEFAULT_PREPARE_FIRST_LOAD_ITERATION_ANIMATION_DURATION = 100;
    private static final int DEFAULT_ALL_LOAD_ITERATION_ANIMATIONS_COMPLETED_DURATION = 100;
    private static final int INVENTORY_TEXTURE_WIDTH = 128;
    private static final int INVENTORY_TEXTURE_HEIGHT = 128;
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();
    private org.apache.commons.lang3.tuple.Pair<? extends IBakedModel, javax.vecmath.Matrix4f> pair;
    protected EntityLivingBase player;
    protected TextureManager textureManager;
    protected ModelBiped playerBiped = new ModelBiped();
    protected ItemStack itemStack;
    protected ModelResourceLocation resourceLocation;
    public static FloatBuffer atlasMatrix = BufferUtils.createFloatBuffer((int)16);
    private ItemOverrideList itemOverrideList = new WeaponItemOverrideList(Collections.emptyList());
    ItemCameraTransforms.TransformType transformType;
    private Builder builder;
    private Map<EntityLivingBase, MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>>> firstPersonStateManagers;
    private Map<EntityLivingBase, MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>>> thirdPersonStateManagers;
    private MultipartTransitionProvider<RenderableState, Part, RenderContext<RenderableState>> firstPersonTransitionProvider;
    private MultipartTransitionProvider<RenderableState, Part, RenderContext<RenderableState>> thirdPersonTransitionProvider;
    private ArrayList<Pair<FloatBuffer, CustomRenderer<RenderableState>>> deferredPost = new ArrayList();
    private long magicAnimationTimer;
    private WeaponState magicState = WeaponState.READY;
    protected ClientModContext clientModContext;
    public boolean compoundReload = false;
    public boolean compoundReloadEmpty = false;
    private boolean shouldDoEmptyVariant = false;
    public static ResourceLocation SPARKS_ONE = new ResourceLocation("mwc:textures/flashes/sparks1.png");
    public static ResourceLocation FLASHF = new ResourceLocation("mwc:textures/flashes/flashfront2.png");
    public static ItemAttachment<Weapon> magicMagReplacement;
    public static boolean updateMagicMagazine;
    private CompatibleAttachment<?> currentMagazine;
    public String name;
    public static WeaponRotationHandler wrh;
    public static final ModelRenderer bipedLeftArm;
    private static int gunIconSheetHeight;
    private static int gunIconSheetWidth;
    private static boolean hasCalculatedSheetDimensions;
    public static ModelRenderer bipedRightArm;
    public static ModelBiped backupModel;
    public static AbstractClientPlayer acp;

    private WeaponRenderer(Builder builder) {
        this.setBuilder(builder);
        this.firstPersonStateManagers = new HashMap<EntityLivingBase, MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>>>();
        this.thirdPersonStateManagers = new HashMap<EntityLivingBase, MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>>>();
        this.firstPersonTransitionProvider = new FirstPersonWeaponTransitionProvider();
        this.thirdPersonTransitionProvider = new ThirdPersonWeaponTransitionProvider();
        this.textureManager = ClientProxy.MC.func_110434_K();
        this.pair = org.apache.commons.lang3.tuple.Pair.of((Object)this, null);
        this.playerBiped = new ModelBiped();
        this.playerBiped.field_78090_t = 64;
        this.playerBiped.field_78089_u = 64;
    }

    public Builder getWeaponRendererBuilder() {
        return this.getBuilder();
    }

    protected long getTotalReloadingDuration() {
        return this.getBuilder().totalReloadingDuration;
    }

    protected long getTotalUnloadingDuration() {
        return this.getBuilder().totalUnloadingDuration;
    }

    protected long getTotalDrawingDuration() {
        return this.getBuilder().totalDrawingDuration;
    }

    protected ClientModContext getClientModContext() {
        return this.clientModContext;
    }

    protected void setClientModContext(ClientModContext clientModContext) {
        this.clientModContext = clientModContext;
    }

    public boolean isCompoundReloadTactical() {
        return this.getBuilder().compoundReloadUsesTactical;
    }

    public boolean isCompoundReloadEmptyTactical() {
        return this.getBuilder().compoundReloadEmptyUsesTactical;
    }

    public boolean shouldDoEmptyVariant() {
        return this.shouldDoEmptyVariant;
    }

    public void setShouldDoEmptyVariant(boolean state) {
        this.shouldDoEmptyVariant = state;
    }

    protected StateDescriptor getFirstPersonStateDescriptor(EntityLivingBase player, ItemStack itemStack) {
        MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> stateManager;
        float amplitude = this.getBuilder().normalRandomizingAmplitude;
        float rate = this.getBuilder().normalRandomizingRate;
        RenderableState currentState = null;
        PlayerItemInstance<?> playerItemInstance = this.clientModContext.getPlayerItemInstanceRegistry().getItemInstance(player, itemStack);
        PlayerWeaponInstance playerWeaponInstance = null;
        if (playerItemInstance == null || !(playerItemInstance instanceof PlayerWeaponInstance) || playerItemInstance.getItem() != itemStack.func_77973_b()) {
            ModReference.LOG.error("Invalid or mismatching item. Player item instance: {}. Item stack: {}", playerItemInstance, (Object)itemStack);
        } else {
            playerWeaponInstance = (PlayerWeaponInstance)playerItemInstance;
        }
        if (playerWeaponInstance != null) {
            AsyncWeaponState asyncWeaponState = this.getNextNonExpiredState(playerWeaponInstance);
            WeaponState renderableState = asyncWeaponState.getState();
            switch (renderableState) {
                case RECOILED: {
                    if (playerWeaponInstance.isAutomaticModeEnabled() && !this.hasRecoilPositioning()) {
                        if (playerWeaponInstance.isAimed()) {
                            currentState = RenderableState.ZOOMING;
                            rate = this.getBuilder().firingRandomizingRate;
                            amplitude = this.getBuilder().zoomRandomizingAmplitude;
                            break;
                        }
                        currentState = RenderableState.NORMAL;
                        rate = this.getBuilder().firingRandomizingRate;
                        amplitude = this.getBuilder().firingRandomizingAmplitude;
                        break;
                    }
                    if (playerWeaponInstance.isAimed()) {
                        currentState = RenderableState.ZOOMING_RECOILED;
                        amplitude = this.getBuilder().zoomRandomizingAmplitude;
                        break;
                    }
                    currentState = RenderableState.RECOILED;
                    break;
                }
                case PAUSED: {
                    if (playerWeaponInstance.isAutomaticModeEnabled() && !this.hasRecoilPositioning()) {
                        boolean isLongPaused;
                        boolean bl = isLongPaused = (float)(System.currentTimeMillis() - asyncWeaponState.getTimestamp()) > 50.0f / playerWeaponInstance.getFireRate() && asyncWeaponState.isInfinite();
                        if (playerWeaponInstance.isAimed()) {
                            currentState = RenderableState.ZOOMING;
                            if (!isLongPaused) {
                                rate = this.getBuilder().firingRandomizingRate;
                            }
                            amplitude = this.getBuilder().zoomRandomizingAmplitude;
                            break;
                        }
                        currentState = RenderableState.NORMAL;
                        if (isLongPaused) break;
                        rate = this.getBuilder().firingRandomizingRate;
                        amplitude = this.getBuilder().firingRandomizingAmplitude;
                        break;
                    }
                    if (playerWeaponInstance.isAimed()) {
                        currentState = RenderableState.ZOOMING_SHOOTING;
                        amplitude = this.getBuilder().zoomRandomizingAmplitude;
                        break;
                    }
                    currentState = RenderableState.SHOOTING;
                    break;
                }
                case COMPOUND_RELOAD_EMPTY: {
                    currentState = RenderableState.COMPOUND_RELOAD_EMPTY;
                    break;
                }
                case TACTICAL_RELOAD: {
                    currentState = RenderableState.TACTICAL_RELOAD;
                    break;
                }
                case COMPOUND_RELOAD: {
                    currentState = RenderableState.COMPOUND_RELOAD;
                    break;
                }
                case UNLOAD_PREPARING: 
                case UNLOAD_REQUESTED: 
                case UNLOAD: {
                    if (this.shouldDoEmptyVariant()) {
                        currentState = RenderableState.UNLOAD_EMPTY;
                        break;
                    }
                    currentState = RenderableState.UNLOADING;
                    break;
                }
                case LOAD: {
                    if (this.shouldDoEmptyVariant()) {
                        currentState = RenderableState.LOAD_EMPTY;
                        break;
                    }
                    currentState = RenderableState.RELOADING;
                    break;
                }
                case LOAD_ITERATION: {
                    currentState = RenderableState.LOAD_ITERATION;
                    break;
                }
                case LOAD_ITERATION_COMPLETED: {
                    currentState = RenderableState.LOAD_ITERATION_COMPLETED;
                    break;
                }
                case ALL_LOAD_ITERATIONS_COMPLETED: {
                    currentState = RenderableState.ALL_LOAD_ITERATIONS_COMPLETED;
                    break;
                }
                case EJECTING: {
                    if (playerWeaponInstance.isAimed()) {
                        currentState = RenderableState.EJECT_SPENT_ROUND_AIMED;
                        break;
                    }
                    currentState = RenderableState.EJECT_SPENT_ROUND;
                    break;
                }
                case MODIFYING: 
                case MODIFYING_REQUESTED: 
                case NEXT_ATTACHMENT: 
                case NEXT_ATTACHMENT_REQUESTED: {
                    if (playerWeaponInstance.isAltMofificationModeEnabled()) {
                        currentState = RenderableState.MODIFYING_ALT;
                        break;
                    }
                    currentState = RenderableState.MODIFYING;
                    break;
                }
                case INSPECTING: {
                    currentState = RenderableState.INSPECTING;
                    break;
                }
                case DRAWING: {
                    currentState = RenderableState.DRAWING;
                    break;
                }
                default: {
                    if (player.func_70051_ag() && this.getBuilder().firstPersonPositioningRunning != null && asyncWeaponState.getState() == WeaponState.READY && !playerWeaponInstance.isAwaitingCompoundInstructions() && System.currentTimeMillis() - playerWeaponInstance.getStateUpdateTimestamp() > 50L) {
                        currentState = RenderableState.NORMAL;
                        break;
                    }
                    if (!playerWeaponInstance.isAimed()) break;
                    currentState = RenderableState.ZOOMING;
                    rate = this.getBuilder().zoomRandomizingRate;
                    amplitude = this.getBuilder().zoomRandomizingAmplitude;
                }
            }
        }
        if (currentState == null) {
            currentState = RenderableState.NORMAL;
        }
        if (player instanceof EntityPlayer && MWCUtil.isProning((EntityPlayer)player)) {
            switch (currentState) {
                case NORMAL: {
                    currentState = RenderableState.PRONING;
                    break;
                }
                case RECOILED: {
                    currentState = RenderableState.PRONING_RECOILED;
                    break;
                }
                case SHOOTING: {
                    currentState = RenderableState.PRONING_SHOOTING;
                    break;
                }
            }
        }
        if ((stateManager = this.firstPersonStateManagers.get(player)) == null) {
            stateManager = new MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>>(currentState, this.firstPersonTransitionProvider);
            this.firstPersonStateManagers.put(player, stateManager);
        } else {
            stateManager.setState(currentState, true, currentState == RenderableState.SHOOTING || currentState == RenderableState.PRONING_SHOOTING || currentState == RenderableState.ZOOMING_SHOOTING || currentState == RenderableState.RUNNING || currentState == RenderableState.ZOOMING || currentState == RenderableState.DRAWING);
        }
        return new StateDescriptor(playerWeaponInstance, stateManager, rate, amplitude);
    }

    protected StateDescriptor getThirdPersonStateDescriptor(EntityLivingBase player, ItemStack itemStack) {
        MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> stateManager;
        float amplitude = this.getBuilder().normalRandomizingAmplitude;
        float rate = this.getBuilder().normalRandomizingRate;
        RenderableState currentState = null;
        PlayerItemInstance<?> playerItemInstance = this.clientModContext.getPlayerItemInstanceRegistry().getItemInstance(player, itemStack);
        PlayerWeaponInstance playerWeaponInstance = null;
        if (playerItemInstance == null || !(playerItemInstance instanceof PlayerWeaponInstance) || playerItemInstance.getItem() != itemStack.func_77973_b()) {
            ModReference.LOG.error("Invalid or mismatching item. Player item instance: {}. Item stack: {}", playerItemInstance, (Object)itemStack);
        } else {
            playerWeaponInstance = (PlayerWeaponInstance)playerItemInstance;
        }
        if (playerWeaponInstance != null) {
            AsyncWeaponState asyncWeaponState = this.getNextNonExpiredState(playerWeaponInstance);
            switch (asyncWeaponState.getState()) {
                case RECOILED: {
                    if (playerWeaponInstance.isAutomaticModeEnabled() && !this.hasRecoilPositioning()) {
                        if (playerWeaponInstance.isAimed()) {
                            currentState = RenderableState.ZOOMING;
                            rate = this.getBuilder().firingRandomizingRate;
                            amplitude = this.getBuilder().zoomRandomizingAmplitude;
                            break;
                        }
                        currentState = RenderableState.NORMAL;
                        rate = this.getBuilder().firingRandomizingRate;
                        amplitude = this.getBuilder().firingRandomizingAmplitude;
                        break;
                    }
                    if (playerWeaponInstance.isAimed()) {
                        currentState = RenderableState.ZOOMING_RECOILED;
                        amplitude = this.getBuilder().zoomRandomizingAmplitude;
                        break;
                    }
                    currentState = RenderableState.RECOILED;
                    break;
                }
                case PAUSED: {
                    if (playerWeaponInstance.isAutomaticModeEnabled() && !this.hasRecoilPositioning()) {
                        boolean isLongPaused;
                        boolean bl = isLongPaused = (float)(System.currentTimeMillis() - asyncWeaponState.getTimestamp()) > 50.0f / playerWeaponInstance.getFireRate() && asyncWeaponState.isInfinite();
                        if (playerWeaponInstance.isAimed()) {
                            currentState = RenderableState.ZOOMING;
                            if (!isLongPaused) {
                                rate = this.getBuilder().firingRandomizingRate;
                            }
                            amplitude = this.getBuilder().zoomRandomizingAmplitude;
                            break;
                        }
                        currentState = RenderableState.NORMAL;
                        if (isLongPaused) break;
                        rate = this.getBuilder().firingRandomizingRate;
                        amplitude = this.getBuilder().firingRandomizingAmplitude;
                        break;
                    }
                    if (playerWeaponInstance.isAimed()) {
                        currentState = RenderableState.ZOOMING_SHOOTING;
                        amplitude = this.getBuilder().zoomRandomizingAmplitude;
                        break;
                    }
                    currentState = RenderableState.SHOOTING;
                    break;
                }
                case UNLOAD_PREPARING: 
                case UNLOAD_REQUESTED: 
                case UNLOAD: {
                    currentState = RenderableState.UNLOADING;
                    break;
                }
                case LOAD: {
                    break;
                }
                case LOAD_ITERATION: {
                    currentState = RenderableState.LOAD_ITERATION;
                    break;
                }
                case LOAD_ITERATION_COMPLETED: {
                    currentState = RenderableState.LOAD_ITERATION_COMPLETED;
                    break;
                }
                case ALL_LOAD_ITERATIONS_COMPLETED: {
                    currentState = RenderableState.ALL_LOAD_ITERATIONS_COMPLETED;
                    break;
                }
                case EJECTING: {
                    if (playerWeaponInstance.isAimed()) {
                        currentState = RenderableState.EJECT_SPENT_ROUND_AIMED;
                        break;
                    }
                    currentState = RenderableState.EJECT_SPENT_ROUND;
                    break;
                }
                case MODIFYING: 
                case MODIFYING_REQUESTED: 
                case NEXT_ATTACHMENT: 
                case NEXT_ATTACHMENT_REQUESTED: {
                    currentState = RenderableState.MODIFYING;
                    break;
                }
                case INSPECTING: {
                    currentState = RenderableState.INSPECTING;
                    break;
                }
                default: {
                    if (player != null && player.func_70051_ag() && this.getBuilder().firstPersonPositioningRunning != null) {
                        currentState = RenderableState.RUNNING;
                        break;
                    }
                    if (!playerWeaponInstance.isAimed()) break;
                    currentState = RenderableState.ZOOMING;
                    rate = this.getBuilder().zoomRandomizingRate;
                    amplitude = this.getBuilder().zoomRandomizingAmplitude;
                }
            }
        }
        if (currentState == null) {
            currentState = RenderableState.NORMAL;
        }
        if ((stateManager = this.thirdPersonStateManagers.get(player)) == null) {
            stateManager = new MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>>(currentState, this.thirdPersonTransitionProvider);
            this.thirdPersonStateManagers.put(player, stateManager);
        } else {
            stateManager.setState(currentState, true, currentState == RenderableState.SHOOTING || currentState == RenderableState.ZOOMING_SHOOTING || currentState == RenderableState.RUNNING || currentState == RenderableState.ZOOMING);
        }
        return new StateDescriptor(playerWeaponInstance, stateManager, rate, amplitude);
    }

    private AsyncWeaponState getNextNonExpiredState(PlayerWeaponInstance playerWeaponState) {
        AsyncWeaponState asyncWeaponState = null;
        while ((asyncWeaponState = playerWeaponState.nextHistoryState()) != null && (System.currentTimeMillis() >= asyncWeaponState.getTimestamp() + asyncWeaponState.getDuration() || asyncWeaponState.getState() == WeaponState.FIRING && (this.hasRecoilPositioning() || !playerWeaponState.isAutomaticModeEnabled()))) {
        }
        return asyncWeaponState;
    }

    private Consumer<RenderContext<RenderableState>> createWeaponPartPositionFunction(Transition<RenderContext<RenderableState>> t) {
        if (t == null) {
            return context -> {};
        }
        Consumer<RenderContext<RenderableState>> weaponPositionFunction = t.getItemPositioning();
        if (weaponPositionFunction != null) {
            return context -> weaponPositionFunction.accept((RenderContext<RenderableState>)context);
        }
        return context -> {};
    }

    private Consumer<RenderContext<RenderableState>> createWeaponPartPositionFunction(Consumer<RenderContext<RenderableState>> weaponPositionFunction) {
        if (weaponPositionFunction != null) {
            return context -> weaponPositionFunction.accept((RenderContext<RenderableState>)context);
        }
        return context -> {};
    }

    private List<MultipartTransition<Part, RenderContext<RenderableState>>> getComplexTransition(TransitionContainer tc) {
        return this.getComplexTransition(tc.getFirstPerson(), tc.getLeftHand(), tc.getRightHand(), tc.getCustom());
    }

    private List<MultipartTransition<Part, RenderContext<RenderableState>>> getComplexTransition(List<Transition<RenderContext<RenderableState>>> wt, List<Transition<RenderContext<RenderableState>>> lht, List<Transition<RenderContext<RenderableState>>> rht, LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> custom) {
        ArrayList<MultipartTransition<Part, RenderContext<RenderableState>>> result = new ArrayList<MultipartTransition<Part, RenderContext<RenderableState>>>();
        for (int i = 0; i < wt.size(); ++i) {
            DebugPositioner.TransitionConfiguration transitionConfiguration;
            Transition<RenderContext<RenderableState>> p = wt.get(i);
            Transition<RenderContext<RenderableState>> l = lht.get(i);
            Transition<RenderContext<RenderableState>> r = rht.get(i);
            long pause = p.getPause();
            if (DebugPositioner.isDebugModeEnabled() && (transitionConfiguration = DebugPositioner.getTransitionConfiguration(i, false)) != null) {
                pause = transitionConfiguration.getPause();
            }
            MultipartTransition<Part, RenderContext<RenderableState>> t = new MultipartTransition<Part, RenderContext<RenderableState>>(p.getDuration(), pause).withPartPositionFunction(Part.MAIN_ITEM, this.createWeaponPartPositionFunction(p)).withPartPositionFunction(Part.LEFT_HAND, this.createWeaponPartPositionFunction(l)).withPartPositionFunction(Part.RIGHT_HAND, this.createWeaponPartPositionFunction(r));
            t.sound = p.getSound();
            for (Map.Entry<Part, List<Transition<RenderContext<RenderableState>>>> e : custom.entrySet()) {
                List<Transition<RenderContext<RenderableState>>> partTransitions = e.getValue();
                Transition<RenderContext<RenderableState>> partTransition = null;
                if (partTransitions != null && partTransitions.size() > i) {
                    partTransition = partTransitions.get(i);
                } else {
                    ModReference.LOG.warn("Transition not defined for part {}", custom);
                }
                t.withPartPositionFunction(e.getKey(), this.createWeaponPartPositionFunction(partTransition));
            }
            result.add(t);
        }
        return result;
    }

    private List<MultipartTransition<Part, RenderContext<RenderableState>>> getSimpleTransition(Consumer<RenderContext<RenderableState>> w, Consumer<RenderContext<RenderableState>> lh, Consumer<RenderContext<RenderableState>> rh, LinkedHashMap<Part, Consumer<RenderContext<RenderableState>>> custom, int duration) {
        MultipartTransition<Part, RenderContext<RenderableState>> mt = new MultipartTransition<Part, RenderContext<RenderableState>>(duration, 0L).withPartPositionFunction(Part.MAIN_ITEM, this.createWeaponPartPositionFunction(w)).withPartPositionFunction(Part.LEFT_HAND, this.createWeaponPartPositionFunction(lh)).withPartPositionFunction(Part.RIGHT_HAND, this.createWeaponPartPositionFunction(rh));
        custom.forEach((part, position) -> mt.withPartPositionFunction((Part)part, this.createWeaponPartPositionFunction((Consumer<RenderContext<RenderableState>>)position)));
        return Collections.singletonList(mt);
    }

    private List<MultipartTransition<Part, RenderContext<RenderableState>>> getSimpleTransition(Consumer<RenderContext<RenderableState>> w, Consumer<RenderContext<RenderableState>> lh, Consumer<RenderContext<RenderableState>> rh, LinkedHashMap<Part, Consumer<RenderContext<RenderableState>>> custom, int duration, Interpolation interpType) {
        MultipartTransition<Part, RenderContext<RenderableState>> mt = new MultipartTransition<Part, RenderContext<RenderableState>>((long)duration, 0L, interpType).withPartPositionFunction(Part.MAIN_ITEM, this.createWeaponPartPositionFunction(w)).withPartPositionFunction(Part.LEFT_HAND, this.createWeaponPartPositionFunction(lh)).withPartPositionFunction(Part.RIGHT_HAND, this.createWeaponPartPositionFunction(rh));
        custom.forEach((part, position) -> mt.withPartPositionFunction((Part)part, this.createWeaponPartPositionFunction((Consumer<RenderContext<RenderableState>>)position)));
        return Collections.singletonList(mt);
    }

    private List<MultipartTransition<Part, RenderContext<RenderableState>>> getSimpleTransitionBeizer(Consumer<RenderContext<RenderableState>> w, Consumer<RenderContext<RenderableState>> lh, Consumer<RenderContext<RenderableState>> rh, LinkedHashMap<Part, Consumer<RenderContext<RenderableState>>> custom, int duration, Vec3d beizer) {
        MultipartTransition<Part, RenderContext<RenderableState>> mt = new MultipartTransition<Part, RenderContext<RenderableState>>((long)duration, 0L, beizer).withPartPositionFunction(Part.MAIN_ITEM, this.createWeaponPartPositionFunction(w)).withPartPositionFunction(Part.LEFT_HAND, this.createWeaponPartPositionFunction(lh)).withPartPositionFunction(Part.RIGHT_HAND, this.createWeaponPartPositionFunction(rh));
        custom.forEach((part, position) -> mt.withPartPositionFunction((Part)part, this.createWeaponPartPositionFunction((Consumer<RenderContext<RenderableState>>)position)));
        return Collections.singletonList(mt);
    }

    public void renderItem(ItemStack weaponItemStack, RenderContext<RenderableState> renderContext, MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner) {
        if (DebugCommand.debugFlag == 1) {
            return;
        }
        weaponItemStack.func_77973_b();
        if (ClientEventHandler.muzzlePositioner && !OpenGLSelectionHelper.isInSelectionPass) {
            GlStateManager.func_179094_E();
            Vec3d deb = ClientEventHandler.debugmuzzlePosition;
            GlStateManager.func_179137_b((double)deb.field_72450_a, (double)deb.field_72448_b, (double)deb.field_72449_c);
            WeaponRenderer.captureAtlasPosition();
            GlStateManager.func_179121_F();
        }
        boolean shot = false;
        if (renderContext.getPlayer() != null && (ClientEventHandler.checkShot(renderContext.getPlayer().func_145782_y()) || AnimationGUI.getInstance().forceFlash.isState())) {
            shot = true;
            MuzzleFlashRenderer.renderFlash(renderContext.getPlayer().func_145782_y(), weaponItemStack, false);
        }
        if (DebugCommand.debugFlag == 2) {
            return;
        }
        List<CompatibleAttachment<? extends AttachmentContainer>> attachments = null;
        if (this.getBuilder().getModel() instanceof ModelWithAttachments) {
            attachments = ((Weapon)weaponItemStack.func_77973_b()).getActiveAttachments(renderContext.getPlayer(), weaponItemStack);
        }
        if (this.getBuilder().getTextureName() != null) {
            ClientProxy.MC.field_71446_o.func_110577_a(new ResourceLocation("mwc:textures/models/" + this.getBuilder().getTextureName()));
        } else {
            String textureName = null;
            if (textureName == null) {
                Weapon weapon = (Weapon)weaponItemStack.func_77973_b();
                textureName = weapon.getTextureName();
            }
            ClientProxy.MC.field_71446_o.func_110577_a(new ResourceLocation("mwc:textures/models/" + textureName));
        }
        if (DebugCommand.debugFlag == 3) {
            return;
        }
        if (!OpenGLSelectionHelper.isInSelectionPass && !AnimationGUI.getInstance().magEdit.isState()) {
            boolean useSkin;
            GlStateManager.func_179147_l();
            ItemAttachment<Weapon> skin = renderContext.getWeaponInstance().getAttachmentItemWithCategory(AttachmentCategory.SKIN);
            boolean bl = useSkin = skin != null;
            if (useSkin) {
                ItemSkin itemSkin = (ItemSkin)skin;
                GlStateManager.func_179138_g((int)33987);
                if (itemSkin.getTextureName().startsWith("customskin_")) {
                    ClientProxy.MC.func_110434_K().func_110577_a(CustomSkin.getCustomSkinResource(itemSkin.getTextureName().replace("customskin_", "") + ".png"));
                } else {
                    ClientProxy.MC.func_110434_K().func_110577_a(new ResourceLocation("mwc:textures/models/" + itemSkin.getTextureName() + ".png"));
                }
                GlStateManager.func_179138_g((int)33984);
            }
            if (DebugCommand.debugFlag == 4) {
                return;
            }
            if (ModernConfigManager.enableAllShaders && ModernConfigManager.enableGunShaders) {
                Shaders.gunLightingShader.use();
                Shaders.gunLightingShader.uniform1f("time", ClientValueRepo.TICKER.getLerpedFloat());
                Shaders.gunLightingShader.uniform1i("disabled", BalancePackManager.isWeaponDisabled(renderContext.getWeaponInstance().getWeapon()) ? 1 : 0);
                if (useSkin) {
                    Shaders.gunLightingShader.uniform1i("skin", 3);
                }
                Shaders.gunLightingShader.uniform1i("useSkin", useSkin ? 1 : 0);
                GL20.glUniform1i((int)GL20.glGetUniformLocation((int)Shaders.gunLightingShader.getShaderId(), (CharSequence)"lightmap"), (int)1);
                GL20.glUniform1f((int)GL20.glGetUniformLocation((int)Shaders.gunLightingShader.getShaderId(), (CharSequence)"lightIntensity"), (float)(shot ? 1.5f + (float)Math.random() : 0.0f));
            }
            if (DebugCommand.debugFlag == 5) {
                return;
            }
        }
        this.deferredPost.clear();
        double sqDistance = 0.0;
        if (this.player != null && this.player != ClientProxy.MC.field_71439_g) {
            Vec3d projectView = ActiveRenderInfo.func_178806_a((Entity)ClientProxy.MC.field_71439_g, (double)renderContext.getAgeInTicks());
            sqDistance = projectView.func_186679_c(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v);
        }
        if (!AnimationModeProcessor.getInstance().shouldIsolateCategory()) {
            if (this.getBuilder().getModel() != null) {
                this.getBuilder().getModel().func_78088_a((Entity)this.player, renderContext.getLimbSwing(), renderContext.getFlimbSwingAmount(), renderContext.getAgeInTicks(), renderContext.getNetHeadYaw(), renderContext.getHeadPitch(), renderContext.getScale());
            } else {
                this.getBuilder().getBakedModel();
            }
        }
        if (DebugCommand.debugFlag == 6) {
            return;
        }
        if (attachments != null) {
            this.renderAttachments(positioner, renderContext, attachments);
        }
        if (DebugCommand.debugFlag == 7) {
            return;
        }
        if (DebugCommand.debugFlag == 8) {
            return;
        }
        if (!OpenGLSelectionHelper.isInSelectionPass && ModernConfigManager.enableAllShaders && ModernConfigManager.enableGunShaders) {
            Shaders.gunLightingShader.release();
        }
        if (DebugCommand.debugFlag == 9) {
            return;
        }
        if (!AnimationModeProcessor.getInstance().getFPSMode()) {
            this.renderPostRenderers(renderContext);
        }
    }

    public void renderAttachments(MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner, RenderContext<RenderableState> renderContext, List<CompatibleAttachment<? extends AttachmentContainer>> attachments) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        for (CompatibleAttachment<? extends AttachmentContainer> compatibleAttachment : attachments) {
            if (compatibleAttachment == null || compatibleAttachment.getAttachment() instanceof ItemSkin || compatibleAttachment.getAttachment() instanceof ItemScope || AnimationModeProcessor.getInstance().shouldIsolateCategory() && compatibleAttachment.getAttachment().getCategory() != AnimationModeProcessor.getInstance().getIsolatedCategory()) continue;
            this.renderCompatibleAttachment(compatibleAttachment, positioner, renderContext);
        }
        for (CompatibleAttachment<? extends AttachmentContainer> compatibleAttachment : attachments) {
            if (compatibleAttachment == null || compatibleAttachment.getAttachment() instanceof ItemSkin || !(compatibleAttachment.getAttachment() instanceof ItemScope) || AnimationModeProcessor.getInstance().shouldIsolateCategory() && compatibleAttachment.getAttachment().getCategory() != AnimationModeProcessor.getInstance().getIsolatedCategory()) continue;
            this.renderCompatibleAttachment(compatibleAttachment, positioner, renderContext);
        }
    }

    public void setMagicMagPermit(boolean state) {
    }

    public void setMagicMag(PlayerWeaponInstance instance, ItemAttachment<Weapon> weapon, WeaponState nextState) {
        magicMagReplacement = weapon;
        updateMagicMagazine = true;
        this.magicState = nextState;
        this.magicAnimationTimer = System.currentTimeMillis();
        Vec3d magRotationPoint = ((ItemMagazine)weapon).rotationPoint;
        if (this.getBuilder().isHasTacticalReload() && nextState == WeaponState.TACTICAL_RELOAD) {
            this.getWeaponRendererBuilder().tacticalReloadContainer.getCustom().put(SpecialAttachments.MagicMag.getRenderablePart(), BBLoader.getAnimation(this.getBuilder().getAnimationFileName(), "reloadtactical", "magazine_extra").getTransitionList(Transform.NULL.withRotationPoint(magRotationPoint.field_72450_a, magRotationPoint.field_72448_b, magRotationPoint.field_72449_c).copy(), BBLoader.HANDDIVISOR));
        } else if (this.isCompoundReloadEmptyTactical() && nextState == WeaponState.COMPOUND_RELOAD_EMPTY) {
            ModReference.LOG.debug("Creating a compound empty animation using the magic magazine system");
            this.getWeaponRendererBuilder().compoundReloadEmptyContainer.getCustom().put(SpecialAttachments.MagicMag.getRenderablePart(), BBLoader.getAnimation(this.getBuilder().getAnimationFileName(), "reloadempty", "magazine_extra").getTransitionList(Transform.NULL.withRotationPoint(magRotationPoint.field_72450_a, magRotationPoint.field_72448_b, magRotationPoint.field_72449_c).copy(), BBLoader.HANDDIVISOR));
        } else if (this.isCompoundReloadTactical() && nextState == WeaponState.COMPOUND_RELOAD) {
            ModReference.LOG.debug("Creating a standard compound animation using the magic magazine system");
            this.getWeaponRendererBuilder().compoundReloadContainer.getCustom().put(SpecialAttachments.MagicMag.getRenderablePart(), BBLoader.getAnimation(this.getBuilder().getAnimationFileName(), "reload", "magazine_extra").getTransitionList(Transform.NULL.withRotationPoint(magRotationPoint.field_72450_a, magRotationPoint.field_72448_b, magRotationPoint.field_72449_c).copy(), BBLoader.HANDDIVISOR));
        }
    }

    private void renderCompatibleAttachment(CompatibleAttachment<?> compatibleAttachment, MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner, RenderContext<RenderableState> renderContext) {
        Entity renderViewEntity;
        if (compatibleAttachment.getAttachment().getCategory() == AttachmentCategory.MAGAZINE) {
            this.currentMagazine = compatibleAttachment;
        }
        if (AnimationModeProcessor.getInstance().getExcludedCategory() == compatibleAttachment.getAttachment().getCategory()) {
            return;
        }
        if (!AnimationModeProcessor.getInstance().shouldIsolateCategory() || AnimationModeProcessor.getInstance().getIsolatedCategory() != compatibleAttachment.getAttachment().getCategory()) {
            // empty if block
        }
        if (compatibleAttachment.getAttachment().getCategory() == AttachmentCategory.MAGICMAG) {
            boolean isFinishing;
            boolean time;
            WeaponState state = (WeaponState)renderContext.getWeaponInstance().getState();
            if (!renderContext.getWeaponInstance().getWeapon().builder.isUsingNewSystem()) {
                return;
            }
            if (magicMagReplacement != null && updateMagicMagazine) {
                updateMagicMagazine = false;
                compatibleAttachment.getAttachment().setFirstModel(magicMagReplacement);
            }
            boolean bl = time = (double)(System.currentTimeMillis() - this.magicAnimationTimer) >= (double)renderContext.getWeaponInstance().getAnimationDuration(this.magicState) * 1.2;
            if (time) {
                this.setMagicMagPermit(false);
            }
            boolean bl2 = isFinishing = state != WeaponState.COMPOUND_RELOAD_FINISHED && state != WeaponState.COMPOUND_RELOAD_FINISH;
            if (!(this.magicState != WeaponState.COMPOUND_RELOAD || state != WeaponState.COMPOUND_REQUESTED && state != WeaponState.COMPOUND_RELOAD && state != WeaponState.COMPOUND_RELOAD_FINISHED || this.isCompoundReloadTactical())) {
                return;
            }
            if (this.magicState == WeaponState.COMPOUND_RELOAD_EMPTY && state == WeaponState.COMPOUND_RELOAD_EMPTY && !this.isCompoundReloadEmptyTactical()) {
                return;
            }
            if (time) {
                if (!(this.isCompoundReloadEmptyTactical() || this.isCompoundReloadTactical() || this.getBuilder().isHasTacticalReload())) {
                    return;
                }
                if (state != WeaponState.COMPOUND_RELOAD_EMPTY && state != WeaponState.COMPOUND_RELOAD && state != WeaponState.TACTICAL_RELOAD && isFinishing) {
                    return;
                }
            } else if (!(this.isCompoundReloadEmptyTactical() || this.isCompoundReloadTactical() || this.getBuilder().isHasTacticalReload())) {
                return;
            }
            if (this.currentMagazine != null) {
                // empty if block
            }
        }
        if (compatibleAttachment.getAttachment() instanceof ItemMagazine && AnimationGUI.getInstance().magEdit.isState() && !OpenGLSelectionHelper.isInSelectionPass) {
            compatibleAttachment.getAttachment();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)ClientEventHandler.magRotPositioner.field_72450_a, (double)ClientEventHandler.magRotPositioner.field_72448_b, (double)ClientEventHandler.magRotPositioner.field_72449_c);
            WeaponRenderer.captureAtlasPosition();
            GlStateManager.func_179121_F();
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8193);
        if (compatibleAttachment.getPositioning() instanceof BiConsumer) {
            ((BiConsumer)compatibleAttachment.getPositioning()).accept(renderContext.getPlayer(), renderContext.getWeapon());
        } else if (compatibleAttachment.getPositioning() instanceof Consumer) {
            ((Consumer)compatibleAttachment.getPositioning()).accept(renderContext);
        }
        ItemAttachment<?> itemAttachment = compatibleAttachment.getAttachment();
        if (positioner != null) {
            if (itemAttachment instanceof Part) {
                positioner.position((Part)((Object)itemAttachment), renderContext);
            } else if (itemAttachment.getRenderablePart() != null) {
                positioner.position(itemAttachment.getRenderablePart(), renderContext);
            }
        }
        if ((renderViewEntity = ClientProxy.MC.func_175606_aa()) == null) {
            renderViewEntity = ClientProxy.MC.field_71439_g;
        }
        for (Tuple<ModelBase, String> texturedModel : compatibleAttachment.getAttachment().getTexturedModels()) {
            ClientProxy.MC.field_71446_o.func_110577_a(new ResourceLocation("mwc:textures/models/" + texturedModel.getV()));
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8193);
            if (compatibleAttachment.getAttachment().getCategory() == AttachmentCategory.ACTION && AnimationModeProcessor.getInstance().getFPSMode()) {
                AnimationModeProcessor.getInstance().slideTransform.doGLDirect();
                WeaponRenderer.captureAtlasPosition();
            }
            if (compatibleAttachment.getModelPositioning() != null) {
                ItemAttachment<Weapon>[] itemAttachmentArray;
                if (compatibleAttachment.getAttachment().getCategory() == AttachmentCategory.MAGICMAG) {
                    if (this.currentMagazine != null) {
                        this.currentMagazine.getModelPositioning().accept(texturedModel.getU());
                    }
                } else {
                    compatibleAttachment.getModelPositioning().accept(texturedModel.getU());
                }
                if ((itemAttachmentArray = renderContext.getWeaponInstance().getWeapon().getRenderer().getBuilder().actionPiece) != null && itemAttachmentArray.length > 0) {
                    for (ItemAttachment<Weapon> part : itemAttachmentArray) {
                        if (compatibleAttachment.getAttachment() != part) continue;
                        float mu = ClientValueRepo.slidePumpValue.getLerpedFloat();
                        mu = Math.min(mu, 1.0f);
                        Transform t = renderContext.getWeaponInstance().getWeapon().getRenderer().getBuilder().actionPieceTransform;
                        if (DebugCommand.isDebuggingActionPosition()) {
                            t = DebugCommand.debugSlideTransform;
                            mu = 1.0f;
                        }
                        if (t == null) break;
                        GlStateManager.func_179137_b((double)(t.getPositionX() * (double)mu), (double)(t.getPositionY() * (double)mu), (double)(t.getPositionZ() * (double)mu));
                        break;
                    }
                }
            }
            texturedModel.getU().func_78088_a((Entity)renderContext.getPlayer(), renderContext.getLimbSwing(), renderContext.getFlimbSwingAmount(), renderContext.getAgeInTicks(), renderContext.getNetHeadYaw(), renderContext.getHeadPitch(), renderContext.getScale());
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        List<CustomRenderer<?>> postList = compatibleAttachment.getAttachment().getAllPostRenderers();
        Iterator<Object> iterator = postList.iterator();
        while (iterator.hasNext()) {
            CustomRenderer<?> customRenderer;
            CustomRenderer<?> actualPost = customRenderer = iterator.next();
            this.deferredPost.add(new Pair(this.captureCurrentModelViewMatrix(), actualPost));
        }
        for (CompatibleAttachment compatibleAttachment2 : itemAttachment.getAttachments()) {
            this.renderCompatibleAttachment(compatibleAttachment2, positioner, renderContext);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public FloatBuffer captureCurrentModelViewMatrix() {
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)buf);
        buf.rewind();
        return buf;
    }

    public void renderPostRenderers(RenderContext<RenderableState> renderContext) {
        for (Pair<FloatBuffer, CustomRenderer<RenderableState>> pair : this.deferredPost) {
            GL11.glPushMatrix();
            GL11.glLoadMatrix((FloatBuffer)pair.getFirst());
            GL11.glPushAttrib((int)8193);
            pair.getSecond().render(renderContext);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    public boolean hasRecoilPositioning() {
        return this.getBuilder().hasRecoilPositioningDefined;
    }

    public Vec3d getADSBeizer() {
        return this.getBuilder().beizer;
    }

    public long getTotalLoadIterationDuration() {
        return this.getBuilder().totalLoadIterationDuration;
    }

    public long getPrepareFirstLoadIterationAnimationDuration() {
        return this.getBuilder().prepareFirstLoadIterationAnimationDuration;
    }

    public long getAllLoadIterationAnimationsCompletedDuration() {
        return this.getBuilder().allLoadIterationAnimationsCompletedDuration;
    }

    public MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> getStateManager(EntityPlayer player) {
        return this.firstPersonStateManagers.get(player);
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public void setBuilder(Builder builder) {
        this.builder = builder;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (ForgeModContainer.allowEmissiveItems) {
            ForgeModContainer.allowEmissiveItems = false;
        }
        if (this.transformType == ItemCameraTransforms.TransformType.GROUND || this.transformType == ItemCameraTransforms.TransformType.GUI || this.transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || this.transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || this.transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || this.transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            tessellator.func_78381_a();
            GlStateManager.func_179094_E();
            if (this.player == null || this.transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || this.transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || this.transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                // empty if block
            }
            if (this.onGround()) {
                GlStateManager.func_179152_a((float)-3.0f, (float)-3.0f, (float)-3.0f);
            }
            int currentTextureId = GlStateManager.func_187397_v((int)32873);
            if (!AnimationModeProcessor.getInstance().getFPSMode()) {
                this.renderItem();
            } else {
                GlStateManager.func_179094_E();
                this.renderItem();
                GlStateManager.func_179121_F();
                OpenGLSelectionHelper.startSelectionPass();
                OpenGLSelectionHelper.bindSelectBuffer();
                this.renderItem();
                OpenGLSelectionHelper.stopSelectionPass();
                OpenGLSelectionHelper.fbo.func_147610_a(true);
                if (AnimationModeProcessor.getInstance().colorSelected == -1) {
                    OpenGLSelectionHelper.readValueAtMousePosition();
                }
                ClientProxy.MC.func_147110_a().func_147610_a(false);
            }
            if (currentTextureId != 0) {
                GlStateManager.func_179144_i((int)currentTextureId);
            }
            GlStateManager.func_179121_F();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        }
        this.player = null;
        this.itemStack = null;
        this.transformType = null;
        return Collections.emptyList();
    }

    protected boolean onGround() {
        return this.transformType == null;
    }

    public final boolean func_177555_b() {
        return true;
    }

    public final boolean func_177556_c() {
        return true;
    }

    public final boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return ClientProxy.MC.func_147117_R().func_174944_f();
    }

    public void setOwner(EntityLivingBase player) {
        this.player = player;
    }

    public static void applyRotationAtPoint(float xOffset, float yOffset, float zOffset, float xRotation, float yRotation, float zRotation) {
        GL11.glTranslatef((float)(-xOffset), (float)(-yOffset), (float)(-zOffset));
        GL11.glRotatef((float)xRotation, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)yRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)zRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)xOffset, (float)yOffset, (float)zOffset);
    }

    public static void captureAtlasPosition() {
        GL11.glGetFloat((int)2982, (FloatBuffer)atlasMatrix);
    }

    public void setTransformType(ItemCameraTransforms.TransformType type) {
        this.transformType = type;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem() {
        GL11.glPushMatrix();
        Framebuffer framebuffer = null;
        Integer inventoryTexture = null;
        boolean inventoryTextureInitializationPhaseOn = false;
        ScaledResolution scaledresolution = new ScaledResolution(ClientProxy.MC);
        int originalFramebufferId = -1;
        if (this.transformType == ItemCameraTransforms.TransformType.GUI && DebugCommand.isForceLiveRenderGUI()) {
            WeaponRenderer textureMapKey = this;
            inventoryTexture = this.getClientModContext().getInventoryTextureMap().get(textureMapKey);
            if (inventoryTexture == null) {
                originalFramebufferId = GlStateManager.func_187397_v((int)36006);
                if (OpenGlHelper.func_148822_b()) {
                    OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)0);
                }
                inventoryTextureInitializationPhaseOn = true;
                framebuffer = new Framebuffer(128, 128, true);
                framebuffer.func_147610_a(true);
                inventoryTexture = framebuffer.field_147617_g;
                this.getClientModContext().getInventoryTextureMap().put(textureMapKey, inventoryTexture);
                this.setupInventoryRendering(128.0, 128.0);
            }
        }
        RenderContext<RenderableState> renderContext = new RenderContext<RenderableState>(this.player, this.itemStack);
        renderContext.setAgeInTicks(-0.4f);
        renderContext.setScale(0.08f);
        renderContext.setCompatibleTransformType(this.transformType);
        MultipartPositioning.Positioner positioner = null;
        Matrix4f forLater = null;
        boolean forceMSAA = false;
        switch (this.transformType) {
            case GROUND: {
                GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
                GL11.glScaled((double)0.45f, (double)0.45f, (double)0.45f);
                GL11.glTranslatef((float)-1.1f, (float)-0.9f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.builder.getEntityPositioning().accept(this.itemStack);
                break;
            }
            case GUI: {
                forceMSAA = true;
                double inventoryScale = 30.0;
                GL11.glScaled((double)1.0, (double)-1.0, (double)1.0);
                new Transform().withPosition(75.0, -85.0, 0.0).withRotation(20.0, 130.0, 120.0).withScale(inventoryScale, inventoryScale, inventoryScale).doGLDirect();
                StateDescriptor thirdPersonStateDescriptor = this.getThirdPersonStateDescriptor(this.player, this.itemStack);
                renderContext.setPlayerItemInstance(thirdPersonStateDescriptor.instance);
                MultipartPositioning<Part, RenderContext<RenderableState>> multipartPositioning = thirdPersonStateDescriptor.stateManager.nextPositioning();
                renderContext.setTransitionProgress(multipartPositioning.getProgress());
                renderContext.setFromState(multipartPositioning.getFromState(RenderableState.class));
                renderContext.setToState(multipartPositioning.getToState(RenderableState.class));
                positioner = multipartPositioning.getPositioner();
                positioner.position(Part.MAIN_ITEM, renderContext);
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                StateDescriptor thirdPersonStateDescriptor;
                GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
                GL11.glScaled((double)0.4f, (double)0.4f, (double)0.4f);
                GL11.glTranslatef((float)-1.25f, (float)-2.1f, (float)0.6f);
                GL11.glRotatef((float)110.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                if (this.player instanceof EntityPlayer && !MWCUtil.isProning((EntityPlayer)this.player)) {
                    thirdPersonStateDescriptor = this.getThirdPersonStateDescriptor(this.player, this.itemStack);
                    renderContext.setPlayerItemInstance(thirdPersonStateDescriptor.instance);
                    MultipartPositioning<Part, RenderContext<RenderableState>> thirdPersonMultipartPositioning = thirdPersonStateDescriptor.stateManager.nextPositioning();
                    renderContext.setTransitionProgress(thirdPersonMultipartPositioning.getProgress());
                    renderContext.setCancelBeizer();
                    renderContext.setFromState(thirdPersonMultipartPositioning.getFromState(RenderableState.class));
                    renderContext.setToState(thirdPersonMultipartPositioning.getToState(RenderableState.class));
                    positioner = thirdPersonMultipartPositioning.getPositioner();
                    positioner.position(Part.MAIN_ITEM, renderContext);
                    if (!DebugPositioner.isDebugModeEnabled()) break;
                    DebugPositioner.position(Part.MAIN_ITEM, renderContext);
                    break;
                }
                this.builder.getThirdPersonPositioning().accept(renderContext);
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: {
                if (AnimationModeProcessor.getInstance().isLegacyMode()) {
                    WeaponRenderer.fixVersionSpecificFirstPersonPositioning(this.transformType);
                }
                GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
                StateDescriptor stateDescriptor = this.getFirstPersonStateDescriptor(this.player, this.itemStack);
                renderContext.setPlayerItemInstance(stateDescriptor.instance);
                MultipartPositioning<Part, RenderContext<RenderableState>> multipartPositioning = stateDescriptor.stateManager.nextPositioning();
                renderContext.setTransitionProgress(multipartPositioning.getProgress());
                renderContext.setFromState(multipartPositioning.getFromState(RenderableState.class));
                renderContext.setToState(multipartPositioning.getToState(RenderableState.class));
                positioner = multipartPositioning.getPositioner();
                positioner.randomize(stateDescriptor.rate, stateDescriptor.amplitude);
                if (!OpenGLSelectionHelper.isInSelectionPass && AnimationModeProcessor.getInstance().getFPSMode()) {
                    GlStateManager.func_179094_E();
                    ResourceLocation loc = new ResourceLocation("mwc:textures/hud/grid.png");
                    Shader grid = Shaders.grid;
                    grid.use();
                    GlStateManager.func_179129_p();
                    Tessellator t = Tessellator.func_178181_a();
                    BufferBuilder bb = t.func_178180_c();
                    bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    double sL = 30.0;
                    double y = 10.0;
                    bb.func_181662_b(-1.0 * sL, y, -1.0 * sL).func_187315_a(1.0, 0.0).func_181675_d();
                    bb.func_181662_b(1.0 * sL, y, -1.0 * sL).func_187315_a(1.0, 1.0).func_181675_d();
                    bb.func_181662_b(1.0 * sL, y, 1.0 * sL).func_187315_a(0.0, 1.0).func_181675_d();
                    bb.func_181662_b(-1.0 * sL, y, 1.0 * sL).func_187315_a(1.0, 1.0).func_181675_d();
                    t.func_78381_a();
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179121_F();
                    grid.release();
                }
                GlStateManager.func_179126_j();
                forLater = MatrixHelper.captureMatrix();
                positioner.position(Part.MAIN_ITEM, renderContext);
                wrh.run(renderContext, stateDescriptor);
                if (DebugPositioner.isDebugModeEnabled()) {
                    DebugPositioner.position(Part.MAIN_ITEM, renderContext);
                }
                if (this.player == null || this.player.func_184614_ca() == null || !(this.player.func_184614_ca().func_77973_b() instanceof Weapon)) break;
                if (OpenGLSelectionHelper.isInSelectionPass) {
                    if (OpenGLSelectionHelper.shouldRender(1)) {
                        OpenGLSelectionHelper.bindSelectShader(1);
                        WeaponRenderer.renderLeftArm(this.player, renderContext, positioner);
                    }
                    if (OpenGLSelectionHelper.shouldRender(2)) {
                        OpenGLSelectionHelper.bindSelectShader(2);
                        WeaponRenderer.renderRightArm(this.player, renderContext, positioner);
                    }
                    GL20.glUseProgram((int)0);
                    break;
                }
                WeaponRenderer.renderLeftArm(this.player, renderContext, positioner);
                WeaponRenderer.renderRightArm(this.player, renderContext, positioner);
                if (OpenGLSelectionHelper.isInSelectionPass || !AnimationModeProcessor.getInstance().getFPSMode() || OpenGLSelectionHelper.selectID != 1 && OpenGLSelectionHelper.selectID != 2) break;
                GlStateManager.func_179094_E();
                Transform t = AnimationModeProcessor.getInstance().getTransformFromSelected();
                GlStateManager.func_179137_b((double)t.getPositionX(), (double)t.getPositionY(), (double)t.getPositionZ());
                WeaponRenderer.captureAtlasPosition();
                GlStateManager.func_179126_j();
                GlStateManager.func_179121_F();
                break;
            }
        }
        if (this.transformType != ItemCameraTransforms.TransformType.GUI || inventoryTextureInitializationPhaseOn) {
            if (OpenGLSelectionHelper.isInSelectionPass) {
                if (OpenGLSelectionHelper.shouldRender(3)) {
                    OpenGLSelectionHelper.bindSelectShader(3);
                    AnimationModeProcessor.getInstance().setExcludedCategory(AttachmentCategory.ACTION);
                    this.renderItem(this.itemStack, renderContext, positioner);
                    AnimationModeProcessor.getInstance().setExcludedCategory(null);
                } else if (OpenGLSelectionHelper.shouldRender(4)) {
                    // empty if block
                }
                OpenGLSelectionHelper.bindSelectShader(4);
                AnimationModeProcessor.getInstance().setActiveCategory(AttachmentCategory.ACTION);
                this.renderItem(this.itemStack, renderContext, positioner);
                AnimationModeProcessor.getInstance().setActiveCategory(null);
            } else {
                if (forceMSAA) {
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179141_d();
                }
                if (AnimationModeProcessor.getInstance().getFPSMode()) {
                    AnimationModeProcessor.getInstance().setActiveCategory(AttachmentCategory.ACTION);
                    this.renderItem(this.itemStack, renderContext, positioner);
                    AnimationModeProcessor.getInstance().setActiveCategory(null);
                    AnimationModeProcessor.getInstance().setExcludedCategory(AttachmentCategory.ACTION);
                    this.renderItem(this.itemStack, renderContext, positioner);
                    AnimationModeProcessor.getInstance().setExcludedCategory(null);
                } else {
                    this.renderItem(this.itemStack, renderContext, positioner);
                }
                if (AnimationGUI.getInstance().magEdit.isState() && AnimationModeProcessor.getInstance().getFPSMode()) {
                    GL11.glPushMatrix();
                    AnimationModeProcessor.getInstance().deferredMatrix.rewind();
                    GL11.glLoadMatrix((FloatBuffer)AnimationModeProcessor.getInstance().deferredMatrix);
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179084_k();
                    AnimationModeProcessor.getInstance().renderCross();
                    GlStateManager.func_179145_e();
                    GL11.glPopMatrix();
                }
                if (OpenGLSelectionHelper.selectID == 3 && AnimationModeProcessor.getInstance().getFPSMode() && !AnimationModeProcessor.getInstance().editRotationPointMode && !AnimationGUI.getInstance().magEdit.isState()) {
                    AnimationModeProcessor.getInstance().currentPartMatrix = MatrixHelper.captureMatrix();
                    WeaponRenderer.captureAtlasPosition();
                }
            }
            if (OpenGLSelectionHelper.selectID == 3 && AnimationModeProcessor.getInstance().getFPSMode() && AnimationModeProcessor.getInstance().editRotationPointMode && !OpenGLSelectionHelper.isInSelectionPass) {
                GlStateManager.func_179094_E();
                FloatBuffer temp = BufferUtils.createFloatBuffer((int)16);
                forLater.store(temp);
                temp.rewind();
                GL11.glLoadMatrix((FloatBuffer)temp);
                AnimationModeProcessor.getInstance().currentPartMatrix = MatrixHelper.captureMatrix();
                AnimationModeProcessor.getInstance().renderTransformIndicator(1.0f);
                GlStateManager.func_179121_F();
            }
        }
        if (this.transformType == ItemCameraTransforms.TransformType.GUI && inventoryTextureInitializationPhaseOn) {
            framebuffer.func_147609_e();
            framebuffer.field_147617_g = -1;
            framebuffer.func_147608_a();
            this.restoreInventoryRendering(scaledresolution);
        }
        GL11.glPopMatrix();
        if (originalFramebufferId >= 0 && OpenGlHelper.func_148822_b()) {
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)originalFramebufferId);
            GlStateManager.func_179083_b((int)0, (int)0, (int)ClientProxy.MC.func_147110_a().field_147621_c, (int)ClientProxy.MC.func_147110_a().field_147618_d);
        }
        if (this.transformType == ItemCameraTransforms.TransformType.GUI) {
            this.renderCachedInventoryTexture(renderContext, inventoryTexture);
        }
        if (!AnimationModeProcessor.getInstance().editRotationPointMode && AnimationModeProcessor.getInstance().getFPSMode() && !OpenGLSelectionHelper.isInSelectionPass) {
            GL11.glPushMatrix();
            GL11.glLoadMatrix((FloatBuffer)atlasMatrix);
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            AnimationModeProcessor.getInstance().renderTransformIndicator(1.0f);
            GL11.glPopMatrix();
        }
        if (AnimationModeProcessor.getInstance().getFPSMode()) {
            Shaders.selectedge.use();
            if (OpenGLSelectionHelper.fbo != null) {
                GlStateManager.func_179138_g((int)33989);
                GL11.glBindTexture((int)3553, (int)OpenGLSelectionHelper.fbo.field_147617_g);
                Shaders.selectedge.uniform1i("select", 5);
            }
            Shaders.selectedge.uniform1i("idSelected", OpenGLSelectionHelper.selectID);
            Shaders.selectedge.uniform2f("fragSize", 1.0f / (float)ClientProxy.MC.field_71443_c, 1.0f / (float)ClientProxy.MC.field_71440_d);
            GlStateManager.func_179138_g((int)33984);
            ClientProxy.MC.func_147110_a().func_147610_a(true);
            Shaders.selectedge.release();
            OpenGLSelectionHelper.bindBallBuf();
            ByteBuffer buf = OpenGLSelectionHelper.readRawColor();
            int red = buf.get(0) & 0xFF;
            int green = buf.get(1) & 0xFF;
            int blue = buf.get(2) & 0xFF;
            boolean changed = false;
            if (red != 0 || green != 0 || blue != 0) {
                if (red == 0 && green == 0) {
                    changed = true;
                    AnimationModeProcessor.getInstance().colorHover = 3;
                } else if (red == 0 && blue == 0) {
                    changed = true;
                    AnimationModeProcessor.getInstance().colorHover = 2;
                } else if (green == 0 && blue == 0) {
                    changed = true;
                    AnimationModeProcessor.getInstance().colorHover = 1;
                }
            }
            Color s = new Color(4774907);
            double diff = red - s.getRed() + (blue - s.getBlue()) + (green - s.getGreen());
            if (!changed && Math.abs(diff) > 10.0) {
                AnimationModeProcessor.getInstance().colorHover = -1;
            }
            if (!Mouse.isButtonDown((int)0)) {
                AnimationModeProcessor.getInstance().tryToUpdateSelectedColor(-1);
            }
        }
    }

    public static void fixVersionSpecificFirstPersonPositioning(ItemCameraTransforms.TransformType transformType) {
        int i = transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND ? 1 : -1;
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        i = -i;
        GL11.glTranslatef((float)((float)i * 0.56f), (float)1.12f, (float)0.72f);
        if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
        }
        i = 1;
        GL11.glTranslatef((float)((float)i * 0.56f), (float)-1.12f, (float)-0.72f);
        GL11.glTranslatef((float)0.0f, (float)0.6f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
    }

    private void setupInventoryRendering(double projectionWidth, double projectionHeight) {
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)projectionWidth, (double)projectionHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    private void restoreInventoryRendering(ScaledResolution scaledresolution) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
    }

    private void renderCachedInventoryTexture(RenderContext<RenderableState> renderContext, Integer inventoryTexture) {
        if (this.getClientModContext() != null) {
            WeaponSpritesheetBuilder.provideModContext(this.getClientModContext());
        }
        if (!DebugCommand.isForceLiveRenderGUI()) {
            PlayerWeaponInstance pwi = renderContext.getWeaponInstance();
            if (!WeaponSpritesheetBuilder.hasSpriteID(pwi.getWeapon().getName())) {
                return;
            }
            GlStateManager.func_179094_E();
            GL11.glPushAttrib((int)8192);
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179140_f();
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.5f);
            GL11.glScalef((float)0.004f, (float)0.004f, (float)0.004f);
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)-8.0f, (float)-8.0f, (float)0.0f);
            ClientProxy.MC.func_110434_K().func_110577_a(ResourceManager.GUN_ICON_SHEET);
            if (!hasCalculatedSheetDimensions) {
                hasCalculatedSheetDimensions = true;
                try {
                    InputStream inputStream = ClientProxy.MC.func_110442_L().func_110536_a(ResourceManager.GUN_ICON_SHEET).func_110527_b();
                    BufferedImage bf = ImageIO.read(inputStream);
                    gunIconSheetWidth = bf.getWidth();
                    gunIconSheetHeight = bf.getHeight();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    gunIconSheetHeight = 1664;
                    gunIconSheetWidth = 1664;
                }
            }
            int id = WeaponSpritesheetBuilder.getSpriteID(pwi.getWeapon().getName());
            SpriteSheetTools.Sprite sprite = SpriteSheetTools.getSquareSprite(id, 128.0, gunIconSheetWidth, gunIconSheetHeight);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.0, 256.0, 0.0).func_187315_a(sprite.getMinU(), sprite.getMaxV()).func_181675_d();
            buffer.func_181662_b(256.0, 256.0, 0.0).func_187315_a(sprite.getMaxU(), sprite.getMaxV()).func_181675_d();
            buffer.func_181662_b(256.0, 0.0, 0.0).func_187315_a(sprite.getMaxU(), sprite.getMinV()).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(sprite.getMinU(), sprite.getMinV()).func_181675_d();
            tessellator.func_78381_a();
            GL11.glPopAttrib();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            GlStateManager.func_179098_w();
        } else {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.5f);
            GL11.glScalef((float)0.004f, (float)0.004f, (float)0.004f);
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)-8.0f, (float)-8.0f, (float)0.0f);
            GlStateManager.func_179144_i((int)inventoryTexture);
            WeaponRenderer.drawTexturedQuadFit(0.0, 0.0, 256.0, 256.0, 0.0);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        if (BalancePackManager.isWeaponDisabled(renderContext.getWeaponInstance().getWeapon())) {
            GlStateManager.func_179090_x();
            Tessellator t = Tessellator.func_178181_a();
            BufferBuilder bb = t.func_178180_c();
            bb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            double size = 1.0;
            bb.func_181662_b(0.0, 0.0, 10.0).func_181666_a(1.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
            bb.func_181662_b(size, 0.0, 10.0).func_181666_a(1.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
            bb.func_181662_b(size, size, 10.0).func_181666_a(1.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
            bb.func_181662_b(0.0, size, 10.0).func_181666_a(1.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
            t.func_78381_a();
            GlStateManager.func_179098_w();
        }
    }

    private static void drawTexturedQuadFit(double x, double y, double width, double height, double zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x + 0.0, y + height, zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + width, y + height, zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + width, y + 0.0, zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x + 0.0, y + 0.0, zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static <T> void renderRightArm(EntityLivingBase player, RenderContext<T> renderContext, MultipartPositioning.Positioner<Part, RenderContext<T>> positioner) {
        Render entityRenderObject = ClientProxy.MC.func_175598_ae().func_78713_a((Entity)((AbstractClientPlayer)player));
        RenderPlayer render = (RenderPlayer)entityRenderObject;
        ClientProxy.MC.func_110434_K().func_110577_a(((AbstractClientPlayer)player).func_110306_p());
        GL11.glPushMatrix();
        if (AnimationModeProcessor.getInstance().isLegacyMode()) {
            GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
            GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)0.2f);
            GL11.glRotatef((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        positioner.position(Part.RIGHT_HAND, renderContext);
        if (DebugPositioner.isDebugModeEnabled()) {
            DebugPositioner.position(Part.RIGHT_HAND, renderContext);
        }
        renderContext.capturePartPosition(Part.RIGHT_HAND);
        if (!AnimationModeProcessor.getInstance().isLegacyMode()) {
            GL11.glTranslatef((float)0.35f, (float)-0.15f, (float)-0.1f);
        }
        WeaponRenderer.renderRightArm((ModelBiped)render.func_177087_b(), (AbstractClientPlayer)player);
        ItemStack itemstack = WeaponRenderer.getItemStackFromSlot(player, EntityEquipmentSlot.CHEST);
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemArmor) {
            render.func_110776_a(WeaponRenderer.getArmorResource((Entity)player, itemstack, EntityEquipmentSlot.CHEST, null));
            ModelBiped armorModel = WeaponRenderer.getArmorModelHook(player, itemstack, EntityEquipmentSlot.CHEST, null);
            if (armorModel != null) {
                WeaponRenderer.renderRightArm(armorModel, (AbstractClientPlayer)player);
            }
        }
        GL11.glPopMatrix();
    }

    static <T> void renderSpecialLeftArm(EntityLivingBase player, RenderContext<T> renderContext, MultipartPositioning.Positioner<Part, RenderContext<T>> positioner) {
        Render entityRenderObject = ClientProxy.MC.func_175598_ae().func_78713_a((Entity)((AbstractClientPlayer)player));
        RenderPlayer render = (RenderPlayer)entityRenderObject;
        ClientProxy.MC.func_110434_K().func_110577_a(((AbstractClientPlayer)player).func_110306_p());
        GL11.glPushMatrix();
        if (DebugPositioner.isDebugModeEnabled()) {
            DebugPositioner.position(Part.LEFT_HAND, renderContext);
        }
        GlStateManager.func_179109_b((float)5.0f, (float)-5.0f, (float)-2.0f);
        float MCT = 45.0f * (float)(ClientProxy.MC.field_71439_g.field_70173_aa % 20) / 20.0f;
        GlStateManager.func_179114_b((float)MCT, (float)0.0f, (float)1.0f, (float)0.0f);
        renderContext.capturePartPosition(Part.LEFT_HAND);
        if (!AnimationModeProcessor.getInstance().isLegacyMode()) {
            // empty if block
        }
        GlStateManager.func_179090_x();
        ItemStack itemstack = WeaponRenderer.getItemStackFromSlot(player, EntityEquipmentSlot.CHEST);
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemArmor) {
            render.func_110776_a(WeaponRenderer.getArmorResource((Entity)player, itemstack, EntityEquipmentSlot.CHEST, null));
            ModelBiped armorModel = WeaponRenderer.getArmorModelHook(player, itemstack, EntityEquipmentSlot.CHEST, null);
            if (armorModel != null) {
                WeaponRenderer.renderLeftArm(armorModel, (AbstractClientPlayer)player);
            }
        }
        GL11.glPopMatrix();
    }

    public static <T> void renderLeftArm(EntityLivingBase player, RenderContext<T> renderContext, MultipartPositioning.Positioner<Part, RenderContext<T>> positioner) {
        Render entityRenderObject = ClientProxy.MC.func_175598_ae().func_78713_a((Entity)((AbstractClientPlayer)player));
        RenderPlayer render = (RenderPlayer)entityRenderObject;
        ClientProxy.MC.func_110434_K().func_110577_a(((AbstractClientPlayer)player).func_110306_p());
        GL11.glPushMatrix();
        if (AnimationModeProcessor.getInstance().isLegacyMode()) {
            GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glRotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        float MCt = 45.0f * ((float)(ClientProxy.MC.field_71439_g.field_70173_aa % 45) / 45.0f);
        positioner.position(Part.LEFT_HAND, renderContext);
        if (DebugPositioner.isDebugModeEnabled()) {
            DebugPositioner.position(Part.LEFT_HAND, renderContext);
        }
        renderContext.capturePartPosition(Part.LEFT_HAND);
        if (!AnimationModeProcessor.getInstance().isLegacyMode()) {
            // empty if block
        }
        WeaponRenderer.renderLeftArm((ModelBiped)render.func_177087_b(), (AbstractClientPlayer)player);
        ItemStack itemstack = WeaponRenderer.getItemStackFromSlot(player, EntityEquipmentSlot.CHEST);
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemArmor) {
            render.func_110776_a(WeaponRenderer.getArmorResource((Entity)player, itemstack, EntityEquipmentSlot.CHEST, null));
            ModelBiped armorModel = WeaponRenderer.getArmorModelHook(player, itemstack, EntityEquipmentSlot.CHEST, null);
            if (armorModel != null) {
                WeaponRenderer.renderLeftArm(armorModel, (AbstractClientPlayer)player);
            }
        }
        GL11.glPopMatrix();
    }

    public static void renderRightArm(ModelBiped modelplayer, AbstractClientPlayer clientPlayer) {
        float f = 1.0f;
        GlStateManager.func_179124_c((float)f, (float)f, (float)f);
        WeaponRenderer.setModelVisibilities(modelplayer, clientPlayer);
        GlStateManager.func_179147_l();
        modelplayer.field_78095_p = 0.0f;
        modelplayer.field_78117_n = false;
        modelplayer.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)clientPlayer);
        if (AnimationModeProcessor.getInstance().isLegacyMode()) {
            modelplayer.field_178723_h.field_78795_f = -0.3f;
            modelplayer.field_178723_h.field_78796_g = 0.0f;
        } else {
            modelplayer.field_178723_h.field_78795_f = (float)Math.toRadians(-90.0);
            modelplayer.field_178723_h.field_78796_g = 0.0f;
            modelplayer.field_178723_h.field_78808_h = 0.0f;
        }
        modelplayer.field_178723_h.func_78785_a(0.0625f);
        if (modelplayer instanceof ModelPlayer) {
            if (AnimationModeProcessor.getInstance().isLegacyMode()) {
                ((ModelPlayer)modelplayer).field_178732_b.field_78795_f = 0.0f;
                ((ModelPlayer)modelplayer).field_178732_b.field_78795_f = -0.3f;
            } else {
                ((ModelPlayer)modelplayer).field_178723_h.field_78795_f = 0.0f;
                ((ModelPlayer)modelplayer).field_178723_h.field_78796_g = 0.0f;
                ((ModelPlayer)modelplayer).field_178723_h.field_78808_h = 0.0f;
            }
        }
        GlStateManager.func_179084_k();
    }

    public static ModelBiped duplicateBiped(ModelBiped mb) {
        ModelBiped newBiped = new ModelBiped();
        newBiped.field_78089_u = mb.field_78089_u;
        newBiped.field_78090_t = mb.field_78090_t;
        newBiped.field_187075_l = mb.field_187075_l;
        newBiped.field_187076_m = mb.field_187076_m;
        newBiped.field_78095_p = mb.field_78095_p;
        for (ModelRenderer mr : mb.field_78092_r) {
            ModelRenderer newModelRenderer = WeaponRenderer.cloneModelRenderer((ModelBase)newBiped, mr);
            if (mr.field_78805_m == null) continue;
            for (ModelRenderer children : mr.field_78805_m) {
                newModelRenderer.field_78805_m.add(WeaponRenderer.cloneModelRenderer((ModelBase)newBiped, children));
            }
        }
        newBiped.field_178724_i = WeaponRenderer.cloneModelRenderer((ModelBase)newBiped, mb.field_178724_i);
        newBiped.field_178723_h = WeaponRenderer.cloneModelRenderer((ModelBase)newBiped, mb.field_178724_i);
        newBiped.field_78115_e = WeaponRenderer.cloneModelRenderer((ModelBase)newBiped, mb.field_178724_i);
        newBiped.field_178720_f = WeaponRenderer.cloneModelRenderer((ModelBase)newBiped, mb.field_178724_i);
        newBiped.field_178722_k = WeaponRenderer.cloneModelRenderer((ModelBase)newBiped, mb.field_178724_i);
        newBiped.field_178721_j = WeaponRenderer.cloneModelRenderer((ModelBase)newBiped, mb.field_178724_i);
        newBiped.field_78116_c = WeaponRenderer.cloneModelRenderer((ModelBase)newBiped, mb.field_178724_i);
        return newBiped;
    }

    public static ModelRenderer cloneModelRenderer(ModelBase base, ModelRenderer children) {
        ModelRenderer newModel = new ModelRenderer(base);
        newModel.field_78804_l.addAll(children.field_78804_l);
        newModel.field_78807_k = children.field_78807_k;
        newModel.field_78809_i = children.field_78809_i;
        newModel.field_82906_o = children.field_82906_o;
        newModel.field_82908_p = children.field_82908_p;
        newModel.field_82907_q = children.field_82907_q;
        newModel.field_78795_f = children.field_78795_f;
        newModel.field_78796_g = children.field_78796_g;
        newModel.field_78808_h = children.field_78808_h;
        newModel.field_78800_c = children.field_78800_c;
        newModel.field_78797_d = children.field_78797_d;
        newModel.field_78798_e = children.field_78798_e;
        newModel.field_78806_j = children.field_78806_j;
        newModel.field_78799_b = children.field_78799_b;
        newModel.field_78801_a = children.field_78801_a;
        return newModel;
    }

    public static void renderLeftArm(ModelBiped modelplayer, AbstractClientPlayer clientPlayer) {
        ModelRendererPreset preset = new ModelRendererPreset(modelplayer.field_178724_i);
        ModelBiped toRender = modelplayer;
        WeaponRenderer.setModelVisibilities(toRender, clientPlayer);
        GlStateManager.func_179147_l();
        toRender.field_78117_n = false;
        toRender.field_78095_p = 0.0f;
        toRender.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)clientPlayer);
        if (!AnimationModeProcessor.getInstance().isLegacyMode() && ClientProxy.MC.field_71474_y.field_74320_O == 0) {
            toRender.field_178724_i.field_78795_f = (float)Math.toRadians(-90.0);
            toRender.field_178724_i.field_78796_g = 0.0f;
            toRender.field_178724_i.field_78808_h = 0.0f;
        } else {
            toRender.field_178724_i.field_78795_f = 0.0f;
        }
        if (AnimationModeProcessor.getInstance().isLegacyMode() || ClientProxy.MC.field_71474_y.field_74320_O != 0) {
            toRender.field_178724_i.field_82906_o = 0.0f;
            toRender.field_178724_i.field_82908_p = 0.0f;
            toRender.field_178724_i.field_82907_q = 0.0f;
        } else {
            toRender.field_178724_i.field_82906_o = -0.375f;
            toRender.field_178724_i.field_82908_p = -0.125f;
            toRender.field_178724_i.field_82907_q = -0.15f;
        }
        toRender.field_178724_i.func_78785_a(0.0625f);
        preset.set(toRender.field_178724_i);
        if (modelplayer instanceof ModelPlayer) {
            // empty if block
        }
        GlStateManager.func_179084_k();
    }

    public static void renderVehicleRightArm(ModelBiped modelplayer, AbstractClientPlayer clientPlayer) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        WeaponRenderer.setModelVisibilities(modelplayer, clientPlayer);
        GlStateManager.func_179147_l();
        modelplayer.field_178723_h.func_78785_a(0.0625f);
        if (modelplayer instanceof ModelPlayer) {
            ((ModelPlayer)modelplayer).field_178732_b.field_78795_f = 0.0f;
            ((ModelPlayer)modelplayer).field_178732_b.field_78795_f = -0.3f;
            ((ModelPlayer)modelplayer).field_178732_b.func_78785_a(0.0625f);
        }
        GlStateManager.func_179084_k();
    }

    public static void renderLeftVehicleArm(ModelBiped modelplayer, AbstractClientPlayer clientPlayer) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        WeaponRenderer.setModelVisibilities(modelplayer, clientPlayer);
        GlStateManager.func_179147_l();
        modelplayer.field_178724_i.func_78785_a(0.0625f);
        if (modelplayer instanceof ModelPlayer) {
            ((ModelPlayer)modelplayer).field_178734_a.field_78795_f = 0.0f;
            ((ModelPlayer)modelplayer).field_178734_a.func_78785_a(0.0625f);
        }
        GlStateManager.func_179084_k();
    }

    public static void setModelVisibilities(ModelBiped modelplayer, AbstractClientPlayer clientPlayer) {
        if (clientPlayer.func_175149_v()) {
            modelplayer.func_178719_a(true);
            modelplayer.field_78116_c.field_78806_j = true;
            modelplayer.field_178720_f.field_78806_j = true;
        } else {
            ItemStack itemstack = clientPlayer.func_184614_ca();
            ItemStack itemstack1 = clientPlayer.func_184592_cb();
            modelplayer.func_178719_a(true);
            modelplayer.field_178720_f.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.HAT);
            if (modelplayer instanceof ModelPlayer) {
                ((ModelPlayer)modelplayer).field_178730_v.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.JACKET);
                ((ModelPlayer)modelplayer).field_178733_c.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.LEFT_PANTS_LEG);
                ((ModelPlayer)modelplayer).field_178731_d.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.RIGHT_PANTS_LEG);
                ((ModelPlayer)modelplayer).field_178734_a.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.LEFT_SLEEVE);
                ((ModelPlayer)modelplayer).field_178732_b.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.RIGHT_SLEEVE);
            }
            modelplayer.field_78117_n = clientPlayer.func_70093_af();
            ModelBiped.ArmPose modelbiped$armpose = ModelBiped.ArmPose.EMPTY;
            ModelBiped.ArmPose modelbiped$armpose1 = ModelBiped.ArmPose.EMPTY;
            if (itemstack != null) {
                modelbiped$armpose = ModelBiped.ArmPose.ITEM;
                if (clientPlayer.func_184605_cv() > 0) {
                    EnumAction enumaction = itemstack.func_77975_n();
                    if (enumaction == EnumAction.BLOCK) {
                        modelbiped$armpose = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction == EnumAction.BOW) {
                        modelbiped$armpose = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
            if (itemstack1 != null) {
                EnumAction enumaction1;
                modelbiped$armpose1 = ModelBiped.ArmPose.ITEM;
                if (clientPlayer.func_184605_cv() > 0 && (enumaction1 = itemstack1.func_77975_n()) == EnumAction.BLOCK) {
                    modelbiped$armpose1 = ModelBiped.ArmPose.BLOCK;
                }
            }
            if (clientPlayer.func_184591_cq() == EnumHandSide.RIGHT) {
                modelplayer.field_187076_m = modelbiped$armpose;
                modelplayer.field_187075_l = modelbiped$armpose1;
            } else {
                modelplayer.field_187076_m = modelbiped$armpose1;
                modelplayer.field_187075_l = modelbiped$armpose;
            }
        }
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return this.itemOverrideList;
    }

    public org.apache.commons.lang3.tuple.Pair<? extends IBakedModel, javax.vecmath.Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        this.transformType = cameraTransformType;
        return this.pair;
    }

    public static ModelBiped getArmorModelHook(EntityLivingBase entity, ItemStack itemStack, EntityEquipmentSlot slot, ModelBiped model) {
        return ForgeHooksClient.getArmorModel((EntityLivingBase)entity, (ItemStack)itemStack, (EntityEquipmentSlot)slot, (ModelBiped)model);
    }

    protected void setModelVisible(ModelBiped model) {
        model.func_178719_a(true);
    }

    protected void setModelSlotVisible(ModelBiped p_188359_1_, EntityEquipmentSlot slotIn) {
        this.setModelVisible(p_188359_1_);
        switch (slotIn) {
            case HEAD: {
                p_188359_1_.field_78116_c.field_78806_j = true;
                p_188359_1_.field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                p_188359_1_.field_78115_e.field_78806_j = true;
                p_188359_1_.field_178723_h.field_78806_j = true;
                p_188359_1_.field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                p_188359_1_.field_78115_e.field_78806_j = true;
                p_188359_1_.field_178721_j.field_78806_j = true;
                p_188359_1_.field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                p_188359_1_.field_178721_j.field_78806_j = true;
                p_188359_1_.field_178722_k.field_78806_j = true;
            }
        }
    }

    @Nullable
    public static ItemStack getItemStackFromSlot(EntityLivingBase living, EntityEquipmentSlot slotIn) {
        return living.func_184582_a(slotIn);
    }

    private static boolean isLegSlot(EntityEquipmentSlot slotIn) {
        return slotIn == EntityEquipmentSlot.LEGS;
    }

    public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, EntityEquipmentSlot slot, String type) {
        ItemArmor item = (ItemArmor)stack.func_77973_b();
        String texture = item.func_82812_d().func_179242_c();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, WeaponRenderer.isLegSlot(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EntityEquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    static {
        wrh = new WeaponRotationHandler();
        bipedLeftArm = null;
        hasCalculatedSheetDimensions = false;
        bipedRightArm = null;
    }

    public static class ModelRendererPreset {
        public boolean isHidden;
        public boolean mirror;
        public boolean showModel;
        public float offsetX;
        public float offsetY;
        public float offsetZ;
        public float rotateAngleX;
        public float rotateAngleY;
        public float rotateAngleZ;
        public float rotationPointX;
        public float rotationPointY;
        public float rotationPointZ;
        public float textureHeight;
        public float textureWidth;

        public ModelRendererPreset(ModelRenderer mr) {
            this.isHidden = mr.field_78807_k;
            this.showModel = mr.field_78806_j;
            this.mirror = mr.field_78809_i;
            this.offsetX = mr.field_82906_o;
            this.offsetY = mr.field_82908_p;
            this.offsetZ = mr.field_82907_q;
            this.rotateAngleX = mr.field_78795_f;
            this.rotateAngleY = mr.field_78796_g;
            this.rotateAngleZ = mr.field_78808_h;
            this.rotationPointX = mr.field_78800_c;
            this.rotationPointY = mr.field_78797_d;
            this.rotationPointZ = mr.field_78798_e;
            this.textureHeight = mr.field_78799_b;
            this.textureWidth = mr.field_78801_a;
        }

        public void set(ModelRenderer mr) {
            mr.field_78807_k = this.isHidden;
            mr.field_78806_j = this.showModel;
            mr.field_78809_i = this.mirror;
            mr.field_82906_o = this.offsetX;
            mr.field_82908_p = this.offsetY;
            mr.field_82907_q = this.offsetZ;
            mr.field_78795_f = this.rotateAngleX;
            mr.field_78796_g = this.rotateAngleY;
            mr.field_78808_h = this.rotateAngleZ;
            mr.field_78800_c = this.rotationPointX;
            mr.field_78797_d = this.rotationPointY;
            mr.field_78798_e = this.rotationPointZ;
            mr.field_78799_b = this.textureHeight;
            mr.field_78801_a = this.textureWidth;
        }
    }

    private class ThirdPersonWeaponTransitionProvider
    implements MultipartTransitionProvider<RenderableState, Part, RenderContext<RenderableState>> {
        private ThirdPersonWeaponTransitionProvider() {
        }

        @Override
        public List<MultipartTransition<Part, RenderContext<RenderableState>>> getTransitions(RenderableState state) {
            switch (state) {
                case UNLOADING: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().thirdPersonPositioningUnloading, WeaponRenderer.this.getBuilder().thirdPersonLeftHandPositioningUnloading, WeaponRenderer.this.getBuilder().thirdPersonRightHandPositioningUnloading, WeaponRenderer.this.getBuilder().thirdPersonCustomPositioningUnloading);
                }
                case RELOADING: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().thirdPersonPositioningReloading, WeaponRenderer.this.getBuilder().thirdPersonLeftHandPositioningReloading, WeaponRenderer.this.getBuilder().thirdPersonRightHandPositioningReloading, WeaponRenderer.this.getBuilder().thirdPersonCustomPositioningReloading);
                }
            }
            return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.getBuilder().thirdPersonPositioning, context -> {}, context -> {}, new LinkedHashMap(), 250);
        }
    }

    private class FirstPersonWeaponTransitionProvider
    implements MultipartTransitionProvider<RenderableState, Part, RenderContext<RenderableState>> {
        private FirstPersonWeaponTransitionProvider() {
        }

        @Override
        public List<MultipartTransition<Part, RenderContext<RenderableState>>> getTransitions(RenderableState state) {
            switch (state) {
                case MODIFYING: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningModifying, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningModifying, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningModifying, WeaponRenderer.this.getBuilder().firstPersonCustomPositioning, 250);
                }
                case MODIFYING_ALT: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningModifyingAlt, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningModifyingAlt, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningModifyingAlt, WeaponRenderer.this.getBuilder().firstPersonCustomPositioning, 250);
                }
                case RUNNING: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningRunning, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningRunning, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningRunning, WeaponRenderer.this.getBuilder().firstPersonCustomPositioning, 325, Interpolation.ACCELERATION);
                }
                case UNLOAD_EMPTY: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().unloadEmptyContainer);
                }
                case LOAD_EMPTY: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().loadEmptyContainer);
                }
                case TACTICAL_RELOAD: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().tacticalReloadContainer);
                }
                case UNLOADING: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningUnloading, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningUnloading, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningUnloading, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningUnloading);
                }
                case RELOADING: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningReloading, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningReloading, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningReloading, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningReloading);
                }
                case COMPOUND_RELOAD: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().compoundReloadContainer);
                }
                case COMPOUND_RELOAD_EMPTY: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().compoundReloadEmptyContainer);
                }
                case LOAD_ITERATION: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningLoadIteration, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningLoadIteration, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningLoadIteration, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningLoadIteration);
                }
                case INSPECTING: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningInspecting, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningInspecting, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningInspecting, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningInspecting);
                }
                case DRAWING: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningDrawing, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningDrawing, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningDrawing, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningDrawing);
                }
                case LOAD_ITERATION_COMPLETED: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningLoadIterationCompleted, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningLoadIterationCompleted, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningLoadIterationCompleted, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningLoadIterationCompleted, WeaponRenderer.this.getBuilder().loadIterationCompletedAnimationDuration);
                }
                case ALL_LOAD_ITERATIONS_COMPLETED: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningAllLoadIterationsCompleted, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningAllLoadIterationsCompleted, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningAllLoadIterationsCompleted, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningLoadIterationsCompleted);
                }
                case RECOILED: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningRecoiled, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningRecoiled, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningRecoiled, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningRecoiled, WeaponRenderer.this.getBuilder().recoilAnimationDuration);
                }
                case PRONING_RECOILED: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningProningRecoiled, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningProningRecoiled, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningProningRecoiled, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningProningRecoiled, WeaponRenderer.this.getBuilder().recoilAnimationDuration);
                }
                case SHOOTING: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningShooting, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningShooting, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningShooting, WeaponRenderer.this.getBuilder().firstPersonCustomPositioning, WeaponRenderer.this.getBuilder().shootingAnimationDuration);
                }
                case PRONING_SHOOTING: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningProningShooting, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningProningShooting, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningProningShooting, WeaponRenderer.this.getBuilder().firstPersonCustomPositioning, WeaponRenderer.this.getBuilder().shootingAnimationDuration);
                }
                case EJECT_SPENT_ROUND: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningEjectSpentRound, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningEjectSpentRound, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningEjectSpentRound, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningEjectSpentRound);
                }
                case EJECT_SPENT_ROUND_AIMED: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningEjectSpentRoundAimed, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningEjectSpentRoundAimed, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningEjectSpentRoundAimed, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningEjectSpentRoundAimed);
                }
                case NORMAL: {
                    return WeaponRenderer.this.getSimpleTransitionBeizer(WeaponRenderer.this.getBuilder().firstPersonPositioning, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioning, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioning, WeaponRenderer.this.getBuilder().firstPersonCustomPositioning, 250, WeaponRenderer.this.getBuilder().beizer);
                }
                case PRONING: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningProning, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningProning, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningProning, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningProning, 250);
                }
                case ZOOMING: {
                    return WeaponRenderer.this.getSimpleTransitionBeizer(WeaponRenderer.this.getBuilder().firstPersonPositioningZooming, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningZooming, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningZooming, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningZooming, 250, WeaponRenderer.this.getBuilder().beizer);
                }
                case ZOOMING_SHOOTING: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningZoomingShooting, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningZooming, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningZooming, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningZoomingShooting, 60);
                }
                case ZOOMING_RECOILED: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.getBuilder().firstPersonPositioningZoomingRecoiled, WeaponRenderer.this.getBuilder().firstPersonLeftHandPositioningZooming, WeaponRenderer.this.getBuilder().firstPersonRightHandPositioningZooming, WeaponRenderer.this.getBuilder().firstPersonCustomPositioningZoomingRecoiled, 60);
                }
            }
            return null;
        }
    }

    public static class Builder {
        private Random random = new Random();
        public boolean threePointOh;
        private Vec3d beizer = new Vec3d(0.0, 3.5, -1.0);
        private ModelBase model;
        private WavefrontModel bakedModel;
        private String textureName;
        private Consumer<ItemStack> entityPositioning;
        private Consumer<ItemStack> inventoryPositioning;
        private Consumer<RenderContext<RenderableState>> thirdPersonPositioning;
        public Consumer<RenderContext<RenderableState>> firstPersonPositioning;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioningProning;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioningZooming;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioningRunning;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioningModifying;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioningModifyingAlt;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioningRecoiled;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioningProningRecoiled;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioningShooting;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioningProningShooting;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioningZoomingRecoiled;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioningZoomingShooting;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioningLoadIterationCompleted;
        private Consumer<RenderContext<RenderableState>> firstPersonLeftHandPositioning;
        private Consumer<RenderContext<RenderableState>> firstPersonLeftHandPositioningProning;
        private Consumer<RenderContext<RenderableState>> firstPersonLeftHandPositioningZooming;
        private Consumer<RenderContext<RenderableState>> firstPersonLeftHandPositioningRunning;
        private Consumer<RenderContext<RenderableState>> firstPersonLeftHandPositioningModifying;
        private Consumer<RenderContext<RenderableState>> firstPersonLeftHandPositioningModifyingAlt;
        private Consumer<RenderContext<RenderableState>> firstPersonLeftHandPositioningRecoiled;
        private Consumer<RenderContext<RenderableState>> firstPersonLeftHandPositioningProningRecoiled;
        private Consumer<RenderContext<RenderableState>> firstPersonLeftHandPositioningShooting;
        private Consumer<RenderContext<RenderableState>> firstPersonLeftHandPositioningProningShooting;
        private Consumer<RenderContext<RenderableState>> firstPersonLeftHandPositioningLoadIterationCompleted;
        private Consumer<RenderContext<RenderableState>> firstPersonRightHandPositioning;
        private Consumer<RenderContext<RenderableState>> firstPersonRightHandPositioningProning;
        private Consumer<RenderContext<RenderableState>> firstPersonRightHandPositioningZooming;
        private Consumer<RenderContext<RenderableState>> firstPersonRightHandPositioningRunning;
        private Consumer<RenderContext<RenderableState>> firstPersonRightHandPositioningModifying;
        private Consumer<RenderContext<RenderableState>> firstPersonRightHandPositioningModifyingAlt;
        private Consumer<RenderContext<RenderableState>> firstPersonRightHandPositioningRecoiled;
        private Consumer<RenderContext<RenderableState>> firstPersonRightHandPositioningProningRecoiled;
        private Consumer<RenderContext<RenderableState>> firstPersonRightHandPositioningShooting;
        private Consumer<RenderContext<RenderableState>> firstPersonRightHandPositioningProningShooting;
        private Consumer<RenderContext<RenderableState>> firstPersonRightHandPositioningLoadIterationCompleted;
        private List<Transition<RenderContext<RenderableState>>> firstPersonPositioningReloading;
        private List<Transition<RenderContext<RenderableState>>> firstPersonLeftHandPositioningReloading;
        private List<Transition<RenderContext<RenderableState>>> firstPersonRightHandPositioningReloading;
        @Deprecated
        private List<Transition<RenderContext<RenderableState>>> thirdPersonPositioningReloading;
        @Deprecated
        private List<Transition<RenderContext<RenderableState>>> thirdPersonLeftHandPositioningReloading;
        @Deprecated
        private List<Transition<RenderContext<RenderableState>>> thirdPersonRightHandPositioningReloading;
        private List<Transition<RenderContext<RenderableState>>> firstPersonPositioningInspecting;
        private List<Transition<RenderContext<RenderableState>>> firstPersonLeftHandPositioningInspecting;
        private List<Transition<RenderContext<RenderableState>>> firstPersonRightHandPositioningInspecting;
        private TransitionContainer compoundReloadContainer = new TransitionContainer();
        private TransitionContainer compoundReloadEmptyContainer = new TransitionContainer();
        private TransitionContainer loadEmptyContainer = new TransitionContainer();
        private TransitionContainer unloadEmptyContainer = new TransitionContainer();
        public TransitionContainer tacticalReloadContainer = new TransitionContainer();
        private TransitionContainer compoundReloadADSContainer = new TransitionContainer();
        private List<Transition<RenderContext<RenderableState>>> firstPersonPositioningDrawing;
        private List<Transition<RenderContext<RenderableState>>> firstPersonLeftHandPositioningDrawing;
        private List<Transition<RenderContext<RenderableState>>> firstPersonRightHandPositioningDrawing;
        private List<Transition<RenderContext<RenderableState>>> firstPersonPositioningUnloading;
        private List<Transition<RenderContext<RenderableState>>> firstPersonLeftHandPositioningUnloading;
        private List<Transition<RenderContext<RenderableState>>> firstPersonRightHandPositioningUnloading;
        @Deprecated
        private List<Transition<RenderContext<RenderableState>>> thirdPersonPositioningUnloading;
        @Deprecated
        private List<Transition<RenderContext<RenderableState>>> thirdPersonLeftHandPositioningUnloading;
        @Deprecated
        private List<Transition<RenderContext<RenderableState>>> thirdPersonRightHandPositioningUnloading;
        private List<Transition<RenderContext<RenderableState>>> firstPersonPositioningLoadIteration;
        private List<Transition<RenderContext<RenderableState>>> firstPersonLeftHandPositioningLoadIteration;
        private List<Transition<RenderContext<RenderableState>>> firstPersonRightHandPositioningLoadIteration;
        private List<Transition<RenderContext<RenderableState>>> firstPersonPositioningAllLoadIterationsCompleted;
        private List<Transition<RenderContext<RenderableState>>> firstPersonLeftHandPositioningAllLoadIterationsCompleted;
        private List<Transition<RenderContext<RenderableState>>> firstPersonRightHandPositioningAllLoadIterationsCompleted;
        private long totalReloadingDuration;
        private long totalUnloadingDuration;
        private long totalDrawingDuration;
        private long totalLoadIterationDuration;
        private int recoilAnimationDuration = 100;
        private int shootingAnimationDuration = 100;
        private int loadIterationCompletedAnimationDuration = 100;
        private int prepareFirstLoadIterationAnimationDuration = 100;
        private int allLoadIterationAnimationsCompletedDuration = 100;
        private float normalRandomizingRate = 0.33f;
        private float firingRandomizingRate = 20.0f;
        private float zoomRandomizingRate = 0.25f;
        private float normalRandomizingAmplitude = 0.06f;
        private float zoomRandomizingAmplitude = 0.005f;
        private float firingRandomizingAmplitude = 0.03f;
        private LinkedHashMap<Part, Consumer<RenderContext<RenderableState>>> firstPersonCustomPositioning = new LinkedHashMap();
        private LinkedHashMap<Part, Consumer<RenderContext<RenderableState>>> firstPersonCustomPositioningProning = new LinkedHashMap();
        private LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> firstPersonCustomPositioningUnloading = new LinkedHashMap();
        private LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> firstPersonCustomPositioningReloading = new LinkedHashMap();
        @Deprecated
        private LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> thirdPersonCustomPositioningUnloading = new LinkedHashMap();
        @Deprecated
        private LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> thirdPersonCustomPositioningReloading = new LinkedHashMap();
        private LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> firstPersonCustomPositioningLoadIteration = new LinkedHashMap();
        private LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> firstPersonCustomPositioningLoadIterationsCompleted = new LinkedHashMap();
        private LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> firstPersonCustomPositioningInspecting = new LinkedHashMap();
        private LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> firstPersonCustomPositioningDrawing = new LinkedHashMap();
        private LinkedHashMap<Part, Consumer<RenderContext<RenderableState>>> firstPersonCustomPositioningRecoiled = new LinkedHashMap();
        private LinkedHashMap<Part, Consumer<RenderContext<RenderableState>>> firstPersonCustomPositioningProningRecoiled = new LinkedHashMap();
        private LinkedHashMap<Part, Consumer<RenderContext<RenderableState>>> firstPersonCustomPositioningZoomingRecoiled = new LinkedHashMap();
        private LinkedHashMap<Part, Consumer<RenderContext<RenderableState>>> firstPersonCustomPositioningZoomingShooting = new LinkedHashMap();
        private LinkedHashMap<Part, Consumer<RenderContext<RenderableState>>> firstPersonCustomPositioningLoadIterationCompleted = new LinkedHashMap();
        private LinkedHashMap<Part, Consumer<RenderContext<RenderableState>>> firstPersonCustomPositioningZooming = new LinkedHashMap();
        private List<Transition<RenderContext<RenderableState>>> firstPersonPositioningEjectSpentRound;
        private List<Transition<RenderContext<RenderableState>>> firstPersonLeftHandPositioningEjectSpentRound;
        private List<Transition<RenderContext<RenderableState>>> firstPersonRightHandPositioningEjectSpentRound;
        private LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> firstPersonCustomPositioningEjectSpentRound = new LinkedHashMap();
        private List<Transition<RenderContext<RenderableState>>> firstPersonPositioningEjectSpentRoundAimed;
        private List<Transition<RenderContext<RenderableState>>> firstPersonLeftHandPositioningEjectSpentRoundAimed;
        private List<Transition<RenderContext<RenderableState>>> firstPersonRightHandPositioningEjectSpentRoundAimed;
        private LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> firstPersonCustomPositioningEjectSpentRoundAimed = new LinkedHashMap();
        private boolean hasRecoilPositioningDefined;
        public Transform firstPersonTransform;
        public Transform firstPersonLeftHandTransform;
        public Transform firstPersonRightHandTransform;
        public Transform firstPersonZoomingTransform;
        public Transform firstPersonLeftHandZoomingTransform;
        public Transform firstPersonRightHandZoomingTransform;
        private boolean compoundReloadUsesTactical;
        private boolean compoundReloadEmptyUsesTactical;
        private boolean hasTacticalReload;
        private boolean hasUnloadEmpty;
        private boolean hasLoadEmpty;
        private boolean hasCompoundReloadEmpty;
        private boolean hasCompoundReload;
        private boolean hasLoad;
        private boolean hasUnload;
        private boolean hasDraw;
        private boolean hasInspect;
        private boolean hasEjectSpentRound;
        private boolean hasEjectSpentRoundAimed;
        protected ItemAttachment<Weapon>[] actionPiece;
        protected Transform actionPieceTransform;
        private String animationFileName;

        public boolean isHasTacticalReload() {
            return this.hasTacticalReload;
        }

        public void setHasTacticalReload(boolean hasTacticalReload) {
            this.hasTacticalReload = hasTacticalReload;
        }

        public boolean isHasUnloadEmpty() {
            return this.hasUnloadEmpty;
        }

        public void setHasUnloadEmpty(boolean hasUnloadEmpty) {
            this.hasUnloadEmpty = hasUnloadEmpty;
        }

        public boolean isHasLoadEmpty() {
            return this.hasLoadEmpty;
        }

        public void setHasLoadEmpty(boolean hasLoadEmpty) {
            this.hasLoadEmpty = hasLoadEmpty;
        }

        public boolean isHasCompoundReloadEmpty() {
            return this.hasCompoundReloadEmpty;
        }

        public void setHasCompoundReloadEmpty(boolean hasCompoundReloadEmpty) {
            this.hasCompoundReloadEmpty = hasCompoundReloadEmpty;
        }

        public boolean isHasCompoundReload() {
            return this.hasCompoundReload;
        }

        public void setHasCompoundReload(boolean hasCompoundReload) {
            this.hasCompoundReload = hasCompoundReload;
        }

        public boolean isHasLoad() {
            return this.hasLoad;
        }

        public void setHasLoad(boolean hasLoad) {
            this.hasLoad = hasLoad;
        }

        public boolean isHasUnload() {
            return this.hasUnload;
        }

        public void setHasUnload(boolean hasUnload) {
            this.hasUnload = hasUnload;
        }

        public boolean isHasDraw() {
            return this.hasDraw;
        }

        public void setHasDraw(boolean hasDraw) {
            this.hasDraw = hasDraw;
        }

        public boolean isHasInspect() {
            return this.hasInspect;
        }

        public void setHasInspect(boolean hasInspect) {
            this.hasInspect = hasInspect;
        }

        public long getTacticalReloadDuration() {
            return this.tacticalReloadContainer.getDuration();
        }

        public long getCompoundReloadDuration() {
            return this.compoundReloadContainer.getDuration();
        }

        public long getCompoundReloadEmptyDuration() {
            return this.compoundReloadEmptyContainer.getDuration();
        }

        public Builder withModel(ModelBase model) {
            this.model = model;
            return this;
        }

        public Builder withBakedModel(WavefrontModel bakedModel) {
            this.bakedModel = bakedModel;
            return this;
        }

        public Builder withActionPiece(ItemAttachment<Weapon> ... attachment) {
            this.actionPiece = attachment;
            return this;
        }

        public Builder withActionTransform(Transform transform) {
            this.actionPieceTransform = transform;
            return this;
        }

        @Deprecated
        public Builder withShootingAnimationDuration(int shootingAnimationDuration) {
            this.shootingAnimationDuration = shootingAnimationDuration;
            return this;
        }

        @Deprecated
        public Builder withRecoilAnimationDuration(int recoilAnimationDuration) {
            this.recoilAnimationDuration = recoilAnimationDuration;
            return this;
        }

        @Deprecated
        public Builder withPrepareFirstLoadIterationAnimationDuration(int prepareFirstLoadIterationAnimationDuration) {
            this.prepareFirstLoadIterationAnimationDuration = prepareFirstLoadIterationAnimationDuration;
            return this;
        }

        @Deprecated
        public Builder withAllLoadIterationAnimationsCompletedDuration(int allLoadIterationAnimationsCompletedDuration) {
            this.allLoadIterationAnimationsCompletedDuration = allLoadIterationAnimationsCompletedDuration;
            return this;
        }

        public Builder withNormalRandomizingRate(float normalRandomizingRate) {
            this.normalRandomizingRate = normalRandomizingRate;
            return this;
        }

        public Builder withZoomRandomizingRate(float zoomRandomizingRate) {
            this.zoomRandomizingRate = zoomRandomizingRate;
            return this;
        }

        public Builder withFiringRandomizingRate(float firingRandomizingRate) {
            this.firingRandomizingRate = firingRandomizingRate;
            return this;
        }

        public Builder withFiringRandomizingAmplitude(float firingRandomizingAmplitude) {
            this.firingRandomizingAmplitude = firingRandomizingAmplitude;
            return this;
        }

        public Builder withNormalRandomizingAmplitude(float firingRandomizingRate) {
            this.firingRandomizingRate = firingRandomizingRate;
            return this;
        }

        public Builder withZoomRandomizingAmplitude(float zoomRandomizingAmplitude) {
            this.zoomRandomizingAmplitude = zoomRandomizingAmplitude;
            return this;
        }

        public Builder withTextureName(String textureName) {
            this.textureName = textureName + ".png";
            return this;
        }

        public Builder withADSBeizer(Vec3d beizer) {
            this.beizer = beizer;
            return this;
        }

        public Builder withWeaponProximity(float weaponProximity) {
            return this;
        }

        public Builder withYOffsetZoom(float yOffsetZoom) {
            return this;
        }

        public Builder withXOffsetZoom(float xOffsetZoom) {
            return this;
        }

        public Builder withEntityPositioning(Consumer<ItemStack> entityPositioning) {
            this.entityPositioning = entityPositioning;
            return this;
        }

        @Deprecated
        public Builder withInventoryPositioning(Consumer<ItemStack> inventoryPositioning) {
            this.inventoryPositioning = inventoryPositioning;
            return this;
        }

        public Builder withThirdPersonPositioning(Consumer<RenderContext<RenderableState>> thirdPersonPositioning) {
            this.thirdPersonPositioning = thirdPersonPositioning;
            return this;
        }

        public Builder withFirstPersonPositioning(Consumer<RenderContext<RenderableState>> firstPersonPositioning) {
            this.firstPersonPositioning = firstPersonPositioning;
            return this;
        }

        public Builder withFirstPersonPositioningProning(Consumer<RenderContext<RenderableState>> firstPersonPositioningProning) {
            this.firstPersonPositioningProning = firstPersonPositioningProning;
            return this;
        }

        @Deprecated
        public Builder withFirstPersonPositioningRunning(Consumer<RenderContext<RenderableState>> firstPersonPositioningRunning) {
            return this;
        }

        public Builder withFirstPersonPositioningZooming(Consumer<RenderContext<RenderableState>> firstPersonPositioningZooming) {
            this.firstPersonPositioningZooming = firstPersonPositioningZooming;
            return this;
        }

        @Deprecated
        public Builder withFirstPersonPositioningRecoiled(Consumer<RenderContext<RenderableState>> firstPersonPositioningRecoiled) {
            return this;
        }

        @Deprecated
        public Builder withFirstPersonPositioningProningRecoiled(Consumer<RenderContext<RenderableState>> firstPersonPositioningProningRecoiled) {
            return this;
        }

        public Builder withFirstPersonPositioningShooting(Consumer<RenderContext<RenderableState>> firstPersonPositioningShooting) {
            this.firstPersonPositioningShooting = firstPersonPositioningShooting;
            return this;
        }

        public Builder withFirstPersonPositioningProningShooting(Consumer<RenderContext<RenderableState>> firstPersonPositioningProningShooting) {
            this.firstPersonPositioningProningShooting = firstPersonPositioningProningShooting;
            return this;
        }

        @Deprecated
        public Builder withFirstPersonPositioningZoomingRecoiled(Consumer<RenderContext<RenderableState>> firstPersonPositioningZoomingRecoiled) {
            return this;
        }

        public Builder withFirstPersonPositioningZoomingShooting(Consumer<RenderContext<RenderableState>> firstPersonPositioningZoomingShooting) {
            this.firstPersonPositioningZoomingShooting = firstPersonPositioningZoomingShooting;
            return this;
        }

        public Builder withFirstPersonPositioningLoadIterationCompleted(Consumer<RenderContext<RenderableState>> firstPersonPositioningLoadIterationCompleted) {
            this.firstPersonPositioningLoadIterationCompleted = firstPersonPositioningLoadIterationCompleted;
            return this;
        }

        public final Builder withFirstPersonPositioningReloadingNew(List<Transition<RenderContext<RenderableState>>> transitions) {
            this.firstPersonPositioningReloading = transitions;
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonPositioningReloading(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonPositioningReloading = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonPositioningUnloading(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonPositioningUnloading = Arrays.asList(transitions);
            return this;
        }

        public final Builder withFirstPersonPositioningUnloading(List<Transition<RenderContext<RenderableState>>> transitions) {
            this.firstPersonPositioningUnloading = transitions;
            return this;
        }

        @Deprecated
        @SafeVarargs
        public final Builder withThirdPersonPositioningReloading(Transition<RenderContext<RenderableState>> ... transitions) {
            this.thirdPersonPositioningReloading = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withThirdPersonPositioningUnloading(Transition<RenderContext<RenderableState>> ... transitions) {
            this.thirdPersonPositioningUnloading = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonPositioningInspecting(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonPositioningInspecting = Arrays.asList(transitions);
            return this;
        }

        public final Builder withFirstPersonPositioningInspecting(List<Transition<RenderContext<RenderableState>>> transitions) {
            this.firstPersonPositioningInspecting = transitions;
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonPositioningDrawing(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonPositioningDrawing = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonPositioningLoadIteration(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonPositioningLoadIteration = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonPositioningAllLoadIterationsCompleted(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonPositioningAllLoadIterationsCompleted = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonPositioningEjectSpentRound(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonPositioningEjectSpentRound = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonPositioningEjectSpentRoundAimed(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonPositioningEjectSpentRoundAimed = Arrays.asList(transitions);
            return this;
        }

        public Builder withFirstPersonPositioningModifying(Consumer<RenderContext<RenderableState>> firstPersonPositioningModifying) {
            this.firstPersonPositioningModifying = firstPersonPositioningModifying;
            return this;
        }

        public Builder withFirstPersonPositioningModifyingAlt(Consumer<RenderContext<RenderableState>> firstPersonPositioningModifyingAlt) {
            this.firstPersonPositioningModifyingAlt = firstPersonPositioningModifyingAlt;
            return this;
        }

        public Builder withFirstPersonHandPositioning(Consumer<RenderContext<RenderableState>> leftHand, Consumer<RenderContext<RenderableState>> rightHand) {
            this.firstPersonLeftHandPositioning = leftHand;
            this.firstPersonRightHandPositioning = rightHand;
            return this;
        }

        public Builder withFirstPersonHandPositioningProning(Consumer<RenderContext<RenderableState>> leftHand, Consumer<RenderContext<RenderableState>> rightHand) {
            this.firstPersonLeftHandPositioningProning = leftHand;
            this.firstPersonRightHandPositioningProning = rightHand;
            return this;
        }

        @Deprecated
        public Builder withFirstPersonHandPositioningRunning(Consumer<RenderContext<RenderableState>> leftHand, Consumer<RenderContext<RenderableState>> rightHand) {
            return this;
        }

        public Builder withFirstPersonHandPositioningZooming(Consumer<RenderContext<RenderableState>> leftHand, Consumer<RenderContext<RenderableState>> rightHand) {
            this.firstPersonLeftHandPositioningZooming = leftHand;
            this.firstPersonRightHandPositioningZooming = rightHand;
            return this;
        }

        @Deprecated
        public Builder withFirstPersonHandPositioningRecoiled(Consumer<RenderContext<RenderableState>> leftHand, Consumer<RenderContext<RenderableState>> rightHand) {
            return this;
        }

        @Deprecated
        public Builder withFirstPersonHandPositioningProningRecoiled(Consumer<RenderContext<RenderableState>> leftHand, Consumer<RenderContext<RenderableState>> rightHand) {
            return this;
        }

        public Builder withFirstPersonHandPositioningShooting(Consumer<RenderContext<RenderableState>> leftHand, Consumer<RenderContext<RenderableState>> rightHand) {
            this.firstPersonLeftHandPositioningShooting = leftHand;
            this.firstPersonRightHandPositioningShooting = rightHand;
            return this;
        }

        public Builder withFirstPersonHandPositioningProningShooting(Consumer<RenderContext<RenderableState>> leftHand, Consumer<RenderContext<RenderableState>> rightHand) {
            this.firstPersonLeftHandPositioningProningShooting = leftHand;
            this.firstPersonRightHandPositioningProningShooting = rightHand;
            return this;
        }

        public Builder withFirstPersonHandPositioningLoadIterationCompleted(Consumer<RenderContext<RenderableState>> leftHand, Consumer<RenderContext<RenderableState>> rightHand) {
            this.firstPersonLeftHandPositioningLoadIterationCompleted = leftHand;
            this.firstPersonRightHandPositioningLoadIterationCompleted = rightHand;
            return this;
        }

        public final Builder withFirstPersonLeftHandPositioningReloading(List<Transition<RenderContext<RenderableState>>> transitions) {
            this.firstPersonLeftHandPositioningReloading = transitions;
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonLeftHandPositioningReloading(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonLeftHandPositioningReloading = Arrays.asList(transitions);
            return this;
        }

        @Deprecated
        @SafeVarargs
        public final Builder withThirdPersonLeftHandPositioningReloading(Transition<RenderContext<RenderableState>> ... transitions) {
            this.thirdPersonLeftHandPositioningReloading = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonLeftHandPositioningInspecting(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonLeftHandPositioningInspecting = Arrays.asList(transitions);
            return this;
        }

        public final Builder withFirstPersonLeftHandPositioningInspecting(List<Transition<RenderContext<RenderableState>>> transitions) {
            this.firstPersonLeftHandPositioningInspecting = transitions;
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonLeftHandPositioningDrawing(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonLeftHandPositioningDrawing = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonLeftHandPositioningEjectSpentRound(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonLeftHandPositioningEjectSpentRound = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonLeftHandPositioningEjectSpentRoundAimed(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonLeftHandPositioningEjectSpentRoundAimed = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonLeftHandPositioningUnloading(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonLeftHandPositioningUnloading = Arrays.asList(transitions);
            return this;
        }

        public final Builder withFirstPersonLeftHandPositioningUnloading(List<Transition<RenderContext<RenderableState>>> transitions) {
            this.firstPersonLeftHandPositioningUnloading = transitions;
            return this;
        }

        @SafeVarargs
        public final Builder withThirdPersonLeftHandPositioningUnloading(Transition<RenderContext<RenderableState>> ... transitions) {
            this.thirdPersonLeftHandPositioningUnloading = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonLeftHandPositioningLoadIteration(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonLeftHandPositioningLoadIteration = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonLeftHandPositioningAllLoadIterationsCompleted(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonLeftHandPositioningAllLoadIterationsCompleted = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonRightHandPositioningReloading(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonRightHandPositioningReloading = Arrays.asList(transitions);
            return this;
        }

        @Deprecated
        @SafeVarargs
        public final Builder withThirdPersonRightHandPositioningReloading(Transition<RenderContext<RenderableState>> ... transitions) {
            this.thirdPersonRightHandPositioningReloading = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonRightHandPositioningUnloading(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonRightHandPositioningUnloading = Arrays.asList(transitions);
            return this;
        }

        public final Builder withFirstPersonRightHandPositioningUnloading(List<Transition<RenderContext<RenderableState>>> transitions) {
            this.firstPersonRightHandPositioningUnloading = transitions;
            return this;
        }

        @Deprecated
        @SafeVarargs
        public final Builder withThirdPersonRightHandPositioningUnloading(Transition<RenderContext<RenderableState>> ... transitions) {
            this.thirdPersonRightHandPositioningUnloading = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonRightHandPositioningInspecting(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonRightHandPositioningInspecting = Arrays.asList(transitions);
            return this;
        }

        public final Builder withFirstPersonRightHandPositioningInspecting(List<Transition<RenderContext<RenderableState>>> transitions) {
            this.firstPersonRightHandPositioningInspecting = transitions;
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonRightHandPositioningDrawing(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonRightHandPositioningDrawing = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonRightHandPositioningEjectSpentRound(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonRightHandPositioningEjectSpentRound = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonRightHandPositioningEjectSpentRoundAimed(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonRightHandPositioningEjectSpentRoundAimed = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonRightHandPositioningLoadIteration(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonRightHandPositioningLoadIteration = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonRightHandPositioningAllLoadIterationsCompleted(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonRightHandPositioningAllLoadIterationsCompleted = Arrays.asList(transitions);
            return this;
        }

        public Builder withFirstPersonHandPositioningModifying(Consumer<RenderContext<RenderableState>> leftHand, Consumer<RenderContext<RenderableState>> rightHand) {
            this.firstPersonLeftHandPositioningModifying = leftHand;
            this.firstPersonRightHandPositioningModifying = rightHand;
            return this;
        }

        public Builder withFirstPersonHandPositioningModifyingAlt(Consumer<RenderContext<RenderableState>> leftHand, Consumer<RenderContext<RenderableState>> rightHand) {
            this.firstPersonLeftHandPositioningModifyingAlt = leftHand;
            this.firstPersonRightHandPositioningModifyingAlt = rightHand;
            return this;
        }

        public Builder withFirstPersonCustomPositioning(Part part, Consumer<RenderContext<RenderableState>> positioning) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            if (this.firstPersonCustomPositioning.put(part, positioning) != null) {
                throw new IllegalArgumentException("Part " + part + " already added");
            }
            return this;
        }

        public Builder withFirstPersonCustomPositioningProning(Part part, Consumer<RenderContext<RenderableState>> positioning) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            if (this.firstPersonCustomPositioningProning.put(part, positioning) != null) {
                throw new IllegalArgumentException("Part " + part + " already added");
            }
            return this;
        }

        public Builder withFirstPersonCustomPositioningZooming(Part part, Consumer<RenderContext<RenderableState>> positioning) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            if (this.firstPersonCustomPositioningZooming.put(part, positioning) != null) {
                throw new IllegalArgumentException("Part " + part + " already added");
            }
            return this;
        }

        @Deprecated
        public Builder withFirstPersonPositioningCustomRecoiled(Part part, Consumer<RenderContext<RenderableState>> positioning) {
            return this;
        }

        @Deprecated
        public Builder withFirstPersonPositioningCustomProningRecoiled(Part part, Consumer<RenderContext<RenderableState>> positioning) {
            return this;
        }

        public Builder withFirstPersonPositioningCustomZoomingShooting(Part part, Consumer<RenderContext<RenderableState>> positioning) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            if (this.firstPersonCustomPositioningZoomingShooting.put(part, positioning) != null) {
                throw new IllegalArgumentException("Part " + part + " already added");
            }
            return this;
        }

        @Deprecated
        public Builder withFirstPersonPositioningCustomZoomingRecoiled(Part part, Consumer<RenderContext<RenderableState>> positioning) {
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonCustomPositioningReloading(Part part, Transition<RenderContext<RenderableState>> ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningReloading.put(part, Arrays.asList(transitions));
            return this;
        }

        public final Builder withFirstPersonCustomPositioningReloading(Part part, List<Transition<RenderContext<RenderableState>>> transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningReloading.put(part, transitions);
            return this;
        }

        @Deprecated
        @SafeVarargs
        public final Builder withThirdPersonCustomPositioningReloading(Part part, Transition<RenderContext<RenderableState>> ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.thirdPersonCustomPositioningReloading.put(part, Arrays.asList(transitions));
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonCustomPositioningInspecting(Part part, Transition<RenderContext<RenderableState>> ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningInspecting.put(part, Arrays.asList(transitions));
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonCustomPositioningDrawing(Part part, Transition<RenderContext<RenderableState>> ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningDrawing.put(part, Arrays.asList(transitions));
            return this;
        }

        public Builder withFirstPersonCustomPositioningLoadIterationCompleted(Part part, Consumer<RenderContext<RenderableState>> positioning) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            if (this.firstPersonCustomPositioningLoadIterationCompleted.put(part, positioning) != null) {
                throw new IllegalArgumentException("Part " + part + " already added");
            }
            return this;
        }

        public final Builder withFirstPersonCustomPositioningUnloading(Part part, List<Transition<RenderContext<RenderableState>>> transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningUnloading.put(part, transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonCustomPositioningUnloading(Part part, Transition<RenderContext<RenderableState>> ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningUnloading.put(part, Arrays.asList(transitions));
            return this;
        }

        @Deprecated
        @SafeVarargs
        public final Builder withThirdPersonCustomPositioningUnloading(Part part, Transition<RenderContext<RenderableState>> ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.thirdPersonCustomPositioningUnloading.put(part, Arrays.asList(transitions));
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonCustomPositioningEjectSpentRound(Part part, Transition<RenderContext<RenderableState>> ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningEjectSpentRound.put(part, Arrays.asList(transitions));
            return this;
        }

        public final Builder withFirstPersonCustomPositioningEjectSpentRound(Part part, List<Transition<RenderContext<RenderableState>>> list) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningEjectSpentRound.put(part, list);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonCustomPositioningEjectSpentRoundAimed(Part part, Transition<RenderContext<RenderableState>> ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningEjectSpentRoundAimed.put(part, Arrays.asList(transitions));
            return this;
        }

        public final Builder withFirstPersonCustomPositioningEjectSpentRoundAimed(Part part, List<Transition<RenderContext<RenderableState>>> list) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningEjectSpentRoundAimed.put(part, list);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonCustomPositioningLoadIteration(Part part, Transition<RenderContext<RenderableState>> ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningLoadIteration.put(part, Arrays.asList(transitions));
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonCustomPositioningAllLoadIterationsCompleted(Part part, Transition<RenderContext<RenderableState>> ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningLoadIterationsCompleted.put(part, Arrays.asList(transitions));
            return this;
        }

        public boolean isUsingNewSystem() {
            return this.threePointOh;
        }

        public void setUsingThreePointOh() {
            this.threePointOh = true;
        }

        public Builder withFirstPersonPositioning(Transform firstPersonTransform) {
            this.firstPersonTransform = firstPersonTransform;
            this.firstPersonPositioning = firstPersonTransform.getAsPosition();
            return this;
        }

        public Builder withFPSZooming(Transform zooming) {
            this.firstPersonZoomingTransform = zooming;
            this.firstPersonPositioningZooming = zooming.getAsPosition();
            return this;
        }

        public Builder withFirstPersonHandPositioning(Transform leftHand, Transform rightHand) {
            this.firstPersonLeftHandTransform = leftHand;
            this.firstPersonRightHandTransform = rightHand;
            this.firstPersonLeftHandPositioning = leftHand.getAsPosition();
            this.firstPersonRightHandPositioning = rightHand.getAsPosition();
            return this;
        }

        public void checkDefaults() {
            if (this.firstPersonTransform == null) {
                this.firstPersonTransform = Transform.NULL.copy();
            }
            if (this.firstPersonLeftHandTransform == null) {
                this.firstPersonLeftHandTransform = Transform.NULL.copy();
            }
            if (this.firstPersonRightHandTransform == null) {
                this.firstPersonRightHandTransform = Transform.NULL.copy();
            }
        }

        public Builder setupModernMagazineAnimations(String animationFile, Part ... parts) {
            this.setAnimationFileName(animationFile);
            for (Part p : parts) {
                Vec3d r = ((ItemMagazine)p).rotationPoint;
                if (this.hasUnloadEmpty) {
                    this.withUnloadEmptyCustom(p, BBLoader.getAnimation(animationFile, "unloadempty", "magazine").getTransitionList(Transform.NULL.copy().withRotationPoint(r.field_72450_a, r.field_72448_b, r.field_72449_c), BBLoader.HANDDIVISOR));
                }
                if (this.hasLoadEmpty) {
                    this.withLoadEmptyCustom(p, BBLoader.getAnimation(animationFile, "loadempty", "magazine").getTransitionList(Transform.NULL.copy().withRotationPoint(r.field_72450_a, r.field_72448_b, r.field_72449_c), BBLoader.HANDDIVISOR));
                }
                if (this.hasTacticalReload) {
                    this.withTacticalReloadCustom(p, BBLoader.getAnimation(animationFile, "reloadtactical", "magazine").getTransitionList(Transform.NULL.copy().withRotationPoint(r.field_72450_a, r.field_72448_b, r.field_72449_c), BBLoader.HANDDIVISOR));
                }
                if (this.hasLoad) {
                    this.withFirstPersonCustomPositioningReloading(p, BBLoader.getAnimation(animationFile, "load", "magazine").getTransitionList(Transform.NULL.copy().withRotationPoint(r.field_72450_a, r.field_72448_b, r.field_72449_c), BBLoader.HANDDIVISOR));
                }
                if (this.hasUnload) {
                    this.withFirstPersonCustomPositioningUnloading(p, BBLoader.getAnimation(animationFile, "unload", "magazine").getTransitionList(Transform.NULL.copy().withRotationPoint(r.field_72450_a, r.field_72448_b, r.field_72449_c), BBLoader.HANDDIVISOR));
                }
                if (this.hasCompoundReload) {
                    this.withFirstPersonCustomPositioningCompoundReloading(p, BBLoader.getAnimation(animationFile, "reload", "magazine").getTransitionList(Transform.NULL.copy().withRotationPoint(r.field_72450_a, r.field_72448_b, r.field_72449_c), BBLoader.HANDDIVISOR));
                }
                if (!this.hasCompoundReloadEmpty) continue;
                this.withFPSCustomCompoundReloadingEmpty(p, BBLoader.getAnimation(animationFile, "reloadempty", "magazine").getTransitionList(Transform.NULL.copy().withRotationPoint(r.field_72450_a, r.field_72448_b, r.field_72449_c), BBLoader.HANDDIVISOR));
            }
            if (this.hasCompoundReloadEmpty && this.compoundReloadEmptyUsesTactical) {
                this.withFPSCustomCompoundReloadingEmpty(SpecialAttachments.MagicMag.getRenderablePart(), BBLoader.getAnimation(animationFile, "reloadempty", "magazine_extra").getTransitionList(Transform.NULL.copy(), BBLoader.HANDDIVISOR));
            }
            if (this.hasCompoundReload && this.compoundReloadUsesTactical) {
                this.withFirstPersonCustomPositioningCompoundReloading(SpecialAttachments.MagicMag.getRenderablePart(), BBLoader.getAnimation(animationFile, "reload", "magazine_extra").getTransitionList(Transform.NULL.copy(), BBLoader.HANDDIVISOR));
            }
            return this;
        }

        public static boolean isOnServer() {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_71214_G() != null;
        }

        public Builder setupModernAnimations(String animationFile, ItemAttachment<Weapon> aR15Action) {
            SingleAnimation compoundEmpty;
            SingleAnimation compound;
            if (FMLCommonHandler.instance().getSide().isServer()) {
                return this;
            }
            String mainBoneName = "main";
            String leftBoneName = "lefthand";
            String rightBoneName = "righthand";
            AnimationSet set = BBLoader.getAnimationSet(animationFile);
            if (set.containsKey("loadempty")) {
                this.hasLoadEmpty = true;
            }
            if (set.containsKey("unloadempty")) {
                this.hasUnloadEmpty = true;
            }
            if (set.containsKey("reloadtactical")) {
                this.hasTacticalReload = true;
            }
            if (set.containsKey("reload")) {
                this.hasCompoundReload = true;
            }
            if (set.containsKey("reloadempty")) {
                this.hasCompoundReloadEmpty = true;
            }
            if (set.containsKey("inspect")) {
                this.hasInspect = true;
            }
            if (set.containsKey("draw")) {
                this.hasDraw = true;
            }
            if (set.containsKey("load")) {
                this.hasLoad = true;
            }
            if (set.containsKey("unload")) {
                this.hasUnload = true;
            }
            if (set.containsKey("ejectspentround")) {
                this.hasEjectSpentRound = true;
            }
            if (set.containsKey("ejectspentroundaimed")) {
                this.hasEjectSpentRoundAimed = true;
            }
            if ((compound = set.getSingleAnimation("reload")) != null && compound.hasBone("magazine_extra") && compound.getBone((String)"magazine_extra").bbTransition.size() > 1) {
                this.compoundReloadUsesTactical = true;
            }
            if ((compoundEmpty = set.getSingleAnimation("reloadempty")) != null && compoundEmpty.hasBone("magazine_extra") && compoundEmpty.getBone((String)"magazine_extra").bbTransition.size() > 1) {
                this.compoundReloadEmptyUsesTactical = true;
            }
            if (this.hasLoadEmpty) {
                this.setupLoadEmpty(animationFile, "loadempty", "main", "lefthand", "righthand");
            }
            if (this.hasUnloadEmpty) {
                this.setupUnloadEmpty(animationFile, "unloadempty", "main", "lefthand", "righthand");
            }
            if (this.hasTacticalReload) {
                this.setupTacticalReload(animationFile, "reloadtactical", "main", "lefthand", "righthand");
            }
            if (this.hasInspect) {
                this.setupInspectAnimations(animationFile, "inspect", "main", "lefthand", "righthand");
            }
            if (this.hasCompoundReload) {
                if (this.firstPersonZoomingTransform != null) {
                    this.setupModernContainerADS(animationFile, "reload", this.compoundReloadADSContainer);
                }
                this.setupCompoundReload(animationFile, "reload", "main", "lefthand", "righthand");
            }
            if (this.hasLoad) {
                this.setupReload(animationFile, "load", "main", "lefthand", "righthand");
            }
            if (this.hasUnload) {
                this.setupUnload(animationFile, "unload", "main", "lefthand", "righthand");
            }
            if (this.hasDraw) {
                this.setupDraw(animationFile, "draw", "main", "lefthand", "righthand");
            }
            if (this.hasCompoundReloadEmpty) {
                this.setupCompoundReloadEmpty(animationFile, "reloadempty", "main", "lefthand", "righthand");
            }
            if (this.hasEjectSpentRound) {
                this.setupModernEjectSpentRoundAnimation(animationFile);
            }
            if (this.hasEjectSpentRoundAimed) {
                this.setupModernEjectSpentRoundAimedAnimation(animationFile);
            }
            this.setupCustomKeyedPart(aR15Action, animationFile, "action");
            return this;
        }

        public Builder setupModernEjectSpentRoundAnimation(String animationFile) {
            if (FMLCommonHandler.instance().getSide().isServer()) {
                return this;
            }
            AnimationData main = BBLoader.getAnimation(animationFile, "ejectspentround", "main");
            AnimationData left = BBLoader.getAnimation(animationFile, "ejectspentround", "lefthand");
            AnimationData right = BBLoader.getAnimation(animationFile, "ejectspentround", "righthand");
            this.checkDefaults();
            this.firstPersonPositioningEjectSpentRound = main.getTransitionList(this.firstPersonTransform, BBLoader.GENDIVISOR, false);
            this.firstPersonLeftHandPositioningEjectSpentRound = left.getTransitionList(this.firstPersonLeftHandTransform, BBLoader.HANDDIVISOR, false);
            this.firstPersonRightHandPositioningEjectSpentRound = right.getTransitionList(this.firstPersonRightHandTransform, BBLoader.HANDDIVISOR, false);
            return this;
        }

        public Builder setupModernEjectSpentRoundAimedAnimation(String animationFile) {
            if (FMLCommonHandler.instance().getSide().isServer()) {
                return this;
            }
            AnimationData main = BBLoader.getAnimation(animationFile, "ejectspentround", "main");
            AnimationData left = BBLoader.getAnimation(animationFile, "ejectspentround", "lefthand");
            AnimationData right = BBLoader.getAnimation(animationFile, "ejectspentround", "righthand");
            this.checkDefaults();
            this.firstPersonPositioningEjectSpentRoundAimed = main.getTransitionList(this.firstPersonTransform, BBLoader.GENDIVISOR, false);
            this.firstPersonLeftHandPositioningEjectSpentRoundAimed = left.getTransitionList(this.firstPersonLeftHandTransform, BBLoader.HANDDIVISOR, false);
            this.firstPersonRightHandPositioningEjectSpentRoundAimed = right.getTransitionList(this.firstPersonRightHandTransform, BBLoader.HANDDIVISOR, false);
            return this;
        }

        public Builder setupBoltActionAnimations(ItemAttachment<Weapon> action, String animationFile, String partKey) {
            if (FMLCommonHandler.instance().getSide().isServer()) {
                return this;
            }
            AnimationSet set = BBLoader.getAnimationSet(animationFile);
            Vec3d rotPoint = action.rotationPoint;
            Part aR15Action = action.getRenderablePart();
            if (this.hasEjectSpentRound && set.getSingleAnimation("ejectspentround").hasBone(partKey)) {
                this.withFirstPersonCustomPositioningUnloading(aR15Action, BBLoader.getAnimation(animationFile, "ejectspentround", partKey).getTransitionList(Transform.NULL.copy().withRotationPoint(rotPoint.field_72450_a, rotPoint.field_72448_b, rotPoint.field_72449_c), BBLoader.HANDDIVISOR));
            }
            if (this.hasEjectSpentRoundAimed && set.getSingleAnimation("ejectspentroundaimed").hasBone(partKey)) {
                this.withFirstPersonCustomPositioningUnloading(aR15Action, BBLoader.getAnimation(animationFile, "ejectspentroundaimed", partKey).getTransitionList(Transform.NULL.copy().withRotationPoint(rotPoint.field_72450_a, rotPoint.field_72448_b, rotPoint.field_72449_c), BBLoader.HANDDIVISOR));
            }
            return this;
        }

        public Builder setupCustomKeyedPart(ItemAttachment<Weapon> action, String animationFile, String partKey) {
            List<Transition<RenderContext<RenderableState>>> list;
            if (FMLCommonHandler.instance().getSide().isServer()) {
                return this;
            }
            AnimationSet set = BBLoader.getAnimationSet(animationFile);
            Vec3d rotPoint = action.rotationPoint;
            Part aR15Action = action.getRenderablePart();
            if (this.hasLoadEmpty && set.getSingleAnimation("loadempty").hasBone(partKey)) {
                this.withLoadEmptyCustom(aR15Action, BBLoader.getAnimation(animationFile, "loadempty", partKey).getTransitionList(Transform.NULL.copy().withRotationPoint(rotPoint.field_72450_a, rotPoint.field_72448_b, rotPoint.field_72449_c), BBLoader.HANDDIVISOR));
            }
            if (this.hasUnloadEmpty && set.getSingleAnimation("unloadempty").hasBone(partKey)) {
                this.withUnloadEmptyCustom(aR15Action, BBLoader.getAnimation(animationFile, "unloadempty", partKey).getTransitionList(Transform.NULL.copy().withRotationPoint(rotPoint.field_72450_a, rotPoint.field_72448_b, rotPoint.field_72449_c), BBLoader.HANDDIVISOR));
            }
            if (this.hasCompoundReload && set.getSingleAnimation("reload").hasBone(partKey)) {
                this.withFirstPersonCustomPositioningCompoundReloading(aR15Action, BBLoader.getAnimation(animationFile, "reload", partKey).getTransitionList(Transform.NULL.copy().withRotationPoint(rotPoint.field_72450_a, rotPoint.field_72448_b, rotPoint.field_72449_c), BBLoader.HANDDIVISOR));
            }
            if (this.hasCompoundReloadEmpty && set.getSingleAnimation("reloadempty").hasBone(partKey)) {
                this.withFPSCustomCompoundReloadingEmpty(aR15Action, BBLoader.getAnimation(animationFile, "reloadempty", partKey).getTransitionList(Transform.NULL.copy().withRotationPoint(rotPoint.field_72450_a, rotPoint.field_72448_b, rotPoint.field_72449_c), BBLoader.HANDDIVISOR));
            }
            if (this.hasTacticalReload && set.getSingleAnimation("reloadtactical").hasBone(partKey)) {
                this.withTacticalReloadCustom(aR15Action, BBLoader.getAnimation(animationFile, "reloadtactical", partKey).getTransitionList(Transform.NULL.copy().withRotationPoint(rotPoint.field_72450_a, rotPoint.field_72448_b, rotPoint.field_72449_c), BBLoader.HANDDIVISOR));
            }
            if (this.hasDraw && set.getSingleAnimation("draw").hasBone(partKey)) {
                this.withFirstPersonCustomPositioningDrawing(aR15Action, BBLoader.getAnimation(animationFile, "draw", partKey).getTransitionList(Transform.NULL.copy().withRotationPoint(rotPoint.field_72450_a, rotPoint.field_72448_b, rotPoint.field_72449_c), BBLoader.HANDDIVISOR));
            }
            if (this.hasInspect && set.getSingleAnimation("inspect").hasBone(partKey)) {
                this.withFirstPersonCustomPositioningInspecting(aR15Action, BBLoader.getAnimation(animationFile, "inspect", partKey).getTransitionList(Transform.NULL.copy().withRotationPoint(rotPoint.field_72450_a, rotPoint.field_72448_b, rotPoint.field_72449_c), BBLoader.HANDDIVISOR));
            }
            if (this.hasLoad && set.getSingleAnimation("load").hasBone(partKey)) {
                this.withFirstPersonCustomPositioningReloading(aR15Action, BBLoader.getAnimation(animationFile, "load", partKey).getTransitionList(Transform.NULL.copy().withRotationPoint(rotPoint.field_72450_a, rotPoint.field_72448_b, rotPoint.field_72449_c), BBLoader.HANDDIVISOR));
            }
            if (this.hasUnload && set.getSingleAnimation("unload").hasBone(partKey)) {
                this.withFirstPersonCustomPositioningUnloading(aR15Action, BBLoader.getAnimation(animationFile, "unload", partKey).getTransitionList(Transform.NULL.copy().withRotationPoint(rotPoint.field_72450_a, rotPoint.field_72448_b, rotPoint.field_72449_c), BBLoader.HANDDIVISOR));
            }
            if (this.hasEjectSpentRound && set.getSingleAnimation("ejectspentround").hasBone(partKey)) {
                list = BBLoader.getAnimation(animationFile, "ejectspentround", partKey).getTransitionList(Transform.NULL.copy().withRotationPoint(rotPoint.field_72450_a, rotPoint.field_72448_b, rotPoint.field_72449_c), BBLoader.HANDDIVISOR);
                this.withFirstPersonCustomPositioningEjectSpentRound(aR15Action, list);
            }
            if (this.hasEjectSpentRoundAimed && set.getSingleAnimation("ejectspentroundaimed").hasBone(partKey)) {
                list = BBLoader.getAnimation(animationFile, "ejectspentroundaimed", partKey).getTransitionList(Transform.NULL.copy().withRotationPoint(rotPoint.field_72450_a, rotPoint.field_72448_b, rotPoint.field_72449_c), BBLoader.HANDDIVISOR);
                this.withFirstPersonCustomPositioningEjectSpentRoundAimed(aR15Action, list);
            }
            return this;
        }

        public Builder setCompoundReloadTacticalFunctionality(boolean normal, boolean empty) {
            this.compoundReloadUsesTactical = normal;
            this.compoundReloadEmptyUsesTactical = empty;
            return this;
        }

        public Builder setupInspectAnimations(String animationFile, String anim, String mainBoneName, String leftHandBoneName, String rightHandBoneName) {
            AnimationData main = BBLoader.getAnimation(animationFile, anim, mainBoneName);
            AnimationData left = BBLoader.getAnimation(animationFile, anim, leftHandBoneName);
            AnimationData right = BBLoader.getAnimation(animationFile, anim, rightHandBoneName);
            this.checkDefaults();
            this.firstPersonPositioningInspecting = main.getTransitionList(this.firstPersonTransform, BBLoader.GENDIVISOR);
            this.firstPersonLeftHandPositioningInspecting = left.getTransitionList(this.firstPersonLeftHandTransform, BBLoader.HANDDIVISOR);
            this.firstPersonRightHandPositioningInspecting = right.getTransitionList(this.firstPersonRightHandTransform, BBLoader.HANDDIVISOR);
            return this;
        }

        public Builder setupCompoundReload(String animationFile, String anim, String mainBoneName, String leftHandBoneName, String rightHandBoneName) {
            AnimationData main = BBLoader.getAnimation(animationFile, anim, mainBoneName);
            AnimationData left = BBLoader.getAnimation(animationFile, anim, leftHandBoneName);
            AnimationData right = BBLoader.getAnimation(animationFile, anim, rightHandBoneName);
            this.checkDefaults();
            if (this.firstPersonZoomingTransform != null) {
                this.compoundReloadContainer.setFirstPerson(main.getTransitionListDual(this.firstPersonTransform, this.firstPersonZoomingTransform, BBLoader.GENDIVISOR));
            } else {
                this.compoundReloadContainer.setFirstPerson(main.getTransitionList(this.firstPersonTransform, BBLoader.GENDIVISOR));
            }
            this.compoundReloadContainer.setLeftHand(left.getTransitionList(this.firstPersonLeftHandTransform, BBLoader.HANDDIVISOR));
            this.compoundReloadContainer.setRightHand(right == null ? null : right.getTransitionList(this.firstPersonRightHandTransform, BBLoader.HANDDIVISOR));
            this.compoundReloadContainer.setDuration();
            return this;
        }

        public Builder setupLoadEmpty(String animationFile, String anim, String mainBoneName, String leftHandBoneName, String rightHandBoneName) {
            AnimationData main = BBLoader.getAnimation(animationFile, anim, mainBoneName);
            AnimationData left = BBLoader.getAnimation(animationFile, anim, leftHandBoneName);
            AnimationData right = BBLoader.getAnimation(animationFile, anim, rightHandBoneName);
            this.checkDefaults();
            this.loadEmptyContainer.setFirstPerson(main.getTransitionList(this.firstPersonTransform, BBLoader.GENDIVISOR));
            this.loadEmptyContainer.setLeftHand(left.getTransitionList(this.firstPersonLeftHandTransform, BBLoader.HANDDIVISOR));
            this.loadEmptyContainer.setRightHand(right == null ? null : right.getTransitionList(this.firstPersonRightHandTransform, BBLoader.HANDDIVISOR));
            this.loadEmptyContainer.setDuration();
            return this;
        }

        public Builder setupUnloadEmpty(String animationFile, String anim, String mainBoneName, String leftHandBoneName, String rightHandBoneName) {
            AnimationData main = BBLoader.getAnimation(animationFile, anim, mainBoneName);
            AnimationData left = BBLoader.getAnimation(animationFile, anim, leftHandBoneName);
            AnimationData right = BBLoader.getAnimation(animationFile, anim, rightHandBoneName);
            this.checkDefaults();
            this.unloadEmptyContainer.setFirstPerson(main.getTransitionList(this.firstPersonTransform, BBLoader.GENDIVISOR));
            this.unloadEmptyContainer.setLeftHand(left.getTransitionList(this.firstPersonLeftHandTransform, BBLoader.HANDDIVISOR));
            this.unloadEmptyContainer.setRightHand(right == null ? null : right.getTransitionList(this.firstPersonRightHandTransform, BBLoader.HANDDIVISOR));
            this.unloadEmptyContainer.setDuration();
            return this;
        }

        public Builder setupModernContainer(String animationFile, String anim, TransitionContainer container) {
            AnimationData main = BBLoader.getAnimation(animationFile, anim, "main");
            AnimationData left = BBLoader.getAnimation(animationFile, anim, "lefthand");
            AnimationData right = BBLoader.getAnimation(animationFile, anim, "righthand");
            this.checkDefaults();
            container.setFirstPerson(main.getTransitionList(this.firstPersonTransform, BBLoader.GENDIVISOR));
            container.setLeftHand(left.getTransitionList(this.firstPersonLeftHandTransform, BBLoader.HANDDIVISOR));
            container.setRightHand(right == null ? null : right.getTransitionList(this.firstPersonRightHandTransform, BBLoader.HANDDIVISOR));
            container.setDuration();
            return this;
        }

        public Builder setupModernContainerADS(String animationFile, String anim, TransitionContainer container) {
            AnimationData main = BBLoader.getAnimation(animationFile, anim, "main");
            AnimationData left = BBLoader.getAnimation(animationFile, anim, "lefthand");
            AnimationData right = BBLoader.getAnimation(animationFile, anim, "righthand");
            this.checkDefaults();
            container.setFirstPerson(main.getTransitionList(this.firstPersonZoomingTransform, BBLoader.GENDIVISOR));
            container.setLeftHand(left.getTransitionList(this.firstPersonLeftHandTransform, BBLoader.HANDDIVISOR));
            container.setRightHand(right == null ? null : right.getTransitionList(this.firstPersonRightHandTransform, BBLoader.HANDDIVISOR));
            container.setDuration();
            return this;
        }

        public Builder setupTacticalReload(String animationFile, String anim, String mainBoneName, String leftHandBoneName, String rightHandBoneName) {
            AnimationData main = BBLoader.getAnimation(animationFile, anim, mainBoneName);
            AnimationData left = BBLoader.getAnimation(animationFile, anim, leftHandBoneName);
            AnimationData right = BBLoader.getAnimation(animationFile, anim, rightHandBoneName);
            this.checkDefaults();
            this.tacticalReloadContainer.setFirstPerson(main.getTransitionList(this.firstPersonTransform, BBLoader.GENDIVISOR));
            this.tacticalReloadContainer.setLeftHand(left.getTransitionList(this.firstPersonLeftHandTransform, BBLoader.HANDDIVISOR));
            this.tacticalReloadContainer.setRightHand(right == null ? null : right.getTransitionList(this.firstPersonRightHandTransform, BBLoader.HANDDIVISOR));
            this.tacticalReloadContainer.setDuration();
            return this;
        }

        public Builder setupCompoundReloadEmpty(String animationFile, String anim, String mainBoneName, String leftHandBoneName, String rightHandBoneName) {
            AnimationData main = BBLoader.getAnimation(animationFile, anim, mainBoneName);
            AnimationData left = BBLoader.getAnimation(animationFile, anim, leftHandBoneName);
            AnimationData right = BBLoader.getAnimation(animationFile, anim, rightHandBoneName);
            this.checkDefaults();
            this.compoundReloadEmptyContainer.setFirstPerson(main.getTransitionList(this.firstPersonTransform, BBLoader.GENDIVISOR));
            this.compoundReloadEmptyContainer.setLeftHand(left.getTransitionList(this.firstPersonLeftHandTransform, BBLoader.HANDDIVISOR));
            this.compoundReloadEmptyContainer.setRightHand(right == null ? null : right.getTransitionList(this.firstPersonRightHandTransform, BBLoader.HANDDIVISOR));
            this.compoundReloadEmptyContainer.setDuration();
            return this;
        }

        public Builder setupReload(String animationFile, String anim, String mainBoneName, String leftHandBoneName, String rightHandBoneName) {
            AnimationData main = BBLoader.getAnimation(animationFile, anim, mainBoneName);
            AnimationData left = BBLoader.getAnimation(animationFile, anim, leftHandBoneName);
            AnimationData right = BBLoader.getAnimation(animationFile, anim, rightHandBoneName);
            this.checkDefaults();
            this.firstPersonPositioningReloading = main.getTransitionList(this.firstPersonTransform, BBLoader.GENDIVISOR);
            this.firstPersonLeftHandPositioningReloading = left.getTransitionList(this.firstPersonLeftHandTransform, BBLoader.HANDDIVISOR);
            this.firstPersonRightHandPositioningReloading = right.getTransitionList(this.firstPersonRightHandTransform, BBLoader.HANDDIVISOR);
            return this;
        }

        public Builder setupUnload(String animationFile, String anim, String mainBoneName, String leftHandBoneName, String rightHandBoneName) {
            AnimationData main = BBLoader.getAnimation(animationFile, anim, mainBoneName);
            AnimationData left = BBLoader.getAnimation(animationFile, anim, leftHandBoneName);
            AnimationData right = BBLoader.getAnimation(animationFile, anim, rightHandBoneName);
            this.checkDefaults();
            this.firstPersonPositioningUnloading = main.getTransitionList(this.firstPersonTransform, BBLoader.GENDIVISOR);
            this.firstPersonLeftHandPositioningUnloading = left.getTransitionList(this.firstPersonLeftHandTransform, BBLoader.HANDDIVISOR);
            this.firstPersonRightHandPositioningUnloading = right.getTransitionList(this.firstPersonRightHandTransform, BBLoader.HANDDIVISOR);
            return this;
        }

        public Builder setupDraw(String animationFile, String anim, String mainBoneName, String leftHandBoneName, String rightHandBoneName) {
            AnimationData main = BBLoader.getAnimation(animationFile, anim, mainBoneName);
            AnimationData left = BBLoader.getAnimation(animationFile, anim, leftHandBoneName);
            AnimationData right = BBLoader.getAnimation(animationFile, anim, rightHandBoneName);
            this.checkDefaults();
            this.firstPersonPositioningDrawing = main.getTransitionList(this.firstPersonTransform, BBLoader.GENDIVISOR);
            this.firstPersonLeftHandPositioningDrawing = left.getTransitionList(this.firstPersonLeftHandTransform, BBLoader.HANDDIVISOR);
            this.firstPersonRightHandPositioningDrawing = right.getTransitionList(this.firstPersonRightHandTransform, BBLoader.HANDDIVISOR);
            return this;
        }

        public final Builder withLoadEmptyCustom(Part part, List<Transition<RenderContext<RenderableState>>> transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.loadEmptyContainer.getCustom().put(part, transitions);
            return this;
        }

        public final Builder withUnloadEmptyCustom(Part part, List<Transition<RenderContext<RenderableState>>> transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.unloadEmptyContainer.getCustom().put(part, transitions);
            return this;
        }

        public final Builder withTacticalReloadCustom(Part part, List<Transition<RenderContext<RenderableState>>> transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.tacticalReloadContainer.getCustom().put(part, transitions);
            return this;
        }

        public final Builder withFirstPersonCustomPositioningCompoundReloading(Part part, List<Transition<RenderContext<RenderableState>>> transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.compoundReloadContainer.getCustom().put(part, transitions);
            return this;
        }

        public final Builder withFPSCustomCompoundReloadingEmpty(Part part, List<Transition<RenderContext<RenderableState>>> transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.compoundReloadEmptyContainer.getCustom().put(part, transitions);
            return this;
        }

        public final Builder withFPSCustomCompoundReloadingEmpty(Part part, Transition<RenderContext<RenderableState>> ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.compoundReloadEmptyContainer.getCustom().put(part, Arrays.asList(transitions));
            return this;
        }

        public final Builder withFirstPersonCustomPositioningInspecting(Part part, List<Transition<RenderContext<RenderableState>>> transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningInspecting.put(part, transitions);
            return this;
        }

        public final Builder withFirstPersonCustomPositioningDrawing(Part part, List<Transition<RenderContext<RenderableState>>> transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningDrawing.put(part, transitions);
            return this;
        }

        public WeaponRenderer build() {
            if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
                return null;
            }
            if (this.inventoryPositioning == null) {
                this.inventoryPositioning = itemStack -> GL11.glTranslatef((float)0.0f, (float)0.12f, (float)0.0f);
            }
            if (this.entityPositioning == null) {
                this.entityPositioning = itemStack -> {};
            }
            WeaponRenderer renderer = new WeaponRenderer(this);
            if (this.firstPersonPositioningProning == null) {
                this.firstPersonPositioningProning = this.firstPersonPositioning;
            }
            if (this.firstPersonPositioningZooming == null) {
                this.firstPersonPositioningZooming = this.firstPersonPositioning;
            }
            if (this.firstPersonPositioningReloading == null) {
                this.firstPersonPositioningReloading = Collections.singletonList(new Transition<RenderContext<RenderableState>>(this.firstPersonPositioning, 250L));
            }
            if (this.thirdPersonPositioningReloading == null) {
                this.thirdPersonPositioningReloading = Collections.singletonList(new Transition<RenderContext<RenderableState>>(this.thirdPersonPositioning, 250L));
            }
            if (this.firstPersonPositioningInspecting == null) {
                this.firstPersonPositioningInspecting = Collections.singletonList(new Transition<RenderContext<RenderableState>>(this.firstPersonPositioning, 250L));
            }
            if (this.firstPersonPositioningDrawing == null) {
                this.firstPersonPositioningDrawing = Collections.singletonList(new Transition<RenderContext<RenderableState>>(this.firstPersonPositioning, 250L));
            }
            if (this.firstPersonPositioningLoadIteration == null) {
                this.firstPersonPositioningLoadIteration = Collections.singletonList(new Transition<RenderContext<RenderableState>>(this.firstPersonPositioning, 250L));
            }
            for (Transition<RenderContext<RenderableState>> t2 : this.firstPersonPositioningReloading) {
                this.totalReloadingDuration += t2.getDuration();
                this.totalReloadingDuration += t2.getPause();
            }
            for (Transition<RenderContext<RenderableState>> t2 : this.firstPersonPositioningLoadIteration) {
                this.totalLoadIterationDuration += t2.getDuration();
                this.totalLoadIterationDuration += t2.getPause();
            }
            if (this.firstPersonPositioningUnloading == null) {
                this.firstPersonPositioningUnloading = Collections.singletonList(new Transition<RenderContext<RenderableState>>(this.firstPersonPositioning, 250L));
            }
            if (this.thirdPersonPositioningUnloading == null) {
                this.thirdPersonPositioningUnloading = Collections.singletonList(new Transition<RenderContext<RenderableState>>(this.thirdPersonPositioning, 250L));
            }
            for (Transition<RenderContext<RenderableState>> t2 : this.firstPersonPositioningUnloading) {
                this.totalUnloadingDuration += t2.getDuration();
                this.totalUnloadingDuration += t2.getPause();
            }
            for (Transition<RenderContext<RenderableState>> t2 : this.firstPersonPositioningDrawing) {
                this.totalDrawingDuration += t2.getDuration();
                this.totalDrawingDuration += t2.getPause();
            }
            if (this.firstPersonPositioningLoadIteration == null) {
                this.firstPersonPositioningLoadIteration = Collections.singletonList(new Transition<RenderContext<RenderableState>>(this.firstPersonPositioning, 250L));
            }
            if (this.firstPersonPositioningAllLoadIterationsCompleted == null) {
                this.firstPersonPositioningAllLoadIterationsCompleted = Collections.singletonList(new Transition<RenderContext<RenderableState>>(this.firstPersonPositioning, 250L));
            }
            if (this.firstPersonPositioningRecoiled == null) {
                this.firstPersonPositioningRecoiled = this.firstPersonPositioning;
            } else {
                Consumer<RenderContext<RenderableState>> firstPersonPositioningRecoiledOrig = this.firstPersonPositioningRecoiled;
                this.firstPersonPositioningRecoiled = renderContext -> {
                    float maxAngle = 1.5f;
                    float xRotation = this.random.nextFloat() * maxAngle;
                    float yRotation = this.random.nextFloat() * maxAngle;
                    float zRotation = this.random.nextFloat() * maxAngle;
                    GL11.glRotatef((float)xRotation, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)yRotation, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)zRotation, (float)0.0f, (float)0.0f, (float)1.0f);
                    float amplitude = 0.0f;
                    float xRandomOffset = this.random.nextFloat() * amplitude;
                    float yRandomOffset = this.random.nextFloat() * amplitude;
                    float zRandomOffset = this.random.nextFloat() * amplitude;
                    GL11.glTranslatef((float)xRandomOffset, (float)yRandomOffset, (float)zRandomOffset);
                    firstPersonPositioningRecoiledOrig.accept((RenderContext<RenderableState>)renderContext);
                };
            }
            if (this.firstPersonPositioningProningRecoiled == null) {
                this.firstPersonPositioningProningRecoiled = this.firstPersonPositioningRecoiled;
            }
            if (this.firstPersonPositioningRunning == null) {
                this.firstPersonPositioningRunning = rc -> {
                    if (rc.getWeaponInstance().getWeapon().builder.isUsingNewSystem()) {
                        new Transform().withPosition(-0.5, 0.0, 0.5).withRotation(15.0, -5.0, 15.0).withScale(1.0, 1.0, 1.0).doGLDirect();
                    } else {
                        new Transform().withPosition(-0.5, 0.0, 0.5).withRotation(15.0, -5.0, 15.0).withScale(1.0, 1.0, 1.0).doGLDirect();
                    }
                };
            }
            if (this.firstPersonPositioningModifying == null) {
                this.firstPersonPositioningModifying = this.firstPersonPositioning;
            }
            if (this.firstPersonPositioningModifyingAlt == null) {
                this.firstPersonPositioningModifyingAlt = this.firstPersonPositioning;
            }
            if (this.firstPersonPositioningShooting == null) {
                this.firstPersonPositioningShooting = this.firstPersonPositioning;
            }
            if (this.firstPersonPositioningProningShooting == null) {
                this.firstPersonPositioningProningShooting = this.firstPersonPositioningProning;
            }
            if (this.firstPersonPositioningZoomingRecoiled == null) {
                this.firstPersonPositioningZoomingRecoiled = this.firstPersonPositioningZooming;
            }
            if (this.firstPersonPositioningZoomingShooting == null) {
                this.firstPersonPositioningZoomingShooting = this.firstPersonPositioningZooming;
            }
            if (this.firstPersonPositioningLoadIterationCompleted == null) {
                this.firstPersonPositioningLoadIterationCompleted = this.firstPersonPositioning;
            }
            if (this.thirdPersonPositioning == null) {
                this.thirdPersonPositioning = context -> {
                    GL11.glTranslatef((float)-0.4f, (float)0.2f, (float)0.4f);
                    GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                };
            }
            if (this.firstPersonLeftHandPositioning == null) {
                this.firstPersonLeftHandPositioning = context -> {};
            }
            if (this.firstPersonLeftHandPositioningProning == null) {
                this.firstPersonLeftHandPositioningProning = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonLeftHandPositioningReloading == null) {
                this.firstPersonLeftHandPositioningReloading = this.firstPersonPositioningReloading.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonLeftHandPositioningUnloading == null) {
                this.firstPersonLeftHandPositioningUnloading = this.firstPersonPositioningUnloading.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.thirdPersonLeftHandPositioningReloading == null) {
                this.thirdPersonLeftHandPositioningReloading = this.thirdPersonPositioningReloading.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.thirdPersonLeftHandPositioningUnloading == null) {
                this.thirdPersonLeftHandPositioningUnloading = this.thirdPersonPositioningUnloading.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonLeftHandPositioningInspecting == null) {
                this.firstPersonLeftHandPositioningInspecting = this.firstPersonPositioningInspecting.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonLeftHandPositioningDrawing == null) {
                this.firstPersonLeftHandPositioningDrawing = this.firstPersonPositioningDrawing.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonLeftHandPositioningLoadIteration == null) {
                this.firstPersonLeftHandPositioningLoadIteration = this.firstPersonPositioningReloading.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonLeftHandPositioningAllLoadIterationsCompleted == null) {
                this.firstPersonLeftHandPositioningAllLoadIterationsCompleted = this.firstPersonPositioningReloading.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonLeftHandPositioningRecoiled == null) {
                this.firstPersonLeftHandPositioningRecoiled = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonLeftHandPositioningProningRecoiled == null) {
                this.firstPersonLeftHandPositioningProningRecoiled = this.firstPersonLeftHandPositioningProning;
            }
            if (this.firstPersonLeftHandPositioningShooting == null) {
                this.firstPersonLeftHandPositioningShooting = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonLeftHandPositioningProningShooting == null) {
                this.firstPersonLeftHandPositioningProningShooting = this.firstPersonLeftHandPositioningProning;
            }
            if (this.firstPersonLeftHandPositioningZooming == null) {
                this.firstPersonLeftHandPositioningZooming = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonLeftHandPositioningRunning == null) {
                this.firstPersonLeftHandPositioningRunning = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonLeftHandPositioningModifying == null) {
                this.firstPersonLeftHandPositioningModifying = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonLeftHandPositioningModifyingAlt == null) {
                this.firstPersonLeftHandPositioningModifyingAlt = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonLeftHandPositioningLoadIterationCompleted == null) {
                this.firstPersonLeftHandPositioningLoadIterationCompleted = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonRightHandPositioning == null) {
                this.firstPersonRightHandPositioning = context -> {};
            }
            if (this.firstPersonRightHandPositioningProning == null) {
                this.firstPersonRightHandPositioningProning = this.firstPersonRightHandPositioning;
            }
            if (this.firstPersonRightHandPositioningReloading == null) {
                this.firstPersonRightHandPositioningReloading = this.firstPersonPositioningReloading.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonRightHandPositioningUnloading == null) {
                this.firstPersonRightHandPositioningUnloading = this.firstPersonPositioningUnloading.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.thirdPersonRightHandPositioningReloading == null) {
                this.thirdPersonRightHandPositioningReloading = this.thirdPersonPositioningReloading.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.thirdPersonRightHandPositioningUnloading == null) {
                this.thirdPersonRightHandPositioningUnloading = this.thirdPersonPositioningUnloading.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonRightHandPositioningInspecting == null) {
                this.firstPersonRightHandPositioningInspecting = this.firstPersonPositioningInspecting.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonRightHandPositioningDrawing == null) {
                this.firstPersonRightHandPositioningDrawing = this.firstPersonPositioningDrawing.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonRightHandPositioningLoadIteration == null) {
                this.firstPersonRightHandPositioningLoadIteration = this.firstPersonPositioningReloading.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonRightHandPositioningAllLoadIterationsCompleted == null) {
                this.firstPersonRightHandPositioningAllLoadIterationsCompleted = this.firstPersonPositioningReloading.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            this.compoundReloadContainer.build(this);
            this.compoundReloadEmptyContainer.build(this);
            this.loadEmptyContainer.build(this);
            this.unloadEmptyContainer.build(this);
            this.tacticalReloadContainer.build(this);
            if (this.firstPersonRightHandPositioningRecoiled == null) {
                this.firstPersonRightHandPositioningRecoiled = this.firstPersonRightHandPositioning;
            }
            if (this.firstPersonRightHandPositioningProningRecoiled == null) {
                this.firstPersonRightHandPositioningProningRecoiled = this.firstPersonRightHandPositioningProning;
            }
            if (this.firstPersonRightHandPositioningShooting == null) {
                this.firstPersonRightHandPositioningShooting = this.firstPersonRightHandPositioning;
            }
            if (this.firstPersonRightHandPositioningProningShooting == null) {
                this.firstPersonRightHandPositioningProningShooting = this.firstPersonRightHandPositioningProning;
            }
            if (this.firstPersonRightHandPositioningZooming == null) {
                this.firstPersonRightHandPositioningZooming = this.firstPersonRightHandPositioning;
            }
            if (this.firstPersonRightHandPositioningRunning == null) {
                this.firstPersonRightHandPositioningRunning = this.firstPersonRightHandPositioning;
            }
            if (this.firstPersonRightHandPositioningModifying == null) {
                this.firstPersonRightHandPositioningModifying = this.firstPersonRightHandPositioning;
            }
            if (this.firstPersonRightHandPositioningModifyingAlt == null) {
                this.firstPersonRightHandPositioningModifyingAlt = this.firstPersonRightHandPositioning;
            }
            if (this.firstPersonRightHandPositioningLoadIterationCompleted == null) {
                this.firstPersonRightHandPositioningLoadIterationCompleted = this.firstPersonLeftHandPositioning;
            }
            if (!this.firstPersonCustomPositioning.isEmpty() && this.firstPersonCustomPositioningRecoiled.isEmpty()) {
                this.firstPersonCustomPositioning.forEach((part, pos) -> this.firstPersonCustomPositioningRecoiled.put((Part)part, (Consumer<RenderContext<RenderableState>>)pos));
            }
            if (!this.firstPersonCustomPositioning.isEmpty() && this.firstPersonCustomPositioningProning.isEmpty()) {
                this.firstPersonCustomPositioning.forEach((part, pos) -> this.firstPersonCustomPositioningProning.put((Part)part, (Consumer<RenderContext<RenderableState>>)pos));
            }
            if (!this.firstPersonCustomPositioning.isEmpty() && this.firstPersonCustomPositioningZooming.isEmpty()) {
                this.firstPersonCustomPositioning.forEach((part, pos) -> this.firstPersonCustomPositioningZooming.put((Part)part, (Consumer<RenderContext<RenderableState>>)pos));
            }
            if (!this.firstPersonCustomPositioning.isEmpty() && this.firstPersonCustomPositioningZoomingRecoiled.isEmpty()) {
                this.firstPersonCustomPositioning.forEach((part, pos) -> this.firstPersonCustomPositioningZoomingRecoiled.put((Part)part, (Consumer<RenderContext<RenderableState>>)pos));
            }
            if (!this.firstPersonCustomPositioning.isEmpty() && this.firstPersonCustomPositioningProningRecoiled.isEmpty()) {
                this.firstPersonCustomPositioningRecoiled.forEach((part, pos) -> this.firstPersonCustomPositioningProningRecoiled.put((Part)part, (Consumer<RenderContext<RenderableState>>)pos));
            }
            if (!this.firstPersonCustomPositioning.isEmpty() && this.firstPersonCustomPositioningZoomingShooting.isEmpty()) {
                this.firstPersonCustomPositioning.forEach((part, pos) -> this.firstPersonCustomPositioningZoomingShooting.put((Part)part, (Consumer<RenderContext<RenderableState>>)pos));
            }
            if (!this.firstPersonCustomPositioning.isEmpty() && this.firstPersonCustomPositioningLoadIterationCompleted.isEmpty()) {
                this.firstPersonCustomPositioning.forEach((part, pos) -> this.firstPersonCustomPositioningLoadIterationCompleted.put((Part)part, (Consumer<RenderContext<RenderableState>>)pos));
            }
            this.firstPersonCustomPositioningReloading.forEach((p, t) -> {
                if (t.size() != this.firstPersonPositioningReloading.size()) {
                    throw new IllegalStateException("Custom reloading transition number mismatch. Expected " + this.firstPersonPositioningReloading.size() + ", actual: " + t.size());
                }
            });
            this.thirdPersonCustomPositioningReloading.forEach((p, t) -> {
                if (t.size() != this.thirdPersonPositioningReloading.size()) {
                    throw new IllegalStateException("Custom reloading transition number mismatch. Expected " + this.thirdPersonPositioningReloading.size() + ", actual: " + t.size());
                }
            });
            this.firstPersonCustomPositioningUnloading.forEach((p, t) -> {
                if (t.size() != this.firstPersonPositioningUnloading.size()) {
                    throw new IllegalStateException("Custom unloading transition number mismatch. Expected " + this.firstPersonPositioningUnloading.size() + ", actual: " + t.size());
                }
            });
            this.thirdPersonCustomPositioningUnloading.forEach((p, t) -> {
                if (t.size() != this.thirdPersonPositioningUnloading.size()) {
                    throw new IllegalStateException("Custom unloading transition number mismatch. Expected " + this.thirdPersonPositioningUnloading.size() + ", actual: " + t.size());
                }
            });
            this.firstPersonCustomPositioningInspecting.forEach((p, t) -> {
                if (t.size() != this.firstPersonPositioningInspecting.size()) {
                    throw new IllegalStateException("Custom inspecting transition number mismatch. Expected " + this.firstPersonPositioningInspecting.size() + ", actual: " + t.size());
                }
            });
            this.firstPersonCustomPositioningDrawing.forEach((p, t) -> {
                if (t.size() != this.firstPersonPositioningDrawing.size()) {
                    throw new IllegalStateException("Custom Drawing transition number mismatch. Expected " + this.firstPersonPositioningDrawing.size() + ", actual: " + t.size());
                }
            });
            this.firstPersonCustomPositioningLoadIteration.forEach((p, t) -> {
                if (t.size() != this.firstPersonPositioningLoadIteration.size()) {
                    throw new IllegalStateException("Custom reloading transition number mismatch. Expected " + this.firstPersonPositioningLoadIteration.size() + ", actual: " + t.size());
                }
            });
            this.firstPersonCustomPositioningLoadIterationsCompleted.forEach((p, t) -> {
                if (t.size() != this.firstPersonPositioningAllLoadIterationsCompleted.size()) {
                    throw new IllegalStateException("Custom reloading transition number mismatch. Expected " + this.firstPersonPositioningAllLoadIterationsCompleted.size() + ", actual: " + t.size());
                }
            });
            return renderer;
        }

        public void buildNormalTransition(List<Transition<RenderContext<RenderableState>>> transitionList) {
            if (transitionList == null) {
                transitionList = this.firstPersonPositioningReloading.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
        }

        public void buildCustomTransitionList(LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> lhm) {
            lhm.forEach((p, t) -> {
                if (t.size() != lhm.size()) {
                    throw new IllegalStateException("Custom reloading transition number mismatch. Expected " + lhm.size() + ", actual: " + t.size());
                }
            });
        }

        public Consumer<ItemStack> getEntityPositioning() {
            return this.entityPositioning;
        }

        public Consumer<ItemStack> getInventoryPositioning() {
            return this.inventoryPositioning;
        }

        public Consumer<RenderContext<RenderableState>> getThirdPersonPositioning() {
            return this.thirdPersonPositioning;
        }

        public String getTextureName() {
            return this.textureName;
        }

        public ModelBase getModel() {
            return this.model;
        }

        public WavefrontModel getBakedModel() {
            return this.bakedModel;
        }

        public String getAnimationFileName() {
            return this.animationFileName;
        }

        public void setAnimationFileName(String animationFileName) {
            this.animationFileName = animationFileName;
        }
    }

    private class WeaponItemOverrideList
    extends ItemOverrideList {
        public WeaponItemOverrideList(List<ItemOverride> overridesIn) {
            super(overridesIn);
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            WeaponRenderer.this.itemStack = stack;
            WeaponRenderer.this.player = entity;
            return super.handleItemState(originalModel, stack, world, entity);
        }
    }

    public static class StateDescriptor
    implements MultipartRenderStateDescriptor<RenderableState, Part, RenderContext<RenderableState>> {
        protected MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> stateManager;
        protected float rate;
        protected float amplitude = 0.04f;
        private PlayerWeaponInstance instance;

        public StateDescriptor(PlayerWeaponInstance instance, MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> stateManager, float rate, float amplitude) {
            this.instance = instance;
            this.stateManager = stateManager;
            this.rate = rate;
            this.amplitude = amplitude;
        }

        @Override
        public MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> getStateManager() {
            return this.stateManager;
        }
    }
}

