/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.network.NetworkPermitManager;
import com.paneedah.mwc.network.TypeRegistry;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.AttachmentContainer;
import com.paneedah.weaponlib.CompatibleAttachment;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.PlayerItemInstance;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.Tags;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.WeaponState;
import com.paneedah.weaponlib.state.Aspect;
import com.paneedah.weaponlib.state.Permit;
import com.paneedah.weaponlib.state.StateManager;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public final class WeaponAttachmentAspect
implements Aspect<WeaponState, PlayerWeaponInstance> {
    private ModContext modContext;
    private NetworkPermitManager permitManager;
    private StateManager<WeaponState, ? super PlayerWeaponInstance> stateManager;
    private long clickSpammingTimeout = 150L;
    private Predicate<PlayerWeaponInstance> clickSpammingPreventer = es -> System.currentTimeMillis() >= es.getStateUpdateTimestamp() + this.clickSpammingTimeout;
    private Predicate<PlayerWeaponInstance> clickSpammingPreventer2 = es -> System.currentTimeMillis() >= es.getStateUpdateTimestamp() + this.clickSpammingTimeout * 2L;
    private Collection<WeaponState> allowedUpdateFromStates = Arrays.asList(WeaponState.MODIFYING_REQUESTED);
    private static final int INVENTORY_SIZE = 36;

    WeaponAttachmentAspect(ModContext modContext) {
        this.modContext = modContext;
    }

    @Override
    public void setStateManager(StateManager<WeaponState, ? super PlayerWeaponInstance> stateManager) {
        if (this.permitManager == null) {
            throw new IllegalStateException("Permit manager not initialized");
        }
        this.stateManager = stateManager.in(this).change(WeaponState.READY).to(WeaponState.MODIFYING).when(this.clickSpammingPreventer).withPermit((s, es) -> new EnterAttachmentModePermit((WeaponState)s), this.modContext.getPlayerItemInstanceRegistry()::update, this.permitManager).manual().in(this).change(WeaponState.MODIFYING).to(WeaponState.READY).when(this.clickSpammingPreventer2).withAction(instance -> this.permitManager.request(new ExitAttachmentModePermit(WeaponState.READY), instance, (p, e) -> {})).manual().in(this).change(WeaponState.MODIFYING).to(WeaponState.NEXT_ATTACHMENT).when(this.clickSpammingPreventer).withPermit(null, this.modContext.getPlayerItemInstanceRegistry()::update, this.permitManager).manual().in(this).change(WeaponState.NEXT_ATTACHMENT).to(WeaponState.MODIFYING).automatic();
    }

    @Override
    public void setPermitManager(NetworkPermitManager permitManager) {
        this.permitManager = permitManager;
        permitManager.registerEvaluator(EnterAttachmentModePermit.class, PlayerWeaponInstance.class, this::enterAttachmentSelectionMode);
        permitManager.registerEvaluator(ExitAttachmentModePermit.class, PlayerWeaponInstance.class, this::exitAttachmentSelectionMode);
        permitManager.registerEvaluator(ChangeAttachmentPermit.class, PlayerWeaponInstance.class, this::changeAttachment);
    }

    public void toggleClientAttachmentSelectionMode(EntityPlayer player) {
        PlayerWeaponInstance weaponInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerWeaponInstance.class);
        if (weaponInstance != null) {
            this.stateManager.changeState(this, weaponInstance, new WeaponState[]{WeaponState.MODIFYING, WeaponState.READY});
        }
    }

    void updateMainHeldItem(EntityPlayer player) {
        PlayerWeaponInstance instance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerWeaponInstance.class);
        if (instance != null) {
            this.stateManager.changeStateFromAnyOf(this, instance, this.allowedUpdateFromStates, new WeaponState[0]);
        }
    }

    private void enterAttachmentSelectionMode(EnterAttachmentModePermit permit, PlayerWeaponInstance weaponInstance) {
        ModReference.LOG.debug("Entering attachment mode");
        byte[] selectedAttachmentIndexes = new byte[AttachmentCategory.values.length];
        Arrays.fill(selectedAttachmentIndexes, (byte)-1);
        weaponInstance.setSelectedAttachmentIndexes(selectedAttachmentIndexes);
        permit.setStatus(Permit.Status.GRANTED);
    }

    private void exitAttachmentSelectionMode(ExitAttachmentModePermit permit, PlayerWeaponInstance weaponInstance) {
        ModReference.LOG.debug("Exiting attachment mode");
        weaponInstance.setSelectedAttachmentIndexes(new byte[0]);
        permit.setStatus(Permit.Status.GRANTED);
    }

    List<CompatibleAttachment<? extends AttachmentContainer>> getActiveAttachments(EntityLivingBase player, ItemStack itemStack) {
        int[] activeAttachmentsIds;
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        ArrayList<CompatibleAttachment<? extends AttachmentContainer>> activeAttachments = new ArrayList<CompatibleAttachment<? extends AttachmentContainer>>();
        PlayerItemInstance<?> itemInstance = this.modContext.getPlayerItemInstanceRegistry().getItemInstance(player, itemStack);
        if (!(itemInstance instanceof PlayerWeaponInstance)) {
            activeAttachmentsIds = new int[AttachmentCategory.values.length];
            for (CompatibleAttachment<Weapon> attachment : ((Weapon)itemStack.func_77973_b()).getCompatibleAttachments().values()) {
                if (!attachment.isDefault()) continue;
                activeAttachmentsIds[attachment.getAttachment().getCategory().ordinal()] = Item.func_150891_b(attachment.getAttachment());
            }
        } else {
            activeAttachmentsIds = ((PlayerWeaponInstance)itemInstance).getActiveAttachmentIds();
        }
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        for (int activeIndex : activeAttachmentsIds) {
            CompatibleAttachment<Weapon> compatibleAttachment;
            Item item;
            if (activeIndex == 0 || !((item = Item.func_150899_d((int)activeIndex)) instanceof ItemAttachment) || (compatibleAttachment = weapon.getCompatibleAttachments().get(item)) == null) continue;
            activeAttachments.add(compatibleAttachment);
        }
        return activeAttachments;
    }

    public boolean isCompatibleAttachment(ItemAttachment<Weapon> attachment, PlayerWeaponInstance weaponInstance) {
        Weapon weapon = weaponInstance.getWeapon();
        CompatibleAttachment<Weapon> compatibleAttachment = weapon.getCompatibleAttachments().get(attachment);
        return compatibleAttachment != null;
    }

    public ArrayList<FlaggedAttachment> getInventoryAttachments(AttachmentCategory category, PlayerWeaponInstance weaponInstance) {
        EntityPlayer player = (EntityPlayer)weaponInstance.getPlayer();
        Weapon weapon = weaponInstance.getWeapon();
        ArrayList<FlaggedAttachment> attachmentList = new ArrayList<FlaggedAttachment>();
        for (ItemStack i : player.field_71071_by.field_70462_a) {
            if (!(i.func_77973_b() instanceof ItemAttachment)) continue;
            ItemAttachment potentialAttachment = (ItemAttachment)i.func_77973_b();
            FlaggedAttachment flaggedAttachment = new FlaggedAttachment(i, potentialAttachment);
            if (potentialAttachment.getCategory() != category || !this.isCompatibleAttachment(potentialAttachment, weaponInstance)) continue;
            this.modContext.getAttachmentAspect();
            if (!WeaponAttachmentAspect.hasRequiredAttachments(potentialAttachment, weaponInstance)) {
                flaggedAttachment.setRequiredParts(this.getRequiredParts(potentialAttachment, weaponInstance));
            }
            attachmentList.add(flaggedAttachment);
        }
        return attachmentList;
    }

    public ArrayList<ItemAttachment<Weapon>> getRequiredParts(ItemAttachment<Weapon> attachment, PlayerWeaponInstance weaponInstance) {
        ArrayList<ItemAttachment<Weapon>> requiredPartsList = new ArrayList<ItemAttachment<Weapon>>();
        List<ItemAttachment<Weapon>> unfilteredParts = attachment.getRequiredAttachments();
        for (ItemAttachment<Weapon> attach : unfilteredParts) {
            if (!this.isCompatibleAttachment(attach, weaponInstance)) continue;
            requiredPartsList.add(attach);
        }
        return requiredPartsList;
    }

    public void changeAttachment(AttachmentCategory attachmentCategory, PlayerWeaponInstance weaponInstance) {
        if (weaponInstance != null) {
            this.stateManager.changeState(this, weaponInstance, new ChangeAttachmentPermit(attachmentCategory), new WeaponState[]{WeaponState.NEXT_ATTACHMENT});
        }
    }

    public void forceAttachment(AttachmentCategory attachmentCategory, PlayerWeaponInstance weaponInstance, ItemStack attachment) {
        if (weaponInstance != null) {
            this.stateManager.changeState(this, weaponInstance, new ChangeAttachmentPermit(attachmentCategory, attachment), new WeaponState[]{WeaponState.NEXT_ATTACHMENT});
        }
    }

    public void tryChange(ChangeAttachmentPermit permit, PlayerWeaponInstance weaponInstance) {
        this.changeAttachment(permit, weaponInstance);
    }

    private void changeAttachment(ChangeAttachmentPermit permit, PlayerWeaponInstance weaponInstance) {
        if (!(weaponInstance.getPlayer() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)weaponInstance.getPlayer();
        AttachmentCategory attachmentCategory = permit.attachmentCategory;
        int[] originalActiveAttachmentIds = weaponInstance.getActiveAttachmentIds();
        int[] activeAttachmentIds = Arrays.copyOf(originalActiveAttachmentIds, originalActiveAttachmentIds.length);
        int activeAttachmentIdForThisCategory = activeAttachmentIds[attachmentCategory.ordinal()];
        ItemAttachment currentAttachment = null;
        if (activeAttachmentIdForThisCategory > 0) {
            currentAttachment = (ItemAttachment)Item.func_150899_d((int)activeAttachmentIdForThisCategory);
        }
        if (currentAttachment != null) {
            CompatibleAttachment<Weapon> currentCompatibleAttachment = weaponInstance.getWeapon().getCompatibleAttachments().get(currentAttachment);
            if (currentCompatibleAttachment.isPermanent()) {
                return;
            }
            if (WeaponAttachmentAspect.isAttachmentInUse(currentCompatibleAttachment.getAttachment(), weaponInstance)) {
                return;
            }
        }
        AttachmentLookupResult lookupResult = permit.attachment != null ? this.findForcedAttach(permit.attachment, currentAttachment, attachmentCategory, weaponInstance, ((EntityPlayer)weaponInstance.getPlayer()).func_184812_l_()) : this.next(attachmentCategory, currentAttachment, weaponInstance);
        if (currentAttachment != null) {
            if (currentAttachment.getRemove() != null) {
                currentAttachment.getRemove().apply(currentAttachment, weaponInstance.getWeapon(), (EntityLivingBase)player);
            }
            if (currentAttachment.getRemove2() != null) {
                currentAttachment.getRemove2().apply(currentAttachment, weaponInstance);
            }
        }
        if (lookupResult.index >= 0) {
            ItemStack slotItemStack = player.field_71071_by.func_70301_a(lookupResult.index);
            ItemAttachment nextAttachment = (ItemAttachment)slotItemStack.func_77973_b();
            if (nextAttachment.getApply() != null) {
                nextAttachment.getApply().apply(nextAttachment, weaponInstance.getWeapon(), (EntityLivingBase)player);
            } else if (nextAttachment.getApply2() != null) {
                nextAttachment.getApply2().apply(nextAttachment, weaponInstance);
            } else if (lookupResult.compatibleAttachment.getApplyHandler() != null) {
                lookupResult.compatibleAttachment.getApplyHandler().apply(nextAttachment, weaponInstance);
            } else {
                ItemAttachment.ApplyHandler2<Weapon> handler = weaponInstance.getWeapon().getEquivalentHandler(attachmentCategory);
                if (handler != null) {
                    handler.apply(null, weaponInstance);
                }
            }
            if (player.field_71071_by.func_70301_a(lookupResult.index) == null) {
                return;
            }
            player.field_71071_by.func_70301_a(lookupResult.index).func_190918_g(1);
            if (((ItemStack)player.field_71071_by.field_70462_a.get(lookupResult.index)).func_190916_E() <= 0) {
                player.field_71071_by.func_70304_b(lookupResult.index);
            }
            activeAttachmentIds[attachmentCategory.ordinal()] = Item.func_150891_b((Item)nextAttachment);
        } else if (lookupResult.isCreative) {
            ItemAttachment<Weapon> nextAttachment = lookupResult.compatibleAttachment.getAttachment();
            if (nextAttachment.getApply() != null) {
                nextAttachment.getApply().apply(nextAttachment, weaponInstance.getWeapon(), (EntityLivingBase)player);
            } else if (nextAttachment.getApply2() != null) {
                nextAttachment.getApply2().apply(nextAttachment, weaponInstance);
            } else if (lookupResult.compatibleAttachment.getApplyHandler() != null) {
                lookupResult.compatibleAttachment.getApplyHandler().apply(nextAttachment, weaponInstance);
            } else {
                ItemAttachment.ApplyHandler2<Weapon> handler = weaponInstance.getWeapon().getEquivalentHandler(attachmentCategory);
                if (handler != null) {
                    handler.apply(null, weaponInstance);
                }
            }
            activeAttachmentIds[attachmentCategory.ordinal()] = Item.func_150891_b(nextAttachment);
        } else if (weaponInstance.getWeapon().isCategoryRemovable(attachmentCategory)) {
            activeAttachmentIds[attachmentCategory.ordinal()] = -1;
            ItemAttachment.ApplyHandler2<Weapon> handler = weaponInstance.getWeapon().getEquivalentHandler(attachmentCategory);
            if (handler != null) {
                handler.apply(null, weaponInstance);
            }
        } else {
            return;
        }
        if (currentAttachment != null && !player.func_184812_l_()) {
            if (lookupResult.index == -1) {
                player.field_71071_by.func_70441_a(new ItemStack((Item)currentAttachment));
            } else if (player.field_71071_by.field_70462_a.get(lookupResult.index) == null || ((ItemStack)player.field_71071_by.field_70462_a.get(lookupResult.index)).func_77973_b() == Items.field_190931_a) {
                player.field_71071_by.field_70462_a.set(lookupResult.index, (Object)new ItemStack((Item)currentAttachment));
            }
        }
        Tags.setAttachmentIds(weaponInstance.getItemStack(), activeAttachmentIds);
        weaponInstance.setActiveAttachmentIds(activeAttachmentIds);
    }

    private AttachmentLookupResult findForcedAttach(ItemStack stack, Item currentAttachment, AttachmentCategory category, PlayerWeaponInstance weaponInstance, boolean isCreative) {
        AttachmentLookupResult result = new AttachmentLookupResult();
        if (stack.func_190926_b()) {
            result.index = -1;
            return result;
        }
        if (isCreative) {
            CompatibleAttachment<Weapon> compatibleAttachment = weaponInstance.getWeapon().getCompatibleAttachments().get(stack.func_77973_b());
            if (compatibleAttachment != null) {
                result.compatibleAttachment = compatibleAttachment;
                result.isCreative = true;
            }
            return result;
        }
        EntityPlayer player = (EntityPlayer)weaponInstance.getPlayer();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            CompatibleAttachment<Weapon> compatibleAttachment;
            ItemStack inventory = player.field_71071_by.func_70301_a(i);
            if (!ItemStack.func_77989_b((ItemStack)inventory, (ItemStack)stack) || (compatibleAttachment = weaponInstance.getWeapon().getCompatibleAttachments().get(inventory.func_77973_b())) == null || category != compatibleAttachment.getAttachment().getCategory() || !WeaponAttachmentAspect.hasRequiredAttachments(compatibleAttachment.getAttachment(), weaponInstance) || inventory.func_77973_b() == currentAttachment) continue;
            result.index = i;
            result.compatibleAttachment = compatibleAttachment;
            break;
        }
        return result;
    }

    private AttachmentLookupResult next(AttachmentCategory category, Item currentAttachment, PlayerWeaponInstance weaponInstance) {
        AttachmentLookupResult result = new AttachmentLookupResult();
        byte[] originallySelectedAttachmentIndexes = weaponInstance.getSelectedAttachmentIds();
        if (originallySelectedAttachmentIndexes == null || originallySelectedAttachmentIndexes.length != AttachmentCategory.values.length) {
            return result;
        }
        byte[] selectedAttachmentIndexes = Arrays.copyOf(originallySelectedAttachmentIndexes, originallySelectedAttachmentIndexes.length);
        byte activeIndex = selectedAttachmentIndexes[category.ordinal()];
        boolean isCategoryRemovable = weaponInstance.getWeapon().isCategoryRemovable(category);
        result.index = -1;
        int offset = activeIndex + 1;
        int endIndex = isCategoryRemovable ? 37 : 36;
        for (int i = 0; i < endIndex; ++i) {
            CompatibleAttachment<Weapon> compatibleAttachment;
            ItemAttachment attachmentItemFromInventory;
            int currentIndex = i + offset;
            if (currentIndex >= 36) {
                currentIndex -= 36 + (isCategoryRemovable ? 1 : 0);
            }
            ModReference.LOG.debug("Searching for an attachment in slot {}", (Object)currentIndex);
            if (currentIndex == -1) {
                result.index = -1;
                break;
            }
            ItemStack slotItemStack = ((EntityPlayer)weaponInstance.getPlayer()).field_71071_by.func_70301_a(currentIndex);
            if (slotItemStack == null || !(slotItemStack.func_77973_b() instanceof ItemAttachment) || (attachmentItemFromInventory = (ItemAttachment)slotItemStack.func_77973_b()).getCategory() != category || (compatibleAttachment = weaponInstance.getWeapon().getCompatibleAttachments().get(attachmentItemFromInventory)) == null || attachmentItemFromInventory == currentAttachment || !WeaponAttachmentAspect.hasRequiredAttachments(compatibleAttachment.getAttachment(), weaponInstance)) continue;
            result.index = currentIndex;
            result.compatibleAttachment = compatibleAttachment;
            break;
        }
        selectedAttachmentIndexes[category.ordinal()] = (byte)result.index;
        weaponInstance.setSelectedAttachmentIndexes(selectedAttachmentIndexes);
        return result;
    }

    public static boolean hasRequiredAttachments(ItemAttachment<Weapon> attachmentItemFromInventory, PlayerWeaponInstance weaponInstance) {
        List<ItemAttachment<Weapon>> requiredAttachments = attachmentItemFromInventory.getRequiredAttachments();
        if (requiredAttachments.isEmpty()) {
            return true;
        }
        boolean result = false;
        for (int currentAttachmentId : weaponInstance.getActiveAttachmentIds()) {
            Item attachmentItem = Item.func_150899_d((int)currentAttachmentId);
            boolean bl = result = attachmentItem != null && requiredAttachments.contains(attachmentItem);
            if (result) break;
        }
        return result;
    }

    public static boolean isAttachmentInUse(ItemAttachment<Weapon> attachmentItem, PlayerWeaponInstance weaponInstance) {
        return WeaponAttachmentAspect.isRequired(attachmentItem, weaponInstance);
    }

    public static boolean isRequired(ItemAttachment<Weapon> attachmentItem, PlayerWeaponInstance weaponInstance) {
        int currentAttachmentId;
        Item otherAttachmentItem;
        boolean result = false;
        int[] nArray = weaponInstance.getActiveAttachmentIds();
        int n = nArray.length;
        for (int i = 0; !(i >= n || (otherAttachmentItem = Item.func_150899_d((int)(currentAttachmentId = nArray[i]))) instanceof ItemAttachment && (result = ((ItemAttachment)otherAttachmentItem).getRequiredAttachments().contains(attachmentItem))); ++i) {
        }
        return result;
    }

    public static ArrayList<ItemAttachment<Weapon>> whatRequiredFor(ItemAttachment<Weapon> attachmentItem, PlayerWeaponInstance weaponInstance) {
        ArrayList<ItemAttachment<Weapon>> requireesList = new ArrayList<ItemAttachment<Weapon>>();
        boolean result = false;
        for (int currentAttachmentId : weaponInstance.getActiveAttachmentIds()) {
            Item otherAttachmentItem = Item.func_150899_d((int)currentAttachmentId);
            if (!(otherAttachmentItem instanceof ItemAttachment) || !(result = ((ItemAttachment)otherAttachmentItem).getRequiredAttachments().contains(attachmentItem))) continue;
            requireesList.add((ItemAttachment)otherAttachmentItem);
        }
        return requireesList;
    }

    public static void addAttachment(ItemAttachment<Weapon> attachment, PlayerWeaponInstance weaponInstance) {
        int[] activeAttachmentsIds = weaponInstance.getActiveAttachmentIds();
        int activeAttachmentIdForThisCategory = activeAttachmentsIds[attachment.getCategory().ordinal()];
        ItemAttachment currentAttachment = null;
        if (activeAttachmentIdForThisCategory > 0) {
            currentAttachment = (ItemAttachment)Item.func_150899_d((int)activeAttachmentIdForThisCategory);
        }
        if (currentAttachment == null) {
            if (attachment != null) {
                if (attachment.getApply() != null) {
                    attachment.getApply().apply(attachment, weaponInstance.getWeapon(), weaponInstance.getPlayer());
                } else if (attachment.getApply2() != null) {
                    attachment.getApply2().apply(attachment, weaponInstance);
                }
            }
            activeAttachmentsIds[attachment.getCategory().ordinal()] = Item.func_150891_b(attachment);
        } else {
            System.err.println("Attachment of category " + (Object)((Object)attachment.getCategory()) + " installed, remove it first");
        }
    }

    ItemAttachment<Weapon> removeAttachment(AttachmentCategory attachmentCategory, PlayerWeaponInstance weaponInstance) {
        int[] activeAttachmentIds = weaponInstance.getActiveAttachmentIds();
        int activeAttachmentIdForThisCategory = activeAttachmentIds[attachmentCategory.ordinal()];
        ItemAttachment currentAttachment = null;
        if (activeAttachmentIdForThisCategory > 0 && WeaponAttachmentAspect.isAttachmentInUse(currentAttachment = (ItemAttachment)Item.func_150899_d((int)activeAttachmentIdForThisCategory), weaponInstance)) {
            return null;
        }
        if (currentAttachment != null && currentAttachment.getRemove() != null) {
            currentAttachment.getRemove().apply(currentAttachment, weaponInstance.getWeapon(), weaponInstance.getPlayer());
        }
        if (currentAttachment != null) {
            activeAttachmentIds[attachmentCategory.ordinal()] = -1;
            weaponInstance.setActiveAttachmentIds(activeAttachmentIds);
        }
        return currentAttachment;
    }

    public static ItemAttachment<Weapon> getActiveAttachment(AttachmentCategory category, PlayerWeaponInstance weaponInstance) {
        int[] activeAttachmentIds;
        ItemAttachment<Weapon> itemAttachment = null;
        for (int activeIndex : activeAttachmentIds = weaponInstance.getActiveAttachmentIds()) {
            CompatibleAttachment<Weapon> compatibleAttachment;
            Item item;
            if (activeIndex == 0 || !((item = Item.func_150899_d((int)activeIndex)) instanceof ItemAttachment) || (compatibleAttachment = weaponInstance.getWeapon().getCompatibleAttachments().get(item)) == null || category != compatibleAttachment.getAttachment().getCategory()) continue;
            itemAttachment = compatibleAttachment.getAttachment();
            break;
        }
        return itemAttachment;
    }

    static boolean isActiveAttachment(ItemAttachment<Weapon> attachment, PlayerWeaponInstance weaponInstance) {
        int[] activeAttachmentIds = weaponInstance.getActiveAttachmentIds();
        return Arrays.stream(activeAttachmentIds).anyMatch(attachmentId -> attachment == Item.func_150899_d((int)attachmentId));
    }

    boolean isSilencerOn(PlayerWeaponInstance weaponInstance) {
        int[] activeAttachmentsIds = weaponInstance.getActiveAttachmentIds();
        int activeAttachmentIdForThisCategory = activeAttachmentsIds[AttachmentCategory.SILENCER.ordinal()];
        return activeAttachmentIdForThisCategory > 0;
    }

    ItemAttachment<Weapon> getActiveAttachment(PlayerWeaponInstance weaponInstance, AttachmentCategory category) {
        return weaponInstance.getAttachmentItemWithCategory(category);
    }

    static {
        TypeRegistry.getINSTANCE().register(EnterAttachmentModePermit.class);
        TypeRegistry.getINSTANCE().register(ExitAttachmentModePermit.class);
        TypeRegistry.getINSTANCE().register(ChangeAttachmentPermit.class);
    }

    public static class FlaggedAttachment {
        private ItemAttachment<Weapon> attachment;
        private ItemStack stack;
        private ArrayList<ItemAttachment<Weapon>> requiredParts;

        public FlaggedAttachment(ItemStack stack, ItemAttachment<Weapon> attachment) {
            this.stack = stack;
            this.attachment = attachment;
        }

        public void setRequiredParts(ArrayList<ItemAttachment<Weapon>> list) {
            this.requiredParts = list;
        }

        public ItemStack getItemStack() {
            return this.stack;
        }

        public ArrayList<ItemAttachment<Weapon>> getRequiredParts() {
            return this.requiredParts;
        }

        public boolean requiresAnyParts() {
            if (this.requiredParts == null) {
                return false;
            }
            return !this.requiredParts.isEmpty();
        }

        public ItemAttachment<Weapon> getAttachment() {
            return this.attachment;
        }
    }

    public static class ChangeAttachmentPermit
    extends Permit<WeaponState> {
        AttachmentCategory attachmentCategory;
        ItemStack attachment;

        public ChangeAttachmentPermit() {
        }

        public ChangeAttachmentPermit(AttachmentCategory attachmentCategory) {
            super(WeaponState.NEXT_ATTACHMENT);
            this.attachmentCategory = attachmentCategory;
        }

        public ChangeAttachmentPermit(AttachmentCategory category, ItemStack attachment) {
            super(WeaponState.NEXT_ATTACHMENT);
            this.attachmentCategory = category;
            this.attachment = attachment;
        }

        @Override
        public void read(ByteBuf byteBuf) {
            super.read(byteBuf);
            this.attachmentCategory = AttachmentCategory.values()[byteBuf.readInt()];
            if (byteBuf.readBoolean()) {
                this.attachment = ByteBufUtils.readItemStack((ByteBuf)byteBuf);
            }
        }

        @Override
        public void write(ByteBuf byteBuf) {
            super.write(byteBuf);
            byteBuf.writeInt(this.attachmentCategory.ordinal());
            if (this.attachment == null) {
                byteBuf.writeBoolean(false);
            } else {
                byteBuf.writeBoolean(true);
                ByteBufUtils.writeItemStack((ByteBuf)byteBuf, (ItemStack)this.attachment);
            }
        }
    }

    public static class ExitAttachmentModePermit
    extends Permit<WeaponState> {
        public ExitAttachmentModePermit() {
        }

        public ExitAttachmentModePermit(WeaponState state) {
            super(state);
        }
    }

    public static class EnterAttachmentModePermit
    extends Permit<WeaponState> {
        public EnterAttachmentModePermit() {
        }

        public EnterAttachmentModePermit(WeaponState state) {
            super(state);
        }
    }

    private static class AttachmentLookupResult {
        CompatibleAttachment<Weapon> compatibleAttachment;
        int index = -1;
        boolean isCreative;

        private AttachmentLookupResult() {
        }
    }
}

