/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.weaponlib.Contextual;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.Spreadable;
import com.paneedah.weaponlib.SpreadableExposure;
import com.paneedah.weaponlib.compatibility.CompatibleExposureCapability;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntitySpreadable
extends Entity
implements Contextual,
Spreadable {
    private static final String TAG_SPREAD_MAP = "spreadMap";
    private static final float DEFAULT_CONCENTRATION_SPREAD_FACTOR = 0.8f;
    private static final float DEFAULT_MIN_CONCENTRATION_THRESHOLD = 0.01f;
    private static final float DEFAULT_SPREAD_RATE = 0.5f;
    private static final float DEFAULT_CONCENTRATION_DECAY_FACTOR = 0.99f;
    private Map<BlockPos, Float> spreadMap = new HashMap<BlockPos, Float>();
    private List<BlockPos> currentSpread;
    private float initialConcentration = 1.0f;
    private float concentrationSpreadUpFactor = 0.8f;
    private float concentrationSpreadDownFactor = 0.8f;
    private float concentrationSpreadSideFactor = 0.8f;
    private float minConcentrationThreshold = 0.01f;
    private AxisAlignedBB spreadBox;
    private float spreadRate = 0.5f;
    private long lastSpreadTimestamp;
    private float concentrationDecayAdjustment = 1.0f;
    private float concentrationDecayFactor = 0.99f;
    private ModContext modContext;

    public EntitySpreadable(World worldIn) {
        super(worldIn);
    }

    @Override
    public void setContext(ModContext modContext) {
        this.modContext = modContext;
    }

    EntitySpreadable setConcentrationSpreadUpFactor(float concentrationSpreadUpFactor) {
        this.concentrationSpreadUpFactor = concentrationSpreadUpFactor;
        return this;
    }

    EntitySpreadable setConcentrationSpreadDownFactor(float concentrationSpreadDownFactor) {
        this.concentrationSpreadDownFactor = concentrationSpreadDownFactor;
        return this;
    }

    EntitySpreadable setConcentrationSpreadSideFactor(float concentrationSpreadSideFactor) {
        this.concentrationSpreadSideFactor = concentrationSpreadSideFactor;
        return this;
    }

    EntitySpreadable setMinConcentrationThreshold(float minConcentrationThreshold) {
        this.minConcentrationThreshold = minConcentrationThreshold;
        return this;
    }

    EntitySpreadable setSpreadRate(float spreadRate) {
        this.spreadRate = spreadRate;
        return this;
    }

    EntitySpreadable setConcentrationDecayFactor(float concentrationDecayFactor) {
        this.concentrationDecayFactor = concentrationDecayFactor;
        return this;
    }

    protected void func_70088_a() {
    }

    private void initSpreadBox() {
        double spreadUpDistance = Math.log10(this.minConcentrationThreshold / this.initialConcentration) / Math.log10(this.concentrationSpreadUpFactor) + 1.0;
        double spreadDownDistance = Math.log10(this.minConcentrationThreshold / this.initialConcentration) / Math.log10(this.concentrationSpreadDownFactor) + 1.0;
        double spreadSideDistance = Math.log10(this.minConcentrationThreshold / this.initialConcentration) / Math.log10(this.concentrationSpreadSideFactor) + 1.0;
        this.spreadBox = new AxisAlignedBB(this.field_70165_t - spreadSideDistance, this.field_70163_u - spreadDownDistance, this.field_70161_v - spreadSideDistance, this.field_70165_t + spreadSideDistance, this.field_70163_u + spreadUpDistance, this.field_70161_v + spreadSideDistance);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        BlockPos blockPos;
        byte[] bytes = compound.func_74770_j(TAG_SPREAD_MAP);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
        this.concentrationSpreadUpFactor = buf.readFloat();
        this.concentrationSpreadDownFactor = buf.readFloat();
        this.concentrationSpreadSideFactor = buf.readFloat();
        this.minConcentrationThreshold = buf.readFloat();
        this.spreadRate = buf.readFloat();
        this.lastSpreadTimestamp = buf.readLong();
        this.concentrationDecayAdjustment = buf.readFloat();
        this.concentrationDecayFactor = buf.readFloat();
        int spreadMapSize = buf.readInt();
        for (int i = 0; i < spreadMapSize; ++i) {
            blockPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.spreadMap.put(blockPos, Float.valueOf(buf.readFloat()));
        }
        int currentSpreadSize = buf.readInt();
        if (this.currentSpread == null) {
            this.currentSpread = new ArrayList<BlockPos>();
            this.initSpreadBox();
            blockPos = new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            this.spreadMap.put(blockPos, Float.valueOf(this.initialConcentration));
        }
        for (int i = 0; i < currentSpreadSize; ++i) {
            BlockPos blockPos2 = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.currentSpread.add(blockPos2);
        }
        this.initSpreadBox();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeFloat(this.concentrationSpreadUpFactor);
        buf.writeFloat(this.concentrationSpreadDownFactor);
        buf.writeFloat(this.concentrationSpreadSideFactor);
        buf.writeFloat(this.minConcentrationThreshold);
        buf.writeFloat(this.spreadRate);
        buf.writeLong(this.lastSpreadTimestamp);
        buf.writeFloat(this.concentrationDecayAdjustment);
        buf.writeFloat(this.concentrationDecayFactor);
        buf.writeInt(this.spreadMap.size());
        for (Map.Entry<BlockPos, Float> e : this.spreadMap.entrySet()) {
            BlockPos blockPos = e.getKey();
            buf.writeInt(blockPos.func_177958_n());
            buf.writeInt(blockPos.func_177956_o());
            buf.writeInt(blockPos.func_177952_p());
            buf.writeFloat(e.getValue().floatValue());
        }
        if (this.currentSpread != null) {
            buf.writeInt(this.currentSpread.size());
            for (BlockPos blockPos : this.currentSpread) {
                buf.writeInt(blockPos.func_177958_n());
                buf.writeInt(blockPos.func_177956_o());
                buf.writeInt(blockPos.func_177952_p());
            }
        } else {
            buf.writeInt(0);
        }
        compound.func_74773_a(TAG_SPREAD_MAP, buf.array());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.spread();
            this.updateNearbyEntities();
        }
    }

    private void updateNearbyEntities() {
        if (this.spreadBox == null) {
            return;
        }
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.spreadBox);
        for (Entity entity : entities) {
            BlockPos entityPos = new BlockPos((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v);
            float adjustedConcentration = this.spreadMap.getOrDefault(entityPos, Float.valueOf(0.0f)).floatValue() * this.concentrationDecayAdjustment;
            if (!(entity instanceof EntityLivingBase)) continue;
            this.onEntityExposure((EntityLivingBase)entity, adjustedConcentration);
        }
    }

    protected void onEntityExposure(EntityLivingBase entity, float concentration) {
        SpreadableExposure exposure = CompatibleExposureCapability.getExposure((Entity)entity, this.getExposureType());
        if (exposure == null) {
            exposure = this.createSpreadableExposure();
            CompatibleExposureCapability.updateExposure((Entity)entity, exposure);
        }
        exposure.apply(this, (Entity)entity, concentration);
    }

    protected Class<SpreadableExposure> getExposureType() {
        return SpreadableExposure.class;
    }

    protected SpreadableExposure createSpreadableExposure() {
        return new SpreadableExposure(5000L, this.field_70170_p.func_82737_E());
    }

    private void spread() {
        long currentWorldTime = this.field_70170_p.func_82737_E();
        if ((float)(currentWorldTime - this.lastSpreadTimestamp) <= 20.0f / this.spreadRate) {
            return;
        }
        this.lastSpreadTimestamp = currentWorldTime;
        if (this.currentSpread == null) {
            this.currentSpread = new ArrayList<BlockPos>();
            this.initSpreadBox();
            BlockPos blockPos = new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            this.currentSpread.add(blockPos);
            this.spreadMap.put(blockPos, Float.valueOf(this.initialConcentration));
        }
        ArrayList<BlockPos> newSpread = new ArrayList<BlockPos>();
        for (BlockPos blockPos : this.currentSpread) {
            BlockPos nearer;
            BlockPos farther;
            BlockPos right;
            BlockPos left;
            BlockPos bottom;
            float concentration = this.spreadMap.getOrDefault(blockPos, Float.valueOf(0.0f)).floatValue();
            BlockPos top = new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o() + 1, blockPos.func_177952_p());
            if (this.updateSpreadAtPosition(top, concentration * this.concentrationSpreadUpFactor)) {
                newSpread.add(top);
            }
            if (this.updateSpreadAtPosition(bottom = new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o() - 1, blockPos.func_177952_p()), concentration * this.concentrationSpreadDownFactor)) {
                newSpread.add(bottom);
            }
            if (this.updateSpreadAtPosition(left = new BlockPos(blockPos.func_177958_n() - 1, blockPos.func_177956_o(), blockPos.func_177952_p()), concentration * this.concentrationSpreadSideFactor)) {
                newSpread.add(left);
            }
            if (this.updateSpreadAtPosition(right = new BlockPos(blockPos.func_177958_n() + 1, blockPos.func_177956_o(), blockPos.func_177952_p()), concentration * this.concentrationSpreadSideFactor)) {
                newSpread.add(right);
            }
            if (this.updateSpreadAtPosition(farther = new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p() + 1), concentration * this.concentrationSpreadSideFactor)) {
                newSpread.add(farther);
            }
            if (!this.updateSpreadAtPosition(nearer = new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p() - 1), concentration * this.concentrationSpreadSideFactor)) continue;
            newSpread.add(nearer);
        }
        this.currentSpread = newSpread;
        this.concentrationDecayAdjustment *= this.concentrationDecayFactor;
        if (this.currentSpread.isEmpty()) {
            Iterator<Map.Entry<BlockPos, Float>> it = this.spreadMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<BlockPos, Float> e = it.next();
                if (!(e.getValue().floatValue() * this.concentrationDecayAdjustment < this.minConcentrationThreshold)) continue;
                it.remove();
            }
            if (this.spreadMap.isEmpty()) {
                this.func_70106_y();
            }
        }
    }

    private boolean updateSpreadAtPosition(BlockPos blockPos, float concentration) {
        Float currentConcentration;
        float adjustedConcentration = concentration * this.concentrationDecayAdjustment;
        if (adjustedConcentration < this.minConcentrationThreshold) {
            return false;
        }
        boolean result = false;
        IBlockState iBlockState = this.field_70170_p.func_180495_p(blockPos);
        if (iBlockState.func_177230_c() == Blocks.field_150350_a && ((currentConcentration = this.spreadMap.get(blockPos)) == null || currentConcentration.floatValue() < concentration)) {
            this.spreadMap.put(blockPos, Float.valueOf(concentration));
            result = true;
        }
        return result;
    }

    @Override
    public UUID getId() {
        return this.func_110124_au();
    }
}

