/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.asm.Interceptors;
import com.paneedah.mwc.network.messages.VehicleInteractMessage;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.MWCUtil;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.mwc.utils.PlayerUtil;
import com.paneedah.weaponlib.BlankStateMapper;
import com.paneedah.weaponlib.BulletHoleRenderer;
import com.paneedah.weaponlib.ClientModContext;
import com.paneedah.weaponlib.KeyBindings;
import com.paneedah.weaponlib.LightExposure;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.PipelineShaderGroupSourceProvider;
import com.paneedah.weaponlib.PlayerItemInstance;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.RenderingPhase;
import com.paneedah.weaponlib.SpreadableExposure;
import com.paneedah.weaponlib.WeaponState;
import com.paneedah.weaponlib.animation.AnimationModeProcessor;
import com.paneedah.weaponlib.animation.ClientValueRepo;
import com.paneedah.weaponlib.animation.gui.AnimationGUI;
import com.paneedah.weaponlib.animation.movement.WeaponRotationHandler;
import com.paneedah.weaponlib.command.DebugCommand;
import com.paneedah.weaponlib.compatibility.CompatibleExposureCapability;
import com.paneedah.weaponlib.compatibility.ModelRegistryServerInterchange;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.perspective.Perspective;
import com.paneedah.weaponlib.render.HDRFramebuffer;
import com.paneedah.weaponlib.render.IHasModel;
import com.paneedah.weaponlib.render.MWCFrameTimer;
import com.paneedah.weaponlib.render.bgl.PostProcessPipeline;
import com.paneedah.weaponlib.render.shells.ShellManager;
import com.paneedah.weaponlib.shader.DynamicShaderContext;
import com.paneedah.weaponlib.shader.DynamicShaderGroupManager;
import com.paneedah.weaponlib.shader.DynamicShaderGroupSource;
import com.paneedah.weaponlib.shader.DynamicShaderPhase;
import com.paneedah.weaponlib.tracking.LivingEntityTracker;
import com.paneedah.weaponlib.vehicle.EntityVehicle;
import com.paneedah.weaponlib.vehicle.collisions.OreintedBB;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ClientEventHandler {
    public static boolean freecamEnabled = false;
    public static boolean freecamLock = false;
    public static boolean muzzlePositioner = false;
    public static boolean cancelSway = false;
    public static double freeYaw = 0.0;
    public static double freePitch = 0.0;
    public static double yawDelta = 0.0;
    public static double pitchDelta = 0.0;
    public static final ShellManager SHELL_MANAGER = new ShellManager();
    public static final BulletHoleRenderer BULLET_HOLE_RENDERER = new BulletHoleRenderer();
    public static HashMap<Integer, Stack<Long>> muzzleFlashMap = new HashMap();
    public static Vec3d debugmuzzlePosition = new Vec3d(0.0, -1.0, -6.5);
    public static Vec3d magRotPositioner = Vec3d.field_186680_a;
    private static Field EVENT_DWHEEL_FIELD = null;
    private Entity originalRenderViewEntity;
    private static final int DEFAULT_RECONCILE_TIMEOUT_MILLIS = 5000;
    private static final float SLOW_DOWN_WHEN_POISONED_DOSE_THRESHOLD = 0.4f;
    private static final UUID SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER_UUID = UUID.fromString("8efa8469-0256-4f8e-bdd9-3e7b23970663");
    private static final AttributeModifier SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER = new AttributeModifier(SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER_UUID, "Slow Down While Zooming", -0.3, 2).func_111168_a(false);
    private static final UUID SLOW_DOWN_WHILE_PRONING_ATTRIBUTE_MODIFIER_UUID = UUID.fromString("a3fa1751-953d-4b6c-955b-6824a193d271");
    private static final AttributeModifier SLOW_DOWN_WHILE_PRONING_ATTRIBUTE_MODIFIER = new AttributeModifier(SLOW_DOWN_WHILE_PRONING_ATTRIBUTE_MODIFIER_UUID, "Slow Down While Proning", -0.7, 2).func_111168_a(false);
    private static final UUID SLOW_DOWN_WHILE_POISONED_ATTRIBUTE_MODIFIER_UUID = UUID.fromString("9d2eac95-9b9c-4942-8287-7952c6de353e");
    private static final AttributeModifier SLOW_DOWN_WHILE_POISONED_ATTRIBUTE_MODIFIER = new AttributeModifier(SLOW_DOWN_WHILE_POISONED_ATTRIBUTE_MODIFIER_UUID, "Slow Down While Poisoned", -0.7, 2).func_111168_a(false);
    public static Stack<MuzzleFlash> muzzleFlashStack = new Stack();
    private final ClientModContext modContext;
    private final DynamicShaderGroupManager shaderGroupManager;
    private final PipelineShaderGroupSourceProvider pipelineShaderGroupSourceProvider = new PipelineShaderGroupSourceProvider();
    private int currentSlotIndex;
    public static ArrayList<Block> BLANKMAPPED_LIST = new ArrayList();
    public static ArrayList<IHasModel> ITEM_REG = new ArrayList();
    public MWCFrameTimer frameTimer = new MWCFrameTimer();
    public static TextureAtlasSprite carParticles;

    protected ModContext getModContext() {
        return this.modContext;
    }

    public ClientEventHandler(ClientModContext modContext) {
        this.modContext = modContext;
        this.shaderGroupManager = new DynamicShaderGroupManager();
    }

    @SubscribeEvent
    public void onModelRegistry(ModelRegistryEvent event) {
        for (Block b : BLANKMAPPED_LIST) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)BlankStateMapper.DEFAULT);
        }
        for (IHasModel ima : ITEM_REG) {
            ima.registerModels();
        }
        for (Item i : ModelRegistryServerInterchange.ITEM_MODEL_REG) {
            ModelLoader.setCustomModelResourceLocation((Item)i, (int)0, (ModelResourceLocation)new ModelResourceLocation(i.getRegistryName(), "inventory"));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public final void onTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = ClientProxy.MC.field_71439_g;
        if (event.phase == TickEvent.Phase.START) {
            this.updateOnStartTick();
        } else if (event.phase == TickEvent.Phase.END) {
            this.update();
            this.modContext.getSyncManager().run();
            LivingEntityTracker tracker = LivingEntityTracker.getTracker((EntityLivingBase)ClientProxy.MC.field_71439_g);
            if (tracker != null) {
                tracker.update();
            }
            if (player instanceof EntityPlayerSP && player.func_184187_bx() instanceof EntityVehicle) {
                EntityPlayerSP clientPlayer = player;
                EntityVehicle entityBoat = (EntityVehicle)clientPlayer.func_184187_bx();
                entityBoat.updateInputs(clientPlayer.field_71158_b.field_187257_e, clientPlayer.field_71158_b.field_187258_f, clientPlayer.field_71158_b.field_187255_c, clientPlayer.field_71158_b.field_187256_d);
            }
            if (ClientProxy.MC.field_71439_g != null) {
                // empty if block
            }
        }
        if (player != null && event.phase == TickEvent.Phase.END) {
            double yAmount = ClientValueRepo.recoilWoundY * 0.2;
            player.field_70125_A = (float)((double)player.field_70125_A + yAmount);
            ClientValueRepo.recoilWoundY -= yAmount;
        }
        if (event.phase != TickEvent.Phase.START || ClientProxy.MC.field_71439_g == null) {
            return;
        }
        if (ModernConfigManager.enableFancyRainAndSnow && PostProcessPipeline.getWeatherRenderer() != null && PostProcessPipeline.getWeatherRenderer().shouldRecalculateRainVectors((EntityPlayer)ClientProxy.MC.field_71439_g)) {
            PostProcessPipeline.getWeatherRenderer().recalculateRainVectors((EntityPlayer)ClientProxy.MC.field_71439_g, MWCUtil.getInterpolatedPlayerPos());
        }
        if (this.getModContext() != null) {
            ClientValueRepo.update(this.getModContext());
            if (this.getModContext().getMainHeldWeapon() != null) {
                WeaponRotationHandler.STRAFING_ANIMATION.update(0.08f);
                WeaponRotationHandler.RUNNING_ANIMATION.update(0.08f);
                WeaponRotationHandler.WALKING_ANIMATION.update(0.08f);
            }
        }
        int ticksRequired = (int)Math.round(AnimationGUI.getInstance().debugFireRate.getValue());
        if (DebugCommand.isWorkingOnScreenShake() && ClientProxy.MC.field_71439_g.field_70173_aa % 20 == 0 && this.getModContext().getMainHeldWeapon() != null) {
            ClientEventHandler.uploadFlash(ClientProxy.MC.field_71439_g.func_145782_y());
            ClientValueRepo.fireWeapon(this.getModContext().getMainHeldWeapon());
        }
        if (ClientProxy.MC.field_71439_g.field_70173_aa % ticksRequired == 0 && AnimationModeProcessor.getInstance().getFPSMode() && !AnimationGUI.getInstance().isPanelClosed("Recoil")) {
            ClientValueRepo.fireWeapon(this.getModContext().getMainHeldWeapon());
        }
        ClientValueRepo.TICKER.update(ClientProxy.MC.field_71439_g.field_70173_aa);
        SHELL_MANAGER.update(0.05);
    }

    private void updateOnStartTick() {
        int newSlotIndex;
        EntityPlayerSP player = ClientProxy.MC.field_71439_g;
        if (player != null && this.currentSlotIndex != (newSlotIndex = player.field_71071_by.field_70461_c)) {
            this.currentSlotIndex = newSlotIndex;
            this.modContext.getWeaponReloadAspect().drawMainHeldItem((EntityPlayer)player);
        }
    }

    private void update() {
        SpreadableExposure spreadableExposure;
        EntityPlayerSP player = ClientProxy.MC.field_71439_g;
        if (player == null) {
            return;
        }
        this.modContext.getPlayerItemInstanceRegistry().update((EntityPlayer)player);
        PlayerWeaponInstance mainHandHeldWeaponInstance = this.modContext.getMainHeldWeapon();
        if (PlayerUtil.isProning((EntityPlayer)player)) {
            PlayerUtil.slowPlayerDown((EntityPlayer)player, SLOW_DOWN_WHILE_PRONING_ATTRIBUTE_MODIFIER);
        } else {
            PlayerUtil.restorePlayerSpeed((EntityPlayer)player, SLOW_DOWN_WHILE_PRONING_ATTRIBUTE_MODIFIER);
        }
        if (mainHandHeldWeaponInstance != null) {
            if (player.func_70051_ag()) {
                mainHandHeldWeaponInstance.setAimed(false);
            }
            if (mainHandHeldWeaponInstance.isAimed()) {
                PlayerUtil.slowPlayerDown((EntityPlayer)player, SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER);
            } else {
                PlayerUtil.restorePlayerSpeed((EntityPlayer)player, SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER);
            }
            if (mainHandHeldWeaponInstance != null && mainHandHeldWeaponInstance.getState() == WeaponState.READY && mainHandHeldWeaponInstance.getStateUpdateTimestamp() + 5000L < System.currentTimeMillis() && mainHandHeldWeaponInstance.getSyncStartTimestamp() == 0L && mainHandHeldWeaponInstance.getUpdateTimestamp() + 5000L < System.currentTimeMillis()) {
                mainHandHeldWeaponInstance.reconcile();
            }
        } else {
            PlayerUtil.restorePlayerSpeed((EntityPlayer)player, SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER);
        }
        if ((spreadableExposure = CompatibleExposureCapability.getExposure((Entity)ClientProxy.MC.field_71439_g, SpreadableExposure.class)) != null && spreadableExposure.getTotalDose() > 0.4f) {
            PlayerUtil.slowPlayerDown((EntityPlayer)player, SLOW_DOWN_WHILE_POISONED_ATTRIBUTE_MODIFIER);
        } else {
            PlayerUtil.restorePlayerSpeed((EntityPlayer)player, SLOW_DOWN_WHILE_POISONED_ATTRIBUTE_MODIFIER);
        }
        LightExposure lightExposure = CompatibleExposureCapability.getExposure((Entity)ClientProxy.MC.field_71439_g, LightExposure.class);
        if (lightExposure != null && !ClientProxy.MC.func_147113_T()) {
            lightExposure.update((Entity)ClientProxy.MC.field_71439_g);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public final void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        DynamicShaderContext shaderContext = new DynamicShaderContext(DynamicShaderPhase.POST_WORLD_RENDER, ClientProxy.MC.field_71460_t, ClientProxy.MC.func_147110_a(), event.renderTickTime);
        EntityPlayerSP clientPlayer = ClientProxy.MC.field_71439_g;
        if (event.phase == TickEvent.Phase.START) {
            ClientModContext.currentContext = this.modContext;
            if (clientPlayer != null) {
                Perspective<?> view;
                PlayerItemInstance<?> instance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)clientPlayer);
                DynamicShaderGroupSource source = this.pipelineShaderGroupSourceProvider.getShaderSource(shaderContext.getPhase());
                if (source != null) {
                    this.shaderGroupManager.loadFromSource(shaderContext, source);
                }
                if (instance != null && (view = this.modContext.getViewManager().getPerspective(instance, true)) != null) {
                    view.update(event);
                }
            }
        } else if (event.phase == TickEvent.Phase.END) {
            ClientProxy.renderingPhase = null;
            this.shaderGroupManager.removeStaleShaders(shaderContext);
        }
    }

    @SubscribeEvent
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        RenderingPhase phase;
        Framebuffer current;
        PlayerWeaponInstance pwi;
        if (ModernConfigManager.enableAllShaders && ModernConfigManager.enableWorldShaders) {
            PostProcessPipeline.captureMatricesIntoBuffers();
        }
        PostProcessPipeline.setWorldElements();
        this.frameTimer.markFrame();
        double divisor = 120.0 / this.frameTimer.getFramerate() * 0.05;
        divisor = Math.min(0.08, divisor);
        Interceptors.nsm.update();
        BULLET_HOLE_RENDERER.render();
        if (ClientModContext.getContext() != null && ClientModContext.getContext().getMainHeldWeapon() != null && (pwi = ClientModContext.getContext().getMainHeldWeapon()).getState() == WeaponState.READY) {
            pwi.setDelayCompoundEnd(true);
            pwi.getWeapon().getRenderer().setShouldDoEmptyVariant(false);
        }
        if (ModernConfigManager.enableHDRFramebuffer && !((current = ClientProxy.MC.func_147110_a()) instanceof HDRFramebuffer)) {
            ClientProxy.MC.field_147124_at = new HDRFramebuffer(current.field_147621_c, current.field_147618_d, current.field_147619_e);
        }
        if (this.getModContext() != null) {
            boolean bl = AnimationModeProcessor.getInstance().legacyMode = this.getModContext().getMainHeldWeapon() == null || !this.getModContext().getMainHeldWeapon().getWeapon().builder.isUsingNewSystem();
        }
        if ((phase = ClientProxy.renderingPhase) == RenderingPhase.RENDER_PERSPECTIVE) {
            return;
        }
        SHELL_MANAGER.render();
        if (AnimationModeProcessor.getInstance().getFPSMode()) {
            ClientProxy.MC.func_71364_i();
            AnimationModeProcessor.getInstance().onTick();
            ClientProxy.MC.field_71439_g.field_71071_by.field_70461_c = 0;
            return;
        }
        if (ModernConfigManager.enableAllShaders && ModernConfigManager.enableWorldShaders) {
            if (PostProcessPipeline.shouldDoFog()) {
                PostProcessPipeline.blitDepth();
            }
            PostProcessPipeline.doWorldProcessing();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    protected void onPreRenderPlayerPreEvent(RenderPlayerEvent.Pre event) {
        if (event.getEntityPlayer().func_184218_aH() && event.getEntityPlayer().func_184187_bx() instanceof EntityVehicle && event.getEntityPlayer().field_184619_aG != 39.0f) {
            event.setCanceled(true);
        }
        ClientModContext modContext = (ClientModContext)this.getModContext();
        if (ClientProxy.renderingPhase == RenderingPhase.RENDER_PERSPECTIVE && event.getEntityPlayer() instanceof EntityPlayerSP) {
            this.originalRenderViewEntity = event.getRenderer().func_177068_d().field_78734_h;
            event.getRenderer().func_177068_d().field_78734_h = event.getEntityPlayer();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public final void onPostRenderPlayer(RenderPlayerEvent.Post event) {
        if (ClientProxy.renderingPhase == RenderingPhase.RENDER_PERSPECTIVE && event.getEntityPlayer() instanceof EntityPlayerSP) {
            event.getRenderer().func_177068_d().field_78734_h = this.originalRenderViewEntity;
        }
    }

    @SubscribeEvent
    public void onRightHandEmpty(PlayerInteractEvent.RightClickEmpty event) {
        EntityPlayerSP player = ClientProxy.MC.field_71439_g;
        List entityVehicleList = player.field_70170_p.func_72872_a(EntityVehicle.class, new AxisAlignedBB(player.func_180425_c()).func_186662_g(10.0));
        if (entityVehicleList.isEmpty()) {
            return;
        }
        for (EntityVehicle entityVehicle : entityVehicleList) {
            OreintedBB boundingBox = entityVehicle.getOreintedBoundingBox();
            Vec3d start = player.func_174824_e(ClientProxy.MC.func_184121_ak());
            Vec3d endVec = start.func_178787_e(player.func_70040_Z().func_186678_a(7.0));
            boundingBox.updateInverse();
            if (boundingBox.doRayTrace(start, endVec) == null) continue;
            MWC.CHANNEL.sendToServer((IMessage)new VehicleInteractMessage(true, entityVehicle.func_145782_y(), player.func_145782_y()));
            return;
        }
    }

    @SubscribeEvent
    public void onLeftHandEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        EntityPlayerSP player = ClientProxy.MC.field_71439_g;
        List entityVehicleList = player.field_70170_p.func_72872_a(EntityVehicle.class, new AxisAlignedBB(player.func_180425_c()).func_186662_g(3.0));
        if (entityVehicleList.isEmpty()) {
            return;
        }
        for (EntityVehicle entityVehicle : entityVehicleList) {
            Vec3d endVec;
            Vec3d start;
            OreintedBB boundingBox = entityVehicle.getOreintedBoundingBox();
            if (boundingBox.doRayTrace(start = player.func_174824_e(ClientProxy.MC.func_184121_ak()), endVec = start.func_178787_e(player.func_70040_Z().func_186678_a(4.0))) == null) continue;
            MWC.CHANNEL.sendToServer((IMessage)new VehicleInteractMessage(false, entityVehicle.func_145782_y(), player.func_145782_y()));
            return;
        }
    }

    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(this.getModContext().getNamedResource("particle/blood"));
        carParticles = event.getMap().func_174942_a(new ResourceLocation("mwc:particle/carparticle"));
    }

    @SubscribeEvent
    public void mouseMove(MouseEvent mouseEvent) {
        if (!AnimationModeProcessor.getInstance().getFPSMode()) {
            return;
        }
        AnimationModeProcessor animationModeProcessor = AnimationModeProcessor.getInstance();
        double pan = Math.max(0.01, Math.abs(animationModeProcessor.pan.field_72449_c) / 10000.0);
        animationModeProcessor.pan = animationModeProcessor.pan.func_72441_c(0.0, 0.0, (double)mouseEvent.getDwheel() * pan);
        if (EVENT_DWHEEL_FIELD == null) {
            EVENT_DWHEEL_FIELD = ReflectionHelper.findField(Mouse.class, (String[])new String[]{"event_dwheel"});
        }
        try {
            EVENT_DWHEEL_FIELD.set(null, 0);
        }
        catch (Exception e) {
            ModReference.LOG.error("Could not assign value to EVENT_DWHEEL_FIELD!");
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public final void updateFOV(FOVUpdateEvent fovUpdateEvent) {
        EntityPlayer player = fovUpdateEvent.getEntity();
        if (!player.func_184218_aH() || !(player.func_184187_bx() instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)player.func_184187_bx();
        fovUpdateEvent.setNewfov((float)((double)fovUpdateEvent.getFov() + (vehicle.getSolver().getSyntheticAcceleration() / 55.0 + vehicle.getRealSpeed() / 120.0) * 0.2));
    }

    @SubscribeEvent
    public void keyInputEvent(GuiScreenEvent.KeyboardInputEvent kie) {
        if (Keyboard.isKeyDown((int)KeyBindings.freecamLock.func_151463_i())) {
            freecamLock = !freecamLock;
        }
    }

    @SubscribeEvent
    public final void properCameraSetup(EntityViewRenderEvent.CameraSetup cameraSetupEvent) {
        if (freecamEnabled) {
            if (Keyboard.isKeyDown((int)KeyBindings.freecamRotate.func_151463_i()) && freecamEnabled) {
                freeYaw += yawDelta;
                freePitch += pitchDelta;
            } else if (!freecamLock) {
                freeYaw = 0.0;
                freePitch = 0.0;
            }
            cameraSetupEvent.setYaw((float)freeYaw);
            cameraSetupEvent.setPitch((float)freePitch);
        }
        yawDelta = 0.0;
        pitchDelta = 0.0;
    }

    public static boolean checkShot(int entityID) {
        if (muzzleFlashMap.isEmpty() || !muzzleFlashMap.containsKey(entityID) || muzzleFlashMap.get(entityID).isEmpty()) {
            return false;
        }
        if (System.currentTimeMillis() - muzzleFlashMap.get(entityID).peek() > 25L) {
            muzzleFlashMap.get(entityID).pop();
        }
        return true;
    }

    public static void uploadFlash(int entityID) {
        if (muzzleFlashMap.containsKey(entityID)) {
            muzzleFlashMap.get(entityID).push(System.currentTimeMillis());
        } else {
            Stack<Long> stack = new Stack<Long>();
            stack.push(System.currentTimeMillis());
            muzzleFlashMap.put(entityID, stack);
        }
    }

    public static class MuzzleFlash {
        public Vec3d pos;
        public float yaw;
        public Vec3d thirdPersonPos;
        public float pitch;
        public double scale;

        public MuzzleFlash(Vec3d pos, Vec3d thirdPersonPos, float yaw, float pitch, double scale) {
            this.pos = pos;
            this.thirdPersonPos = thirdPersonPos;
            this.yaw = yaw;
            this.pitch = pitch;
            this.scale = scale;
        }
    }
}

