/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.renderer.ModelSourceTransforms;
import com.paneedah.mwc.renderer.StaticModelSourceRenderer;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.CompatibleAttachment;
import com.paneedah.weaponlib.CustomRenderer;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.Part;
import com.paneedah.weaponlib.Tuple;
import com.paneedah.weaponlib.animation.Transform;
import com.paneedah.weaponlib.crafting.CraftingComplexity;
import com.paneedah.weaponlib.crafting.CraftingEntry;
import com.paneedah.weaponlib.crafting.CraftingGroup;
import com.paneedah.weaponlib.crafting.CraftingRegistry;
import com.paneedah.weaponlib.crafting.OptionsMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.model.ModelBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class AttachmentBuilder<T> {
    public static int noRecipe = 0;
    protected String name;
    protected ModelBase model;
    protected String textureName;
    protected ModelSourceTransforms transforms = ModelSourceTransforms.builder().entityPositioning(() -> new Transform().withScale(0.17, 0.17, 0.17).withPosition(-0.5, -0.5, 0.6).doGLDirect()).build();
    protected Vec3d rotationPoint;
    protected CreativeTabs tab;
    protected AttachmentCategory attachmentCategory;
    protected ItemAttachment.ApplyHandler<T> apply;
    protected ItemAttachment.ApplyHandler<T> remove;
    protected ItemAttachment.ApplyHandler2<T> apply2;
    protected ItemAttachment.ApplyHandler2<T> remove2;
    private String crosshair;
    private List<CustomRenderer<?>> postRenderer = new ArrayList();
    private List<Tuple<ModelBase, String>> texturedModels = new ArrayList<Tuple<ModelBase, String>>();
    private boolean isRenderablePart;
    private int maxStackSize = 1;
    private Function<ItemStack, String> informationProvider;
    private CraftingComplexity craftingComplexity;
    private Object[] craftingMaterials;
    Map<ItemAttachment<T>, CompatibleAttachment<T>> compatibleAttachments = new HashMap<ItemAttachment<T>, CompatibleAttachment<T>>();
    private int craftingCount = 1;
    private Object[] craftingRecipe;
    private List<ItemAttachment<T>> requiredAttachments = new ArrayList<ItemAttachment<T>>();
    private CraftingEntry[] modernRecipe;
    private CraftingGroup craftingGroup;

    public AttachmentBuilder<T> withCategory(AttachmentCategory attachmentCategory) {
        this.attachmentCategory = attachmentCategory;
        return this;
    }

    public AttachmentBuilder<T> withModernRecipe(CraftingGroup group, CraftingEntry ... is) {
        this.modernRecipe = is;
        this.craftingGroup = group;
        return this;
    }

    public AttachmentBuilder<T> withName(String name) {
        this.name = name;
        return this;
    }

    public AttachmentBuilder<T> withCreativeTab(CreativeTabs tab) {
        this.tab = tab;
        return this;
    }

    public AttachmentBuilder<T> withRotationPoint(double x, double y, double z) {
        this.rotationPoint = new Vec3d(x, y, z);
        return this;
    }

    public AttachmentBuilder<T> withCompatibleAttachment(ItemAttachment<T> attachment, Consumer<ModelBase> positioner) {
        this.compatibleAttachments.put(attachment, new CompatibleAttachment<T>(attachment, positioner));
        return this;
    }

    @SafeVarargs
    public final AttachmentBuilder<T> withRequiredAttachments(ItemAttachment<T> ... requiredAttachments) {
        for (int i = 0; i < requiredAttachments.length; ++i) {
            this.requiredAttachments.add(requiredAttachments[i]);
        }
        return this;
    }

    public AttachmentBuilder<T> withModel(ModelBase model) {
        this.model = model;
        return this;
    }

    public AttachmentBuilder<T> withTextureName(String textureName) {
        this.textureName = textureName.toLowerCase();
        return this;
    }

    public AttachmentBuilder<T> withMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        return this;
    }

    public AttachmentBuilder<T> withEntityPositioning(Runnable entityPositioning) {
        this.transforms.setEntityPositioning(entityPositioning);
        return this;
    }

    public AttachmentBuilder<T> withInventoryPositioning(Runnable inventoryPositioning) {
        this.transforms.setInventoryPositioning(inventoryPositioning);
        return this;
    }

    public AttachmentBuilder<T> withThirdPersonPositioning(Runnable thirdPersonPositioning) {
        this.transforms.setThirdPersonPositioning(thirdPersonPositioning);
        return this;
    }

    public AttachmentBuilder<T> withFirstPersonPositioning(Runnable firstPersonPositioning) {
        this.transforms.setFirstPersonPositioning(firstPersonPositioning);
        return this;
    }

    public AttachmentBuilder<T> withFirstPersonModelPositioning(Consumer<ModelBase> firstPersonModelPositioning) {
        this.transforms.setFirstPersonModelPositioning(firstPersonModelPositioning);
        return this;
    }

    public AttachmentBuilder<T> withEntityModelPositioning(Consumer<ModelBase> entityModelPositioning) {
        this.transforms.setEntityModelPositioning(entityModelPositioning);
        return this;
    }

    public AttachmentBuilder<T> withInventoryModelPositioning(Consumer<ModelBase> inventoryModelPositioning) {
        this.transforms.setInventoryModelPositioning(inventoryModelPositioning);
        return this;
    }

    public AttachmentBuilder<T> withThirdPersonModelPositioning(Consumer<ModelBase> thirdPersonModelPositioning) {
        this.transforms.setThirdPersonModelPositioning(thirdPersonModelPositioning);
        return this;
    }

    public AttachmentBuilder<T> withFirstPersonHandPositioning(Runnable leftHand, Runnable rightHand) {
        this.transforms.setFirstPersonLeftHandPositioning(leftHand);
        this.transforms.setFirstPersonRightHandPositioning(rightHand);
        return this;
    }

    public AttachmentBuilder<T> withCrosshair(String crosshair) {
        this.crosshair = crosshair.toLowerCase();
        return this;
    }

    public AttachmentBuilder<T> withPostRender(CustomRenderer<?> postRenderer) {
        this.postRenderer.add(postRenderer);
        return this;
    }

    public AttachmentBuilder<T> withModel(ModelBase model, String textureName) {
        this.texturedModels.add(new Tuple<ModelBase, String>(model, textureName.toLowerCase()));
        return this;
    }

    public AttachmentBuilder<T> withRenderablePart() {
        this.isRenderablePart = true;
        return this;
    }

    public AttachmentBuilder<T> withApply(ItemAttachment.ApplyHandler<T> apply) {
        this.apply = apply;
        return this;
    }

    public AttachmentBuilder<T> withRemove(ItemAttachment.ApplyHandler<T> remove) {
        this.remove = remove;
        return this;
    }

    public AttachmentBuilder<T> withApply(ItemAttachment.ApplyHandler2<T> apply) {
        this.apply2 = apply;
        return this;
    }

    public AttachmentBuilder<T> withRemove(ItemAttachment.ApplyHandler2<T> remove) {
        this.remove2 = remove;
        return this;
    }

    public AttachmentBuilder<T> withCrafting(CraftingComplexity craftingComplexity, Object ... craftingMaterials) {
        return this.withCrafting(1, craftingComplexity, craftingMaterials);
    }

    public AttachmentBuilder<T> withInformationProvider(Function<ItemStack, String> informationProvider) {
        this.informationProvider = informationProvider;
        return this;
    }

    public AttachmentBuilder<T> withCrafting(int craftingCount, CraftingComplexity craftingComplexity, Object ... craftingMaterials) {
        if (craftingComplexity == null) {
            throw new IllegalArgumentException("Crafting complexity not set");
        }
        if (craftingMaterials.length < 2) {
            throw new IllegalArgumentException("2 or more materials required for crafting");
        }
        if (craftingCount == 0) {
            throw new IllegalArgumentException("Invalid item count");
        }
        this.craftingComplexity = craftingComplexity;
        this.craftingMaterials = craftingMaterials;
        this.craftingCount = craftingCount;
        return this;
    }

    public AttachmentBuilder<T> withCraftingRecipe(Object ... craftingRecipe) {
        this.craftingRecipe = craftingRecipe;
        return this;
    }

    protected ItemAttachment<T> createAttachment(ModContext modContext) {
        return new ItemAttachment<T>(this.attachmentCategory, this.crosshair, this.apply, this.remove);
    }

    public ItemAttachment<T> build(ModContext modContext) {
        ItemAttachment attachment = this.createAttachment(modContext);
        attachment.func_77655_b("mwc_" + this.name);
        attachment.func_77637_a(this.tab);
        attachment.setPostRenderer(this.postRenderer);
        attachment.setName(this.name);
        attachment.apply2 = this.apply2;
        attachment.setCraftingGroup(this.craftingGroup);
        attachment.setModernRecipe(this.modernRecipe);
        CraftingRegistry.registerHook(attachment);
        if (this.rotationPoint != null) {
            attachment.rotationPoint = this.rotationPoint;
        }
        attachment.remove2 = this.remove2;
        attachment.field_77777_bU = this.maxStackSize;
        attachment.setRequiredAttachments(this.requiredAttachments);
        if (attachment.getInformationProvider() == null) {
            attachment.setInformationProvider(this.informationProvider);
        }
        if (this.getTextureName() != null) {
            attachment.setTextureName("mwc:" + AttachmentBuilder.stripFileExtension(this.getTextureName(), ".png"));
        }
        if (this.isRenderablePart) {
            attachment.setRenderablePart(new Part(){

                public String toString() {
                    return AttachmentBuilder.this.name != null ? "Part [" + AttachmentBuilder.this.name + "]" : super.toString();
                }
            });
        }
        if (this.getModel() != null) {
            attachment.addModel(this.getModel(), AttachmentBuilder.addFileExtension(this.getTextureName(), ".png"));
        }
        this.texturedModels.forEach(tm -> attachment.addModel((ModelBase)tm.getU(), AttachmentBuilder.addFileExtension((String)tm.getV(), ".png")));
        this.compatibleAttachments.values().forEach(a -> attachment.addCompatibleAttachment((CompatibleAttachment)a));
        if (this.getModel() != null || !this.texturedModels.isEmpty()) {
            modContext.registerRenderableItem(this.name, attachment, (Object)(FMLCommonHandler.instance().getSide() == Side.CLIENT ? new StaticModelSourceRenderer(this.transforms) : null));
        }
        if (this.craftingRecipe != null && this.craftingRecipe.length >= 2) {
            modContext.getRecipeManager().registerShapedRecipe(attachment, this.craftingRecipe);
        } else if (this.craftingComplexity != null) {
            OptionsMetadata optionsMetadata = new OptionsMetadata.OptionMetadataBuilder().withSlotCount(9).build(this.craftingComplexity, Arrays.copyOf(this.craftingMaterials, this.craftingMaterials.length));
            List<Object> shape = modContext.getRecipeManager().createShapedRecipe(attachment, this.name, optionsMetadata);
            ItemStack itemStack = new ItemStack(attachment);
            itemStack.func_190920_e(this.craftingCount);
            if (optionsMetadata.hasOres()) {
                ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, itemStack, shape.toArray()).setMirrored(false).setRegistryName("mwc", itemStack.func_77973_b().func_77658_a() + "_recipe"));
            } else {
                ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, itemStack, shape.toArray()).setMirrored(false).setRegistryName("mwc", itemStack.func_77973_b().func_77658_a() + "_recipe"));
            }
        } else if (attachment.getCategory() == AttachmentCategory.GRIP || attachment.getCategory() == AttachmentCategory.SCOPE || attachment.getCategory() == AttachmentCategory.MAGAZINE || attachment.getCategory() == AttachmentCategory.BULLET || attachment.getCategory() == AttachmentCategory.SILENCER || attachment.getCategory() == AttachmentCategory.SKIN || attachment.getCategory() == AttachmentCategory.LASER) {
            ++noRecipe;
        }
        return attachment;
    }

    static String addFileExtension(String s, String ext) {
        return s != null && !s.endsWith(ext) ? s + ext : s;
    }

    protected static String stripFileExtension(String str, String extension) {
        return str.endsWith(extension) ? str.substring(0, str.length() - extension.length()) : str;
    }

    public <V extends ItemAttachment<T>> V build(ModContext modContext, Class<V> target) {
        return (V)((ItemAttachment)target.cast(this.build(modContext)));
    }

    public ModelBase getModel() {
        return this.model;
    }

    public String getTextureName() {
        return this.textureName;
    }
}

