/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.renderer;

import com.paneedah.mwc.capabilities.EquipmentCapability;
import com.paneedah.mwc.equipment.inventory.EquipmentInventory;
import com.paneedah.mwc.items.equipment.carryable.ItemBelt;
import com.paneedah.mwc.items.equipment.carryable.ItemCarryable;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.renderer.EquipmentModelPools;
import com.paneedah.weaponlib.ItemVest;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class EquipmentRenderer
implements LayerRenderer<EntityPlayer> {
    private final RenderPlayer renderer;

    public EquipmentRenderer(RenderPlayer rendererIn) {
        this.renderer = rendererIn;
    }

    public void doRenderLayer(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ModelBiped model;
        EquipmentInventory equipmentInventory = EquipmentCapability.getInventory((EntityLivingBase)player);
        if (equipmentInventory == null) {
            return;
        }
        ItemStack backpackSlot = equipmentInventory.func_70301_a(0);
        ItemStack beltSlot = equipmentInventory.func_70301_a(1);
        ItemStack vestSlot = equipmentInventory.func_70301_a(2);
        if (!backpackSlot.func_190926_b()) {
            ItemCarryable itemCarryable = (ItemCarryable)backpackSlot.func_77973_b();
            model = EquipmentModelPools.getEquipped(itemCarryable.modelName);
            this.doEquipmentRender(model, player, new ResourceLocation("mwc:textures/models/" + itemCarryable.textureName), limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        }
        if (!beltSlot.func_190926_b()) {
            ItemBelt itemBelt = (ItemBelt)beltSlot.func_77973_b();
            model = EquipmentModelPools.getEquipped(itemBelt.modelName);
            this.doEquipmentRender(model, player, new ResourceLocation("mwc:textures/models/" + itemBelt.textureName), limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        }
        if (!vestSlot.func_190926_b()) {
            ItemVest itemVest = (ItemVest)vestSlot.func_77973_b();
            model = EquipmentModelPools.getEquipped(itemVest.modelFileString);
            this.doEquipmentRender(model, player, new ResourceLocation("mwc:textures/models/" + itemVest.textureName), limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    public void doEquipmentRender(ModelBiped model, EntityPlayer player, ResourceLocation texture, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        float swingProgress = model.field_78095_p;
        boolean isRiding = model.field_78093_q;
        boolean isChild = model.field_78091_s;
        ModelBiped.ArmPose leftArmPose = model.field_187075_l;
        ModelBiped.ArmPose rightArmPose = model.field_187076_m;
        boolean isSneak = model.field_78117_n;
        ClientProxy.MC.func_110434_K().func_110577_a(texture);
        model.func_178686_a((ModelBase)this.renderer.func_177087_b());
        model.func_78088_a((Entity)ClientProxy.MC.field_71439_g, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        model.field_78095_p = swingProgress;
        model.field_78093_q = isRiding;
        model.field_78091_s = isChild;
        model.field_187075_l = leftArmPose;
        model.field_187076_m = rightArmPose;
        model.field_78117_n = isSneak;
    }

    public boolean func_177142_b() {
        return false;
    }
}

