/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.network.messages;

import io.netty.buffer.ByteBuf;
import io.redstudioragnarok.redcore.vectors.Vector3F;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class SpawnParticleMessage
implements IMessage {
    private ParticleType type;
    private int count;
    private Vector3F position = new Vector3F();
    private Vector3F velocity = new Vector3F();

    public void fromBytes(ByteBuf byteBuf) {
        this.type = ParticleType.values()[byteBuf.readInt()];
        this.count = byteBuf.readInt();
        this.position.read(byteBuf);
        this.velocity.read(byteBuf);
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.type.ordinal());
        byteBuf.writeInt(this.count);
        this.position.write(byteBuf);
        this.velocity.write(byteBuf);
    }

    public ParticleType getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public Vector3F getPosition() {
        return this.position;
    }

    public Vector3F getVelocity() {
        return this.velocity;
    }

    public SpawnParticleMessage() {
    }

    public SpawnParticleMessage(ParticleType type, int count, Vector3F position, Vector3F velocity) {
        this.type = type;
        this.count = count;
        this.position = position;
        this.velocity = velocity;
    }

    public static enum ParticleType {
        SMOKE_GRENADE_SMOKE,
        SMOKE_GRENADE_YELLOW_SMOKE;

    }
}

