/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.network.messages;

import com.paneedah.mwc.utils.ModReference;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class CraftingClientMessage
implements IMessage {
    private int opCode;
    private ByteArrayOutputStream fileStream;

    public void fromBytes(ByteBuf byteBuf) {
        int size = byteBuf.readInt();
        try {
            byteBuf.readBytes((OutputStream)this.fileStream, size);
        }
        catch (IOException ioException) {
            ModReference.RED_LOG.printFramedError("Networking", "Failed to read file stream for craft mappings", "Bad things will happen", new String[]{ioException.getMessage()});
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.opCode);
        byteBuf.writeBytes(this.fileStream.toByteArray());
    }

    public int getOpCode() {
        return this.opCode;
    }

    public ByteArrayOutputStream getFileStream() {
        return this.fileStream;
    }

    public CraftingClientMessage() {
    }

    public CraftingClientMessage(int opCode, ByteArrayOutputStream fileStream) {
        this.opCode = opCode;
        this.fileStream = fileStream;
    }
}

