/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.network.handlers;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.messages.WorkbenchClientMessage;
import com.paneedah.mwc.network.messages.WorkbenchServerMessage;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.crafting.CraftingEntry;
import com.paneedah.weaponlib.crafting.CraftingRegistry;
import com.paneedah.weaponlib.crafting.IModernCraftingRecipe;
import com.paneedah.weaponlib.crafting.ammopress.TileEntityAmmoPress;
import com.paneedah.weaponlib.crafting.base.TileEntityStation;
import com.paneedah.weaponlib.crafting.workbench.TileEntityWorkbench;
import io.redstudioragnarok.redcore.utils.MathUtil;
import io.redstudioragnarok.redcore.utils.NetworkUtil;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public final class WorkbenchServerMessageHandler
implements IMessageHandler<WorkbenchServerMessage, IMessage> {
    public IMessage onMessage(WorkbenchServerMessage workbenchServerMessage, MessageContext messageContext) {
        NetworkUtil.processMessage((MessageContext)messageContext, () -> {
            World world = messageContext.getServerHandler().field_147369_b.field_70170_p;
            TileEntity tileEntity = world.func_175625_s(workbenchServerMessage.getTeLocation());
            if (tileEntity instanceof TileEntityStation) {
                TileEntityStation station = (TileEntityStation)tileEntity;
                if (workbenchServerMessage.getOpCode() == 1) {
                    Item stackItem;
                    if (tileEntity instanceof TileEntityAmmoPress) {
                        TileEntityAmmoPress press = (TileEntityAmmoPress)station;
                        ItemStack newStack = new ItemStack(CraftingRegistry.getModernCrafting(workbenchServerMessage.getCraftingGroup(), workbenchServerMessage.getCraftingName()).getItemStack().func_77973_b(), workbenchServerMessage.getQuantity());
                        if (press.hasStack()) {
                            ItemStack topQueue = press.getCraftingQueue().getLast();
                            if (ItemStack.func_185132_d((ItemStack)topQueue, (ItemStack)newStack)) {
                                topQueue.func_190920_e(MathUtil.clampMaxFirst((int)(topQueue.func_190916_E() + workbenchServerMessage.getQuantity()), (int)1, (int)999));
                            } else {
                                press.addStack(newStack);
                            }
                        } else {
                            press.addStack(newStack);
                        }
                        MWC.CHANNEL.sendToAllAround((IMessage)new WorkbenchClientMessage(station.func_145831_w(), workbenchServerMessage.getTeLocation()), new NetworkRegistry.TargetPoint(0, (double)workbenchServerMessage.getTeLocation().func_177958_n(), (double)workbenchServerMessage.getTeLocation().func_177956_o(), (double)workbenchServerMessage.getTeLocation().func_177952_p(), 20.0));
                        return;
                    }
                    CraftingEntry[] modernRecipe = CraftingRegistry.getModernCrafting(workbenchServerMessage.getCraftingGroup(), workbenchServerMessage.getCraftingName()).getModernRecipe();
                    if (modernRecipe == null) {
                        return;
                    }
                    HashMap<Item, HashMap> itemRemovalList = new HashMap<Item, HashMap>();
                    block0: for (CraftingEntry stack : modernRecipe) {
                        stackItem = stack.getItem();
                        int requiredCount = stack.getCount();
                        itemRemovalList.computeIfAbsent(stackItem, k -> new HashMap());
                        for (int i = 23; i < station.mainInventory.getSlots(); ++i) {
                            ItemStack iS = station.mainInventory.getStackInSlot(i);
                            if (iS.func_77973_b() != stackItem) continue;
                            int existingCount = ((HashMap)itemRemovalList.get(stackItem)).values().stream().mapToInt(Integer::intValue).sum();
                            if (existingCount >= requiredCount) continue block0;
                            int iSCount = iS.func_190916_E();
                            if (existingCount + iSCount >= requiredCount) {
                                ((HashMap)itemRemovalList.get(stackItem)).put(iS, requiredCount - existingCount);
                                continue block0;
                            }
                            ((HashMap)itemRemovalList.get(stackItem)).put(iS, iSCount);
                        }
                    }
                    for (CraftingEntry stack : modernRecipe) {
                        if (!stack.isOreDictionary()) {
                            stackItem = stack.getItem();
                            if (itemRemovalList.containsKey(stackItem) && ((HashMap)itemRemovalList.get(stackItem)).values().stream().mapToInt(Integer::intValue).sum() >= stack.getCount()) continue;
                            return;
                        }
                        ModReference.LOG.error("Could not verify that items are available in the inventory.");
                        return;
                    }
                    for (Item i : itemRemovalList.keySet()) {
                        for (ItemStack iS : ((HashMap)itemRemovalList.get(i)).keySet()) {
                            iS.func_190918_g(((Integer)((HashMap)itemRemovalList.get(i)).get(iS)).intValue());
                        }
                    }
                    if (station instanceof TileEntityWorkbench) {
                        TileEntityWorkbench workbench = (TileEntityWorkbench)station;
                        workbench.craftingTimer = workbenchServerMessage.getCraftingTimer();
                        workbench.craftingDuration = workbenchServerMessage.getCraftingDuration();
                        workbench.craftingTarget = CraftingRegistry.getModernCrafting(workbenchServerMessage.getCraftingGroup(), workbenchServerMessage.getCraftingName());
                    }
                    station.sendUpdate();
                    MWC.CHANNEL.sendToAllAround((IMessage)new WorkbenchClientMessage(station.func_145831_w(), workbenchServerMessage.getTeLocation()), new NetworkRegistry.TargetPoint(0, (double)workbenchServerMessage.getTeLocation().func_177958_n(), (double)workbenchServerMessage.getTeLocation().func_177956_o(), (double)workbenchServerMessage.getTeLocation().func_177952_p(), 20.0));
                } else if (workbenchServerMessage.getOpCode() == 2) {
                    for (int i = 9; i < 13; ++i) {
                        ItemStack stack;
                        if (station.mainInventory.getStackInSlot(i).func_190926_b() || !((stack = station.mainInventory.getStackInSlot(i)).func_77973_b() instanceof IModernCraftingRecipe) || ((IModernCraftingRecipe)stack.func_77973_b()).getModernRecipe() == null || station.dismantleStatus[i - 9] != -1 && station.dismantleStatus[i - 9] <= station.dismantleDuration[i - 9]) continue;
                        station.dismantleStatus[i - 9] = 0;
                        station.dismantleDuration[i - 9] = ((TileEntityStation)tileEntity).getDismantlingTime((IModernCraftingRecipe)stack.func_77973_b());
                    }
                    MWC.CHANNEL.sendToAllAround((IMessage)new WorkbenchClientMessage(station.func_145831_w(), workbenchServerMessage.getTeLocation()), new NetworkRegistry.TargetPoint(0, (double)workbenchServerMessage.getTeLocation().func_177958_n(), (double)workbenchServerMessage.getTeLocation().func_177956_o(), (double)workbenchServerMessage.getTeLocation().func_177952_p(), 25.0));
                } else if (workbenchServerMessage.getOpCode() == 3) {
                    ((EntityPlayer)world.func_73045_a(workbenchServerMessage.getPlayerID())).func_191521_c(station.mainInventory.getStackInSlot(workbenchServerMessage.getSlotToMove()));
                } else if (workbenchServerMessage.getOpCode() == 5) {
                    if (!(tileEntity instanceof TileEntityAmmoPress)) {
                        return;
                    }
                    TileEntityAmmoPress teAmmoPress = (TileEntityAmmoPress)tileEntity;
                    if (teAmmoPress.hasStack() && teAmmoPress.getCraftingQueue().size() > workbenchServerMessage.getSlotToMove()) {
                        teAmmoPress.getCraftingQueue().remove(workbenchServerMessage.getSlotToMove());
                    }
                    MWC.CHANNEL.sendToAllAround((IMessage)new WorkbenchClientMessage(station.func_145831_w(), workbenchServerMessage.getTeLocation()), new NetworkRegistry.TargetPoint(0, (double)workbenchServerMessage.getTeLocation().func_177958_n(), (double)workbenchServerMessage.getTeLocation().func_177956_o(), (double)workbenchServerMessage.getTeLocation().func_177952_p(), 25.0));
                }
            }
        });
        return null;
    }
}

