/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.network.handlers;

import com.paneedah.mwc.network.messages.SpawnParticleMessage;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.particle.ExplosionSmokeFX;
import io.redstudioragnarok.redcore.utils.NetworkUtil;
import io.redstudioragnarok.redcore.vectors.Vector3F;
import java.util.Random;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class SpawnParticleMessageHandler
implements IMessageHandler<SpawnParticleMessage, IMessage> {
    private static final String REGULAR_SMOKE_TEXTURE = "weaponlib:/com/paneedah/weaponlib/resources/large-smoke.png";
    private static final String YELLOW_SMOKE_TEXTURE = "weaponlib:/com/paneedah/weaponlib/resources/large-yellow-smoke.png";
    private static final Random RANDOM = new Random();
    private ModContext modContext;

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(SpawnParticleMessage spawnParticleMessage, MessageContext messageContext) {
        NetworkUtil.processMessage((MessageContext)messageContext, () -> {
            Vector3F position = spawnParticleMessage.getPosition();
            Vector3F velocity = spawnParticleMessage.getVelocity();
            block4: for (int i = 0; i < spawnParticleMessage.getCount(); ++i) {
                switch (spawnParticleMessage.getType()) {
                    case SMOKE_GRENADE_SMOKE: {
                        this.modContext.getEffectManager().spawnExplosionSmoke(position.x, position.y, position.z, velocity.x, velocity.y, velocity.z, 4.0f * RANDOM.nextFloat(), 500, ExplosionSmokeFX.Behavior.SMOKE_GRENADE, REGULAR_SMOKE_TEXTURE);
                        continue block4;
                    }
                    case SMOKE_GRENADE_YELLOW_SMOKE: {
                        this.modContext.getEffectManager().spawnExplosionSmoke(position.x, position.y, position.z, velocity.x, velocity.y, velocity.z, 0.3f * RANDOM.nextFloat(), 500, ExplosionSmokeFX.Behavior.SMOKE_GRENADE, YELLOW_SMOKE_TEXTURE);
                    }
                }
            }
        });
        return null;
    }

    public SpawnParticleMessageHandler() {
    }

    public SpawnParticleMessageHandler(ModContext modContext) {
        this.modContext = modContext;
    }
}

