/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.items.equipment.carryable;

import com.paneedah.mwc.renderer.ModelSourceTransforms;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.animation.Transform;
import com.paneedah.weaponlib.config.BalancePackManager;
import com.paneedah.weaponlib.crafting.CraftingEntry;
import com.paneedah.weaponlib.crafting.CraftingGroup;
import com.paneedah.weaponlib.crafting.IModernCraftingRecipe;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemCarryable
extends Item
implements IModernCraftingRecipe {
    protected int size;
    protected ResourceLocation guiTextureLocation;
    protected int guiTextureWidth;
    protected Predicate<Item> validItemPredicate;
    protected Runnable customEquippedPositioning;
    protected CraftingEntry[] modernRecipe;
    protected CraftingGroup craftGroup;
    public final String modelName;
    public final String textureName;

    public Runnable getCustomEquippedPositioning() {
        return this.customEquippedPositioning;
    }

    public ItemCarryable(int size, Predicate<Item> validItemPredicate, ResourceLocation guiTextureLocation, int guiTextureWidth, String modelName, String textureName) {
        this.validItemPredicate = validItemPredicate;
        this.size = size;
        this.guiTextureLocation = guiTextureLocation;
        this.guiTextureWidth = guiTextureWidth;
        this.modelName = modelName;
        this.textureName = textureName;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public int getSize() {
        return this.size;
    }

    public void func_77624_a(ItemStack itemStack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(itemStack, worldIn, tooltip, flagIn);
        tooltip.add(String.format("%sSize:%s %d", TextFormatting.GREEN, TextFormatting.GRAY, this.size));
    }

    public ResourceLocation getGuiTextureLocation() {
        return this.guiTextureLocation;
    }

    private static String addFileExtension(String s, String ext) {
        return s != null && !s.endsWith(ext) ? s + ext : s;
    }

    public int getGuiTextureWidth() {
        return this.guiTextureWidth;
    }

    public Predicate<Item> getValidItemPredicate() {
        return this.validItemPredicate;
    }

    @Override
    public CraftingEntry[] getModernRecipe() {
        return this.modernRecipe;
    }

    @Override
    public ItemStack getItemStack() {
        return new ItemStack((Item)this);
    }

    @Override
    public CraftingGroup getCraftingGroup() {
        return this.craftGroup;
    }

    @Override
    public void setCraftingRecipe(CraftingEntry[] recipe) {
        this.modernRecipe = recipe;
    }

    @Override
    public void setCraftingGroup(CraftingGroup group) {
        this.craftGroup = group;
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected static final int DEFAULT_GUI_TEXTURE_WIDTH = 176;
        protected String name;
        protected String modelName;
        protected String textureName;
        protected ModelSourceTransforms transforms = ModelSourceTransforms.builder().entityPositioning(() -> new Transform().withPosition(-0.5, -1.75, 0.4).withScale(1.0, 1.0, 1.0).doGLDirect()).inventoryPositioning(() -> new Transform().withPosition(-0.15, -4.15, 0.35).withRotation(18.0, -50.0, 0.0).withScale(2.9, 2.9, 2.9).doGLDirect()).build();
        protected int size;
        protected int guiTextureWidth = 176;
        protected Predicate<Item> validItemPredicate = item -> !(item instanceof Weapon) || ((Weapon)item).getConfigurationGroup() == BalancePackManager.GunConfigurationGroup.HANDGUN;

        public T withName(String name) {
            this.name = name;
            return this.self();
        }

        public T withSize(int size) {
            this.size = size;
            return this.self();
        }

        public T withValidItemPredicate(Predicate<Item> validItemPredicate) {
            this.validItemPredicate = validItemPredicate;
            return this.self();
        }

        public T withModel(String model) {
            this.modelName = "com.paneedah.mwc.models." + model;
            return this.self();
        }

        public T withTexture(String textureName) {
            this.textureName = ItemCarryable.addFileExtension(textureName, ".png");
            return this.self();
        }

        public T withEntityPositioning(Runnable entityPositioning) {
            this.transforms.setEntityPositioning(entityPositioning);
            return this.self();
        }

        public T withInventoryPositioning(Runnable inventoryPositioning) {
            this.transforms.setInventoryPositioning(inventoryPositioning);
            return this.self();
        }

        public T withThirdPersonPositioning(Runnable thirdPersonPositioning) {
            this.transforms.setThirdPersonPositioning(thirdPersonPositioning);
            return this.self();
        }

        public T withCustomEquippedPositioning(Runnable customEquippedPositioning) {
            this.transforms.setCustomEquippedPositioning(customEquippedPositioning);
            return this.self();
        }

        public T withFirstPersonPositioning(Runnable firstPersonPositioning) {
            this.transforms.setFirstPersonPositioning(firstPersonPositioning);
            return this.self();
        }

        public T withFirstPersonModelPositioning(Consumer<ModelBase> firstPersonModelPositioning) {
            this.transforms.setFirstPersonModelPositioning(firstPersonModelPositioning);
            return this.self();
        }

        public T withEntityModelPositioning(Consumer<ModelBase> entityModelPositioning) {
            this.transforms.setEntityModelPositioning(entityModelPositioning);
            return this.self();
        }

        public T withInventoryModelPositioning(Consumer<ModelBase> inventoryModelPositioning) {
            this.transforms.setInventoryModelPositioning(inventoryModelPositioning);
            return this.self();
        }

        public T withThirdPersonModelPositioning(Consumer<ModelBase> thirdPersonModelPositioning) {
            this.transforms.setThirdPersonModelPositioning(thirdPersonModelPositioning);
            return this.self();
        }

        public T withFirstPersonHandPositioning(Runnable leftHand, Runnable rightHand) {
            this.transforms.setFirstPersonLeftHandPositioning(leftHand);
            this.transforms.setFirstPersonRightHandPositioning(rightHand);
            return this.self();
        }

        protected void validateInput() {
            if (this.name == null) {
                ModReference.RED_LOG.printFramedError("Carryable Item", "Carryable Item has no name set", "Non critical exception falling back to 'missing_name'", new String[]{"At:" + new Throwable().getStackTrace()[3].toString()});
                this.name = "missing_name";
            }
            if (this.size <= 0) {
                ModReference.RED_LOG.printFramedError("Carryable Item", this.name + " size was not greater than 0", "Non critical exception falling back to a size of 8", new String[]{"At:" + new Throwable().getStackTrace()[3].toString()});
                this.size = 8;
            }
        }

        protected abstract T self();

        public abstract ItemCarryable build();
    }
}

