/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.network.data;

import bletch.tektopiainformation.network.data.EntityData;
import bletch.tektopiainformation.network.data.ResidentData;
import bletch.tektopiainformation.network.data.VillageData;
import bletch.tektopiainformation.network.data.VisitorData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.VillagerRole;
import net.tangotek.tektopia.entities.EntityVillagerTek;

public class VisitorsData {
    protected static final String NBTTAG_VILLAGE_VISITORS = "visitors";
    protected static final String NBTTAG_VILLAGE_VISITORSLIST = "list";
    protected VillageData villageData;
    protected List<VisitorData> visitors;

    public VisitorsData() {
        this.populateData(null, null);
    }

    protected VillageData getVillageData() {
        return this.villageData;
    }

    public int getVisitorsCount() {
        return this.visitors == null ? 0 : this.visitors.size();
    }

    public List<VisitorData> getVisitors() {
        return this.visitors == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.visitors.stream().sorted(Comparator.comparing(ResidentData::getProfessionType).thenComparing(EntityData::getName)).collect(Collectors.toList()));
    }

    public VisitorData getVisitor(int index) {
        return this.visitors == null ? null : this.visitors.get(index);
    }

    public VisitorData getVisitorById(int visitorId) {
        return this.visitors == null ? null : (VisitorData)this.visitors.stream().filter(m -> m.getId() == visitorId).findFirst().orElse(null);
    }

    protected void clearData() {
        this.visitors = new ArrayList<VisitorData>();
    }

    public void populateData(VillageData villageData, Village village) {
        this.clearData();
        this.villageData = villageData;
        if (village != null) {
            AxisAlignedBB villageAABB = village.getAABB().func_186662_g(120.0);
            List villageEntities = village.getWorld().func_72872_a(EntityVillagerTek.class, villageAABB);
            for (EntityVillagerTek entity : villageEntities) {
                if (entity.field_70128_L || !entity.isRole(VillagerRole.VISITOR) || entity.isRole(VillagerRole.ENEMY)) continue;
                this.visitors.add(new VisitorData(entity));
            }
        }
    }

    public void readNBT(VillageData villageData, NBTTagCompound nbtTag) {
        NBTTagCompound nbtVisitorsData;
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        this.clearData();
        this.villageData = villageData;
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_VISITORS) && (nbtVisitorsData = nbtTag.func_74775_l(NBTTAG_VILLAGE_VISITORS)).func_74764_b(NBTTAG_VILLAGE_VISITORSLIST)) {
            NBTTagList nbtTagListVisitors = nbtVisitorsData.func_150295_c(NBTTAG_VILLAGE_VISITORSLIST, 10);
            for (int index = 0; index < nbtTagListVisitors.func_74745_c(); ++index) {
                this.visitors.add(new VisitorData(nbtTagListVisitors.func_150305_b(index)));
            }
        }
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        NBTTagCompound nbtVisitorsData = new NBTTagCompound();
        if (this.visitors != null && this.visitors.size() > 0) {
            NBTTagList nbtTagListVisitors = new NBTTagList();
            for (VisitorData visitor : this.visitors) {
                NBTTagCompound nbtTagVisitor = visitor.writeNBT(new NBTTagCompound());
                if (nbtTagVisitor.func_82582_d()) continue;
                nbtTagListVisitors.func_74742_a((NBTBase)nbtTagVisitor);
            }
            if (!nbtTagListVisitors.func_82582_d()) {
                nbtVisitorsData.func_74782_a(NBTTAG_VILLAGE_VISITORSLIST, (NBTBase)nbtTagListVisitors);
            }
        }
        if (!nbtVisitorsData.func_82582_d()) {
            nbtTag.func_74782_a(NBTTAG_VILLAGE_VISITORS, (NBTBase)nbtVisitorsData);
        }
        return nbtTag;
    }
}

