/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.network.data;

import bletch.tektopiainformation.core.ModConfig;
import bletch.tektopiainformation.network.data.EconomyData;
import bletch.tektopiainformation.network.data.EnemiesData;
import bletch.tektopiainformation.network.data.HomesData;
import bletch.tektopiainformation.network.data.ResidentData;
import bletch.tektopiainformation.network.data.ResidentsData;
import bletch.tektopiainformation.network.data.StructureData;
import bletch.tektopiainformation.network.data.StructuresData;
import bletch.tektopiainformation.network.data.VisitorsData;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.entities.EntityVillageNavigator;

public class VillageData {
    public static final float MC_TICKS_PER_SECOND = 0.27777776f;
    protected static final String NBTTAG_VILLAGE_NAME = "name";
    protected static final String NBTTAG_VILLAGE_ORIGIN = "origin";
    protected static final String NBTTAG_VILLAGE_SIZE = "size";
    protected static final String NBTTAG_VILLAGE_WORLDTIME = "time";
    protected static final String NBTTAG_ENTITYID = "sel_entity";
    protected static final String NBTTAG_BEDPOSITION = "sel_bedpos";
    protected static final String NBTTAG_FRAMEPOSITION = "sel_framepos";
    protected static final String NBTTAG_PLAYERPOSITION = "playerpos";
    protected String villageName;
    protected BlockPos villageOrigin;
    protected int villageSize;
    protected long worldTime;
    protected StructuresData structuresData;
    protected HomesData homesData;
    protected ResidentsData residentsData;
    protected EconomyData economyData;
    protected VisitorsData visitorsData;
    protected EnemiesData enemiesData;
    protected int entityId;
    protected int structureId;
    protected BlockPos bedPosition;
    protected BlockPos framePosition;
    protected BlockPos playerPosition;

    public VillageData() {
        this.populateData(null);
        this.playerPosition = null;
    }

    public VillageData(Village village, BlockPos playerPosition) {
        this.populateData(village);
        this.playerPosition = playerPosition;
    }

    public String getVillageName() {
        return this.villageName;
    }

    public BlockPos getVillageOrigin() {
        return this.villageOrigin;
    }

    public int getVillageSize() {
        return this.villageSize;
    }

    public long getVillageDays() {
        return (long)Math.max(1.0f, (float)this.worldTime / 24000.0f + 1.0f);
    }

    public long getVillageSeconds() {
        return (long)Math.max(0.0f, (float)this.worldTime % 24000.0f / 0.27777776f);
    }

    public long getVillageTicks() {
        return (long)Math.max(0.0f, (float)this.worldTime % 24000.0f);
    }

    public long getWorldTime() {
        return this.worldTime;
    }

    public BlockPos getVillageNorthWestCorner() {
        return this.villageOrigin != null ? this.villageOrigin.func_177964_d(this.villageSize).func_177985_f(this.villageSize) : null;
    }

    public BlockPos getVillageNorthEastCorner() {
        return this.villageOrigin != null ? this.villageOrigin.func_177964_d(this.villageSize).func_177965_g(this.villageSize) : null;
    }

    public BlockPos getVillageSouthWestCorner() {
        return this.villageOrigin != null ? this.villageOrigin.func_177970_e(this.villageSize).func_177985_f(this.villageSize) : null;
    }

    public BlockPos getVillageSouthEastCorner() {
        return this.villageOrigin != null ? this.villageOrigin.func_177970_e(this.villageSize).func_177965_g(this.villageSize) : null;
    }

    public StructureData getTownHall() {
        return this.structuresData == null ? null : this.structuresData.getTownHall();
    }

    public StructuresData getStructuresData() {
        return this.structuresData == null ? new StructuresData() : this.structuresData;
    }

    public HomesData getHomesData() {
        return this.structuresData == null ? new HomesData() : this.homesData;
    }

    public ResidentsData getResidentsData() {
        return this.structuresData == null ? new ResidentsData() : this.residentsData;
    }

    public EconomyData getEconomyData() {
        return this.structuresData == null ? new EconomyData() : this.economyData;
    }

    public VisitorsData getVisitorsData() {
        return this.visitorsData == null ? new VisitorsData() : this.visitorsData;
    }

    public EnemiesData getEnemiesData() {
        return this.enemiesData == null ? new EnemiesData() : this.enemiesData;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getStructureId() {
        return this.structureId;
    }

    public BlockPos getBedPosition() {
        return this.bedPosition;
    }

    public BlockPos getFramePosition() {
        return this.framePosition;
    }

    public BlockPos getPlayerPosition() {
        return this.playerPosition;
    }

    public VillageData setEntity(EntityVillageNavigator entity) {
        this.ClearAssignments();
        this.entityId = entity == null ? 0 : entity.func_145782_y();
        return this;
    }

    public VillageData setEntityId(int entityId) {
        this.ClearAssignments();
        this.entityId = entityId;
        return this;
    }

    public VillageData setStructureId(int structureId) {
        this.ClearAssignments();
        this.structureId = structureId;
        return this;
    }

    public VillageData setBedPosition(BlockPos bedPosition) {
        this.ClearAssignments();
        this.bedPosition = bedPosition;
        return this;
    }

    public VillageData setFramePosition(BlockPos framePosition) {
        this.ClearAssignments();
        this.framePosition = framePosition;
        return this;
    }

    public void ClearAssignments() {
        this.entityId = 0;
        this.structureId = 0;
        this.bedPosition = null;
        this.framePosition = null;
    }

    protected void clearData() {
        this.villageName = "";
        this.villageOrigin = null;
        this.villageSize = 0;
        this.worldTime = -1L;
        this.ClearAssignments();
        this.playerPosition = null;
        this.residentsData = new ResidentsData();
        this.visitorsData = new VisitorsData();
        this.enemiesData = new EnemiesData();
        this.structuresData = new StructuresData();
        this.homesData = new HomesData();
        this.economyData = new EconomyData();
    }

    protected void populateData(Village village) {
        this.clearData();
        if (village != null) {
            this.villageName = village.getName();
            this.villageOrigin = village.getOrigin();
            this.villageSize = village.getSize();
            this.worldTime = village.getWorld().func_72820_D();
        }
        this.structuresData.populateData(this, village);
        this.homesData.populateData(this, village);
        this.residentsData.populateData(this, village);
        this.economyData.populateData(this, village);
        this.visitorsData.populateData(this, village);
        if (ModConfig.gui.tektopiaInformationBook.showEnemies) {
            this.enemiesData.populateData(this, village);
        }
    }

    public void readNBT(NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        this.clearData();
        ResidentData.resetEntityList();
        this.villageName = nbtTag.func_74764_b(NBTTAG_VILLAGE_NAME) ? nbtTag.func_74779_i(NBTTAG_VILLAGE_NAME) : "";
        this.villageOrigin = nbtTag.func_74764_b(NBTTAG_VILLAGE_ORIGIN) ? BlockPos.func_177969_a((long)nbtTag.func_74763_f(NBTTAG_VILLAGE_ORIGIN)) : null;
        this.villageSize = nbtTag.func_74764_b(NBTTAG_VILLAGE_SIZE) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_SIZE) : 0;
        this.worldTime = nbtTag.func_74764_b(NBTTAG_VILLAGE_WORLDTIME) ? nbtTag.func_74763_f(NBTTAG_VILLAGE_WORLDTIME) : -1L;
        this.entityId = nbtTag.func_74764_b(NBTTAG_ENTITYID) ? nbtTag.func_74762_e(NBTTAG_ENTITYID) : 0;
        this.bedPosition = nbtTag.func_74764_b(NBTTAG_BEDPOSITION) ? BlockPos.func_177969_a((long)nbtTag.func_74763_f(NBTTAG_BEDPOSITION)) : null;
        this.framePosition = nbtTag.func_74764_b(NBTTAG_FRAMEPOSITION) ? BlockPos.func_177969_a((long)nbtTag.func_74763_f(NBTTAG_FRAMEPOSITION)) : null;
        this.playerPosition = nbtTag.func_74764_b(NBTTAG_PLAYERPOSITION) ? BlockPos.func_177969_a((long)nbtTag.func_74763_f(NBTTAG_PLAYERPOSITION)) : null;
        this.residentsData.readNBT(this, nbtTag);
        this.visitorsData.readNBT(this, nbtTag);
        this.enemiesData.readNBT(this, nbtTag);
        this.structuresData.readNBT(this, nbtTag);
        this.homesData.readNBT(this, nbtTag);
        this.economyData.readNBT(this, nbtTag);
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        nbtTag.func_74778_a(NBTTAG_VILLAGE_NAME, this.villageName);
        if (this.villageOrigin != null) {
            nbtTag.func_74772_a(NBTTAG_VILLAGE_ORIGIN, this.villageOrigin.func_177986_g());
        }
        nbtTag.func_74768_a(NBTTAG_VILLAGE_SIZE, this.villageSize);
        nbtTag.func_74772_a(NBTTAG_VILLAGE_WORLDTIME, this.worldTime);
        if (this.entityId > 0) {
            nbtTag.func_74768_a(NBTTAG_ENTITYID, this.entityId);
        }
        if (this.bedPosition != null) {
            nbtTag.func_74772_a(NBTTAG_BEDPOSITION, this.bedPosition.func_177986_g());
        }
        if (this.framePosition != null) {
            nbtTag.func_74772_a(NBTTAG_FRAMEPOSITION, this.framePosition.func_177986_g());
        }
        if (this.playerPosition != null) {
            nbtTag.func_74772_a(NBTTAG_PLAYERPOSITION, this.playerPosition.func_177986_g());
        }
        this.residentsData.writeNBT(nbtTag);
        this.visitorsData.writeNBT(nbtTag);
        this.enemiesData.writeNBT(nbtTag);
        this.structuresData.writeNBT(nbtTag);
        this.homesData.writeNBT(nbtTag);
        this.economyData.writeNBT(nbtTag);
        return nbtTag;
    }
}

