/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.gui;

import bletch.tektopiainformation.enums.GuiMapMarkerType;
import bletch.tektopiainformation.enums.GuiMapQuadrant;
import bletch.tektopiainformation.gui.GuiButton;
import bletch.tektopiainformation.gui.GuiTexture;
import bletch.tektopiainformation.gui.GuiTooltip;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class GuiMapMarker
extends GuiButton
implements Comparable<GuiMapMarker> {
    private final GuiMapMarkerType markerType;
    private BlockPos position;
    private final GuiTooltip tooltip;
    private List<GuiMapQuadrant> quadrants;
    private int priority;

    public GuiMapMarker(String key) {
        super(key);
        this.markerType = GuiMapMarkerType.UNKNOWN;
        this.position = null;
        this.tooltip = null;
        this.priority = 1;
        this.setQuadrants();
    }

    public GuiMapMarker(String key, GuiMapMarkerType markerType, GuiTexture icon, BlockPos position, GuiTooltip tooltip) {
        super(key, icon);
        this.markerType = markerType;
        this.position = position;
        this.tooltip = tooltip;
        this.priority = 1;
        this.setQuadrants();
    }

    public GuiMapMarker addPosition(BlockPos position) {
        this.position = this.position.func_177971_a((Vec3i)position);
        return this;
    }

    public GuiMapMarkerType getMarkerType() {
        return this.markerType;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public GuiTooltip getTooltip() {
        return this.tooltip;
    }

    public int getPriority() {
        return this.priority;
    }

    public Boolean isInQuadrant(GuiMapQuadrant quadrant) {
        return this.quadrants.contains((Object)quadrant);
    }

    public GuiMapMarker setPosition(int left, int top) {
        this.position = new BlockPos(left, this.position.func_177956_o(), top);
        return this;
    }

    public GuiMapMarker setPosition(BlockPos position) {
        this.position = position;
        return this;
    }

    public GuiMapMarker setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    private void setQuadrants() {
        this.quadrants = new ArrayList<GuiMapQuadrant>();
        if (this.position == null) {
            return;
        }
        int x = this.position.func_177958_n();
        int z = this.position.func_177952_p();
        this.quadrants.add(GuiMapQuadrant.ALL);
        if (x >= 0 && z >= 0) {
            this.quadrants.add(GuiMapQuadrant.SOUTHEAST);
        }
        if (x >= 0 && z <= 0) {
            this.quadrants.add(GuiMapQuadrant.NORTHEAST);
        }
        if (x <= 0 && z >= 0) {
            this.quadrants.add(GuiMapQuadrant.SOUTHWEST);
        }
        if (x <= 0 && z <= 0) {
            this.quadrants.add(GuiMapQuadrant.NORTHWEST);
        }
    }

    @Override
    public int compareTo(GuiMapMarker marker) {
        int result = Integer.compare(this.priority, marker.getPriority());
        if (result != 0) {
            return result;
        }
        if (this.position.func_177952_p() == marker.position.func_177952_p()) {
            if (this.position.func_177958_n() == marker.position.func_177958_n()) {
                return 0;
            }
            return this.position.func_177958_n() > marker.position.func_177958_n() ? 1 : -1;
        }
        return this.position.func_177952_p() > marker.position.func_177952_p() ? 1 : -1;
    }

    @Override
    public boolean withinBounds(int x, int y, float scale) {
        if (this.tooltip == null) {
            return super.withinBounds(x, y, scale);
        }
        return this.tooltip.withinBounds(x, y, scale);
    }
}

