/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.commands;

import bletch.common.commands.CommonCommandBase;
import bletch.common.utils.TextUtils;
import bletch.tektopiainformation.utils.LoggerUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.VillageManager;
import net.tangotek.tektopia.entities.EntityNomad;

public class CommandNomadKill
extends CommonCommandBase {
    private static final String COMMAND_NAME = "kill";

    public CommandNomadKill() {
        super("tektopiainformation", "commands.nomad.", COMMAND_NAME);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Village village;
        if (args.length > 1) {
            throw new WrongUsageException(this.prefix + COMMAND_NAME + ".usage", new Object[0]);
        }
        int argValue = -1;
        if (args.length > 0) {
            try {
                argValue = Integer.parseInt(args[0]);
                if (argValue != 0 && argValue != 1) {
                    throw new WrongUsageException(this.prefix + COMMAND_NAME + ".usage", new Object[0]);
                }
            }
            catch (Exception ex) {
                throw new WrongUsageException(this.prefix + COMMAND_NAME + ".usage", new Object[0]);
            }
        }
        int nomadGender = argValue;
        EntityPlayerMP entityPlayer = CommonCommandBase.func_71521_c((ICommandSender)sender);
        World world = entityPlayer != null ? entityPlayer.func_130014_f_() : null;
        VillageManager villageManager = world != null ? VillageManager.get((World)world) : null;
        Village village2 = village = villageManager != null && entityPlayer != null ? villageManager.getVillageAt(entityPlayer.func_180425_c()) : null;
        if (village == null) {
            CommandNomadKill.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(this.prefix + COMMAND_NAME + ".novillage"), (Object[])new Object[0]);
            LoggerUtils.instance.info(TextUtils.translate(this.prefix + COMMAND_NAME + ".novillage", new Object[0]), true);
            return;
        }
        List entityList = world.func_72872_a(EntityNomad.class, village.getAABB().func_186662_g(120.0));
        if ((entityList = entityList.stream().filter(e -> nomadGender == -1 || nomadGender == 0 && e.isMale() || nomadGender == 1 && !e.isMale()).collect(Collectors.toList())).size() == 0) {
            CommandNomadKill.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(this.prefix + COMMAND_NAME + ".noexists"), (Object[])new Object[0]);
            LoggerUtils.instance.info(TextUtils.translate(this.prefix + COMMAND_NAME + ".noexists", new Object[0]), true);
            return;
        }
        for (EntityNomad entity : entityList) {
            if (entity.field_70128_L) continue;
            entity.func_70106_y();
            String name = (entity.isMale() ? TextFormatting.BLUE : TextFormatting.LIGHT_PURPLE) + entity.func_70005_c_();
            CommandNomadKill.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(this.prefix + COMMAND_NAME + ".success"), (Object[])new Object[]{name});
            LoggerUtils.instance.info(TextUtils.translate(this.prefix + COMMAND_NAME + ".success", name), true);
        }
    }
}

