/*
 * Decompiled with CFR 0.152.
 */
package bletch.common.utils;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class ModIdentification {
    public static Map<String, ModContainer> containers = new HashMap<String, ModContainer>();

    public static void init() {
        containers.put("minecraft", (ModContainer)Loader.instance().getMinecraftModContainer());
        containers.put("forge", (ModContainer)ForgeModContainer.getInstance());
    }

    public static String getStackModId(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return "";
        }
        return stack.func_77973_b().getCreatorModId(stack);
    }

    public static String getStackModName(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return "";
        }
        String modId = ModIdentification.getStackModId(stack);
        ModContainer container = ModIdentification.findModContainer(modId);
        if (container == null) {
            return "";
        }
        return container.getName();
    }

    public static String getEntityModId(Entity entity) {
        if (entity == null) {
            return "";
        }
        EntityEntry entityEntry = EntityRegistry.getEntry(entity.getClass());
        if (entityEntry == null) {
            return "";
        }
        return entityEntry.getRegistryName().func_110624_b();
    }

    public static String getEntityModName(Entity entity) {
        if (entity == null) {
            return "";
        }
        String modId = ModIdentification.getEntityModId(entity);
        ModContainer container = ModIdentification.findModContainer(modId);
        if (container == null) {
            return "";
        }
        return container.getName();
    }

    public static ModContainer findModContainer(String modId) {
        return containers.computeIfAbsent(modId, s -> {
            for (ModContainer container : Loader.instance().getModList()) {
                if (!modId.equalsIgnoreCase(container.getModId())) continue;
                return container;
            }
            return Loader.instance().getMinecraftModContainer();
        });
    }
}

