/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world.mapgen;

import java.util.Random;
import mcjty.rftoolsdim.dimensions.world.GenericChunkGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.BaseTerrainGenerator;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class MapGenPyramids {
    private final GenericChunkGenerator provider;

    public MapGenPyramids(GenericChunkGenerator provider) {
        this.provider = provider;
    }

    public void generate(World world, int chunkX, int chunkZ, ChunkPrimer primer) {
        IBlockState[] blocks = this.provider.dimensionInformation.getPyramidBlocks();
        Random random = new Random((world.func_72905_C() + (long)chunkX) * 1133L + (long)(chunkZ * 37) + 77L);
        random.nextFloat();
        if (random.nextFloat() < 0.05f) {
            int x = 8;
            int z = 8;
            int y = this.getBestY(primer, 8, 8);
            if (y < 10 || y > 230) {
                return;
            }
            IBlockState block = Blocks.field_150348_b.func_176223_P();
            if (blocks.length > 1) {
                block = blocks[random.nextInt(blocks.length)];
            } else if (blocks.length == 1) {
                block = blocks[0];
            }
            for (int i = 7; i >= 0; --i) {
                for (int dx = -i; dx <= i - 1; ++dx) {
                    for (int dz = -i; dz <= i - 1; ++dz) {
                        int index = ((x + dx) * 16 + (z + dz)) * 256;
                        BaseTerrainGenerator.setBlockState(primer, index + y, block);
                    }
                }
                ++y;
            }
        }
    }

    private int getBestY(ChunkPrimer primer, int x, int z) {
        int y = this.findTopSolid(primer, x, z);
        int y1 = this.findTopSolid(primer, x - 7, z - 7);
        if (y1 < y) {
            y = y1;
        }
        if ((y1 = this.findTopSolid(primer, x + 7, z - 7)) < y) {
            y = y1;
        }
        if ((y1 = this.findTopSolid(primer, x - 7, z + 7)) < y) {
            y = y1;
        }
        if ((y1 = this.findTopSolid(primer, x + 7, z + 7)) < y) {
            y = y1;
        }
        return y;
    }

    private int findTopSolid(ChunkPrimer primer, int x, int z) {
        int y;
        int index = (x * 16 + z) * 256;
        for (y = 255; y >= 5 && (BaseTerrainGenerator.getBlockState(primer, index + y) == null || BaseTerrainGenerator.getBlockState(primer, index + y).func_177230_c().func_149688_o(BaseTerrainGenerator.getBlockState(primer, index + y)) == Material.field_151579_a); --y) {
        }
        return y;
    }
}

