/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator.tree;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.world.generator.tree.GeneratorTreeBase;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GeneratorProfileTree
extends GeneratorTreeBase {
    protected TreeProfile profile;

    public GeneratorProfileTree(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, IBlockState altLeaves, int minHeight, int maxHeight, TreeProfile profile, GeneratorUtils.ScatterYMethod scatterYMethod) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, trunkFruit, altLeaves, minHeight, maxHeight, scatterYMethod);
        this.profile = profile;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        int i;
        while (pos.func_177956_o() > 1 && world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().isLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos)) {
            pos = pos.func_177977_b();
        }
        if (!this.placeOn.matches(world, pos)) {
            return false;
        }
        int height = GeneratorUtils.nextIntBetween(random, this.minHeight, this.maxHeight);
        if (height < 4) {
            return false;
        }
        int baseHeight = height / (2 + random.nextInt(3));
        int leavesHeight = height - baseHeight;
        if (!this.checkSpace(world, pos = pos.func_177984_a(), baseHeight, height)) {
            return false;
        }
        for (i = 0; i < baseHeight; ++i) {
            this.setLog(world, pos);
            pos = pos.func_177984_a();
        }
        for (i = 0; i < leavesHeight; ++i) {
            int radius = this.profile.radius(i, leavesHeight);
            this.generateLeafLayer(world, pos, radius);
            if (leavesHeight - i > 2) {
                this.setLog(world, pos);
            }
            pos = pos.func_177984_a();
        }
        return true;
    }

    public boolean checkSpace(World world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int radius = y <= baseHeight ? 0 : 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeafLayer(World world, BlockPos pos, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > radius * radius) continue;
                this.setLeaves(world, pos.func_177982_a(x, 0, z));
            }
        }
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.minHeight = conf.getInt("minHeight", this.minHeight);
        this.maxHeight = conf.getInt("minHeight", this.maxHeight);
        this.placeOn = conf.getBlockPosQuery("placeOn", this.placeOn);
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.log = conf.getBlockState("logState", this.log);
        this.leaves = conf.getBlockState("leavesState", this.leaves);
        this.profile = conf.getEnum("profile", this.profile, TreeProfile.class);
    }

    public static enum TreeProfile {
        POPLAR;


        public int radius(int height, int maxHeight) {
            switch (this) {
                default: 
            }
            float x = (float)height / (float)maxHeight;
            float maxRadius = 1.0f + (float)maxHeight * 0.1f;
            float r = maxRadius * 0.6667f * x * (1.0f / (x * x + 0.08173f) - 0.9244f);
            return (int)(r + 0.5f);
        }
    }

    public static class Builder
    extends GeneratorTreeBase.InnerBuilder<Builder, GeneratorProfileTree>
    implements IGenerator.IGeneratorBuilder<GeneratorProfileTree> {
        protected TreeProfile profile;

        public Builder profile(TreeProfile a) {
            this.profile = a;
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.minHeight = 6;
            this.maxHeight = 12;
            this.placeOn = BlockQueries.fertile;
            this.replace = BlockQueries.airOrLeaves;
            this.log = Blocks.field_150364_r.func_176223_P();
            this.leaves = Blocks.field_150362_t.func_176223_P();
            this.vine = null;
            this.hanging = null;
            this.trunkFruit = null;
            this.altLeaves = null;
            this.profile = TreeProfile.POPLAR;
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_SURFACE;
        }

        @Override
        public GeneratorProfileTree create() {
            return new GeneratorProfileTree(this.amountPerChunk, this.placeOn, this.replace, this.log, this.leaves, this.vine, this.hanging, this.trunkFruit, this.altLeaves, this.minHeight, this.maxHeight, this.profile, this.scatterYMethod);
        }
    }
}

