/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.item.ItemAsteroidChip;
import zmaster587.advancedRocketry.item.ItemPlanetIdentificationChip;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.advancedRocketry.item.ItemStationChip;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.util.PlanetaryTravelHelper;
import zmaster587.advancedRocketry.util.StationLandingLocation;
import zmaster587.libVulpes.api.LibVulpesItems;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.tile.multiblock.hatch.TileInventoryHatch;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.Vector3F;

public class TileGuidanceComputer
extends TileInventoryHatch
implements IModularInventory {
    private int destinationId;
    private Vector3F<Float> landingPos;
    private Map<Integer, HashedBlockPosition> landingLoc;

    public TileGuidanceComputer() {
        super(1);
        this.inventory.setCanInsertSlot(0, true);
        this.inventory.setCanExtractSlot(0, true);
        this.landingPos = new Vector3F((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        this.destinationId = -2147483647;
        this.landingLoc = new HashMap<Integer, HashedBlockPosition>();
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        return super.getModules(ID, player);
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        return slot == 0 && (item instanceof ItemPlanetIdentificationChip || item instanceof ItemStationChip || item instanceof ItemAsteroidChip || item instanceof ItemSatelliteIdentificationChip || item == LibVulpesItems.itemLinker);
    }

    public void setLandingLocation(int stationId, StationLandingLocation loc) {
        if (loc == null) {
            this.landingLoc.remove(stationId);
        } else {
            this.landingLoc.put(stationId, loc.getPos());
        }
    }

    public StationLandingLocation getLandingLocation(int stationId) {
        ISpaceObject spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStation(stationId);
        if (spaceObject == null) {
            this.landingLoc.remove(stationId);
            return null;
        }
        HashedBlockPosition myLoc = this.landingLoc.get(stationId);
        if (myLoc == null) {
            return null;
        }
        return ((SpaceStationObject)spaceObject).getPadAtLocation(myLoc);
    }

    public long getTargetSatellite() {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSatelliteIdentificationChip) {
            return SatelliteRegistry.getSatelliteId(stack);
        }
        return -1L;
    }

    public int getDestinationDimId(int currentDimension, BlockPos pos) {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b()) {
            Item itemType = stack.func_77973_b();
            if (itemType instanceof ItemPlanetIdentificationChip) {
                ItemPlanetIdentificationChip item = (ItemPlanetIdentificationChip)itemType;
                return item.getDimensionId(stack);
            }
            if (itemType instanceof ItemStationChip) {
                if (ARConfiguration.getCurrentConfig().spaceDimId == currentDimension) {
                    ISpaceObject spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos);
                    if (spaceObject != null) {
                        if (ItemStationChip.getUUID(stack) == spaceObject.getId()) {
                            return spaceObject.getOrbitingPlanetId();
                        }
                    } else {
                        return -2147483647;
                    }
                }
                return ARConfiguration.getCurrentConfig().spaceDimId;
            }
            if (itemType instanceof ItemAsteroidChip) {
                this.destinationId = currentDimension;
                this.landingPos = new Vector3F((Object)Float.valueOf(pos.func_177958_n()), (Object)Float.valueOf(pos.func_177956_o()), (Object)Float.valueOf(pos.func_177952_p()));
                return currentDimension;
            }
            if (itemType instanceof ItemSatelliteIdentificationChip) {
                SatelliteBase sat;
                long satelliteId = this.getTargetSatellite();
                if (satelliteId != -1L && (sat = DimensionManager.getInstance().getSatellite(satelliteId)) != null) {
                    return sat.getDimensionId();
                }
            } else if (stack.func_77973_b() == LibVulpesItems.itemLinker && ItemLinker.getDimId((ItemStack)stack) != -2147483647) {
                return ItemLinker.getDimId((ItemStack)stack);
            }
        }
        return this.destinationId;
    }

    public Vector3F<Float> getLandingLocation(int landingDimension, boolean commit) {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b()) {
            Item itemType = stack.func_77973_b();
            if (itemType instanceof ItemPlanetIdentificationChip) {
                return null;
            }
            if (itemType instanceof ItemStationChip) {
                ItemStationChip chip = (ItemStationChip)stack.func_77973_b();
                if (landingDimension == ARConfiguration.getCurrentConfig().spaceDimId) {
                    ISpaceObject spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStation(ItemStationChip.getUUID(stack));
                    return this.getStationLocation(spaceObject, commit);
                }
                ItemStationChip.LandingLocation loc = chip.getTakeoffCoords(stack, landingDimension);
                if (loc != null) {
                    return loc.location;
                }
                return null;
            }
            if (itemType instanceof ItemAsteroidChip) {
                return this.landingPos;
            }
            if (itemType instanceof ItemSatelliteIdentificationChip) {
                return null;
            }
            if (stack.func_77973_b() == LibVulpesItems.itemLinker && ItemLinker.getDimId((ItemStack)stack) != -2147483647) {
                BlockPos landingBlock = ItemLinker.getMasterCoords((ItemStack)stack);
                return new Vector3F((Object)Float.valueOf((float)landingBlock.func_177958_n() + 0.5f), (Object)Float.valueOf(ARConfiguration.getCurrentConfig().orbit), (Object)Float.valueOf((float)landingBlock.func_177952_p() + 0.5f));
            }
        } else if (this.destinationId != -2147483647) {
            return this.landingPos;
        }
        return null;
    }

    private Vector3F<Float> getStationLocation(ISpaceObject spaceObject, boolean commit) {
        HashedBlockPosition vec = null;
        if (spaceObject instanceof SpaceStationObject) {
            if (this.landingLoc.get(spaceObject.getId()) != null) {
                vec = this.landingLoc.get(spaceObject.getId());
                if (commit) {
                    ((SpaceStationObject)spaceObject).getPadAtLocation(this.landingLoc.get(spaceObject.getId())).setOccupied(true);
                }
            } else {
                vec = spaceObject.getNextLandingPad(commit);
            }
        }
        if (spaceObject == null) {
            return null;
        }
        if (vec == null) {
            vec = spaceObject.getSpawnLocation();
        }
        return new Vector3F((Object)Float.valueOf(vec.x), (Object)Float.valueOf(vec.y), (Object)Float.valueOf(vec.z));
    }

    public void overrideLandingStation(ISpaceObject spaceObject) {
        this.setFallbackDestination(ARConfiguration.getCurrentConfig().spaceDimId, this.getStationLocation(spaceObject, true));
    }

    public String getDestinationName(int landingDimension) {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemStationChip) {
            ItemStationChip.LandingLocation loc;
            ItemStationChip chip = (ItemStationChip)stack.func_77973_b();
            if (landingDimension != ARConfiguration.getCurrentConfig().spaceDimId && (loc = chip.getTakeoffCoords(stack, landingDimension)) != null) {
                return loc.name;
            }
        }
        return "";
    }

    public void setFallbackDestination(int dimID, Vector3F<Float> coords) {
        this.destinationId = dimID;
        this.landingPos = coords;
    }

    public int getLaunchSequence(int currentDimensionID, BlockPos currentPosition) {
        int totalBurn = currentDimensionID == ARConfiguration.getCurrentConfig().spaceDimId ? ARConfiguration.getCurrentConfig().stationClearanceHeight : ARConfiguration.getCurrentConfig().orbit;
        int destinationDimensionID = this.getDestinationDimId(currentDimensionID, currentPosition);
        return totalBurn += currentDimensionID == ARConfiguration.getCurrentConfig().spaceDimId ? this.getTransBodyInjection(currentDimensionID, destinationDimensionID, currentPosition) : this.getTransBodyInjection(currentDimensionID, destinationDimensionID);
    }

    public int getTransBodyInjection(int currentDimensionID, int destinationDimensionID) {
        ISpaceObject destinationSpaceStation = SpaceObjectManager.getSpaceManager().getSpaceStation(ItemStationChip.getUUID(this.func_70301_a(0)));
        int n = destinationDimensionID = destinationDimensionID == ARConfiguration.getCurrentConfig().spaceDimId && destinationSpaceStation != null ? destinationSpaceStation.getOrbitingPlanetId() : destinationDimensionID;
        if (destinationDimensionID == -2147483647) {
            return 0;
        }
        return PlanetaryTravelHelper.isTravelWithinOrbit(currentDimensionID, destinationDimensionID) && !this.isAsteroidMission() ? 0 : PlanetaryTravelHelper.getTransbodyInjectionBurn(currentDimensionID, destinationDimensionID, this.isAsteroidMission());
    }

    public int getTransBodyInjection(int currentDimensionID, int destinationDimensionID, BlockPos currentPosition) {
        ISpaceObject currentSpaceStation = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(currentPosition);
        ISpaceObject destinationSpaceStation = SpaceObjectManager.getSpaceManager().getSpaceStation(ItemStationChip.getUUID(this.func_70301_a(0)));
        int n = destinationDimensionID = destinationDimensionID == ARConfiguration.getCurrentConfig().spaceDimId && destinationSpaceStation != null ? destinationSpaceStation.getOrbitingPlanetId() : destinationDimensionID;
        if (destinationDimensionID == -2147483647) {
            return 0;
        }
        return PlanetaryTravelHelper.isTravelWithinOrbit(currentSpaceStation.getOrbitingPlanetId(), destinationDimensionID) && !this.isAsteroidMission() ? 0 : PlanetaryTravelHelper.getTransbodyInjectionBurn(currentSpaceStation.getOrbitingPlanetId(), destinationDimensionID, this.isAsteroidMission());
    }

    public boolean isAsteroidMission() {
        return this.func_70301_a(0).func_77973_b() instanceof ItemAsteroidChip;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("destDimId", this.destinationId);
        nbt.func_74776_a("landingx", ((Float)this.landingPos.x).floatValue());
        nbt.func_74776_a("landingy", ((Float)this.landingPos.y).floatValue());
        nbt.func_74776_a("landingz", ((Float)this.landingPos.z).floatValue());
        NBTTagList stationList = new NBTTagList();
        for (int locationID : this.landingLoc.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            HashedBlockPosition loc = this.landingLoc.get(locationID);
            tag.func_74783_a("pos", new int[]{loc.x, loc.y, loc.z});
            tag.func_74768_a("id", locationID);
            stationList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("stationMapping", (NBTBase)stationList);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.destinationId = nbt.func_74762_e("destDimId");
        this.landingPos.x = Float.valueOf(nbt.func_74760_g("landingx"));
        this.landingPos.y = Float.valueOf(nbt.func_74760_g("landingy"));
        this.landingPos.z = Float.valueOf(nbt.func_74760_g("landingz"));
        NBTTagList stationList = nbt.func_150295_c("stationMapping", 10);
        for (int i = 0; i < stationList.func_74745_c(); ++i) {
            NBTTagCompound tag = stationList.func_150305_b(i);
            int[] pos = tag.func_74759_k("pos");
            int id = tag.func_74762_e("id");
            this.landingLoc.put(id, new HashedBlockPosition(pos[0], pos[1], pos[2]));
        }
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (!stack.func_190926_b()) {
            this.destinationId = -2147483647;
        }
    }

    public void setReturnPosition(Vector3F<Float> pos, int dimId) {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemStationChip) {
            ItemStationChip item = (ItemStationChip)stack.func_77973_b();
            item.setTakeoffCoords(stack, pos, dimId, 0);
        }
    }

    public String getModularInventoryName() {
        return AdvancedRocketryBlocks.blockGuidanceComputer.func_149732_F();
    }
}

