/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.blocks.ForgeEntityBlock;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.FuseEntity;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.forge.world.WorldBounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ForgeExplosiveBlock<E extends FuseEntity>
extends ForgeEntityBlock<E> {
    private boolean alwaysDropOres;
    private final CommonTime.Interval ignitionTime;
    private final float breakingStrength;
    private final int explosionRadius;
    private final FloatBounds resistanceBounds;

    public ForgeExplosiveBlock(ForgeMod mod, UnitConfig config, Class<E> entityClass, CommonTime.Interval ignitionTime, int explosionRadius, float breakingStrength, boolean alwaysDropOres) {
        super(mod, config, entityClass, "", Material.field_151590_u, CreativeTabs.field_78028_d);
        this.alwaysDropOres = alwaysDropOres;
        this.ignitionTime = ignitionTime;
        this.explosionRadius = explosionRadius;
        this.breakingStrength = breakingStrength;
        this.resistanceBounds = FloatBounds.from(Float.valueOf(0.0f), Float.valueOf(breakingStrength));
    }

    public abstract void doDestruction(World var1, BlockPos var2, IBlockState var3, Explosion var4);

    protected abstract E createFuseEntity(World var1, BlockPos var2, IBlockState var3, CommonTime.Interval var4, @Nullable EntityLivingBase var5);

    public float getBreakingStrength() {
        return this.breakingStrength;
    }

    protected void destroyBlockAt(World world, BlockPos pos, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        if (ForgeWorld.isAirBlock(state)) {
            return;
        }
        Block block = state.func_177230_c();
        float resistance = block.func_149638_a(null);
        if (this.resistanceBounds.encloses(Float.valueOf(resistance))) {
            boolean dropBlock = this.resistanceBounds.randomFits(Float.valueOf(resistance));
            if (!dropBlock && this.alwaysDropOres) {
                dropBlock = ForgeWorld.isOreBlock(world, pos);
            }
            if (dropBlock) {
                block.func_176226_b(world, pos, state, 0);
            }
            block.onBlockExploded(world, pos, explosion);
        }
    }

    public float getExplosionDamage() {
        return this.getExplosionRadius() * this.getExplosionRadius();
    }

    public float getSafeDistance() {
        return this.getExplosionRadius() + 1;
    }

    protected void damageEntitiesWithIn(World world, WorldBounds bounds, BlockPos epicenter, Explosion explosion) {
        List entities = world.func_72839_b(null, bounds.toAABB());
        float radius = this.getExplosionRadius();
        ForgeEventFactory.onExplosionDetonate((World)world, (Explosion)explosion, (List)entities, (double)(radius * 2.0f));
        Vec3d epicenterVec = new Vec3d((Vec3i)epicenter);
        for (Entity entity : entities) {
            double distance = entity.func_174791_d().func_72438_d(epicenterVec);
            if (!(distance < (double)this.getSafeDistance())) continue;
            float damage = this.getExplosionDamage();
            if (entity instanceof EntityLivingBase) {
                damage = (float)EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)damage);
            }
            float factor = FloatBounds.from(Float.valueOf(0.0f), Float.valueOf(this.getSafeDistance())).approxFactor(Float.valueOf((float)distance));
            damage = FloatBounds.from(Float.valueOf(0.0f), Float.valueOf(damage)).approxDown(factor).floatValue();
            if (!(damage >= 1.0f)) continue;
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)explosion), damage);
        }
    }

    protected void ignite(World world, BlockPos pos, IBlockState state, @Nullable EntityLivingBase igniter) {
        if (this.isServerSide(world)) {
            E fuse = this.createFuseEntity(world, pos, state, this.getIgnitionTime(), igniter);
            world.func_72838_d(fuse);
            world.func_184148_a(null, ((FuseEntity)((Object)fuse)).field_70165_t, ((FuseEntity)((Object)fuse)).field_70163_u, ((FuseEntity)((Object)fuse)).field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_175698_g(pos);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldStack = player.func_184586_b(hand);
        Item heldItem = heldStack.func_77973_b();
        if (heldItem == Items.field_151033_d || heldItem == Items.field_151059_bz) {
            this.ignite(world, pos, state, (EntityLivingBase)player);
            if (heldItem == Items.field_151033_d) {
                heldStack.func_77972_a(1, (EntityLivingBase)player);
            } else if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        EntityArrow arrow;
        if (this.isServerSide(world) && entity instanceof EntityArrow && (arrow = (EntityArrow)entity).func_70027_ad()) {
            EntityLivingBase igniter = arrow.field_70250_c instanceof EntityLivingBase ? (EntityLivingBase)arrow.field_70250_c : null;
            this.ignite(world, pos, state, igniter);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (world.func_175640_z(pos)) {
            this.ignite(world, pos, state, null);
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (this.isServerSide(world)) {
            IBlockState state = world.func_180495_p(pos);
            E fuse = this.createFuseEntity(world, pos, state, CommonTime.Interval.ZERO, explosion.func_94613_c());
            world.func_72838_d(fuse);
        }
        world.func_175698_g(pos);
        super.onBlockExploded(world, pos, explosion);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.func_175640_z(pos) || world.func_180495_p(fromPos).func_177230_c() == Blocks.field_150480_ab) {
            this.ignite(world, pos, state, null);
        }
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public CommonTime.Interval getIgnitionTime() {
        return this.ignitionTime;
    }

    @Override
    protected void registerEntity() {
        this.getMod().getRegistrator().registerEntity(this.getEntityClass(), 255, 20, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRender() {
        this.getMod().getRegistrator().registerRenderingHandler(this.getEntityClass(), new FuseEntity.Renderer.Factory());
    }

    public int getExplosionRadius() {
        return this.explosionRadius;
    }
}

