/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.catsdogs.client.render.dogs;

import com.animania.addons.catsdogs.common.entity.canids.EntityAnimaniaDog;
import com.animania.api.interfaces.IChild;
import com.animania.client.render.layer.LayerBlinking;
import java.util.function.Function;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderDogGeneric<T extends EntityAnimaniaDog>
extends RenderLiving<T> {
    private final ResourceLocation texture;
    private final ResourceLocation blink;
    private final int eyeColor;
    private final float scale;
    private final LayerBlinking blinking;
    private final double x;
    private final double y;
    private final double z;
    private final Function<EntityAnimaniaDog, ResourceLocation> textureOverrideFunction;

    public RenderDogGeneric(RenderManager rm, ModelBase model, ResourceLocation texture, ResourceLocation blink, int eyeColor, float scale, double x, double y, double z, Function<EntityAnimaniaDog, ResourceLocation> textureOverride) {
        super(rm, model, 0.5f);
        this.texture = texture;
        this.blink = blink;
        this.eyeColor = eyeColor;
        this.scale = scale;
        this.x = x;
        this.y = y;
        this.z = z;
        this.textureOverrideFunction = textureOverride;
        this.blinking = new LayerBlinking((RenderLiving)this, blink, eyeColor, true);
        this.func_177094_a((LayerRenderer)this.blinking);
    }

    protected void preRenderScale(EntityAnimaniaDog entity, float f) {
        GlStateManager.func_179137_b((double)this.x, (double)this.y, (double)this.z);
        if (entity instanceof IChild) {
            double dividend = 0.85 / (0.8 * (double)this.scale);
            IChild child = (IChild)((Object)entity);
            float age = child.getEntityAge();
            GlStateManager.func_179139_a((double)((double)this.scale + (double)age / dividend), (double)((double)this.scale + (double)age / dividend), (double)((double)this.scale + (double)age / dividend));
        } else {
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
        }
        if (entity.getSleeping()) {
            GlStateManager.func_179094_E();
            this.field_76989_e = 0.0f;
            float sleepTimer = entity.getSleepTimer().floatValue();
            if (sleepTimer > -0.55f) {
                sleepTimer -= 0.01f;
            }
            entity.setSleepTimer(Float.valueOf(sleepTimer));
            GlStateManager.func_179121_F();
            GlStateManager.func_179137_b((double)0.0, (double)-0.1, (double)0.0);
        }
    }

    protected ResourceLocation getEntityTexture(T entity) {
        ResourceLocation loc;
        if (this.textureOverrideFunction != null && (loc = this.textureOverrideFunction.apply((EntityAnimaniaDog)entity)) != null) {
            return loc;
        }
        if (entity.getVariantCount() > 0) {
            String tex = this.texture.toString().replace(".png", "");
            if (entity.func_180425_c().equals((Object)new BlockPos(-1, -1, -1))) {
                return new ResourceLocation(tex + 0 + ".png");
            }
            tex = tex + entity.getVariant() + ".png";
            return new ResourceLocation(tex);
        }
        return this.texture;
    }

    protected void preRenderCallback(T entityliving, float f) {
        if (entityliving.getVariantCount() > 0) {
            int col = entityliving.getEyeColorForVariant(entityliving.getVariant());
            this.blinking.setColors(col, col);
        }
        this.preRenderScale((EntityAnimaniaDog)entityliving, f);
    }

    public static class Factory<T extends EntityAnimaniaDog>
    implements IRenderFactory<T> {
        ResourceLocation tex;
        ResourceLocation blink;
        int eye;
        float scale;
        ModelBase model;
        double x;
        double y;
        double z;
        Function<EntityAnimaniaDog, ResourceLocation> overrideFunc;

        public Factory(ModelBase model, ResourceLocation texture, ResourceLocation blink, int eyeCol, float scale, double x, double y, double z, Function<EntityAnimaniaDog, ResourceLocation> overrideFunc) {
            this.tex = texture;
            this.blink = blink;
            this.eye = eyeCol;
            this.scale = scale;
            this.model = model;
            this.x = x;
            this.y = y;
            this.z = z;
            this.overrideFunc = overrideFunc;
        }

        public Factory(ModelBase model, ResourceLocation texture, ResourceLocation blink, int eyeCol, float scale) {
            this(model, texture, blink, eyeCol, scale, 0.0, 0.0, 0.0, null);
        }

        public Render<? super T> createRenderFor(RenderManager manager) {
            return new RenderDogGeneric(manager, this.model, this.tex, this.blink, this.eye, this.scale, this.x, this.y, this.z, this.overrideFunc);
        }
    }
}

